/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.astar.pathfinder;

import net.citizensnpcs.api.astar.pathfinder.CachingChunkBlockSource;
import net.citizensnpcs.api.util.BoundingBox;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;

public class ChunkBlockSource
extends CachingChunkBlockSource<Chunk> {
    private static boolean SUPPORT_BOUNDING_BOX = true;

    public ChunkBlockSource(Location location, float f) {
        super(location, f);
    }

    public ChunkBlockSource(World world, int n, int n2, float f) {
        super(world, n, n2, f);
    }

    @Override
    protected Chunk getChunkObject(int n, int n2) {
        return this.world.getChunkAt(n, n2);
    }

    @Override
    protected BoundingBox getCollisionBox(Chunk chunk, int n, int n2, int n3) {
        if (!SUPPORT_BOUNDING_BOX) {
            return null;
        }
        try {
            return BoundingBox.convert(this.world.getBlockAt(n, n2, n3).getBoundingBox());
        }
        catch (NoSuchMethodError noSuchMethodError) {
            SUPPORT_BOUNDING_BOX = false;
            return null;
        }
    }

    @Override
    protected int getLightLevel(Chunk chunk, int n, int n2, int n3) {
        return chunk.getBlock(n, n2, n3).getLightLevel();
    }

    @Override
    protected Material getType(Chunk chunk, int n, int n2, int n3) {
        return chunk.getBlock(n, n2, n3).getType();
    }
}

