/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.astar.pathfinder;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.citizensnpcs.api.astar.pathfinder.BlockExaminer;
import net.citizensnpcs.api.astar.pathfinder.BlockSource;
import net.citizensnpcs.api.astar.pathfinder.MinecraftBlockExaminer;
import net.citizensnpcs.api.astar.pathfinder.NeighbourGeneratorBlockExaminer;
import net.citizensnpcs.api.astar.pathfinder.PathPoint;
import net.citizensnpcs.api.util.SpigotUtil;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.util.Vector;

public class FlyingBlockExaminer
implements NeighbourGeneratorBlockExaminer {
    private static final Vector UP = new Vector(0, 1, 0);
    private static Material WEB = SpigotUtil.isUsing1_13API() ? Material.COBWEB : Material.valueOf((String)"WEB");

    @Override
    public float getCost(BlockSource blockSource, PathPoint pathPoint) {
        Vector vector = pathPoint.getVector();
        Material material = blockSource.getMaterialAt(vector.clone().add(UP));
        Material material2 = blockSource.getMaterialAt(vector);
        if (material == WEB || material2 == WEB) {
            return 0.5f;
        }
        return 0.0f;
    }

    @Override
    public List<PathPoint> getNeighbours(BlockSource blockSource, PathPoint pathPoint) {
        ArrayList arrayList = Lists.newArrayList();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                for (int k = -1; k <= 1; ++k) {
                    Vector vector;
                    if (i == 0 && j == 0 && k == 0 || (vector = pathPoint.getVector().clone().add(new Vector(i, j, k))).getY() < 0.0 || vector.getY() > 255.0 || vector.equals((Object)pathPoint.getVector())) continue;
                    arrayList.add(pathPoint.createAtOffset(vector));
                }
            }
        }
        return arrayList;
    }

    @Override
    public BlockExaminer.PassableState isPassable(BlockSource blockSource, PathPoint pathPoint) {
        Vector vector = pathPoint.getVector();
        Block block = blockSource.getBlockAt(vector.clone().add(UP));
        Block block2 = blockSource.getBlockAt(vector);
        if (MinecraftBlockExaminer.isLiquid(block.getType(), block2.getType())) {
            return BlockExaminer.PassableState.UNPASSABLE;
        }
        return MinecraftBlockExaminer.canStandIn(block, block2) ? BlockExaminer.PassableState.PASSABLE : BlockExaminer.PassableState.UNPASSABLE;
    }
}

