/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.gui;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Map;
import net.citizensnpcs.api.gui.InventoryMenu;
import net.citizensnpcs.api.gui.InventoryMenuSlot;
import net.citizensnpcs.api.util.Messaging;
import org.bukkit.inventory.Inventory;

public class MenuContext {
    private final Map<String, Object> data = Maps.newHashMap();
    private final Inventory inventory;
    private final InventoryMenu menu;
    private final InventoryMenuSlot[] slots;
    private String title;

    public MenuContext(InventoryMenu inventoryMenu, InventoryMenuSlot[] inventoryMenuSlotArray, Inventory inventory, String string) {
        this(inventoryMenu, inventoryMenuSlotArray, inventory, string, Collections.emptyMap());
    }

    public MenuContext(InventoryMenu inventoryMenu, InventoryMenuSlot[] inventoryMenuSlotArray, Inventory inventory, String string, Map<String, Object> map) {
        this.inventory = inventory;
        this.title = string;
        this.slots = inventoryMenuSlotArray;
        this.menu = inventoryMenu;
        this.data.putAll(map);
    }

    public void clearSlots() {
        for (int i = 0; i < this.slots.length; ++i) {
            InventoryMenuSlot inventoryMenuSlot = this.slots[i];
            if (inventoryMenuSlot != null) {
                inventoryMenuSlot.clear();
            }
            this.slots[i] = null;
        }
    }

    public Map<String, Object> data() {
        return this.data;
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public InventoryMenu getMenu() {
        return this.menu;
    }

    public InventoryMenuSlot getSlot(int n) {
        if (this.slots[n] == null) {
            this.slots[n] = new InventoryMenuSlot(this, n);
            return this.slots[n];
        }
        return this.slots[n];
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = Messaging.parseComponents(string);
        this.menu.updateTitle(string);
    }
}

