/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.npc;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import net.citizensnpcs.api.npc.MetadataStore;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.util.DataKey;

public class SimpleMetadataStore
implements MetadataStore {
    private final Map<String, MetadataObject> metadata = Maps.newHashMap();
    private final Map<NPC.Metadata, MetadataObject> npcMetadata = Maps.newEnumMap(NPC.Metadata.class);

    private void checkPrimitive(Object object) {
        boolean bl;
        Objects.requireNonNull(object, "data cannot be null");
        boolean bl2 = bl = object instanceof String || object instanceof Boolean || object instanceof Number;
        if (!bl) {
            throw new IllegalArgumentException("data is not primitive");
        }
    }

    @Override
    public MetadataStore clone() {
        SimpleMetadataStore simpleMetadataStore = new SimpleMetadataStore();
        simpleMetadataStore.metadata.putAll(this.metadata);
        return simpleMetadataStore;
    }

    @Override
    public <T> T get(NPC.Metadata metadata) {
        Objects.requireNonNull(metadata, "key cannot be null");
        MetadataObject metadataObject = this.npcMetadata.get((Object)metadata);
        return (T)(metadataObject == null ? null : metadataObject.value);
    }

    @Override
    public <T> T get(NPC.Metadata metadata, T t) {
        T t2 = this.get(metadata);
        return t2 == null ? t : t2;
    }

    @Override
    public <T> T get(String string) {
        Objects.requireNonNull(string, "key cannot be null");
        MetadataObject metadataObject = this.metadata.get(string);
        return (T)(metadataObject == null ? null : metadataObject.value);
    }

    @Override
    public <T> T get(String string, T t) {
        T t2 = this.get(string);
        if (t2 == null) {
            return t;
        }
        return t2;
    }

    @Override
    public boolean has(NPC.Metadata metadata) {
        Objects.requireNonNull(metadata, "key cannot be null");
        return this.npcMetadata.containsKey((Object)metadata);
    }

    @Override
    public boolean has(String string) {
        Objects.requireNonNull(string, "key cannot be null");
        return this.metadata.containsKey(string);
    }

    @Override
    public void loadFrom(DataKey dataKey) {
        this.metadata.entrySet().removeIf(entry -> ((MetadataObject)entry.getValue()).persistent);
        this.npcMetadata.entrySet().removeIf(entry -> ((MetadataObject)entry.getValue()).persistent);
        for (DataKey dataKey2 : dataKey.getSubKeys()) {
            NPC.Metadata metadata = NPC.Metadata.byKey(dataKey2.name());
            if (metadata != null) {
                this.setPersistent(metadata, dataKey2.getRaw(""));
                continue;
            }
            this.setPersistent(dataKey2.name(), dataKey2.getRaw(""));
        }
    }

    @Override
    public void remove(NPC.Metadata metadata) {
        this.npcMetadata.remove((Object)metadata);
    }

    @Override
    public void remove(String string) {
        this.metadata.remove(string);
    }

    @Override
    public void saveTo(DataKey dataKey) {
        Objects.requireNonNull(dataKey, "key cannot be null");
        for (Map.Entry<String, MetadataObject> entry : this.metadata.entrySet()) {
            if (!entry.getValue().persistent) continue;
            dataKey.setRaw(entry.getKey(), entry.getValue().value);
        }
        for (Map.Entry<Object, MetadataObject> entry : this.npcMetadata.entrySet()) {
            if (!entry.getValue().persistent) continue;
            dataKey.setRaw(((NPC.Metadata)((Object)entry.getKey())).getKey(), entry.getValue().value);
        }
    }

    @Override
    public void set(NPC.Metadata metadata, Object object) {
        Objects.requireNonNull(metadata, "key cannot be null");
        if (object == null) {
            this.remove(metadata);
        } else {
            this.npcMetadata.put(metadata, new MetadataObject(object, false));
        }
    }

    @Override
    public void set(String string, Object object) {
        Objects.requireNonNull(string, "key cannot be null");
        if (object == null) {
            this.remove(string);
        } else {
            this.metadata.put(string, new MetadataObject(object, false));
        }
    }

    @Override
    public void setPersistent(NPC.Metadata metadata, Object object) {
        Objects.requireNonNull(metadata, "key cannot be null");
        if (object == null) {
            this.remove(metadata);
        } else {
            this.checkPrimitive(object);
            this.npcMetadata.put(metadata, new MetadataObject(object, true));
        }
    }

    @Override
    public void setPersistent(String string, Object object) {
        Objects.requireNonNull(string, "key cannot be null");
        if (object == null) {
            this.remove(string);
        } else {
            this.checkPrimitive(object);
            this.metadata.put(string, new MetadataObject(object, true));
        }
    }

    @Override
    public int size() {
        return this.metadata.size() + this.npcMetadata.size();
    }

    private static class MetadataObject {
        final boolean persistent;
        final Object value;

        public MetadataObject(Object object, boolean bl) {
            this.value = object;
            this.persistent = bl;
        }
    }
}

