/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.npc.templates;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.npc.templates.Template;
import net.citizensnpcs.api.npc.templates.TemplateWorkspace;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.api.util.YamlStorage;
import org.bukkit.NamespacedKey;

public class TemplateRegistry {
    private final Path baseFolder;
    private final Map<NamespacedKey, Template> fullyQualifiedTemplates = Maps.newHashMap();
    private final Multimap<String, Template> templatesByName = HashMultimap.create();

    public TemplateRegistry(Path path) {
        this.baseFolder = path;
        if (!path.toFile().exists()) {
            path.toFile().mkdir();
        }
        this.loadTemplates(this.baseFolder);
    }

    public void generateTemplateFromNPC(NamespacedKey namespacedKey, NPC nPC) {
        String string = namespacedKey.getNamespace();
        String string2 = "templates.yml";
        File file = new File(this.baseFolder.toFile(), string);
        file.mkdirs();
        YamlStorage yamlStorage = new YamlStorage(new File(file, string2));
        if (!yamlStorage.load()) {
            throw new IllegalStateException();
        }
        DataKey dataKey = yamlStorage.getKey(namespacedKey.getKey());
        nPC.save(dataKey.getRelative("yaml_replace"));
        yamlStorage.save();
    }

    public Collection<Template> getAllTemplates() {
        return this.fullyQualifiedTemplates.values();
    }

    public Template getTemplateByKey(NamespacedKey namespacedKey) {
        return this.fullyQualifiedTemplates.get(namespacedKey);
    }

    public Collection<Template> getTemplates(String string) {
        return this.templatesByName.get((Object)string);
    }

    public boolean hasNamespace(String string) {
        for (NamespacedKey namespacedKey : this.fullyQualifiedTemplates.keySet()) {
            if (!namespacedKey.getNamespace().equals(string)) continue;
            return true;
        }
        return false;
    }

    private void loadTemplate(File file, String string, DataKey dataKey) {
        NamespacedKey namespacedKey = new NamespacedKey(string, dataKey.name());
        if (this.fullyQualifiedTemplates.containsKey(namespacedKey)) {
            throw new TemplateLoadException("Duplicate template key " + namespacedKey);
        }
        Template template = Template.load(new TemplateWorkspace(file), namespacedKey, dataKey);
        this.fullyQualifiedTemplates.put(namespacedKey, template);
        this.templatesByName.put((Object)namespacedKey.getKey(), (Object)template);
    }

    private void loadTemplates(Path path) {
        try {
            Files.walk(path, 1, new FileVisitOption[0]).forEach(path2 -> {
                File file = path2.toFile();
                if (file.isFile() && file.getName().endsWith(".yml")) {
                    try {
                        this.migrateOldTemplate(path.toFile(), file);
                    }
                    catch (TemplateLoadException templateLoadException) {
                        Messaging.severe("Error migrating " + file.getName() + ": " + templateLoadException.getMessage());
                    }
                }
            });
            Files.walk(path, 1, new FileVisitOption[0]).forEach(path2 -> {
                File file = path2.toFile();
                if (file.isDirectory() && !file.getName().contains(":")) {
                    try {
                        Files.walk(path2, 1, new FileVisitOption[0]).forEach(path -> {
                            File file2 = path.toFile();
                            if (file2.isFile() && file2.getName().endsWith(".yml")) {
                                try {
                                    this.loadTemplatesFromYamlFile(file.getName(), file2);
                                }
                                catch (TemplateLoadException templateLoadException) {
                                    Messaging.severe("Error loading " + file2.getName() + ": " + templateLoadException.getMessage());
                                }
                            }
                        });
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            });
            Messaging.log("Loaded", this.fullyQualifiedTemplates.size(), "templates.");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void loadTemplatesFromYamlFile(String string, File file) {
        YamlStorage yamlStorage = new YamlStorage(file);
        if (!yamlStorage.load()) {
            throw new TemplateLoadException("Unable to load " + file.getName());
        }
        YamlStorage.YamlKey yamlKey = yamlStorage.getKey("");
        for (DataKey dataKey : ((DataKey)yamlKey).getSubKeys()) {
            this.loadTemplate(file.getParentFile(), string, dataKey);
        }
    }

    private void migrateOldTemplate(File file, File file2) {
        Messaging.log("Migrating template", file2.getName());
        YamlStorage yamlStorage = new YamlStorage(file2);
        if (!yamlStorage.load()) {
            throw new TemplateLoadException("Unable to migrate " + file2.getName());
        }
        File file3 = new File(file, "migrated");
        if (!file3.exists() && !file3.mkdir()) {
            throw new TemplateLoadException("Unable to create destination folder while migrating " + file2.getName());
        }
        String string = file2.getName().replace(".yml", "");
        YamlStorage yamlStorage2 = new YamlStorage(new File(file3, file2.getName()));
        DataKey dataKey = yamlStorage.getKey("");
        DataKey dataKey2 = yamlStorage2.getKey(string + ".yaml_replace");
        dataKey2.setBoolean("override", dataKey.getBoolean("override"));
        dataKey2.setRaw("replacements", dataKey.getRelative("replacements").getValuesDeep());
        yamlStorage2.save();
        file2.renameTo(new File(file, file2.getName() + ".migrated"));
    }

    private static class TemplateLoadException
    extends Exception {
        public TemplateLoadException(String string) {
            super(string);
        }
    }
}

