/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.persistence;

import java.math.BigDecimal;
import java.math.RoundingMode;
import net.citizensnpcs.api.persistence.Persister;
import net.citizensnpcs.api.util.DataKey;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;

public class LocationPersister
implements Persister<Location> {
    @Override
    public Location create(DataKey dataKey) {
        if (!dataKey.keyExists("world")) {
            return null;
        }
        World world = Bukkit.getWorld((String)dataKey.getString("world"));
        double d = dataKey.getDouble("x");
        double d2 = dataKey.getDouble("y");
        double d3 = dataKey.getDouble("z");
        float f = this.normalise(dataKey.getDouble("yaw"));
        float f2 = this.normalise(dataKey.getDouble("pitch"));
        return world == null ? new LazilyLoadedLocation(dataKey.getString("world"), d, d2, d3, f, f2) : new Location(world, d, d2, d3, f, f2);
    }

    private float normalise(double d) {
        if (Double.isNaN(d)) {
            return 0.0f;
        }
        return (float)(!Double.isFinite(d) ? 0.0 : d);
    }

    private double round(double d) {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            return 0.0;
        }
        return new BigDecimal(d).setScale(4, RoundingMode.HALF_DOWN).doubleValue();
    }

    @Override
    public void save(Location location, DataKey dataKey) {
        if (location.getWorld() != null) {
            dataKey.setString("world", location.getWorld().getName());
        }
        dataKey.setDouble("x", this.round(location.getX()));
        dataKey.setDouble("y", this.round(location.getY()));
        dataKey.setDouble("z", this.round(location.getZ()));
        dataKey.setDouble("yaw", this.round(location.getYaw()));
        dataKey.setDouble("pitch", this.round(location.getPitch()));
    }

    public static class LazilyLoadedLocation
    extends Location {
        private final String worldName;

        public LazilyLoadedLocation(String string, double d, double d2, double d3, float f, float f2) {
            super(null, d, d2, d3, f, f2);
            this.worldName = string;
        }

        public World getWorld() {
            if (super.getWorld() == null) {
                super.setWorld(Bukkit.getWorld((String)this.worldName));
            }
            return super.getWorld();
        }
    }
}

