/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.trait.trait;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.util.PermissionUtil;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

@TraitName(value="playerfilter")
public class PlayerFilter
extends Trait {
    @Persist
    private double applyRange = -1.0;
    private final Set<UUID> children = Sets.newHashSet();
    private Function<Player, Boolean> filter;
    @Persist
    private Set<String> groups = null;
    private final Set<UUID> hiddenPlayers = Sets.newHashSet();
    private BiConsumer<Player, Entity> hideFunction;
    @Persist
    private Mode mode = Mode.DENYLIST;
    @Persist
    private Set<UUID> players = null;
    private BiConsumer<Player, Entity> viewFunction;
    private final Set<UUID> viewingPlayers = Sets.newHashSet();

    public PlayerFilter() {
        super("playerfilter");
    }

    public PlayerFilter(BiConsumer<Player, Entity> biConsumer, BiConsumer<Player, Entity> biConsumer2) {
        this();
        this.filter = player -> {
            if (this.applyRange != -1.0 && this.npc.isSpawned()) {
                if (player.getLocation().getWorld() != this.npc.getEntity().getLocation().getWorld()) {
                    return false;
                }
                if (player.getLocation().distance(this.npc.getEntity().getLocation()) > this.applyRange) {
                    return false;
                }
            }
            switch (this.mode.ordinal()) {
                case 1: {
                    if ((this.players == null || !this.players.contains(player.getUniqueId())) && (this.groups == null || !PermissionUtil.inGroup(this.groups, player).booleanValue())) break;
                    return true;
                }
                case 0: {
                    if ((this.players == null || this.players.contains(player.getUniqueId())) && (this.groups == null || PermissionUtil.inGroup(this.groups, player).booleanValue())) break;
                    return true;
                }
            }
            return false;
        };
        this.hideFunction = biConsumer;
        this.viewFunction = biConsumer2;
    }

    public void addChildNPC(NPC nPC) {
        this.children.add(nPC.getUniqueId());
    }

    public void addGroup(String string) {
        if (this.groups == null) {
            this.groups = Sets.newHashSet();
        }
        this.groups.add(string);
        this.recalculate();
    }

    public void addPlayer(UUID uUID) {
        if (this.players == null) {
            this.players = Sets.newHashSet();
        }
        this.players.add(uUID);
        this.getSet().add(uUID);
        this.recalculate();
    }

    public boolean affectsGroup(String string) {
        return this.groups.contains(string);
    }

    public boolean affectsPlayer(UUID uUID) {
        return this.players.contains(uUID);
    }

    public void clear() {
        this.players = null;
        this.groups = null;
    }

    public double getApplyRange() {
        return this.applyRange;
    }

    public Set<String> getGroups() {
        return this.groups;
    }

    private Set<UUID> getInverseSet() {
        return this.mode == Mode.ALLOWLIST ? this.viewingPlayers : this.hiddenPlayers;
    }

    public Set<UUID> getPlayerUUIDs() {
        return this.players;
    }

    private Set<UUID> getSet() {
        return this.mode == Mode.DENYLIST ? this.viewingPlayers : this.hiddenPlayers;
    }

    public boolean isAllowlist() {
        return this.mode == Mode.ALLOWLIST;
    }

    public boolean isDenylist() {
        return this.mode == Mode.DENYLIST;
    }

    public boolean isHidden(Player player) {
        return this.filter == null ? false : this.filter.apply(player);
    }

    @Override
    public void onDespawn() {
        this.hiddenPlayers.clear();
        this.viewingPlayers.clear();
    }

    public boolean onSeenByPlayer(Player player) {
        if (this.isHidden(player)) {
            this.hiddenPlayers.add(player.getUniqueId());
            return true;
        }
        this.viewingPlayers.add(player.getUniqueId());
        return false;
    }

    public void recalculate() {
        Player player;
        UUID uUID2;
        Collection collection = this.children.stream().map(uUID -> CitizensAPI.getNPCRegistry().getByUniqueIdGlobal((UUID)uUID)).filter(nPC -> nPC != null).collect(Collectors.toList());
        Iterator<UUID> iterator = this.viewingPlayers.iterator();
        while (iterator.hasNext()) {
            uUID2 = iterator.next();
            player = Bukkit.getPlayer((UUID)uUID2);
            if (player == null) {
                iterator.remove();
                continue;
            }
            if (this.hideFunction == null || !this.filter.apply(player).booleanValue()) continue;
            this.hideFunction.accept(player, this.npc.getEntity());
            for (NPC nPC2 : collection) {
                this.hideFunction.accept(player, nPC2.getEntity());
            }
            iterator.remove();
        }
        iterator = this.hiddenPlayers.iterator();
        while (iterator.hasNext()) {
            uUID2 = iterator.next();
            player = Bukkit.getPlayer((UUID)uUID2);
            if (player == null) {
                iterator.remove();
                continue;
            }
            if (this.viewFunction == null || this.filter.apply(player).booleanValue()) continue;
            this.viewFunction.accept(player, this.npc.getEntity());
            for (NPC nPC2 : collection) {
                this.viewFunction.accept(player, nPC2.getEntity());
            }
            iterator.remove();
        }
    }

    public void removeGroup(String string) {
        if (this.groups != null) {
            this.groups.remove(string);
        }
        this.recalculate();
    }

    public void removePlayer(UUID uUID) {
        if (this.players != null) {
            this.players.remove(uUID);
        }
        this.getInverseSet().add(uUID);
        this.recalculate();
    }

    @Override
    public void run() {
        if (!this.npc.isSpawned() || !this.npc.isUpdating(NPC.NPCUpdate.PACKET)) {
            return;
        }
        this.recalculate();
    }

    public void setAllowlist() {
        this.mode = Mode.ALLOWLIST;
        this.recalculate();
    }

    public void setApplyRange(double d) {
        this.applyRange = d;
        this.recalculate();
    }

    public void setDenylist() {
        this.mode = Mode.DENYLIST;
        this.recalculate();
    }

    public void setPlayerFilter(Function<Player, Boolean> function) {
        this.filter = function;
        this.recalculate();
    }

    public void setPlayers(Set<UUID> set) {
        this.players = set == null ? null : Sets.newHashSet(set);
    }

    public static enum Mode {
        ALLOWLIST,
        DENYLIST;

    }
}

