/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.util;

import com.google.common.collect.Iterables;
import com.google.common.primitives.Ints;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.bukkit.configuration.ConfigurationSection;

public abstract class DataKey {
    protected final String path;

    protected DataKey(String string) {
        this.path = string;
    }

    protected String createRelativeKey(String string) {
        if (string.isEmpty()) {
            return this.path;
        }
        if (string.charAt(0) == '.') {
            return this.path.isEmpty() ? string.substring(1) : this.path + string;
        }
        return this.path.isEmpty() ? string : this.path + '.' + string;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        DataKey dataKey = (DataKey)object;
        return Objects.equals(this.path, dataKey.path);
    }

    public abstract boolean getBoolean(String var1);

    public boolean getBoolean(String string, boolean bl) {
        if (this.keyExists(string)) {
            return this.getBoolean(string);
        }
        this.setBoolean(string, bl);
        return bl;
    }

    public abstract double getDouble(String var1);

    public double getDouble(String string, double d) {
        if (this.keyExists(string)) {
            return this.getDouble(string);
        }
        this.setDouble(string, d);
        return d;
    }

    public abstract DataKey getFromRoot(String var1);

    public abstract int getInt(String var1);

    public int getInt(String string, int n) {
        if (this.keyExists(string)) {
            return this.getInt(string);
        }
        this.setInt(string, n);
        return n;
    }

    public Iterable<DataKey> getIntegerSubKeys() {
        return Iterables.filter(this.getSubKeys(), dataKey -> Ints.tryParse((String)dataKey.name()) != null);
    }

    public abstract long getLong(String var1);

    public long getLong(String string, long l) {
        if (this.keyExists(string)) {
            return this.getLong(string);
        }
        this.setLong(string, l);
        return l;
    }

    public String getPath() {
        return this.path;
    }

    public abstract Object getRaw(String var1);

    public <T> T getRawUnchecked(String string) {
        return (T)this.getRaw(string);
    }

    public DataKey getRelative(int n) {
        return this.getRelative(Integer.toString(n));
    }

    public abstract DataKey getRelative(String var1);

    public abstract String getString(String var1);

    public String getString(String string, String string2) {
        if (this.keyExists(string)) {
            return this.getString(string);
        }
        this.setString(string, string2);
        return string2;
    }

    public abstract Iterable<DataKey> getSubKeys();

    public abstract Map<String, Object> getValuesDeep();

    public int hashCode() {
        int n = 31;
        return 31 + (this.path == null ? 0 : this.path.hashCode());
    }

    public boolean keyExists() {
        return this.keyExists("");
    }

    public abstract boolean keyExists(String var1);

    public abstract String name();

    public abstract void removeKey(String var1);

    protected Map<String, Object> sectionToValues(ConfigurationSection configurationSection) {
        if (configurationSection == null) {
            return Collections.emptyMap();
        }
        Map map = configurationSection.getValues(false);
        ArrayDeque<Map> arrayDeque = new ArrayDeque<Map>();
        arrayDeque.add(map);
        while (!arrayDeque.isEmpty()) {
            for (Map.Entry entry : ((Map)arrayDeque.pollLast()).entrySet()) {
                if (!(entry.getValue() instanceof ConfigurationSection)) continue;
                Map map2 = ((ConfigurationSection)entry.getValue()).getValues(false);
                entry.setValue(map2);
                arrayDeque.add(map2);
            }
        }
        return map;
    }

    public abstract void setBoolean(String var1, boolean var2);

    public abstract void setDouble(String var1, double var2);

    public abstract void setInt(String var1, int var2);

    public abstract void setLong(String var1, long var2);

    public abstract void setRaw(String var1, Object var2);

    public abstract void setString(String var1, String var2);
}

