/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.util;

import com.google.common.collect.Lists;
import com.google.common.io.BaseEncoding;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.event.CitizensDeserialiseMetaEvent;
import net.citizensnpcs.api.event.CitizensSerialiseMetaEvent;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.api.util.SpigotUtil;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.DyeColor;
import org.bukkit.FireworkEffect;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.block.Banner;
import org.bukkit.block.BlockState;
import org.bukkit.block.banner.Pattern;
import org.bukkit.block.banner.PatternType;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.event.Event;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.CrossbowMeta;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.MapMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.Repairable;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;
import org.bukkit.util.io.BukkitObjectInputStream;
import org.bukkit.util.io.BukkitObjectOutputStream;

public class ItemStorage {
    private static MethodHandle SETBASECOLOR = null;
    private static MethodHandle SETBASEPOTIONDATA = null;
    private static boolean SUPPORT_OWNING_PLAYER = true;
    private static boolean SUPPORTS_1_14_API = true;
    private static boolean SUPPORTS_ATTRIBUTES = true;
    private static boolean SUPPORTS_CUSTOM_MODEL_DATA = true;

    private static void deserialiseBanner(DataKey dataKey, Banner banner) {
        if (dataKey.keyExists("banner.basecolor")) {
            banner.setBaseColor(DyeColor.valueOf((String)dataKey.getString("banner.basecolor")));
        }
        if (dataKey.keyExists("banner.patterns")) {
            for (DataKey dataKey2 : dataKey.getRelative("banner.patterns").getIntegerSubKeys()) {
                Pattern pattern = new Pattern(DyeColor.valueOf((String)dataKey2.getString("color")), PatternType.getByIdentifier((String)dataKey2.getString("type")));
                banner.addPattern(pattern);
            }
        }
    }

    private static Iterable<Color> deserialiseColors(DataKey dataKey) {
        ArrayList arrayList = Lists.newArrayList();
        for (DataKey dataKey2 : dataKey.getIntegerSubKeys()) {
            arrayList.add(Color.fromRGB((int)dataKey2.getInt("rgb")));
        }
        return arrayList;
    }

    private static Enchantment deserialiseEnchantment(String string) {
        Enchantment enchantment = null;
        if (SpigotUtil.isUsing1_13API()) {
            enchantment = Enchantment.getByKey((NamespacedKey)NamespacedKey.minecraft((String)string.toLowerCase()));
        }
        if (enchantment == null) {
            enchantment = Enchantment.getByName((String)string);
        }
        return enchantment;
    }

    private static Map<Enchantment, Integer> deserialiseEnchantments(DataKey dataKey, ItemStack itemStack) {
        HashMap<Enchantment, Integer> hashMap = new HashMap<Enchantment, Integer>();
        for (DataKey dataKey2 : dataKey.getSubKeys()) {
            Enchantment enchantment = ItemStorage.deserialiseEnchantment(dataKey2.name());
            if (enchantment == null) continue;
            hashMap.put(enchantment, dataKey2.getInt(""));
        }
        return hashMap;
    }

    private static FireworkEffect deserialiseFireworkEffect(DataKey dataKey) {
        FireworkEffect.Builder builder = FireworkEffect.builder();
        builder.flicker(dataKey.getBoolean("flicker"));
        builder.trail(dataKey.getBoolean("trail"));
        builder.with(FireworkEffect.Type.valueOf((String)dataKey.getString("type")));
        builder.withColor(ItemStorage.deserialiseColors(dataKey.getRelative("colors")));
        builder.withFade(ItemStorage.deserialiseColors(dataKey.getRelative("fadecolors")));
        return builder.build();
    }

    private static void deserialiseMeta(DataKey dataKey, ItemStack itemStack) {
        Object object;
        Object object2;
        if (dataKey.keyExists("encoded-meta")) {
            object2 = BaseEncoding.base64().decode((CharSequence)dataKey.getString("encoded-meta"));
            try {
                BukkitObjectInputStream bukkitObjectInputStream = new BukkitObjectInputStream((InputStream)new ByteArrayInputStream((byte[])object2));
                ItemMeta itemMeta = (ItemMeta)bukkitObjectInputStream.readObject();
                itemStack.setItemMeta(itemMeta);
                Bukkit.getPluginManager().callEvent((Event)new CitizensDeserialiseMetaEvent(dataKey, itemStack));
                return;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
            }
        }
        if (SUPPORTS_CUSTOM_MODEL_DATA) {
            try {
                if (dataKey.keyExists("custommodel")) {
                    object2 = ItemStorage.ensureMeta(itemStack);
                    object2.setCustomModelData(Integer.valueOf(dataKey.getInt("custommodel")));
                    itemStack.setItemMeta((ItemMeta)object2);
                }
            }
            catch (Throwable throwable) {
                SUPPORTS_CUSTOM_MODEL_DATA = false;
            }
        }
        if (dataKey.keyExists("flags")) {
            object2 = ItemStorage.ensureMeta(itemStack);
            for (DataKey object3 : dataKey.getRelative("flags").getIntegerSubKeys()) {
                object2.addItemFlags(new ItemFlag[]{ItemFlag.valueOf((String)object3.getString(""))});
            }
            itemStack.setItemMeta((ItemMeta)object2);
        }
        if (dataKey.keyExists("lore")) {
            object2 = ItemStorage.ensureMeta(itemStack);
            object = Lists.newArrayList();
            for (DataKey dataKey2 : dataKey.getRelative("lore").getIntegerSubKeys()) {
                object.add((String)dataKey2.getString(""));
            }
            object2.setLore((List)object);
            itemStack.setItemMeta((ItemMeta)object2);
        }
        if (dataKey.keyExists("displayname")) {
            object2 = ItemStorage.ensureMeta(itemStack);
            object2.setDisplayName(dataKey.getString("displayname"));
            itemStack.setItemMeta((ItemMeta)object2);
        }
        if (dataKey.keyExists("firework")) {
            object2 = (FireworkMeta)ItemStorage.ensureMeta(itemStack);
            for (DataKey dataKey3 : dataKey.getRelative("firework.effects").getIntegerSubKeys()) {
                object2.addEffect(ItemStorage.deserialiseFireworkEffect(dataKey3));
            }
            object2.setPower(dataKey.getInt("firework.power"));
            itemStack.setItemMeta((ItemMeta)object2);
        }
        if (dataKey.keyExists("book")) {
            object2 = (BookMeta)ItemStorage.ensureMeta(itemStack);
            for (DataKey dataKey4 : dataKey.getRelative("book.pages").getIntegerSubKeys()) {
                object2.addPage(new String[]{dataKey4.getString("")});
            }
            object2.setTitle(dataKey.getString("book.title"));
            object2.setAuthor(dataKey.getString("book.author"));
            itemStack.setItemMeta((ItemMeta)object2);
        }
        if (dataKey.keyExists("armor")) {
            object2 = (LeatherArmorMeta)ItemStorage.ensureMeta(itemStack);
            object2.setColor(Color.fromRGB((int)dataKey.getInt("armor.color")));
            itemStack.setItemMeta((ItemMeta)object2);
        }
        if (dataKey.keyExists("map")) {
            object2 = (MapMeta)ItemStorage.ensureMeta(itemStack);
            object2.setScaling(dataKey.getBoolean("map.scaling"));
            itemStack.setItemMeta((ItemMeta)object2);
        }
        if (dataKey.keyExists("blockstate")) {
            object2 = (BlockStateMeta)ItemStorage.ensureMeta(itemStack);
            if (dataKey.keyExists("blockstate.banner")) {
                object = (Banner)object2.getBlockState();
                ItemStorage.deserialiseBanner(dataKey.getRelative("blockstate"), (Banner)object);
                object.update(true);
                object2.setBlockState((BlockState)object);
            }
            itemStack.setItemMeta((ItemMeta)object2);
        }
        if (dataKey.keyExists("enchantmentstorage")) {
            object2 = (EnchantmentStorageMeta)ItemStorage.ensureMeta(itemStack);
            for (DataKey dataKey5 : dataKey.getRelative("enchantmentstorage").getSubKeys()) {
                object2.addStoredEnchant(ItemStorage.deserialiseEnchantment(dataKey5.name()), dataKey5.getInt(""), true);
            }
            itemStack.setItemMeta((ItemMeta)object2);
        }
        if (dataKey.keyExists("skull")) {
            object2 = (SkullMeta)ItemStorage.ensureMeta(itemStack);
            if (SUPPORT_OWNING_PLAYER) {
                try {
                    object2.getOwningPlayer();
                }
                catch (Throwable throwable) {
                    SUPPORT_OWNING_PLAYER = false;
                }
            }
            if (dataKey.keyExists("skull.uuid") && SUPPORT_OWNING_PLAYER) {
                object = Bukkit.getOfflinePlayer((UUID)UUID.fromString(dataKey.getString("skull.uuid")));
                object2.setOwningPlayer((OfflinePlayer)object);
            } else if (dataKey.keyExists("skull.owner") && !dataKey.getString("skull.owner").isEmpty()) {
                object2.setOwner(dataKey.getString("skull.owner"));
            }
            if (dataKey.keyExists("skull.texture") && !dataKey.getString("skull.texture").isEmpty()) {
                CitizensAPI.getNMSHelper().setTexture(dataKey.getString("skull.texture", ""), (SkullMeta)object2);
            }
            itemStack.setItemMeta((ItemMeta)object2);
        }
        if (dataKey.keyExists("banner")) {
            object2 = (BannerMeta)ItemStorage.ensureMeta(itemStack);
            if (dataKey.keyExists("banner.basecolor")) {
                try {
                    SETBASECOLOR.invoke((BannerMeta)object2, DyeColor.valueOf((String)dataKey.getString("banner.basecolor")));
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
            if (dataKey.keyExists("banner.patterns")) {
                for (DataKey dataKey6 : dataKey.getRelative("banner.patterns").getIntegerSubKeys()) {
                    DataKey dataKey2;
                    dataKey2 = new Pattern(DyeColor.valueOf((String)dataKey6.getString("color")), PatternType.getByIdentifier((String)dataKey6.getString("type")));
                    object2.addPattern((Pattern)dataKey2);
                }
            }
            itemStack.setItemMeta((ItemMeta)object2);
        }
        if (dataKey.keyExists("potion")) {
            object2 = (PotionMeta)ItemStorage.ensureMeta(itemStack);
            try {
                object = new PotionData(PotionType.valueOf((String)dataKey.getString("potion.data.type")), dataKey.getBoolean("potion.data.extended"), dataKey.getBoolean("potion.data.upgraded"));
                SETBASEPOTIONDATA.invoke((PotionMeta)object2, (PotionData)object);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            for (DataKey dataKey7 : dataKey.getRelative("potion.effects").getIntegerSubKeys()) {
                int n = dataKey7.getInt("duration");
                int n2 = dataKey7.getInt("amplifier");
                PotionEffectType potionEffectType = PotionEffectType.getByName((String)dataKey7.getString("type"));
                boolean bl = dataKey7.getBoolean("ambient");
                object2.addCustomEffect(new PotionEffect(potionEffectType, n, n2, bl), true);
            }
            itemStack.setItemMeta((ItemMeta)object2);
        }
        if (dataKey.keyExists("crossbow") && SUPPORTS_1_14_API) {
            object2 = null;
            try {
                object2 = (CrossbowMeta)ItemStorage.ensureMeta(itemStack);
            }
            catch (Throwable throwable) {
                SUPPORTS_1_14_API = false;
            }
            if (object2 != null) {
                for (DataKey dataKey8 : dataKey.getRelative("crossbow.projectiles").getSubKeys()) {
                    object2.addChargedProjectile(ItemStorage.loadItemStack(dataKey8));
                }
                itemStack.setItemMeta((ItemMeta)object2);
            }
        }
        if (dataKey.keyExists("repaircost") && itemStack.getItemMeta() instanceof Repairable) {
            object2 = ItemStorage.ensureMeta(itemStack);
            ((Repairable)object2).setRepairCost(dataKey.getInt("repaircost"));
            itemStack.setItemMeta((ItemMeta)object2);
        }
        if (dataKey.keyExists("attributes") && SUPPORTS_ATTRIBUTES) {
            object2 = ItemStorage.ensureMeta(itemStack);
            try {
                for (DataKey dataKey9 : dataKey.getRelative("attributes").getSubKeys()) {
                    Attribute attribute = Attribute.valueOf((String)dataKey9.name());
                    for (DataKey dataKey10 : dataKey9.getIntegerSubKeys()) {
                        UUID uUID = UUID.fromString(dataKey10.getString("uuid"));
                        String string = dataKey10.getString("name");
                        double d = dataKey10.getDouble("amount");
                        AttributeModifier.Operation operation = AttributeModifier.Operation.valueOf((String)dataKey10.getString("operation"));
                        EquipmentSlot equipmentSlot = dataKey10.keyExists("slot") ? EquipmentSlot.valueOf((String)dataKey10.getString("slot")) : null;
                        object2.addAttributeModifier(attribute, new AttributeModifier(uUID, string, d, operation, equipmentSlot));
                    }
                }
            }
            catch (Throwable throwable) {
                SUPPORTS_ATTRIBUTES = false;
            }
            itemStack.setItemMeta((ItemMeta)object2);
        }
        if ((object2 = (Object)itemStack.getItemMeta()) != null) {
            try {
                object2.setUnbreakable(dataKey.getBoolean("unbreakable", false));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            itemStack.setItemMeta((ItemMeta)object2);
        }
        Bukkit.getPluginManager().callEvent((Event)new CitizensDeserialiseMetaEvent(dataKey, itemStack));
    }

    private static <T extends ItemMeta> T ensureMeta(ItemStack itemStack) {
        if (!itemStack.hasItemMeta()) {
            itemStack.setItemMeta(Bukkit.getServer().getItemFactory().getItemMeta(itemStack.getType()));
        }
        return (T)itemStack.getItemMeta();
    }

    public static ItemStack loadItemStack(DataKey dataKey) {
        String string;
        Material material = null;
        if (dataKey.keyExists("type_key") && SpigotUtil.isUsing1_13API()) {
            string = new NamespacedKey(dataKey.getString("type_namespace", "minecraft"), dataKey.getString("type_key"));
            material = Material.getMaterial((String)string.getKey().toUpperCase(), (boolean)false);
        } else {
            string = dataKey.getString("type", dataKey.getString("id"));
            if (string == null || string.length() == 0) {
                return null;
            }
            Material material2 = material = SpigotUtil.isUsing1_13API() ? Material.matchMaterial((String)string, (boolean)true) : Material.matchMaterial((String)string);
        }
        if (material == null || material == Material.AIR) {
            return null;
        }
        string = new ItemStack(material, dataKey.getInt("amount"), (short)dataKey.getInt("durability", dataKey.getInt("data", 0)));
        if (dataKey.keyExists("mdata") && string.getData() != null) {
            string.getData().setData((byte)dataKey.getInt("mdata"));
        }
        if (dataKey.keyExists("enchantments")) {
            Map<Enchantment, Integer> map = ItemStorage.deserialiseEnchantments(dataKey.getRelative("enchantments"), (ItemStack)string);
            string.addUnsafeEnchantments(map);
        }
        ItemStorage.deserialiseMeta(dataKey.getRelative("meta"), (ItemStack)string);
        return string;
    }

    private static void migrateForSave(DataKey dataKey) {
        dataKey.removeKey("data");
        dataKey.removeKey("id");
    }

    public static void saveItem(DataKey dataKey, ItemStack itemStack) {
        if (itemStack == null) {
            itemStack = new ItemStack(Material.AIR);
        }
        ItemStorage.migrateForSave(dataKey);
        if (SpigotUtil.isUsing1_13API()) {
            if (!itemStack.getType().getKey().getNamespace().equals("minecraft")) {
                dataKey.setString("type_namespace", itemStack.getType().getKey().getNamespace());
            } else {
                dataKey.removeKey("type_namespace");
            }
            dataKey.setString("type_key", itemStack.getType().getKey().getKey());
        } else {
            dataKey.setString("type", itemStack.getType().name());
        }
        dataKey.setInt("amount", itemStack.getAmount());
        if (itemStack.getDurability() != 0) {
            dataKey.setInt("durability", itemStack.getDurability());
        } else {
            dataKey.removeKey("durability");
        }
        if (!SpigotUtil.isUsing1_13API() && itemStack.getData() != null) {
            dataKey.setInt("mdata", itemStack.getData().getData());
        } else {
            dataKey.removeKey("mdata");
        }
        if (itemStack.hasItemMeta()) {
            ItemMeta itemMeta = itemStack.getItemMeta();
            ItemStorage.serialiseMeta(dataKey.getRelative("meta"), itemMeta);
        } else {
            dataKey.removeKey("meta");
        }
        ItemStorage.serialiseEnchantments(dataKey.getRelative("enchantments"), itemStack.getEnchantments());
    }

    private static void serialiseEnchantments(DataKey dataKey, Map<Enchantment, Integer> map) {
        for (Map.Entry<Enchantment, Integer> entry : map.entrySet()) {
            dataKey.setInt(SpigotUtil.isUsing1_13API() ? entry.getKey().getKey().getKey() : entry.getKey().getName(), entry.getValue());
        }
    }

    private static void serialiseMeta(DataKey dataKey, ItemMeta itemMeta) {
        dataKey.removeKey("encoded-meta");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            BukkitObjectOutputStream bukkitObjectOutputStream = new BukkitObjectOutputStream((OutputStream)byteArrayOutputStream);
            bukkitObjectOutputStream.writeObject((Object)itemMeta);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (NullPointerException nullPointerException) {
            Messaging.severe("Spigot error when saving item meta: upgrade spigot");
            nullPointerException.printStackTrace();
            return;
        }
        String string = BaseEncoding.base64().encode(byteArrayOutputStream.toByteArray());
        dataKey.setString("encoded-meta", string);
        Bukkit.getPluginManager().callEvent((Event)new CitizensSerialiseMetaEvent(dataKey, itemMeta));
    }

    static {
        try {
            SETBASEPOTIONDATA = MethodHandles.lookup().unreflect(PotionMeta.class.getMethod("setBasePotionData", PotionData.class));
            SETBASECOLOR = MethodHandles.lookup().unreflect(BannerMeta.class.getMethod("setBaseColor", DyeColor.class));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

