/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.util;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.api.util.FileStorage;
import net.citizensnpcs.api.util.Messaging;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class YamlStorage
implements FileStorage {
    private final FileConfiguration config = new YamlConfiguration();
    private final File file;
    private static Field LOADER_OPTIONS;
    private static Method SET_CODEPOINT_LIMIT;

    public YamlStorage(File file) {
        this(file, null);
    }

    public YamlStorage(File file, String string) {
        this.tryIncreaseMaxCodepoints(this.config);
        this.file = file;
        if (!file.exists()) {
            this.create();
            if (string != null) {
                this.config.options().header(string);
            }
            this.save();
        }
    }

    private void create() {
        try {
            Messaging.debug("Creating file: " + this.file.getName());
            this.file.getParentFile().mkdirs();
            this.file.createNewFile();
        }
        catch (IOException iOException) {
            Messaging.severe("Could not create file: " + this.file.getName());
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        YamlStorage yamlStorage = (YamlStorage)object;
        return Objects.equals(this.file, yamlStorage.file);
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public YamlKey getKey(String string) {
        return new YamlKey(string);
    }

    public int hashCode() {
        return 31 + (this.file == null ? 0 : this.file.hashCode());
    }

    @Override
    public boolean load() {
        try {
            this.config.load(this.file);
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    @Override
    public void save() {
        try {
            Files.createParentDirs((File)this.file);
            File file = File.createTempFile(this.file.getName(), null, this.file.getParentFile());
            file.deleteOnExit();
            this.config.save(file);
            this.file.delete();
            file.renameTo(this.file);
            file.delete();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String toString() {
        return "YamlStorage {file=" + this.file + "}";
    }

    private void tryIncreaseMaxCodepoints(FileConfiguration fileConfiguration) {
        if (SET_CODEPOINT_LIMIT == null || LOADER_OPTIONS == null) {
            return;
        }
        try {
            SET_CODEPOINT_LIMIT.invoke(LOADER_OPTIONS.get(fileConfiguration), 0x4000000);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private boolean valueExists(String string) {
        Object object = this.config.get(string);
        return object != null && !(object instanceof ConfigurationSection);
    }

    static {
        try {
            LOADER_OPTIONS = YamlConfiguration.class.getDeclaredField("yamlLoaderOptions");
            LOADER_OPTIONS.setAccessible(true);
            SET_CODEPOINT_LIMIT = Class.forName("org.yaml.snakeyaml.LoaderOptions").getMethod("setCodepointLimit", Integer.TYPE);
            SET_CODEPOINT_LIMIT.setAccessible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public class YamlKey
    extends DataKey {
        public YamlKey(String string) {
            super(string);
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!super.equals(object) || this.getClass() != object.getClass()) {
                return false;
            }
            YamlKey yamlKey = (YamlKey)object;
            return this.getOuterType().equals(yamlKey.getOuterType());
        }

        @Override
        public boolean getBoolean(String string) {
            String string2 = this.createRelativeKey(string);
            if (YamlStorage.this.valueExists(string2)) {
                if (YamlStorage.this.config.getString(string2) == null) {
                    return YamlStorage.this.config.getBoolean(string2);
                }
                return Boolean.parseBoolean(YamlStorage.this.config.getString(string2));
            }
            return false;
        }

        @Override
        public boolean getBoolean(String string, boolean bl) {
            return YamlStorage.this.config.getBoolean(this.createRelativeKey(string), bl);
        }

        @Override
        public double getDouble(String string) {
            return this.getDouble(string, 0.0);
        }

        @Override
        public double getDouble(String string, double d) {
            String string2 = this.createRelativeKey(string);
            if (YamlStorage.this.valueExists(string2)) {
                Object object = YamlStorage.this.config.get(string2);
                if (object instanceof Number) {
                    return ((Number)object).doubleValue();
                }
                String string3 = object.toString();
                if (string3.isEmpty()) {
                    return d;
                }
                return Double.parseDouble(string3);
            }
            return d;
        }

        @Override
        public DataKey getFromRoot(String string) {
            return new YamlKey(string);
        }

        @Override
        public int getInt(String string) {
            return this.getInt(string, 0);
        }

        @Override
        public int getInt(String string, int n) {
            String string2 = this.createRelativeKey(string);
            if (YamlStorage.this.valueExists(string2)) {
                Object object = YamlStorage.this.config.get(string2);
                if (object instanceof Number) {
                    return ((Number)object).intValue();
                }
                String string3 = object.toString();
                if (string3.isEmpty()) {
                    return n;
                }
                return Integer.parseInt(string3);
            }
            return n;
        }

        @Override
        public long getLong(String string) {
            return this.getLong(string, 0L);
        }

        @Override
        public long getLong(String string, long l) {
            String string2 = this.createRelativeKey(string);
            if (YamlStorage.this.valueExists(string2)) {
                Object object = YamlStorage.this.config.get(string2);
                if (object instanceof Number) {
                    return ((Number)object).longValue();
                }
                String string3 = object.toString();
                if (string3.isEmpty()) {
                    return l;
                }
                return Long.parseLong(string3);
            }
            return l;
        }

        private YamlStorage getOuterType() {
            return YamlStorage.this;
        }

        @Override
        public Object getRaw(String string) {
            return YamlStorage.this.config.get(this.createRelativeKey(string));
        }

        @Override
        public YamlKey getRelative(String string) {
            if (string == null || string.isEmpty()) {
                return this;
            }
            return new YamlKey(this.createRelativeKey(string));
        }

        public ConfigurationSection getSection(String string) {
            String string2 = this.createRelativeKey(string);
            return YamlStorage.this.config.getConfigurationSection(string2);
        }

        public YamlStorage getStorage() {
            return YamlStorage.this;
        }

        @Override
        public String getString(String string) {
            String string2 = this.createRelativeKey(string);
            if (YamlStorage.this.valueExists(string2)) {
                return YamlStorage.this.config.get(string2).toString();
            }
            return "";
        }

        @Override
        public Iterable<DataKey> getSubKeys() {
            ConfigurationSection configurationSection = YamlStorage.this.config.getConfigurationSection(this.path);
            if (configurationSection == null) {
                return Collections.emptyList();
            }
            ArrayList<DataKey> arrayList = new ArrayList<DataKey>();
            for (String string : configurationSection.getKeys(false)) {
                arrayList.add(this.getRelative(string));
            }
            return arrayList;
        }

        @Override
        public Map<String, Object> getValuesDeep() {
            return this.sectionToValues(YamlStorage.this.config.getConfigurationSection(this.path));
        }

        @Override
        public int hashCode() {
            int n = 31;
            int n2 = 31 * super.hashCode() + this.getOuterType().hashCode();
            return n2;
        }

        @Override
        public boolean keyExists(String string) {
            return YamlStorage.this.config.get(this.createRelativeKey(string)) != null;
        }

        @Override
        public String name() {
            int n = this.path.lastIndexOf(46);
            return this.path.substring(n == 0 ? 0 : n + 1);
        }

        @Override
        public void removeKey(String string) {
            YamlStorage.this.config.set(this.createRelativeKey(string), null);
        }

        @Override
        public void setBoolean(String string, boolean bl) {
            YamlStorage.this.config.set(this.createRelativeKey(string), (Object)bl);
        }

        @Override
        public void setDouble(String string, double d) {
            YamlStorage.this.config.set(this.createRelativeKey(string), (Object)String.valueOf(d));
        }

        @Override
        public void setInt(String string, int n) {
            YamlStorage.this.config.set(this.createRelativeKey(string), (Object)n);
        }

        @Override
        public void setLong(String string, long l) {
            YamlStorage.this.config.set(this.createRelativeKey(string), (Object)l);
        }

        @Override
        public void setRaw(String string, Object object) {
            YamlStorage.this.config.set(this.createRelativeKey(string), object);
        }

        @Override
        public void setString(String string, String string2) {
            YamlStorage.this.config.set(this.createRelativeKey(string), (Object)string2);
        }

        public String toString() {
            return "YamlKey [path=" + this.path + "]";
        }
    }
}

