/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.commands;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.io.BaseEncoding;
import java.io.File;
import java.io.FileOutputStream;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.citizensnpcs.Citizens;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.ai.speech.SpeechContext;
import net.citizensnpcs.api.ai.tree.StatusMapper;
import net.citizensnpcs.api.command.Arg;
import net.citizensnpcs.api.command.Command;
import net.citizensnpcs.api.command.CommandContext;
import net.citizensnpcs.api.command.Flag;
import net.citizensnpcs.api.command.Requirements;
import net.citizensnpcs.api.command.exception.CommandException;
import net.citizensnpcs.api.command.exception.CommandUsageException;
import net.citizensnpcs.api.command.exception.NoPermissionsException;
import net.citizensnpcs.api.command.exception.RequirementMissingException;
import net.citizensnpcs.api.command.exception.ServerCommandException;
import net.citizensnpcs.api.event.CommandSenderCloneNPCEvent;
import net.citizensnpcs.api.event.CommandSenderCreateNPCEvent;
import net.citizensnpcs.api.event.DespawnReason;
import net.citizensnpcs.api.event.NPCEvent;
import net.citizensnpcs.api.event.NPCTeleportEvent;
import net.citizensnpcs.api.event.PlayerCloneNPCEvent;
import net.citizensnpcs.api.event.PlayerCreateNPCEvent;
import net.citizensnpcs.api.event.SpawnReason;
import net.citizensnpcs.api.gui.InventoryMenu;
import net.citizensnpcs.api.npc.BlockBreaker;
import net.citizensnpcs.api.npc.MemoryNPCDataStore;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.npc.NPCRegistry;
import net.citizensnpcs.api.npc.templates.Template;
import net.citizensnpcs.api.npc.templates.TemplateRegistry;
import net.citizensnpcs.api.persistence.PersistenceLoader;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.trait.Equipment;
import net.citizensnpcs.api.trait.trait.MobType;
import net.citizensnpcs.api.trait.trait.Owner;
import net.citizensnpcs.api.trait.trait.PlayerFilter;
import net.citizensnpcs.api.trait.trait.Spawned;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.api.util.EntityDim;
import net.citizensnpcs.api.util.MemoryDataKey;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.api.util.Paginator;
import net.citizensnpcs.api.util.Placeholders;
import net.citizensnpcs.api.util.SpigotUtil;
import net.citizensnpcs.commands.NPCCommandSelector;
import net.citizensnpcs.commands.gui.NPCConfigurator;
import net.citizensnpcs.commands.history.CommandHistory;
import net.citizensnpcs.commands.history.CreateNPCHistoryItem;
import net.citizensnpcs.commands.history.RemoveNPCHistoryItem;
import net.citizensnpcs.editor.Editor;
import net.citizensnpcs.npc.EntityControllers;
import net.citizensnpcs.npc.NPCSelector;
import net.citizensnpcs.trait.Age;
import net.citizensnpcs.trait.Anchors;
import net.citizensnpcs.trait.ArmorStandTrait;
import net.citizensnpcs.trait.AttributeTrait;
import net.citizensnpcs.trait.BoatTrait;
import net.citizensnpcs.trait.BoundingBoxTrait;
import net.citizensnpcs.trait.ClickRedirectTrait;
import net.citizensnpcs.trait.CommandTrait;
import net.citizensnpcs.trait.Controllable;
import net.citizensnpcs.trait.CurrentLocation;
import net.citizensnpcs.trait.DropsTrait;
import net.citizensnpcs.trait.EnderCrystalTrait;
import net.citizensnpcs.trait.EndermanTrait;
import net.citizensnpcs.trait.EntityPoseTrait;
import net.citizensnpcs.trait.FollowTrait;
import net.citizensnpcs.trait.ForcefieldTrait;
import net.citizensnpcs.trait.GameModeTrait;
import net.citizensnpcs.trait.Gravity;
import net.citizensnpcs.trait.HologramTrait;
import net.citizensnpcs.trait.HomeTrait;
import net.citizensnpcs.trait.HorseModifiers;
import net.citizensnpcs.trait.ItemFrameTrait;
import net.citizensnpcs.trait.LookClose;
import net.citizensnpcs.trait.MirrorTrait;
import net.citizensnpcs.trait.MountTrait;
import net.citizensnpcs.trait.OcelotModifiers;
import net.citizensnpcs.trait.PacketNPC;
import net.citizensnpcs.trait.PaintingTrait;
import net.citizensnpcs.trait.PausePathfindingTrait;
import net.citizensnpcs.trait.Poses;
import net.citizensnpcs.trait.Powered;
import net.citizensnpcs.trait.RabbitType;
import net.citizensnpcs.trait.RotationTrait;
import net.citizensnpcs.trait.ScoreboardTrait;
import net.citizensnpcs.trait.SheepTrait;
import net.citizensnpcs.trait.ShopTrait;
import net.citizensnpcs.trait.SitTrait;
import net.citizensnpcs.trait.SkinLayers;
import net.citizensnpcs.trait.SkinTrait;
import net.citizensnpcs.trait.SlimeSize;
import net.citizensnpcs.trait.VillagerProfession;
import net.citizensnpcs.trait.WitherTrait;
import net.citizensnpcs.trait.WolfModifiers;
import net.citizensnpcs.trait.shop.StoredShops;
import net.citizensnpcs.trait.waypoint.Waypoints;
import net.citizensnpcs.util.Anchor;
import net.citizensnpcs.util.MojangSkinGenerator;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.PlayerAnimation;
import net.citizensnpcs.util.StringHelper;
import net.citizensnpcs.util.Util;
import org.bukkit.Art;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.DyeColor;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.Rotation;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Boat;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Horse;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Ocelot;
import org.bukkit.entity.Player;
import org.bukkit.entity.Rabbit;
import org.bukkit.entity.Villager;
import org.bukkit.entity.Wolf;
import org.bukkit.entity.Zombie;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

@Requirements(selected=true, ownership=true)
public class NPCCommands {
    private final CommandHistory history;
    private final NPCSelector selector;
    private final StoredShops shops;
    private final TemplateRegistry templateRegistry;
    private final NPCRegistry temporaryRegistry;

    public NPCCommands(Citizens citizens) {
        this.selector = citizens.getNPCSelector();
        this.shops = citizens.getShops();
        this.templateRegistry = citizens.getTemplateRegistry();
        this.temporaryRegistry = citizens.getTemporaryNPCRegistry();
        this.history = new CommandHistory(this.selector);
    }

    @Command(aliases={"npc"}, usage="activationrange [range]", desc="", modifiers={"activationrange"}, min=1, max=2, permission="citizens.npc.activationrange")
    public void activationrange(CommandContext commandContext, CommandSender commandSender, NPC nPC, @Arg(value=1) Integer n) {
        if (n == null) {
            nPC.data().remove(NPC.Metadata.ACTIVATION_RANGE);
        } else {
            nPC.data().setPersistent(NPC.Metadata.ACTIVATION_RANGE, (Object)n);
        }
        Messaging.sendTr(commandSender, "citizens.commands.npc.activationrange.set", n);
    }

    @Command(aliases={"npc"}, usage="age [age] (-l(ock))", desc="", flags="l", modifiers={"age"}, min=1, max=2, permission="citizens.npc.age")
    public void age(CommandContext commandContext, CommandSender commandSender, NPC nPC) {
        if (!nPC.isSpawned() || !(nPC.getEntity() instanceof Ageable) && !(nPC.getEntity() instanceof Zombie) && !nPC.getEntity().getType().name().equals("TADPOLE")) {
            throw new CommandException("citizens.commands.npc.age.cannot-be-aged", nPC.getName());
        }
        Age age = nPC.getOrAddTrait(Age.class);
        boolean bl = commandContext.hasFlag('l');
        if (bl) {
            Messaging.sendTr(commandSender, age.toggle() ? "citizens.commands.npc.age.locked" : "citizens.commands.npc.age.unlocked", new Object[0]);
        }
        if (commandContext.argsLength() <= 1) {
            if (!bl) {
                age.describe(commandSender);
            }
            return;
        }
        int n = 0;
        try {
            n = commandContext.getInteger(1);
            if (n > 0) {
                throw new CommandException("citizens.commands.npc.age.invalid-age");
            }
            Messaging.sendTr(commandSender, "citizens.commands.npc.age.set-normal", nPC.getName(), n);
        }
        catch (NumberFormatException numberFormatException) {
            if (commandContext.getString(1).equalsIgnoreCase("baby")) {
                n = -24000;
                Messaging.sendTr(commandSender, "citizens.commands.npc.age.set-baby", nPC.getName());
            }
            if (commandContext.getString(1).equalsIgnoreCase("adult")) {
                n = 0;
                Messaging.sendTr(commandSender, "citizens.commands.npc.age.set-adult", nPC.getName());
            }
            throw new CommandException("citizens.commands.npc.age.invalid-age");
        }
        age.setAge(n);
    }

    @Command(aliases={"npc"}, usage="aggressive [true|false]", desc="", modifiers={"aggressive"}, min=1, max=2, permission="citizens.npc.aggressive")
    public void aggressive(CommandContext commandContext, CommandSender commandSender, NPC nPC, @Arg(value=1) Boolean bl) {
        boolean bl2 = bl != null ? bl : nPC.data().get(NPC.Metadata.AGGRESSIVE, Boolean.valueOf(false)) == false;
        nPC.data().set(NPC.Metadata.AGGRESSIVE, (Object)bl2);
        NMS.setAggressive(nPC.getEntity(), bl2);
    }

    @Command(aliases={"npc"}, usage="ai (true|false)", desc="", modifiers={"ai"}, min=1, max=2, permission="citizens.npc.ai")
    public void ai(CommandContext commandContext, CommandSender commandSender, NPC nPC, @Arg(value=1) Boolean bl) {
        boolean bl2 = bl == null ? !nPC.useMinecraftAI() : bl;
        nPC.setUseMinecraftAI(bl2);
        Messaging.sendTr(commandSender, bl2 ? "citizens.commands.npc.ai.started" : "citizens.commands.npc.ai.stopped", new Object[0]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Command(aliases={"npc"}, usage="anchor (--save [name]|--assume [name]|--remove [name]) (-a) (-c)", desc="", flags="ac", modifiers={"anchor"}, min=1, max=3, permission="citizens.npc.anchor")
    public void anchor(CommandContext commandContext, CommandSender commandSender, NPC nPC, @Flag(value={"save"}) String string, @Flag(value={"assume"}) String string2, @Flag(value={"remove"}) String string3) {
        Anchors anchors = nPC.getOrAddTrait(Anchors.class);
        if (string != null) {
            if (string.isEmpty()) {
                throw new CommandException("citizens.commands.npc.anchor.invalid-name");
            }
            if (commandContext.getSenderLocation() == null) {
                throw new ServerCommandException();
            }
            if (commandContext.hasFlag('c')) {
                if (!anchors.addAnchor(string, commandContext.getSenderTargetBlockLocation())) throw new CommandException("citizens.commands.npc.anchor.already-exists", string);
                Messaging.sendTr(commandSender, "citizens.commands.npc.anchor.added", new Object[0]);
            } else {
                if (!anchors.addAnchor(string, commandContext.getSenderLocation())) throw new CommandException("citizens.commands.npc.anchor.already-exists", string);
                Messaging.sendTr(commandSender, "citizens.commands.npc.anchor.added", new Object[0]);
            }
        } else if (string2 != null) {
            if (string2.isEmpty()) {
                throw new CommandException("citizens.commands.npc.anchor.invalid-name");
            }
            Anchor anchor = anchors.getAnchor(string2);
            if (anchor == null) {
                throw new CommandException("citizens.commands.npc.anchor.missing", string2);
            }
            nPC.teleport(anchor.getLocation(), PlayerTeleportEvent.TeleportCause.COMMAND);
        } else if (string3 != null) {
            if (string3.isEmpty()) {
                throw new CommandException("citizens.commands.npc.anchor.invalid-name");
            }
            if (!anchors.removeAnchor(anchors.getAnchor(string3))) throw new CommandException("citizens.commands.npc.anchor.missing", string3);
            Messaging.sendTr(commandSender, "citizens.commands.npc.anchor.removed", new Object[0]);
        } else if (!commandContext.hasFlag('a')) {
            int n;
            Paginator paginator = new Paginator().header("Anchors").console(commandSender instanceof ConsoleCommandSender);
            paginator.addLine("Key: [[ID]]  <blue>Name  <red>World  <gray>Location (X,Y,Z)");
            for (n = 0; n < anchors.getAnchors().size(); ++n) {
                if (anchors.getAnchors().get(n).isLoaded()) {
                    String string4 = n + "<blue>  " + anchors.getAnchors().get(n).getName() + "<yellow>  " + anchors.getAnchors().get(n).getLocation().getWorld().getName() + "<gray>  " + anchors.getAnchors().get(n).getLocation().getBlockX() + ", " + anchors.getAnchors().get(n).getLocation().getBlockY() + ", " + anchors.getAnchors().get(n).getLocation().getBlockZ();
                    paginator.addLine(string4);
                    continue;
                }
                String[] stringArray = anchors.getAnchors().get(n).getUnloadedValue();
                String string5 = n + "<blue>  " + anchors.getAnchors().get(n).getName() + "<red>  " + stringArray[0] + "<gray>  " + stringArray[1] + ", " + stringArray[2] + ", " + stringArray[3] + " <white>(unloaded)";
                paginator.addLine(string5);
            }
            n = commandContext.getInteger(1, 1);
            if (!paginator.sendPage(commandSender, n)) {
                throw new CommandException("citizens.commands.page-missing", n);
            }
        }
        if (!commandContext.hasFlag('a')) {
            return;
        }
        if (commandSender instanceof ConsoleCommandSender) {
            throw new ServerCommandException();
        }
        nPC.teleport(commandContext.getSenderLocation(), PlayerTeleportEvent.TeleportCause.COMMAND);
    }

    @Command(aliases={"npc"}, usage="armorstand --visible [visible] --small [small] --marker [marker] --gravity [gravity] --arms [arms] --baseplate [baseplate] --(head|body|leftarm|leftleg|rightarm|rightleg)pose [angle x,y,z]", desc="", modifiers={"armorstand"}, min=1, max=1, valueFlags={"bodypose", "leftarmpose", "rightarmpose", "leftlegpose", "rightlegpose"}, permission="citizens.npc.armorstand")
    @Requirements(selected=true, ownership=true, types={EntityType.ARMOR_STAND})
    public void armorstand(CommandContext commandContext, CommandSender commandSender, NPC nPC, @Flag(value={"visible"}) Boolean bl, @Flag(value={"small"}) Boolean bl2, @Flag(value={"gravity"}) Boolean bl3, @Flag(value={"arms"}) Boolean bl4, @Flag(value={"marker"}) Boolean bl5, @Flag(value={"baseplate"}) Boolean bl6) {
        ArmorStandTrait armorStandTrait = nPC.getOrAddTrait(ArmorStandTrait.class);
        if (bl != null) {
            armorStandTrait.setVisible(bl);
        }
        if (bl2 != null) {
            armorStandTrait.setSmall(bl2);
        }
        if (bl3 != null) {
            armorStandTrait.setGravity(bl3);
        }
        if (bl5 != null) {
            armorStandTrait.setMarker(bl5);
        }
        if (bl4 != null) {
            armorStandTrait.setHasArms(bl4);
        }
        if (bl6 != null) {
            armorStandTrait.setHasBaseplate(bl6);
        }
        ArmorStand armorStand = (ArmorStand)nPC.getEntity();
        if (commandContext.hasValueFlag("headpose")) {
            armorStand.setHeadPose(commandContext.parseEulerAngle(commandContext.getFlag("headpose")));
        }
        if (commandContext.hasValueFlag("bodypose")) {
            armorStand.setBodyPose(commandContext.parseEulerAngle(commandContext.getFlag("bodypose")));
        }
        if (commandContext.hasValueFlag("leftarmpose")) {
            armorStand.setLeftArmPose(commandContext.parseEulerAngle(commandContext.getFlag("leftarmpose")));
        }
        if (commandContext.hasValueFlag("leftlegpose")) {
            armorStand.setLeftLegPose(commandContext.parseEulerAngle(commandContext.getFlag("leftlegpose")));
        }
        if (commandContext.hasValueFlag("rightarmpose")) {
            armorStand.setRightArmPose(commandContext.parseEulerAngle(commandContext.getFlag("rightarmpose")));
        }
        if (commandContext.hasValueFlag("rightlegpose")) {
            armorStand.setRightLegPose(commandContext.parseEulerAngle(commandContext.getFlag("rightlegpose")));
        }
    }

    @Command(aliases={"npc"}, usage="attribute [attribute] [value]", desc="", modifiers={"attribute"}, min=2, max=3, permission="citizens.npc.attribute")
    public void attribute(CommandContext commandContext, CommandSender commandSender, NPC nPC, @Arg(value=1, completionsProvider=OptionalAttributeCompletions.class) String string, @Arg(value=2) Double d) {
        AttributeTrait attributeTrait = nPC.getOrAddTrait(AttributeTrait.class);
        if (d == null) {
            attributeTrait.setDefaultAttribute(Attribute.valueOf((String)string));
            Messaging.sendTr(commandSender, "citizens.commands.npc.attribute.reset", string);
        } else {
            attributeTrait.setAttributeValue(Attribute.valueOf((String)string), d);
            Messaging.sendTr(commandSender, "citizens.commands.npc.attribute.set", string, d);
        }
    }

    @Command(aliases={"npc"}, usage="boat --type [type]", desc="", modifiers={"boat"}, min=1, max=1, permission="citizens.npc.boat")
    public void boat(CommandContext commandContext, CommandSender commandSender, NPC nPC, @Flag(value={"type"}, completionsProvider=OptionalBoatTypeCompletions.class) String string) {
        if (string == null) {
            throw new CommandUsageException();
        }
        Boat.Type type = Boat.Type.valueOf((String)string);
        nPC.getOrAddTrait(BoatTrait.class).setType(type);
        Messaging.sendTr(commandSender, "citizens.commands.npc.boat.type-set", type);
    }

    @Command(aliases={"npc"}, usage="breakblock --location [x,y,z] --radius [radius]", desc="", modifiers={"breakblock"}, min=1, max=1, valueFlags={"location"}, permission="citizens.npc.breakblock")
    @Requirements(selected=true, ownership=true)
    public void breakblock(CommandContext commandContext, CommandSender commandSender, NPC nPC, @Flag(value={"radius"}) Double d) {
        BlockBreaker.BlockBreakerConfiguration blockBreakerConfiguration = new BlockBreaker.BlockBreakerConfiguration();
        if (d != null) {
            blockBreakerConfiguration.radius(d);
        } else if (Settings.Setting.DEFAULT_BLOCK_BREAKER_RADIUS.asDouble() > 0.0) {
            blockBreakerConfiguration.radius(Settings.Setting.DEFAULT_BLOCK_BREAKER_RADIUS.asDouble());
        }
        if (nPC.getEntity() instanceof InventoryHolder) {
            blockBreakerConfiguration.blockBreaker((block, itemStack) -> {
                Inventory inventory = ((InventoryHolder)nPC.getEntity()).getInventory();
                Location location = nPC.getEntity().getLocation();
                for (ItemStack itemStack2 : block.getDrops(itemStack)) {
                    for (ItemStack itemStack3 : inventory.addItem(new ItemStack[]{itemStack2}).values()) {
                        location.getWorld().dropItemNaturally(nPC.getEntity().getLocation(), itemStack3);
                    }
                }
            });
        }
        BlockBreaker blockBreaker = nPC.getBlockBreaker(commandContext.getSenderTargetBlockLocation().getBlock(), blockBreakerConfiguration);
        nPC.getDefaultGoalController().addBehavior(StatusMapper.singleUse(blockBreaker), 1);
    }

    @Command(aliases={"npc"}, usage="chunkload (-t(emporary))", desc="", modifiers={"chunkload", "cload"}, min=1, max=1, flags="t", permission="citizens.npc.chunkload")
    @Requirements(selected=true, ownership=true)
    public void chunkload(CommandContext commandContext, CommandSender commandSender, NPC nPC) {
        boolean bl;
        boolean bl2 = bl = nPC.data().get(NPC.Metadata.KEEP_CHUNK_LOADED, Boolean.valueOf(Settings.Setting.KEEP_CHUNKS_LOADED.asBoolean())) == false;
        if (commandContext.hasFlag('t')) {
            nPC.data().set(NPC.Metadata.KEEP_CHUNK_LOADED, (Object)bl);
        } else {
            nPC.data().setPersistent(NPC.Metadata.KEEP_CHUNK_LOADED, (Object)bl);
        }
        Messaging.sendTr(commandSender, bl ? "citizens.commands.npc.chunkload.set" : "citizens.commands.npc.chunkload.unset", nPC.getName());
    }

    @Command(aliases={"npc"}, usage="collidable", desc="", modifiers={"collidable", "pushable"}, min=1, max=1, permission="citizens.npc.collidable")
    @Requirements(ownership=true, selected=true)
    public void collidable(CommandContext commandContext, CommandSender commandSender, NPC nPC) {
        nPC.data().setPersistent(NPC.Metadata.COLLIDABLE, (Object)(nPC.data().get(NPC.Metadata.COLLIDABLE, Boolean.valueOf(!nPC.isProtected())) == false ? 1 : 0));
        Messaging.sendTr(commandSender, (Boolean)nPC.data().get(NPC.Metadata.COLLIDABLE) != false ? "citizens.commands.npc.collidable.set" : "citizens.commands.npc.collidable.unset", nPC.getName());
    }

    @Command(aliases={"npc"}, usage="command|cmd (add [command] | remove [id|all] | permissions [permissions] | sequential | cycle | random | forgetplayer (uuid) | clearerror [type] (name|uuid) | errormsg [type] [msg] | persistsequence [true|false] | cost [cost] (id) | expcost [cost] (id) | itemcost (id)) (-s(hift)) (-l[eft]/-r[ight]) (-p[layer] -o[p]), --cooldown --gcooldown [seconds] --delay [ticks] --permissions [perms] --n [max # of uses]", desc="", modifiers={"command", "cmd"}, min=1, flags="lrpos", permission="citizens.npc.command")
    public void command(CommandContext commandContext, CommandSender commandSender, NPC nPC, @Flag(value={"permissions", "permission"}) String string, @Flag(value={"cost"}, defValue="-1") Double d, @Flag(value={"expcost"}, defValue="-1") Integer n, @Flag(value={"cooldown"}, defValue="0") Duration duration, @Flag(value={"gcooldown"}, defValue="0") Duration duration2, @Flag(value={"n"}, defValue="-1") int n2, @Flag(value={"delay"}, defValue="0") Duration duration3, @Arg(value=1, completions={"add", "remove", "permissions", "persistsequence", "sequential", "cycle", "random", "forgetplayer", "hideerrors", "errormsg", "clearerror", "expcost", "itemcost", "cost"}) String string2) {
        CommandTrait commandTrait = nPC.getOrAddTrait(CommandTrait.class);
        if (commandContext.argsLength() == 1) {
            commandTrait.describe(commandSender);
        } else if (string2.equalsIgnoreCase("add")) {
            CommandTrait.Hand hand;
            if (commandContext.argsLength() == 2) {
                throw new CommandUsageException();
            }
            if (commandContext.hasFlag('o') && !commandSender.hasPermission("citizens.admin")) {
                throw new NoPermissionsException();
            }
            String string3 = commandContext.getJoinedStrings(2);
            CommandTrait.Hand hand2 = commandContext.hasFlag('l') && commandContext.hasFlag('r') ? CommandTrait.Hand.BOTH : (hand = commandContext.hasFlag('l') ? CommandTrait.Hand.LEFT : CommandTrait.Hand.RIGHT);
            if (commandContext.hasFlag('s') && hand != CommandTrait.Hand.BOTH) {
                hand = hand == CommandTrait.Hand.LEFT ? CommandTrait.Hand.SHIFT_LEFT : CommandTrait.Hand.SHIFT_RIGHT;
            }
            ArrayList arrayList = Lists.newArrayList();
            if (string != null) {
                arrayList.addAll(Arrays.asList(string.split(",")));
            }
            if (string3.toLowerCase().startsWith("npc select")) {
                throw new CommandException("npc select not currently supported within commands. Use --id <id> instead");
            }
            try {
                int n3 = commandTrait.addCommand(new CommandTrait.NPCCommandBuilder(string3, hand).addPerms(arrayList).player(commandContext.hasFlag('p') || commandContext.hasFlag('o')).op(commandContext.hasFlag('o')).cooldown(duration).cost(d).experienceCost(n).globalCooldown(duration2).n(n2).delay(duration3));
                Messaging.sendTr(commandSender, "citizens.commands.npc.command.command-added", string3, n3);
            }
            catch (NumberFormatException numberFormatException) {
                throw new CommandException("citizens.commands.invalid-number");
            }
        } else if (string2.equalsIgnoreCase("forgetplayer")) {
            if (commandContext.argsLength() < 3) {
                commandTrait.clearPlayerHistory(null);
                Messaging.sendTr(commandSender, "citizens.commands.npc.command.all-players-forgotten", nPC.getName());
                return;
            }
            String string4 = commandContext.getString(2);
            Player player = Bukkit.getPlayerExact((String)string4);
            if (player == null) {
                player = Bukkit.getOfflinePlayer((UUID)UUID.fromString(string4));
            }
            if (player == null || !player.hasPlayedBefore()) {
                throw new CommandException("citizens.commands.npc.command.invalid-player", string4);
            }
            commandTrait.clearPlayerHistory(player.getUniqueId());
            Messaging.sendTr(commandSender, "citizens.commands.npc.command.player-forgotten", player.getUniqueId());
        } else if (string2.equalsIgnoreCase("clearerror")) {
            if (commandContext.argsLength() < 3) {
                throw new CommandException("citizens.commands.npc.command.invalid-error-message", Util.listValuesPretty(CommandTrait.CommandTraitError.values()));
            }
            CommandTrait.CommandTraitError commandTraitError = (CommandTrait.CommandTraitError)Util.matchEnum((Enum[])CommandTrait.CommandTraitError.values(), (String)commandContext.getString(2));
            if (commandTraitError == null) {
                throw new CommandException("citizens.commands.npc.command.invalid-error-message", Util.listValuesPretty(CommandTrait.CommandTraitError.values()));
            }
            if (commandContext.argsLength() < 4) {
                commandTrait.clearHistory(commandTraitError, null);
                Messaging.sendTr(commandSender, "citizens.commands.npc.command.all-errors-cleared", nPC.getName(), Util.prettyEnum(commandTraitError));
                return;
            }
            String string5 = commandContext.getString(3);
            Player player = Bukkit.getPlayerExact((String)string5);
            if (player == null) {
                player = Bukkit.getOfflinePlayer((UUID)UUID.fromString(string5));
            }
            if (player == null || !player.hasPlayedBefore()) {
                throw new CommandException("citizens.commands.npc.command.invalid-player", string5);
            }
            commandTrait.clearHistory(commandTraitError, player.getUniqueId());
            Messaging.sendTr(commandSender, "citizens.commands.npc.command.errors-cleared", Util.prettyEnum(commandTraitError), player.getUniqueId());
        } else if (string2.equalsIgnoreCase("sequential")) {
            commandTrait.setExecutionMode(commandTrait.getExecutionMode() == CommandTrait.ExecutionMode.SEQUENTIAL ? CommandTrait.ExecutionMode.LINEAR : CommandTrait.ExecutionMode.SEQUENTIAL);
            Messaging.sendTr(commandSender, commandTrait.getExecutionMode() == CommandTrait.ExecutionMode.SEQUENTIAL ? "citizens.commands.npc.commands.sequential-set" : "citizens.commands.npc.commands.sequential-unset", new Object[0]);
        } else if (string2.equalsIgnoreCase("cycle")) {
            commandTrait.setExecutionMode(commandTrait.getExecutionMode() == CommandTrait.ExecutionMode.CYCLE ? CommandTrait.ExecutionMode.LINEAR : CommandTrait.ExecutionMode.CYCLE);
            Messaging.sendTr(commandSender, commandTrait.getExecutionMode() == CommandTrait.ExecutionMode.CYCLE ? "citizens.commands.npc.command.cycle-set" : "citizens.commands.npc.command.cycle-unset", new Object[0]);
        } else if (string2.equalsIgnoreCase("persistsequence")) {
            if (commandContext.argsLength() == 2) {
                commandTrait.setPersistSequence(!commandTrait.persistSequence());
            } else {
                commandTrait.setPersistSequence(Boolean.parseBoolean(commandContext.getString(3)));
            }
            Messaging.sendTr(commandSender, commandTrait.persistSequence() ? "citizens.commands.npc.command.persist-sequence-set" : "citizens.commands.npc.command.persist-sequence-unset", new Object[0]);
        } else if (string2.equalsIgnoreCase("remove")) {
            if (commandContext.argsLength() == 2) {
                throw new CommandUsageException();
            }
            if (commandContext.getString(2).equalsIgnoreCase("all")) {
                commandTrait.clear();
                Messaging.sendTr(commandSender, "citizens.commands.npc.command.cleared", nPC.getName());
            } else {
                int n4 = commandContext.getInteger(2, -1);
                if (!commandTrait.hasCommandId(n4)) {
                    throw new CommandException("citizens.commands.npc.command.unknown-id", n4);
                }
                commandTrait.removeCommandById(n4);
                Messaging.sendTr(commandSender, "citizens.commands.npc.command.command-removed", n4);
            }
        } else if (string2.equalsIgnoreCase("permissions") || string2.equalsIgnoreCase("perms")) {
            if (!commandSender.hasPermission("citizens.admin")) {
                throw new NoPermissionsException();
            }
            List<String> list = Arrays.asList(commandContext.getSlice(2));
            commandTrait.setTemporaryPermissions(list);
            Messaging.sendTr(commandSender, "citizens.commands.npc.command.temporary-permissions-set", Joiner.on((char)' ').join(list));
        } else if (string2.equalsIgnoreCase("cost")) {
            if (commandContext.argsLength() == 2) {
                throw new CommandException("citizens.commands.npc.command.cost-missing");
            }
            commandTrait.setCost(commandContext.getDouble(2));
            Messaging.sendTr(commandSender, "citizens.commands.npc.command.cost-set", commandContext.getDouble(2));
        } else if (string2.equalsIgnoreCase("expcost")) {
            if (commandContext.argsLength() == 2) {
                throw new CommandException("citizens.commands.npc.command.cost-missing");
            }
            commandTrait.setExperienceCost(commandContext.getInteger(2));
            Messaging.sendTr(commandSender, "citizens.commands.npc.command.experience-cost-set", commandContext.getInteger(2));
        } else if (string2.equalsIgnoreCase("hideerrors")) {
            commandTrait.setHideErrorMessages(!commandTrait.isHideErrorMessages());
            Messaging.sendTr(commandSender, commandTrait.isHideErrorMessages() ? "citizens.commands.npc.command.hide-error-messages-set" : "citizens.commands.npc.command.hide-error-messages-unset", new Object[0]);
        } else if (string2.equalsIgnoreCase("random")) {
            commandTrait.setExecutionMode(commandTrait.getExecutionMode() == CommandTrait.ExecutionMode.RANDOM ? CommandTrait.ExecutionMode.LINEAR : CommandTrait.ExecutionMode.RANDOM);
            Messaging.sendTr(commandSender, commandTrait.getExecutionMode() == CommandTrait.ExecutionMode.RANDOM ? "citizens.commands.npc.commands.random-set" : "citizens.commands.npc.commands.random-unset", new Object[0]);
        } else if (string2.equalsIgnoreCase("itemcost")) {
            if (!(commandSender instanceof Player)) {
                throw new CommandException("citizens.commands.requirements.must-be-ingame");
            }
            if (commandContext.argsLength() == 2) {
                InventoryMenu.createSelfRegistered(new CommandTrait.ItemRequirementGUI(commandTrait)).present((HumanEntity)((Player)commandSender));
            } else {
                InventoryMenu.createSelfRegistered(new CommandTrait.ItemRequirementGUI(commandTrait, commandContext.getInteger(2))).present((HumanEntity)((Player)commandSender));
            }
        } else if (string2.equalsIgnoreCase("errormsg")) {
            CommandTrait.CommandTraitError commandTraitError = (CommandTrait.CommandTraitError)Util.matchEnum((Enum[])CommandTrait.CommandTraitError.values(), (String)commandContext.getString(2));
            if (commandTraitError == null) {
                throw new CommandException("citizens.commands.npc.command.invalid-error-message", Util.listValuesPretty(CommandTrait.CommandTraitError.values()));
            }
            commandTrait.setCustomErrorMessage(commandTraitError, commandContext.getString(3));
        } else {
            throw new CommandUsageException();
        }
    }

    @Command(aliases={"npc"}, usage="configgui", desc="", modifiers={"configgui"}, min=1, max=1, permission="citizens.npc.configgui")
    public void configgui(CommandContext commandContext, Player player, NPC nPC) {
        InventoryMenu.createSelfRegistered(new NPCConfigurator(nPC)).present((HumanEntity)player);
    }

    @Command(aliases={"npc"}, usage="controllable|control (-m(ount),-o(wner required)) (--controls [controls]) (--enabled [true|false])", desc="", modifiers={"controllable", "control"}, min=1, max=1, flags="mo")
    public void controllable(CommandContext commandContext, CommandSender commandSender, NPC nPC, @Flag(value={"controls"}) Controllable.BuiltInControls builtInControls, @Flag(value={"enabled"}) Boolean bl) {
        if (nPC.isSpawned() && !commandSender.hasPermission("citizens.npc.controllable." + nPC.getEntity().getType().name().toLowerCase().replace("_", "")) || !commandSender.hasPermission("citizens.npc.controllable")) {
            throw new NoPermissionsException();
        }
        if (!nPC.hasTrait(Controllable.class) && bl == null) {
            nPC.getOrAddTrait(Controllable.class).setEnabled(false);
        }
        Controllable controllable = nPC.getOrAddTrait(Controllable.class);
        if (bl != null) {
            controllable.setEnabled(bl);
        } else {
            bl = controllable.toggle();
        }
        if (builtInControls != null) {
            controllable.setControls(builtInControls);
        }
        controllable.setOwnerRequired(commandContext.hasFlag('o'));
        String string = bl != false ? "citizens.commands.npc.controllable.set" : "citizens.commands.npc.controllable.removed";
        Messaging.sendTr(commandSender, string, nPC.getName());
        if (controllable.isEnabled() && commandContext.hasFlag('m') && commandSender instanceof Player) {
            controllable.mount((Player)commandSender);
        }
    }

    @Command(aliases={"npc"}, usage="copy (--name newname)", desc="", modifiers={"copy"}, min=1, max=1, permission="citizens.npc.copy")
    public void copy(CommandContext commandContext, CommandSender commandSender, NPC nPC, @Flag(value={"name"}) String string) {
        Object object;
        NPC nPC2;
        if (string == null) {
            string = nPC.getRawName();
        }
        if (!(nPC2 = nPC.clone()).getRawName().equals(string)) {
            nPC2.setName(string);
        }
        if (nPC2.getOrAddTrait(Spawned.class).shouldSpawn() && commandContext.getSenderLocation() != null) {
            object = commandContext.getSenderLocation();
            object.getChunk().load();
            nPC2.teleport((Location)object, PlayerTeleportEvent.TeleportCause.COMMAND);
            nPC2.getOrAddTrait(CurrentLocation.class).setLocation((Location)object);
        }
        object = commandSender instanceof Player ? new PlayerCloneNPCEvent((Player)commandSender, nPC, nPC2) : new CommandSenderCloneNPCEvent(commandSender, nPC, nPC2);
        Bukkit.getPluginManager().callEvent((Event)object);
        if (((CommandSenderCreateNPCEvent)((Object)object)).isCancelled()) {
            ((NPCEvent)((Object)object)).getNPC().destroy();
            String string2 = "Couldn't create NPC.";
            if (!((CommandSenderCreateNPCEvent)((Object)object)).getCancelReason().isEmpty()) {
                string2 = string2 + " Reason: " + ((CommandSenderCreateNPCEvent)((Object)object)).getCancelReason();
            }
            throw new CommandException(string2);
        }
        Messaging.sendTr(commandSender, "citizens.commands.npc.copy.copied", nPC.getName());
        this.selector.select(commandSender, nPC2);
        this.history.add(commandSender, new CreateNPCHistoryItem(nPC2));
    }

    @Command(aliases={"npc"}, usage="create [name] ((-b(aby),u(nspawned),s(ilent),t(emporary),c(enter),p(acket)) --at [x,y,z,world] --type [type] --item (item) --trait ['trait1, trait2...'] --model [model name] --nameplate [true|false|hover] --temporaryticks [ticks] --registry [registry name]", desc="", flags="bustpc", modifiers={"create"}, min=2, permission="citizens.npc.create")
    @Requirements
    public void create(CommandContext commandContext, CommandSender commandSender, NPC nPC, @Flag(value={"at"}) Location location, @Flag(value={"type"}, defValue="PLAYER") EntityType entityType, @Flag(value={"trait"}) String string, @Flag(value={"nameplate"}, completions={"true", "false", "hover"}) String string2, @Flag(value={"temporaryticks"}) Integer n, @Flag(value={"item"}) String string3, @Flag(value={"template"}) String string4, @Flag(value={"registry"}) String string5) {
        StringBuilder stringBuilder;
        Iterable iterable;
        NPC nPC2;
        Object object;
        String string6 = commandContext.getJoinedStrings(1).trim();
        if (commandContext.hasValueFlag("type")) {
            if (entityType == null) {
                throw new CommandException(Messaging.tr("citizens.commands.npc.create.invalid-mobtype", commandContext.getFlag("type")));
            }
            if (!EntityControllers.controllerExistsForType(entityType)) {
                throw new CommandException(Messaging.tr("citizens.commands.npc.create.mobtype-missing", commandContext.getFlag("type")));
            }
        }
        int n2 = SpigotUtil.getMaxNameLength(entityType);
        if (Placeholders.replace(Messaging.stripColor(string6), commandSender, nPC).length() > n2) {
            Messaging.sendErrorTr(commandSender, "citizens.commands.npc.create.npc-name-too-long", n2);
            string6 = string6.substring(0, n2);
        }
        if (string6.length() == 0) {
            throw new CommandException();
        }
        if (!(commandSender.hasPermission("citizens.npc.create.*") || commandSender.hasPermission("citizens.npc.createall") || commandSender.hasPermission("citizens.npc.create." + entityType.name().toLowerCase().replace("_", "")))) {
            throw new NoPermissionsException();
        }
        if (!(location == null && string5 == null && string == null && string4 == null || commandSender.hasPermission("citizens.npc.admin"))) {
            throw new NoPermissionsException();
        }
        NPCRegistry nPCRegistry = CitizensAPI.getNPCRegistry();
        if (string5 != null && (nPCRegistry = CitizensAPI.getNamedNPCRegistry(string5)) == null) {
            nPCRegistry = CitizensAPI.createNamedNPCRegistry(string5, new MemoryNPCDataStore());
            Messaging.send(commandSender, "An in-memory registry has been created named [[" + string5 + "]].");
        }
        if (commandContext.hasFlag('t') || n != null) {
            nPCRegistry = this.temporaryRegistry;
        }
        if (string3 != null) {
            object = Util.parseItemStack(null, string3);
            nPC = nPCRegistry.createNPCUsingItem(entityType, string6, (ItemStack)object);
        } else {
            nPC = nPCRegistry.createNPC(entityType, string6);
        }
        object = "Created [[" + nPC.getName() + "]] (ID [[" + nPC.getId() + "]])";
        if (commandContext.hasFlag('b')) {
            object = (String)object + " as a baby";
            nPC.getOrAddTrait(Age.class).setAge(-24000);
        }
        if (commandContext.hasFlag('s')) {
            nPC.data().set(NPC.Metadata.SILENT, (Object)true);
        }
        if (string2 != null) {
            nPC.data().set(NPC.Metadata.NAMEPLATE_VISIBLE, string2.equalsIgnoreCase("hover") ? string2.toLowerCase() : Boolean.valueOf(Boolean.parseBoolean(string2)));
        }
        if (!Settings.Setting.SERVER_OWNS_NPCS.asBoolean()) {
            nPC.getOrAddTrait(Owner.class).setOwner(commandSender);
        }
        if (n != null) {
            nPC2 = nPC;
            Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), () -> {
                if (this.temporaryRegistry.getByUniqueId(nPC2.getUniqueId()) == nPC2) {
                    nPC2.destroy();
                }
            }, (long)n.intValue());
        }
        nPC.getOrAddTrait(MobType.class).setType(entityType);
        if (commandContext.hasFlag('p')) {
            nPC.addTrait(PacketNPC.class);
        }
        nPC2 = commandContext.getSenderLocation();
        CommandSenderCreateNPCEvent commandSenderCreateNPCEvent = commandSender instanceof Player ? new PlayerCreateNPCEvent((Player)commandSender, nPC) : new CommandSenderCreateNPCEvent(commandSender, nPC);
        Bukkit.getPluginManager().callEvent((Event)commandSenderCreateNPCEvent);
        if (commandSenderCreateNPCEvent.isCancelled()) {
            nPC.destroy();
            String string7 = "Couldn't create NPC.";
            if (!commandSenderCreateNPCEvent.getCancelReason().isEmpty()) {
                string7 = string7 + " Reason: " + commandSenderCreateNPCEvent.getCancelReason();
            }
            throw new CommandException(string7);
        }
        if (location != null) {
            nPC2 = location;
            nPC2.getChunk().load();
        }
        if (nPC2 == null) {
            nPC.destroy();
            throw new CommandException("citizens.commands.npc.create.invalid-location");
        }
        if (commandContext.hasFlag('c')) {
            nPC2 = Util.getCenterLocation(nPC2.getBlock());
        }
        if (!commandContext.hasFlag('u')) {
            nPC.spawn((Location)nPC2, SpawnReason.CREATE);
        }
        if (string != null) {
            iterable = Splitter.on((char)',').trimResults().split((CharSequence)string);
            stringBuilder = new StringBuilder();
            for (String string8 : iterable) {
                Object t = CitizensAPI.getTraitFactory().getTrait(string8);
                if (t == null) continue;
                nPC.addTrait((Trait)t);
                stringBuilder.append(StringHelper.wrap(string8) + ", ");
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.delete(stringBuilder.length() - 2, stringBuilder.length());
            }
            object = (String)object + " with traits " + stringBuilder.toString();
        }
        if (string4 != null) {
            iterable = Splitter.on((char)',').trimResults().split((CharSequence)string4);
            stringBuilder = new StringBuilder();
            for (String string8 : iterable) {
                if (string8.contains(":")) {
                    int n3 = string8.indexOf(58);
                    Template template = this.templateRegistry.getTemplateByKey(new NamespacedKey(string8.substring(0, n3), string8.substring(n3 + 1)));
                    if (template == null) continue;
                    template.apply(nPC);
                    stringBuilder.append(StringHelper.wrap(string8) + ", ");
                    continue;
                }
                Collection<Template> collection = this.templateRegistry.getTemplates(string8);
                if (collection.size() != 1) continue;
                collection.iterator().next().apply(nPC);
                stringBuilder.append(StringHelper.wrap(string8) + ", ");
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.delete(stringBuilder.length() - 2, stringBuilder.length());
            }
            object = (String)object + " with templates " + stringBuilder.toString();
        }
        this.selector.select(commandSender, nPC);
        this.history.add(commandSender, new CreateNPCHistoryItem(nPC));
        Messaging.send(commandSender, (String)object + '.');
    }

    @Command(aliases={"npc"}, usage="debug -p(aths) -n(avigation)", desc="", modifiers={"debug"}, min=1, max=1, flags="pn", permission="citizens.npc.debug")
    @Requirements(ownership=true, selected=true)
    public void debug(CommandContext commandContext, CommandSender commandSender, NPC nPC) {
        if (commandContext.hasFlag('p')) {
            nPC.getNavigator().getDefaultParameters().debug(!nPC.getNavigator().getDefaultParameters().debug());
            Messaging.send(commandSender, "Path debugging set to " + nPC.getNavigator().getDefaultParameters().debug());
        } else if (commandContext.hasFlag('n')) {
            String string = "Use new finder [[" + nPC.getNavigator().getDefaultParameters().useNewPathfinder();
            string = string + "]] distance margin [[" + nPC.getNavigator().getDefaultParameters().distanceMargin() + "]] (path margin [[" + nPC.getNavigator().getDefaultParameters().pathDistanceMargin() + "]])<br>";
            string = string + "Teleport if below " + nPC.getNavigator().getDefaultParameters().destinationTeleportMargin() + " blocks<br>";
            string = string + "Range [[" + nPC.getNavigator().getDefaultParameters().range() + "]] speed [[" + nPC.getNavigator().getDefaultParameters().speed() + "]]<br>";
            string = string + "Stuck action [[" + nPC.getNavigator().getDefaultParameters().stuckAction() + "]]<br>";
            Messaging.send(commandSender, string);
        }
    }

    @Command(aliases={"npc"}, usage="deselect", desc="", modifiers={"deselect", "desel"}, min=1, max=1, permission="citizens.npc.deselect")
    @Requirements
    public void deselect(CommandContext commandContext, CommandSender commandSender, NPC nPC) {
        this.selector.deselect(commandSender);
        Messaging.sendTr(commandSender, "citizens.commands.npc.deselect", new Object[0]);
    }

    @Command(aliases={"npc"}, usage="despawn (id)", desc="", modifiers={"despawn"}, min=1, max=2, permission="citizens.npc.despawn")
    @Requirements
    public void despawn(CommandContext commandContext, CommandSender commandSender, NPC nPC2) {
        NPCCommandSelector.Callback callback = nPC -> {
            if (nPC == null) {
                throw new CommandException("citizens.commands.npc.spawn.missing-npc-id", commandContext.getString(1));
            }
            nPC.getOrAddTrait(Spawned.class).setSpawned(false);
            nPC.despawn(DespawnReason.REMOVAL);
            Messaging.sendTr(commandSender, "citizens.commands.npc.despawn.despawned", nPC.getName());
        };
        if (nPC2 == null || commandContext.argsLength() == 2) {
            if (commandContext.argsLength() < 2) {
                throw new CommandException("citizens.commands.requirements.must-have-selected");
            }
            NPCCommandSelector.startWithCallback(callback, CitizensAPI.getNPCRegistry(), commandSender, commandContext, commandContext.getString(1));
        } else {
            callback.run(nPC2);
        }
    }

    @Command(aliases={"npc"}, usage="drops", desc="", modifiers={"drops"}, min=1, max=1, permission="citizens.npc.drops")
    @Requirements(ownership=true, selected=true)
    public void drops(CommandContext commandContext, Player player, NPC nPC) {
        DropsTrait dropsTrait = nPC.getOrAddTrait(DropsTrait.class);
        dropsTrait.displayEditor(player);
    }

    @Command(aliases={"npc"}, usage="endercrystal -b(ottom)", desc="", modifiers={"endercrystal"}, min=1, max=1, flags="b", permission="citizens.npc.endercrystal")
    @Requirements(ownership=true, selected=true)
    public void endercrystal(CommandContext commandContext, CommandSender commandSender, NPC nPC) {
        if (!nPC.getOrAddTrait(MobType.class).getType().name().equals("END_CRYSTAL") && !nPC.getOrAddTrait(MobType.class).getType().name().equals("ENDER_CRYSTAL")) {
            throw new CommandException();
        }
        if (commandContext.hasFlag('b')) {
            EnderCrystalTrait enderCrystalTrait = nPC.getOrAddTrait(EnderCrystalTrait.class);
            boolean bl = !enderCrystalTrait.isShowBase();
            enderCrystalTrait.setShowBase(bl);
            Messaging.sendTr(commandSender, bl ? "citizens.commands.npc.endercrystal.showing-bottom" : "citizens.commands.npc.endercrystal.not-showing-bottom", nPC.getName());
            return;
        }
        throw new CommandException();
    }

    @Command(aliases={"npc"}, usage="enderman -a(ngry)", desc="", flags="a", modifiers={"enderman"}, min=1, max=2, permission="citizens.npc.enderman")
    public void enderman(CommandContext commandContext, CommandSender commandSender, NPC nPC) {
        if (commandContext.hasFlag('a')) {
            boolean bl = nPC.getOrAddTrait(EndermanTrait.class).toggleAngry();
            Messaging.sendTr(commandSender, bl ? "citizens.commands.npc.enderman.angry-set" : "citizens.commands.npc.enderman.angry-unset", nPC.getName());
        }
        throw new CommandUsageException();
    }

    @Command(aliases={"npc"}, usage="entitypose [pose]", desc="", modifiers={"entitypose"}, min=2, max=2, permission="citizens.npc.entitypose")
    public void entitypose(CommandContext commandContext, CommandSender commandSender, NPC nPC, @Arg(value=1) EntityPoseTrait.EntityPose entityPose) {
        if (entityPose == null) {
            throw new CommandUsageException();
        }
        nPC.getOrAddTrait(EntityPoseTrait.class).setPose(entityPose);
        Messaging.sendTr(commandSender, "citizens.commands.npc.entitypose.set", new Object[]{entityPose});
    }

    @Command(aliases={"npc"}, usage="flyable (true|false)", desc="", modifiers={"flyable"}, min=1, max=2, permission="citizens.npc.flyable")
    @Requirements(selected=true, ownership=true, excludedTypes={EntityType.BAT, EntityType.BLAZE, EntityType.ENDER_DRAGON, EntityType.GHAST, EntityType.WITHER})
    public void flyable(CommandContext commandContext, CommandSender commandSender, NPC nPC, @Arg(value=1) Boolean bl) {
        boolean bl2 = bl != null ? bl : !nPC.isFlyable();
        nPC.setFlyable(bl2);
        bl2 = nPC.isFlyable();
        Messaging.sendTr(commandSender, bl2 ? "citizens.commands.npc.flyable.set" : "citizens.commands.npc.flyable.unset", nPC.getName());
    }

    @Command(aliases={"npc"}, usage="follow (player name|NPC id) (-p[rotect]) (--margin [margin]) (--enable [boolean])", desc="", flags="p", modifiers={"follow"}, min=1, max=2, permission="citizens.npc.follow")
    public void follow(CommandContext commandContext, CommandSender commandSender, NPC nPC, @Flag(value={"margin"}) Double d, @Flag(value={"enable"}) Boolean bl) {
        OfflinePlayer offlinePlayer;
        boolean bl2 = commandContext.hasFlag('p');
        FollowTrait followTrait = nPC.getOrAddTrait(FollowTrait.class);
        if (d != null) {
            followTrait.setFollowingMargin(d);
            Messaging.sendTr(commandSender, "citizens.commands.npc.follow.margin-set", nPC.getName(), d);
            return;
        }
        followTrait.setProtect(bl2);
        String string = commandSender.getName();
        if (commandContext.argsLength() > 1) {
            string = commandContext.getString(1);
        }
        if (!(offlinePlayer = Bukkit.getOfflinePlayer((String)string)).hasPlayedBefore() && !offlinePlayer.isOnline()) {
            NPCCommandSelector.Callback callback = nPC2 -> {
                if (nPC2 == null) {
                    throw new CommandException("citizens.commands.requirements.must-have-selected");
                }
                if (!(commandSender instanceof ConsoleCommandSender) && !nPC2.getOrAddTrait(Owner.class).isOwnedBy(commandSender)) {
                    throw new CommandException("citizens.commands.requirements.must-be-owner");
                }
                boolean bl2 = bl == null ? !followTrait.isEnabled() : bl;
                followTrait.follow(bl2 ? nPC2.getEntity() : null);
                Messaging.sendTr(commandSender, bl2 ? "citizens.commands.npc.follow.set" : "citizens.commands.npc.follow.unset", nPC.getName(), nPC2.getName());
            };
            NPCCommandSelector.startWithCallback(callback, CitizensAPI.getNPCRegistry(), commandSender, commandContext, commandContext.getString(1));
            return;
        }
        boolean bl3 = bl == null ? !followTrait.isEnabled() : bl;
        followTrait.follow((Entity)(bl3 ? offlinePlayer.getPlayer() : null));
        Messaging.sendTr(commandSender, bl3 ? "citizens.commands.npc.follow.set" : "citizens.commands.npc.follow.unset", nPC.getName(), offlinePlayer.getName());
    }

    @Command(aliases={"npc"}, usage="forcefield --width [width] --height [height] --strength [strength]", desc="", modifiers={"forcefield"}, min=1, max=1, permission="citizens.npc.forcefield")
    public void forcefield(CommandContext commandContext, CommandSender commandSender, NPC nPC, @Flag(value={"width"}) Double d, @Flag(value={"height"}) Double d2, @Flag(value={"strength"}) Double d3) {
        ForcefieldTrait forcefieldTrait = nPC.getOrAddTrait(ForcefieldTrait.class);
        String string = "";
        if (d != null) {
            forcefieldTrait.setWidth(d);
            string = string + Messaging.tr("citizens.commands.npc.forcefield.width-set", d);
        }
        if (d2 != null) {
            forcefieldTrait.setHeight(d2);
            string = string + Messaging.tr("citizens.commands.npc.forcefield.height-set", d2);
        }
        if (d3 != null) {
            forcefieldTrait.setStrength(d3);
            string = string + Messaging.tr("citizens.commands.npc.forcefield.strength-set", d3);
        }
        if (!string.isEmpty()) {
            Messaging.send(commandSender, string);
        } else {
            Messaging.sendTr(commandSender, "citizens.commands.npc.forcefield.describe", nPC.getName(), forcefieldTrait.getHeight(), forcefieldTrait.getWidth(), forcefieldTrait.getStrength());
        }
    }

    @Command(aliases={"npc"}, usage="gamemode [gamemode]", desc="", modifiers={"gamemode"}, min=1, max=2, permission="citizens.npc.gamemode")
    @Requirements(selected=true, ownership=true, types={EntityType.PLAYER})
    public void gamemode(CommandContext commandContext, CommandSender commandSender, NPC nPC, @Arg(value=1) GameMode gameMode) {
        Player player = (Player)nPC.getEntity();
        if (commandContext.argsLength() == 1) {
            Messaging.sendTr(commandSender, "citizens.commands.npc.gamemode.describe", nPC.getName(), player.getGameMode().name().toLowerCase());
            return;
        }
        if (gameMode == null) {
            Messaging.sendErrorTr(commandSender, "citizens.commands.npc.gamemode.invalid", commandContext.getString(1));
            return;
        }
        nPC.getOrAddTrait(GameModeTrait.class).setGameMode(gameMode);
        Messaging.sendTr(commandSender, "citizens.commands.npc.gamemode.set", Util.prettyEnum(gameMode));
    }

    @Command(aliases={"npc"}, usage="glowing --color [minecraft chat color]", desc="", modifiers={"glowing"}, min=1, max=1, permission="citizens.npc.glowing")
    @Requirements(selected=true, ownership=true)
    public void glowing(CommandContext commandContext, CommandSender commandSender, NPC nPC, @Flag(value={"color"}) ChatColor chatColor) {
        if (chatColor != null) {
            nPC.getOrAddTrait(ScoreboardTrait.class).setColor(chatColor);
            if (!nPC.data().has(NPC.Metadata.GLOWING)) {
                nPC.data().setPersistent(NPC.Metadata.GLOWING, (Object)true);
            }
            Messaging.sendTr(commandSender, "citizens.commands.npc.glowing.color-set", nPC.getName(), chatColor + Util.prettyEnum(chatColor));
            return;
        }
        nPC.data().setPersistent(NPC.Metadata.GLOWING, (Object)(nPC.data().get(NPC.Metadata.GLOWING, Boolean.valueOf(false)) == false ? 1 : 0));
        boolean bl = (Boolean)nPC.data().get(NPC.Metadata.GLOWING);
        Messaging.sendTr(commandSender, bl ? "citizens.commands.npc.glowing.set" : "citizens.commands.npc.glowing.unset", nPC.getName());
    }

    @Command(aliases={"npc"}, usage="gravity", desc="", modifiers={"gravity"}, min=1, max=1, permission="citizens.npc.gravity")
    public void gravity(CommandContext commandContext, CommandSender commandSender, NPC nPC) {
        boolean bl = nPC.getOrAddTrait(Gravity.class).toggle();
        String string = !bl ? "citizens.commands.npc.gravity.enabled" : "citizens.commands.npc.gravity.disabled";
        Messaging.sendTr(commandSender, string, nPC.getName());
    }

    @Command(aliases={"npc"}, usage="hitbox --scale [scale] --width/height [value]", desc="", modifiers={"hitbox"}, min=1, max=1, permission="citizens.npc.hitbox")
    public void hitbox(CommandContext commandContext, CommandSender commandSender, NPC nPC, @Flag(value={"scale"}) Float f, @Flag(value={"width"}) Float f2, @Flag(value={"height"}) Float f3) {
        if (f != null) {
            nPC.getOrAddTrait(BoundingBoxTrait.class).setScale(f.floatValue());
        }
        if (f2 != null) {
            nPC.getOrAddTrait(BoundingBoxTrait.class).setWidth(f2.floatValue());
        }
        if (f3 != null) {
            nPC.getOrAddTrait(BoundingBoxTrait.class).setHeight(f3.floatValue());
        }
        EntityDim entityDim = nPC.getOrAddTrait(BoundingBoxTrait.class).getAdjustedBoundingBox();
        Messaging.sendTr(commandSender, "citizens.commands.npc.hitbox.set", "width " + entityDim.width + " height " + entityDim.height);
    }

    @Command(aliases={"npc"}, usage="hologram add [text] | set [line #] [text] | remove [line #] | bgcolor [line #] (color) | clear | lineheight [height] | viewrange [range] | margintop [line #] [margin] | marginbottom [line #] [margin]", desc="", modifiers={"hologram"}, min=1, max=-1, permission="citizens.npc.hologram")
    public void hologram(CommandContext commandContext, CommandSender commandSender, NPC nPC, @Arg(value=1, completions={"add", "set", "bgcolor", "remove", "clear", "lineheight", "viewrange", "margintop", "marginbottom"}) String string, @Arg(value=2, completionsProvider=HologramTrait.TabCompletions.class) String string2) {
        HologramTrait hologramTrait = nPC.getOrAddTrait(HologramTrait.class);
        if (commandContext.argsLength() == 1) {
            String string3 = Messaging.tr("citizens.commands.npc.hologram.text-describe-header", nPC.getName());
            List<String> list = hologramTrait.getLines();
            for (int i = 0; i < list.size(); ++i) {
                String string4 = list.get(i);
                string3 = string3 + "<br>    [[" + i + "]] - " + string4;
            }
            Messaging.send(commandSender, string3);
            return;
        }
        if (string.equalsIgnoreCase("set")) {
            if (commandContext.argsLength() == 2) {
                throw new CommandException("citizens.commands.npc.hologram.invalid-text-id");
            }
            int n = Math.max(0, commandContext.getInteger(2));
            if (n >= hologramTrait.getLines().size()) {
                throw new CommandException("citizens.commands.npc.hologram.invalid-text-id");
            }
            if (commandContext.argsLength() == 3) {
                throw new CommandException("citizens.commands.npc.hologram.text-missing");
            }
            hologramTrait.setLine(n, commandContext.getJoinedStrings(3));
            Messaging.sendTr(commandSender, "citizens.commands.npc.hologram.text-set", n, commandContext.getJoinedStrings(3));
        } else if (string.equalsIgnoreCase("bgcolor")) {
            if (commandContext.argsLength() == 3) {
                hologramTrait.setDefaultBackgroundColor(Util.parseColor(commandContext.getString(2)));
                Messaging.sendTr(commandSender, "citizens.commands.npc.hologram.default-background-color-set", commandContext.getString(2));
            } else {
                int n = Math.max(0, commandContext.getInteger(2));
                if (n >= hologramTrait.getLines().size()) {
                    throw new CommandException("citizens.commands.npc.hologram.invalid-text-id");
                }
                hologramTrait.setBackgroundColor(n, Util.parseColor(commandContext.getString(3)));
                Messaging.sendTr(commandSender, "citizens.commands.npc.hologram.background-color-set", n, commandContext.getString(3));
            }
        } else if (string.equalsIgnoreCase("viewrange")) {
            if (commandContext.argsLength() == 2) {
                throw new CommandUsageException();
            }
            hologramTrait.setViewRange(commandContext.getInteger(2));
            Messaging.sendTr(commandSender, "citizens.commands.npc.hologram.view-range-set", nPC.getName(), commandContext.getInteger(2));
        } else if (string.equalsIgnoreCase("add")) {
            if (commandContext.argsLength() == 2) {
                throw new CommandException("citizens.commands.npc.hologram.text-missing");
            }
            hologramTrait.addLine(commandContext.getJoinedStrings(2));
            Messaging.sendTr(commandSender, "citizens.commands.npc.hologram.line-add", commandContext.getJoinedStrings(2));
        } else if (string.equalsIgnoreCase("remove")) {
            if (commandContext.argsLength() == 2) {
                throw new CommandException("citizens.commands.npc.hologram.invalid-text-id");
            }
            int n = Math.max(0, commandContext.getInteger(2));
            if (n >= hologramTrait.getLines().size()) {
                throw new CommandException("citizens.commands.npc.hologram.invalid-text-id");
            }
            hologramTrait.removeLine(n);
            Messaging.sendTr(commandSender, "citizens.commands.npc.hologram.line-removed", n);
        } else if (string.equalsIgnoreCase("clear")) {
            hologramTrait.clear();
            Messaging.sendTr(commandSender, "citizens.commands.npc.hologram.cleared", new Object[0]);
        } else if (string.equalsIgnoreCase("lineheight")) {
            if (commandContext.argsLength() == 2) {
                throw new CommandUsageException();
            }
            hologramTrait.setLineHeight(commandContext.getDouble(2));
            Messaging.sendTr(commandSender, "citizens.commands.npc.hologram.line-height-set", commandContext.getDouble(2));
        } else if (string.equalsIgnoreCase("margintop")) {
            if (commandContext.argsLength() == 2) {
                throw new CommandException("citizens.commands.npc.hologram.invalid-text-id");
            }
            int n = Math.max(0, commandContext.getInteger(2));
            if (n >= hologramTrait.getLines().size()) {
                throw new CommandException("citizens.commands.npc.hologram.invalid-text-id");
            }
            if (commandContext.argsLength() == 3) {
                throw new CommandException("citizens.commands.npc.hologram.margin-missing");
            }
            hologramTrait.setMargin(n, "top", commandContext.getDouble(3));
            Messaging.sendTr(commandSender, "citizens.commands.npc.hologram.margin-set", n, "top", commandContext.getDouble(3));
        } else if (string.equalsIgnoreCase("marginbottom")) {
            if (commandContext.argsLength() == 2) {
                throw new CommandException("citizens.commands.npc.hologram.invalid-text-id");
            }
            int n = Math.max(0, commandContext.getInteger(2));
            if (n >= hologramTrait.getLines().size()) {
                throw new CommandException("citizens.commands.npc.hologram.invalid-text-id");
            }
            if (commandContext.argsLength() == 3) {
                throw new CommandException("citizens.commands.npc.hologram.margin-missing");
            }
            hologramTrait.setMargin(n, "bottom", commandContext.getDouble(3));
            Messaging.sendTr(commandSender, "citizens.commands.npc.hologram.margin-set", n, "bottom", commandContext.getDouble(3));
        }
    }

    @Command(aliases={"npc"}, usage="homeloc --location [loc] --delay [delay] --distance [distance] -h(ere) -p(athfind) -t(eleport)", desc="", modifiers={"home"}, min=1, max=1, flags="pth", permission="citizens.npc.home")
    @Requirements(ownership=true, selected=true)
    public void home(CommandContext commandContext, CommandSender commandSender, NPC nPC, @Flag(value={"location"}) Location location, @Flag(value={"delay"}) Duration duration, @Flag(value={"distance"}) Double d) {
        HomeTrait homeTrait = nPC.getOrAddTrait(HomeTrait.class);
        String string = "";
        if (commandContext.hasFlag('h')) {
            if (!(commandSender instanceof Player)) {
                throw new RequirementMissingException(Messaging.tr("citizens.commands.requirements.living-entity", new Object[0]));
            }
            homeTrait.setHomeLocation(((Player)commandSender).getLocation());
            string = string + Messaging.tr("citizens.commands.npc.home.home-set", Util.prettyPrintLocation(homeTrait.getHomeLocation()));
        }
        if (location != null) {
            homeTrait.setHomeLocation(location);
            string = string + " " + Messaging.tr("citizens.commands.npc.home.home-set", Util.prettyPrintLocation(homeTrait.getHomeLocation()));
        }
        if (d != null) {
            homeTrait.setDistanceBlocks(d);
            string = string + " " + Messaging.tr("citizens.commands.npc.home.distance-set", homeTrait.getDistanceBlocks());
        }
        if (commandContext.hasFlag('p')) {
            homeTrait.setReturnStrategy(HomeTrait.ReturnStrategy.PATHFIND);
            string = string + " " + Messaging.tr("citizens.commands.npc.home.pathfind-set", nPC.getName());
        }
        if (commandContext.hasFlag('t')) {
            homeTrait.setReturnStrategy(HomeTrait.ReturnStrategy.TELEPORT);
            string = string + " " + Messaging.tr("citizens.commands.npc.home.teleport-set", nPC.getName());
        }
        if (duration != null) {
            homeTrait.setDelayTicks(Util.toTicks(duration));
            string = string + " " + Messaging.tr("citizens.commands.npc.home.delay-set", Util.toTicks(duration));
        }
        if (!string.isEmpty()) {
            Messaging.send(commandSender, string.trim());
        }
    }

    @Command(aliases={"npc"}, usage="horse|donkey|mule (--color color) (--type type) (--style style) (-cb)", desc="", modifiers={"horse", "donkey", "mule"}, min=1, max=1, flags="cb", permission="citizens.npc.horse")
    @Requirements(selected=true, ownership=true)
    public void horse(CommandContext commandContext, CommandSender commandSender, NPC nPC, @Flag(value={"color", "colour"}) Horse.Color color, @Flag(value={"style"}) Horse.Style style) {
        EntityType entityType = nPC.getOrAddTrait(MobType.class).getType();
        if (!Util.isHorse(entityType)) {
            throw new CommandException("citizens.commands.requirements.disallowed-mobtype", Util.prettyEnum(entityType));
        }
        HorseModifiers horseModifiers = nPC.getOrAddTrait(HorseModifiers.class);
        String string = "";
        if (commandContext.hasFlag('c')) {
            horseModifiers.setCarryingChest(true);
            string = string + Messaging.tr("citizens.commands.npc.horse.chest-set", new Object[0]) + " ";
        } else if (commandContext.hasFlag('b')) {
            horseModifiers.setCarryingChest(false);
            string = string + Messaging.tr("citizens.commands.npc.horse.chest-unset", new Object[0]) + " ";
        }
        if (entityType == EntityType.HORSE && (commandContext.hasValueFlag("color") || commandContext.hasValueFlag("colour"))) {
            if (color == null) {
                String string2 = Util.listValuesPretty(Horse.Color.values());
                throw new CommandException("citizens.commands.npc.horse.invalid-color", string2);
            }
            horseModifiers.setColor(color);
            string = string + Messaging.tr("citizens.commands.npc.horse.color-set", Util.prettyEnum(color));
        }
        if (entityType == EntityType.HORSE && commandContext.hasValueFlag("style")) {
            if (style == null) {
                String string3 = Util.listValuesPretty(Horse.Style.values());
                throw new CommandException("citizens.commands.npc.horse.invalid-style", string3);
            }
            horseModifiers.setStyle(style);
            string = string + Messaging.tr("citizens.commands.npc.horse.style-set", Util.prettyEnum(style));
        }
        if (string.isEmpty()) {
            Messaging.sendTr(commandSender, "citizens.commands.npc.horse.describe", Util.prettyEnum(horseModifiers.getColor()), Util.prettyEnum(entityType), Util.prettyEnum(horseModifiers.getStyle()));
        } else {
            Messaging.send(commandSender, string);
        }
    }

    @Command(aliases={"npc"}, usage="hurt [damage]", desc="", modifiers={"hurt"}, min=2, max=2, permission="citizens.npc.hurt")
    public void hurt(CommandContext commandContext, CommandSender commandSender, NPC nPC) {
        if (!(nPC.getEntity() instanceof Damageable)) {
            Messaging.sendErrorTr(commandSender, "citizens.commands.npc.hurt.not-damageable", Util.prettyEnum(nPC.getOrAddTrait(MobType.class).getType()));
            return;
        }
        if (nPC.isProtected()) {
            Messaging.sendErrorTr(commandSender, "citizens.commands.npc.hurt.protected", new Object[0]);
            return;
        }
        ((Damageable)nPC.getEntity()).damage((double)commandContext.getInteger(1));
    }

    @Command(aliases={"npc"}, usage="id", desc="", modifiers={"id"}, min=1, max=1, permission="citizens.npc.id")
    public void id(CommandContext commandContext, CommandSender commandSender, NPC nPC) {
        commandSender.sendMessage(Integer.toString(nPC.getId()));
    }

    @Command(aliases={"npc"}, usage="inventory", desc="", modifiers={"inventory"}, min=1, max=1, permission="citizens.npc.inventory")
    public void inventory(CommandContext commandContext, CommandSender commandSender, NPC nPC) {
        nPC.getOrAddTrait(net.citizensnpcs.api.trait.trait.Inventory.class).openInventory((Player)commandSender);
    }

    @Command(aliases={"npc"}, usage="item (item) (metadata) (-h(and))", desc="", modifiers={"item"}, min=1, max=3, flags="h", permission="citizens.npc.item")
    @Requirements(selected=true, ownership=true)
    public void item(CommandContext commandContext, CommandSender commandSender, NPC nPC, @Arg(value=1) Material material, @Arg(value=2) String string) {
        ItemStack itemStack;
        EntityType entityType = nPC.getOrAddTrait(MobType.class).getType();
        if (!(entityType.name().equals("OMINOUS_ITEM_SPAWNER") || entityType.name().contains("ITEM_FRAME") || entityType.name().contains("ITEM_DISPLAY") || entityType.name().contains("BLOCK_DISPLAY") || entityType.name().equals("DROPPED_ITEM") || entityType.name().equals("ITEM") || entityType == EntityType.FALLING_BLOCK)) {
            throw new CommandException("citizens.commands.requirements.disallowed-mobtype", Util.prettyEnum(entityType));
        }
        ItemStack itemStack2 = itemStack = commandContext.hasFlag('h') ? ((Player)commandSender).getItemInHand() : new ItemStack(material, 1);
        if (string != null) {
            itemStack = Util.parseItemStack(itemStack, string);
        }
        if (material == null && !commandContext.hasFlag('h')) {
            throw new CommandException("citizens.commands.npc.item.unknown-material");
        }
        ItemStack itemStack3 = itemStack.clone();
        nPC.setItemProvider(() -> itemStack3);
        if (nPC.isSpawned()) {
            nPC.despawn(DespawnReason.PENDING_RESPAWN);
            nPC.spawn(nPC.getStoredLocation(), SpawnReason.RESPAWN);
        }
        Messaging.sendTr(commandSender, "citizens.commands.npc.item.item-set", nPC.getName(), Util.prettyEnum(itemStack.getType()));
    }

    @Command(aliases={"npc"}, usage="itemframe --visible [true|false] --fixed [true|false] --rotation [rotation] --item [item]", desc="", modifiers={"itemframe"}, min=1, max=1, flags="", permission="citizens.npc.itemframe")
    @Requirements(ownership=true, selected=true, types={EntityType.ITEM_FRAME})
    public void itemframe(CommandContext commandContext, CommandSender commandSender, NPC nPC, @Flag(value={"visible"}) Boolean bl, @Flag(value={"fixed"}) Boolean bl2, @Flag(value={"rotation"}) Rotation rotation, @Flag(value={"item"}) ItemStack itemStack) {
        ItemFrameTrait itemFrameTrait = nPC.getOrAddTrait(ItemFrameTrait.class);
        String string = "";
        if (bl != null) {
            itemFrameTrait.setVisible(bl);
            string = string + " " + Messaging.tr("citizens.commands.npc.itemframe.visible-set", bl);
        }
        if (bl2 != null) {
            itemFrameTrait.setFixed(bl2);
            string = string + " " + Messaging.tr("citizens.commands.npc.itemframe.fixed-set", bl2);
        }
        if (itemStack != null) {
            itemFrameTrait.setItem(itemStack);
            string = string + " " + Messaging.tr("citizens.commands.npc.itemframe.item-set", itemStack);
        }
        if (rotation != null) {
            itemFrameTrait.setRotation(rotation);
            string = string + " " + Messaging.tr("citizens.commands.npc.itemframe.rotation-set", rotation);
        }
        if (string.isEmpty()) {
            throw new CommandUsageException();
        }
        Messaging.send(commandSender, string.trim());
    }

    @Command(aliases={"npc"}, usage="jump", desc="", modifiers={"jump"}, min=1, max=1, permission="citizens.npc.jump")
    public void jump(CommandContext commandContext, CommandSender commandSender, NPC nPC) {
        NMS.setShouldJump(nPC.getEntity());
    }

    @Command(aliases={"npc"}, usage="knockback (--explicit true|false)", desc="", modifiers={"knockback"}, min=1, max=1, permission="citizens.npc.knockback")
    public void knockback(CommandContext commandContext, CommandSender commandSender, NPC nPC, @Flag(value={"explicit"}) Boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = nPC.data().get(NPC.Metadata.KNOCKBACK, Boolean.valueOf(true)) == false;
        if (bl != null) {
            bl2 = bl;
        }
        nPC.data().set(NPC.Metadata.KNOCKBACK, (Object)bl2);
        Messaging.sendTr(commandSender, bl2 ? "citizens.commands.npc.knockback.set" : "citizens.commands.npc.knockback.unset", nPC.getName());
    }

    @Command(aliases={"npc"}, usage="leashable", desc="", modifiers={"leashable"}, min=1, max=1, flags="t", permission="citizens.npc.leashable")
    @Requirements(selected=true, ownership=true, excludedTypes={EntityType.PLAYER})
    public void leashable(CommandContext commandContext, CommandSender commandSender, NPC nPC) {
        boolean bl;
        boolean bl2 = bl = nPC.data().get(NPC.Metadata.LEASH_PROTECTED, Boolean.valueOf(true)) == false;
        if (commandContext.hasFlag('t')) {
            nPC.data().set(NPC.Metadata.LEASH_PROTECTED, (Object)bl);
        } else {
            nPC.data().setPersistent(NPC.Metadata.LEASH_PROTECTED, (Object)bl);
        }
        String string = bl ? "citizens.commands.npc.leashable.stopped" : "citizens.commands.npc.leashable.set";
        Messaging.sendTr(commandSender, string, nPC.getName());
    }

    @Command(aliases={"npc"}, usage="list (page) ((-a) --owner (owner) --type (type) --char (char) --registry (name))", desc="", flags="a", modifiers={"list"}, min=1, max=2, permission="citizens.npc.list")
    @Requirements
    public void list(CommandContext commandContext, CommandSender commandSender, NPC nPC, @Flag(value={"owner"}) String string, @Flag(value={"type"}) EntityType entityType, @Flag(value={"page"}) Integer n, @Flag(value={"registry"}) String string2) {
        int n2;
        Object object;
        NPCRegistry nPCRegistry;
        NPCRegistry nPCRegistry2 = nPCRegistry = string2 != null ? CitizensAPI.getNamedNPCRegistry(string2) : CitizensAPI.getNPCRegistry();
        if (nPCRegistry == null) {
            throw new CommandException();
        }
        ArrayList<NPC> arrayList = new ArrayList<NPC>();
        if (commandContext.hasFlag('a')) {
            for (NPC nPC2 : nPCRegistry.sorted()) {
                arrayList.add(nPC2);
            }
        } else if (string != null) {
            for (NPC nPC2 : nPCRegistry.sorted()) {
                if (arrayList.contains(nPC2) || !nPC2.getOrAddTrait(Owner.class).isOwnedBy(string)) continue;
                arrayList.add(nPC2);
            }
        } else if (commandSender instanceof Player) {
            for (NPC nPC2 : nPCRegistry.sorted()) {
                if (arrayList.contains(nPC2) || !nPC2.getOrAddTrait(Owner.class).isOwnedBy(commandSender)) continue;
                arrayList.add(nPC2);
            }
        }
        if (commandContext.hasValueFlag("type")) {
            if (entityType == null) {
                throw new CommandException("citizens.commands.invalid-mobtype", entityType);
            }
            object = arrayList.iterator();
            while (object.hasNext()) {
                if (object.next().getOrAddTrait(MobType.class).getType() == entityType) continue;
                object.remove();
            }
        }
        object = new Paginator().header("NPCs").console(commandSender instanceof ConsoleCommandSender).enablePageSwitcher('/' + commandContext.getRawCommand() + " --page $page");
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            String string3 = ((NPC)arrayList.get(n2)).getUniqueId().toString();
            String string4 = StringHelper.wrap(((NPC)arrayList.get(n2)).getId()) + " " + ((NPC)arrayList.get(n2)).getName() + " (<click:run_command:/npc tp --uuid " + string3 + "><hover:show_text:Teleport to this NPC>[[tp]]</hover></click>) (<click:run_command:/npc tph --uuid " + string3 + "><hover:show_text:Teleport NPC to me>[[summon]]</hover></click>) (<click:run_command:/npc remove " + string3 + "><hover:show_text:Remove this NPC><red>-</red></hover></click>)";
            ((Paginator)object).addLine(string4);
        }
        int n3 = n2 = n == null ? commandContext.getInteger(1, 1) : n.intValue();
        if (!((Paginator)object).sendPage(commandSender, n2)) {
            throw new CommandException("citizens.commands.page-missing", n2);
        }
    }

    @Command(aliases={"npc"}, usage="lookclose --range [range] -r[ealistic looking] --randomlook [true|false] --perplayer [true|false] --randomswitchtargets [true|false] --randompitchrange [min,max] --randomyawrange [min,max] --disablewhennavigating [true|false] --targetnpcs [true|false]", desc="", modifiers={"lookclose", "look"}, min=1, max=1, flags="r", permission="citizens.npc.lookclose")
    public void lookClose(CommandContext commandContext, CommandSender commandSender, NPC nPC, @Flag(value={"randomlook", "rlook"}) Boolean bl, @Flag(value={"range"}) Double d, @Flag(value={"randomlookdelay"}) Duration duration, @Flag(value={"randomyawrange"}) String string, @Flag(value={"randompitchrange"}) String string2, @Flag(value={"randomswitchtargets"}) Boolean bl2, @Flag(value={"headonly"}) Boolean bl3, @Flag(value={"linkedbody"}) Boolean bl4, @Flag(value={"disablewhennavigating"}) Boolean bl5, @Flag(value={"perplayer"}) Boolean bl6, @Flag(value={"targetnpcs"}) Boolean bl7) {
        float f;
        float f2;
        String[] stringArray;
        boolean bl8 = true;
        LookClose lookClose = nPC.getOrAddTrait(LookClose.class);
        if (bl != null) {
            lookClose.setRandomLook(bl);
            Messaging.sendTr(commandSender, bl != false ? "citizens.commands.npc.lookclose.random-set" : "citizens.commands.npc.lookclose.random-stopped", nPC.getName());
            bl8 = false;
        }
        if (bl6 != null) {
            lookClose.setPerPlayer(bl6);
            Messaging.sendTr(commandSender, bl6 != false ? "citizens.commands.npc.lookclose.perplayer-set" : "citizens.commands.npc.lookclose.perplayer-unset", nPC.getName());
            bl8 = false;
        }
        if (bl3 != null) {
            lookClose.setHeadOnly(bl3);
            Messaging.sendTr(commandSender, bl3 != false ? "citizens.commands.npc.lookclose.headonly-set" : "citizens.commands.npc.lookclose.headonly-unset", nPC.getName());
            bl8 = false;
        }
        if (bl4 != null) {
            lookClose.setLinkedBody(bl4);
            Messaging.sendTr(commandSender, bl4 != false ? "citizens.commands.npc.lookclose.linkedbody-set" : "citizens.commands.npc.lookclose.linkedbody-unset", nPC.getName());
            bl8 = false;
        }
        if (bl2 != null) {
            lookClose.setRandomlySwitchTargets(bl2);
            Messaging.sendTr(commandSender, bl2 != false ? "citizens.commands.npc.lookclose.random-target-switch-enabled" : "citizens.commands.npc.lookclose.random-target-switch-disabled", nPC.getName());
            bl8 = false;
        }
        if (bl7 != null) {
            lookClose.setTargetNPCs(bl7);
            Messaging.sendTr(commandSender, bl7 != false ? "citizens.commands.npc.lookclose.target-npcs-set" : "citizens.commands.npc.lookclose.target-npcs-unset", nPC.getName());
            bl8 = false;
        }
        if (bl5 != null) {
            lookClose.setDisableWhileNavigating(bl5);
            Messaging.sendTr(commandSender, bl5 != false ? "citizens.commands.npc.lookclose.disable-when-navigating" : "citizens.commands.npc.lookclose.enable-when-navigating", nPC.getName());
            bl8 = false;
        }
        if (d != null) {
            lookClose.setRange(d);
            Messaging.sendTr(commandSender, "citizens.commands.npc.lookclose.range-set", nPC.getName(), d);
            bl8 = false;
        }
        if (commandContext.hasFlag('r')) {
            lookClose.setRealisticLooking(!lookClose.useRealisticLooking());
            Messaging.sendTr(commandSender, lookClose.useRealisticLooking() ? "citizens.commands.npc.lookclose.rl-set" : "citizens.commands.npc.lookclose.rl-unset", nPC.getName());
            bl8 = false;
        }
        if (duration != null) {
            lookClose.setRandomLookDelay(Math.max(1, Util.toTicks(duration)));
            Messaging.sendTr(commandSender, "citizens.commands.npc.lookclose.random-look-delay-set", nPC.getName(), Util.toTicks(duration));
            bl8 = false;
        }
        if (string2 != null) {
            try {
                stringArray = string2.split(",");
                f2 = Float.parseFloat(stringArray[0]);
                f = Float.parseFloat(stringArray[1]);
                if (f2 > f) {
                    throw new IllegalArgumentException();
                }
                lookClose.setRandomLookPitchRange(f2, f);
            }
            catch (Exception exception) {
                throw new CommandException(Messaging.tr("citizens.commands.npc.lookclose.error-random-range", string2));
            }
            Messaging.sendTr(commandSender, "citizens.commands.npc.lookclose.random-pitch-range-set", nPC.getName(), string2);
            bl8 = false;
        }
        if (string != null) {
            try {
                stringArray = string.split(",");
                f2 = Float.parseFloat(stringArray[0]);
                f = Float.parseFloat(stringArray[1]);
                if (f2 > f) {
                    throw new IllegalArgumentException();
                }
                lookClose.setRandomLookYawRange(f2, f);
            }
            catch (Exception exception) {
                throw new CommandException(Messaging.tr("citizens.commands.npc.lookclose.error-random-range", string));
            }
            Messaging.sendTr(commandSender, "citizens.commands.npc.lookclose.random-yaw-range-set", nPC.getName(), string);
            bl8 = false;
        }
        if (bl8) {
            Messaging.sendTr(commandSender, lookClose.toggle() ? "citizens.commands.npc.lookclose.set" : "citizens.commands.npc.lookclose.stopped", nPC.getName());
        }
    }

    @Command(aliases={"npc"}, usage="metadata set|get|remove [key] (value) (-t(emporary))", desc="", modifiers={"metadata"}, flags="t", min=3, max=4, permission="citizens.npc.metadata")
    @Requirements(selected=true, ownership=true)
    public void metadata(CommandContext commandContext, CommandSender commandSender, NPC nPC, @Arg(value=1, completions={"set", "get", "remove"}) String string, @Arg(value=2) NPC.Metadata metadata) {
        String string2 = commandContext.getString(2);
        if (string.equals("set")) {
            if (commandContext.argsLength() != 4) {
                throw new CommandException();
            }
            Object object = commandContext.getString(3);
            if (object.equals("false") || object.equals("true")) {
                object = Boolean.parseBoolean(commandContext.getString(3));
            }
            try {
                object = Integer.parseInt(commandContext.getString(3));
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    object = Double.parseDouble(commandContext.getString(3));
                }
                catch (NumberFormatException numberFormatException2) {
                    // empty catch block
                }
            }
            if (commandContext.hasFlag('t')) {
                if (metadata != null) {
                    nPC.data().set(metadata, object);
                } else {
                    nPC.data().set(string2, object);
                }
            } else if (metadata != null) {
                nPC.data().setPersistent(metadata, object);
            } else {
                nPC.data().setPersistent(string2, object);
            }
            Messaging.sendTr(commandSender, "citizens.commands.npc.metadata.set", metadata != null ? metadata : string2, commandContext.getString(3));
        } else if (string.equals("get")) {
            Object object;
            if (commandContext.argsLength() != 3) {
                throw new CommandException();
            }
            Object object2 = object = metadata != null ? nPC.data().get(metadata) : nPC.data().get(string2);
            if (object == null) {
                object = "null";
            }
            commandSender.sendMessage(object.toString());
        } else if (string.equals("remove")) {
            if (commandContext.argsLength() != 3) {
                throw new CommandException();
            }
            if (metadata != null) {
                nPC.data().remove(metadata);
            } else {
                nPC.data().remove(string2);
            }
            Messaging.sendTr(commandSender, "citizens.commands.npc.metadata.unset", metadata != null ? metadata : string2, nPC.getName());
        } else {
            throw new CommandUsageException();
        }
    }

    @Command(aliases={"npc"}, usage="minecart (--item item_name(:data)) (--offset offset)", desc="", modifiers={"minecart"}, min=1, max=1, flags="", permission="citizens.npc.minecart")
    @Requirements(selected=true, ownership=true)
    public void minecart(CommandContext commandContext, CommandSender commandSender, NPC nPC, @Flag(value={"item"}) String string) {
        if (!nPC.getOrAddTrait(MobType.class).getType().name().contains("MINECRAFT")) {
            throw new CommandUsageException();
        }
        if (string != null) {
            Material material;
            int n = 0;
            if (string.contains(":")) {
                int n2 = string.indexOf(58);
                n = Integer.parseInt(string.substring(n2 + 1));
                string = string.substring(0, n2);
            }
            if ((material = Material.matchMaterial((String)string)) == null) {
                throw new CommandException();
            }
            nPC.data().setPersistent(NPC.Metadata.MINECART_ITEM, (Object)material.name());
            nPC.data().setPersistent(NPC.Metadata.MINECART_ITEM_DATA, (Object)n);
        }
        if (commandContext.hasValueFlag("offset")) {
            nPC.data().setPersistent(NPC.Metadata.MINECART_OFFSET, (Object)commandContext.getFlagInteger("offset"));
        }
        Messaging.sendTr(commandSender, "citizens.commands.npc.minecart.set", nPC.data().get(NPC.Metadata.MINECART_ITEM, ""), nPC.data().get(NPC.Metadata.MINECART_ITEM_DATA, Integer.valueOf(0)), nPC.data().get(NPC.Metadata.MINECART_OFFSET, Integer.valueOf(0)));
    }

    @Command(aliases={"npc"}, modifiers={"mirror"}, usage="mirror --name [true|false]", desc="", min=1, max=1, permission="citizens.npc.mirror")
    @Requirements(selected=true, ownership=true)
    public void mirror(CommandContext commandContext, CommandSender commandSender, NPC nPC, @Flag(value={"name"}) Boolean bl) {
        if (((Citizens)CitizensAPI.getPlugin()).getProtocolLibListener() == null) {
            throw new CommandException("ProtocolLib must be enabled to use this feature");
        }
        MirrorTrait mirrorTrait = nPC.getOrAddTrait(MirrorTrait.class);
        if (bl != null) {
            mirrorTrait.setEnabled(true);
            mirrorTrait.setMirrorName(bl);
            Messaging.sendTr(commandSender, bl != false ? "citizens.commands.npc.mirror.namemirror-set" : "citizens.commands.npc.mirror.namemirror-unset", nPC.getName());
        } else {
            boolean bl2 = !mirrorTrait.isEnabled();
            mirrorTrait.setEnabled(bl2);
            Messaging.sendTr(commandSender, bl2 ? "citizens.commands.npc.mirror.set" : "citizens.commands.npc.mirror.unset", nPC.getName());
        }
    }

    @Command(aliases={"npc"}, usage="mount (--onnpc <npc id|uuid>) (-c(ancel))", desc="", modifiers={"mount"}, min=1, max=1, flags="c", permission="citizens.npc.mount")
    public void mount(CommandContext commandContext, CommandSender commandSender, NPC nPC, @Flag(value={"onnpc"}) String string) {
        boolean bl;
        if (string != null) {
            NPC nPC2;
            try {
                UUID uUID = UUID.fromString(string);
                nPC2 = CitizensAPI.getNPCRegistry().getByUniqueId(uUID);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                nPC2 = CitizensAPI.getNPCRegistry().getById(commandContext.getFlagInteger("onnpc"));
            }
            if (nPC2 == null || !nPC2.isSpawned()) {
                throw new CommandException(Messaging.tr("citizens.commands.npc.mount.must-be-spawned", string));
            }
            if (nPC2.equals(nPC)) {
                throw new CommandException("citizens.commands.npc.mount.mount-on-itself");
            }
            NMS.mount(nPC2.getEntity(), nPC.getEntity());
            return;
        }
        if (commandContext.hasFlag('c')) {
            nPC.getOrAddTrait(MountTrait.class).unmount();
            return;
        }
        boolean bl2 = bl = nPC.hasTrait(Controllable.class) && nPC.getOrAddTrait(Controllable.class).isEnabled();
        if (!bl) {
            Messaging.sendTr(commandSender, "citizens.commands.npc.controllable.not-controllable", nPC.getName());
            return;
        }
        if (!(commandSender instanceof Player)) {
            throw new CommandException("citizens.commands.requirements.must-be-ingame");
        }
        Player player = (Player)commandSender;
        boolean bl3 = nPC.getOrAddTrait(Controllable.class).mount(player);
        if (!bl3) {
            Messaging.sendTr((CommandSender)player, "citizens.commands.npc.mount.failed", nPC.getName());
        }
    }

    @Command(aliases={"npc"}, usage="moveto x:y:z:world | x y z world", desc="", modifiers={"moveto"}, min=1, valueFlags={"x", "y", "z", "yaw", "pitch", "world"}, permission="citizens.npc.moveto")
    public void moveto(CommandContext commandContext, CommandSender commandSender, NPC nPC) {
        Location location;
        if (!nPC.isSpawned()) {
            nPC.spawn(nPC.getOrAddTrait(CurrentLocation.class).getLocation(), SpawnReason.COMMAND);
            if (!nPC.isSpawned()) {
                throw new CommandException("NPC could not be spawned.");
            }
        }
        Location location2 = nPC.getEntity().getLocation();
        if (commandContext.argsLength() > 1) {
            World world;
            String[] stringArray = (String[])Iterables.toArray((Iterable)Splitter.on((char)':').split((CharSequence)commandContext.getJoinedStrings(1, ':')), String.class);
            if (stringArray.length != 4 && stringArray.length != 3) {
                throw new CommandException("citizens.commands.npc.moveto.format");
            }
            double d = Double.parseDouble(stringArray[0]);
            double d2 = Double.parseDouble(stringArray[1]);
            double d3 = Double.parseDouble(stringArray[2]);
            World world2 = world = stringArray.length == 4 ? Bukkit.getWorld((String)stringArray[3]) : location2.getWorld();
            if (world == null) {
                throw new CommandException("citizens.commands.errors.missing-world");
            }
            location = new Location(world, d, d2, d3, location2.getYaw(), location2.getPitch());
        } else {
            location = location2.clone();
            if (commandContext.hasValueFlag("x")) {
                location.setX(commandContext.getFlagDouble("x"));
            }
            if (commandContext.hasValueFlag("y")) {
                location.setY(commandContext.getFlagDouble("y"));
            }
            if (commandContext.hasValueFlag("z")) {
                location.setZ(commandContext.getFlagDouble("z"));
            }
            if (commandContext.hasValueFlag("yaw")) {
                location.setYaw((float)commandContext.getFlagDouble("yaw"));
            }
            if (commandContext.hasValueFlag("pitch")) {
                location.setPitch((float)commandContext.getFlagDouble("pitch"));
            }
            if (commandContext.hasValueFlag("world")) {
                World world = Bukkit.getWorld((String)commandContext.getFlag("world"));
                if (world == null) {
                    throw new CommandException("citizens.commands.errors.missing-world");
                }
                location.setWorld(world);
            }
        }
        nPC.teleport(location, PlayerTeleportEvent.TeleportCause.COMMAND);
        NMS.look(nPC.getEntity(), location.getYaw(), location.getPitch());
        Messaging.sendTr(commandSender, "citizens.commands.npc.moveto.teleported", nPC.getName(), Util.prettyPrintLocation(location));
    }

    @Command(aliases={"npc"}, modifiers={"name", "hidename"}, usage="name (-h(over))", desc="", min=1, max=1, flags="h", permission="citizens.npc.name")
    @Requirements(selected=true, ownership=true)
    public void name(CommandContext commandContext, CommandSender commandSender, NPC nPC) {
        String string = ((Object)nPC.data().get(NPC.Metadata.NAMEPLATE_VISIBLE, Boolean.valueOf(true))).toString();
        string = commandContext.hasFlag('h') ? "hover" : (string.equals("hover") ? "true" : "" + !Boolean.parseBoolean(string));
        nPC.data().setPersistent(NPC.Metadata.NAMEPLATE_VISIBLE, (Object)string);
        nPC.scheduleUpdate(NPC.NPCUpdate.PACKET);
        Messaging.sendTr(commandSender, "citizens.commands.npc.nameplate.set", string);
    }

    @Command(aliases={"npc"}, desc="", max=0, permission="citizens.npc.info")
    public void npc(CommandContext commandContext, CommandSender commandSender, NPC nPC) {
        Messaging.send(commandSender, StringHelper.wrapHeader(nPC.getName()));
        Messaging.send(commandSender, "    ID: [[" + nPC.getId());
        EntityType entityType = nPC.getOrAddTrait(MobType.class).getType();
        Messaging.send(commandSender, "    UUID: [[" + nPC.getUniqueId());
        Messaging.send(commandSender, "    Type: [[" + entityType);
        if (nPC.isSpawned()) {
            Location location = nPC.getEntity().getLocation();
            String object = "    Spawned at [[%d, %d, %d, %.2f, %.2f (head %.2f)]] [[%s";
            Messaging.send(commandSender, String.format(object, location.getBlockX(), location.getBlockY(), location.getBlockZ(), Float.valueOf(NMS.getYaw(nPC.getEntity())), Float.valueOf(location.getPitch()), Float.valueOf(NMS.getHeadYaw(nPC.getEntity())), location.getWorld().getName()));
        }
        Messaging.send(commandSender, "    Traits");
        for (Trait trait : nPC.getTraits()) {
            String string = "     - [[" + trait.getName();
            Messaging.send(commandSender, string);
        }
    }

    @Command(aliases={"npc"}, usage="ocelot (--type type) (-s(itting), -n(ot sitting))", desc="", modifiers={"ocelot"}, min=1, max=1, requiresFlags=true, flags="sn", permission="citizens.npc.ocelot")
    @Requirements(selected=true, ownership=true, types={EntityType.OCELOT})
    public void ocelot(CommandContext commandContext, CommandSender commandSender, NPC nPC, @Flag(value={"type"}) Ocelot.Type type) {
        OcelotModifiers ocelotModifiers = nPC.getOrAddTrait(OcelotModifiers.class);
        if (commandContext.hasFlag('s')) {
            ocelotModifiers.setSitting(true);
        } else if (commandContext.hasFlag('n')) {
            ocelotModifiers.setSitting(false);
        }
        if (commandContext.hasValueFlag("type")) {
            if (type == null) {
                String string = Util.listValuesPretty(Ocelot.Type.values());
                throw new CommandException("citizens.commands.npc.ocelot.invalid-type", string);
            }
            ocelotModifiers.setType(type);
            if (!ocelotModifiers.supportsOcelotType()) {
                Messaging.sendErrorTr(commandSender, "citizens.commands.npc.ocelot.deprecated", new Object[0]);
            }
        }
    }

    @Command(aliases={"npc"}, usage="owner [uuid|SERVER]", desc="", modifiers={"owner"}, min=1, max=2, permission="citizens.npc.owner")
    public void owner(CommandContext commandContext, CommandSender commandSender, NPC nPC) {
        OfflinePlayer offlinePlayer;
        Owner owner = nPC.getOrAddTrait(Owner.class);
        if (commandContext.argsLength() == 1) {
            Messaging.sendTr(commandSender, "citizens.commands.npc.owner.owner", nPC.getName(), owner.getOwner());
            return;
        }
        UUID uUID = commandContext.getString(1).equalsIgnoreCase("SERVER") ? null : ((offlinePlayer = Bukkit.getOfflinePlayer((String)commandContext.getString(1))).hasPlayedBefore() || offlinePlayer.isOnline() ? offlinePlayer.getUniqueId() : UUID.fromString(commandContext.getString(1)));
        if (owner.isOwnedBy(uUID)) {
            throw new CommandException("citizens.commands.npc.owner.already-owner", uUID, nPC.getName());
        }
        owner.setOwner(uUID);
        boolean bl = uUID == null;
        Messaging.sendTr(commandSender, bl ? "citizens.commands.npc.owner.set-server" : "citizens.commands.npc.owner.set", nPC.getName(), uUID);
    }

    @Command(aliases={"npc"}, usage="packet --enabled [true|false]", desc="", modifiers={"packet"}, min=1, max=1, permission="citizens.npc.packet")
    @Requirements(selected=true, ownership=true)
    public void packet(CommandContext commandContext, CommandSender commandSender, NPC nPC, @Flag(value={"enabled"}) Boolean bl) {
        if (bl == null) {
            bl = !nPC.hasTrait(PacketNPC.class);
        }
        if (bl.booleanValue()) {
            nPC.getOrAddTrait(PacketNPC.class);
            Messaging.sendTr(commandSender, "citizens.commands.npc.packet.enabled", nPC.getName());
        } else {
            nPC.removeTrait(PacketNPC.class);
            Messaging.sendTr(commandSender, "citizens.commands.npc.packet.disabled", nPC.getName());
        }
    }

    @Command(aliases={"npc"}, usage="painting (--art art)", desc="", modifiers={"painting"}, min=1, max=1, permission="citizens.npc.painting")
    @Requirements(selected=true, ownership=true, types={EntityType.PAINTING})
    public void painting(CommandContext commandContext, CommandSender commandSender, NPC nPC, @Flag(value={"art"}) Art art) {
        PaintingTrait paintingTrait = nPC.getOrAddTrait(PaintingTrait.class);
        if (art != null) {
            paintingTrait.setArt(art);
            Messaging.sendTr(commandSender, "citizens.commands.npc.painting.art-set", nPC.getName(), Util.prettyEnum(art));
            return;
        }
        throw new CommandUsageException();
    }

    @Command(aliases={"npc"}, usage="passive (--set [true|false])", desc="", modifiers={"passive"}, min=1, max=1, permission="citizens.npc.passive")
    public void passive(CommandContext commandContext, CommandSender commandSender, NPC nPC, @Flag(value={"set"}) Boolean bl) {
        boolean bl2 = bl != null ? bl : nPC.data().get(NPC.Metadata.DAMAGE_OTHERS, Boolean.valueOf(true)) == false;
        nPC.data().setPersistent(NPC.Metadata.DAMAGE_OTHERS, (Object)bl2);
        Messaging.sendTr(commandSender, bl2 ? "citizens.commands.npc.passive.unset" : "citizens.commands.npc.passive.set", nPC.getName());
    }

    @Command(aliases={"npc"}, usage="pathopt --avoid-water|aw [true|false] --open-doors [true|false] --path-range [range] --stationary-ticks [ticks] --attack-range [range] --distance-margin [margin] --path-distance-margin [margin] --use-new-finder [true|false] --falling-distance [distance]", desc="", modifiers={"pathopt", "po", "patho"}, min=1, max=1, permission="citizens.npc.pathfindingoptions")
    public void pathfindingOptions(CommandContext commandContext, CommandSender commandSender, NPC nPC, @Flag(value={"path-range"}) Float f, @Flag(value={"avoid-water"}) Boolean bl, @Flag(value={"open-doors"}) Boolean bl2, @Flag(value={"stationary-ticks"}) Integer n, @Flag(value={"distance-margin"}) Double d, @Flag(value={"path-distance-margin"}) Double d2, @Flag(value={"attack-range"}) Double d3, @Flag(value={"use-new-finder"}) Boolean bl3, @Flag(value={"falling-distance"}) Integer n2) {
        String string = "";
        if (bl != null) {
            nPC.getNavigator().getDefaultParameters().avoidWater(bl);
            string = string + Messaging.tr(bl != false ? "citizens.commands.npc.pathopt.avoid-water-set" : "citizens.commands.npc.pathopt.avoid-water-unset", nPC.getName());
        }
        if (bl2 != null) {
            nPC.data().setPersistent(NPC.Metadata.PATHFINDER_OPEN_DOORS, (Object)bl2);
            string = string + Messaging.tr(bl2 != false ? "citizens.commands.npc.pathopt.open-doors-set" : "citizens.commands.npc.pathopt.avoid-water-set", nPC.getName());
        }
        if (n != null) {
            if (n < 0) {
                throw new CommandUsageException();
            }
            nPC.getNavigator().getDefaultParameters().stationaryTicks(n);
            string = string + " " + Messaging.tr("citizens.commands.npc.pathopt.stationary-ticks-set", nPC.getName(), n);
        }
        if (d != null) {
            if (d < 0.0) {
                throw new CommandUsageException();
            }
            nPC.getNavigator().getDefaultParameters().distanceMargin(d);
            string = string + " " + Messaging.tr("citizens.commands.npc.pathopt.distance-margin-set", nPC.getName(), d);
        }
        if (f != null) {
            if (f.floatValue() < 1.0f) {
                throw new CommandUsageException();
            }
            nPC.getNavigator().getDefaultParameters().range(f.floatValue());
            string = string + " " + Messaging.tr("citizens.commands.npc.pathfindingrange.set", f);
        }
        if (d2 != null) {
            if (d2 < 0.0) {
                throw new CommandUsageException();
            }
            nPC.getNavigator().getDefaultParameters().pathDistanceMargin(d2);
            string = string + " " + Messaging.tr("citizens.commands.npc.pathopt.path-distance-margin-set", nPC.getName(), d2);
        }
        if (d3 != null) {
            if (d3 < 0.0) {
                throw new CommandUsageException();
            }
            nPC.getNavigator().getDefaultParameters().attackRange(d3);
            string = string + " " + Messaging.tr("citizens.commands.npc.pathopt.attack-range-set", nPC.getName(), d3);
        }
        if (bl3 != null) {
            nPC.getNavigator().getDefaultParameters().useNewPathfinder(bl3);
            string = string + " " + Messaging.tr("citizens.commands.npc.pathopt.use-new-finder", nPC.getName(), bl3);
        }
        if (n2 != null) {
            nPC.data().set(NPC.Metadata.PATHFINDER_FALL_DISTANCE, (Object)n2);
            string = string + " " + Messaging.tr("citizens.commands.npc.pathopt.falling-distance-set", nPC.getName(), n2);
        }
        if (string.isEmpty()) {
            throw new CommandUsageException();
        }
        Messaging.send(commandSender, string.trim());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Command(aliases={"npc"}, usage="pathto me | here | cursor | [x] [y] [z] (--margin [distance margin]) (-s[traight line])", desc="", modifiers={"pathto"}, min=2, max=4, flags="s", permission="citizens.npc.pathto")
    public void pathto(CommandContext commandContext, CommandSender commandSender, NPC nPC, @Arg(value=1, completions={"me", "here", "cursor"}) String string, @Flag(value={"margin"}) Double d) {
        Location location = nPC.getStoredLocation();
        if (commandContext.argsLength() == 2) {
            if (string.equalsIgnoreCase("me") || string.equalsIgnoreCase("here")) {
                location = commandContext.getSenderLocation();
            } else {
                if (!string.equalsIgnoreCase("cursor")) throw new CommandUsageException();
                location = ((Player)commandSender).getTargetBlockExact(32).getLocation();
            }
        } else {
            location.setX(commandContext.getDouble(1));
            location.setY(commandContext.getDouble(2));
            location.setZ(commandContext.getDouble(3));
        }
        if (commandContext.hasFlag('s')) {
            nPC.getNavigator().setStraightLineTarget(location);
        } else {
            nPC.getNavigator().setTarget(location);
        }
        if (d == null) return;
        nPC.getNavigator().getLocalParameters().distanceMargin(d);
    }

    @Command(aliases={"npc"}, usage="pausepathfinding --onrightclick [true|false] --when-player-within [range in blocks] --pauseticks [ticks]", desc="", modifiers={"pausepathfinding"}, min=1, max=1, permission="citizens.npc.pausepathfinding")
    public void pausepathfinding(CommandContext commandContext, CommandSender commandSender, NPC nPC, @Flag(value={"onrightclick"}) Boolean bl, @Flag(value={"when-player-within"}) Double d, @Flag(value={"pauseticks"}) Integer n) {
        PausePathfindingTrait pausePathfindingTrait = nPC.getOrAddTrait(PausePathfindingTrait.class);
        if (d != null) {
            if (d <= 0.0) {
                throw new CommandException("Invalid range");
            }
            pausePathfindingTrait.setPlayerRangeBlocks(d);
            Messaging.sendTr(commandSender, "citizens.commands.npc.pausepathfinding.pause-range-set", nPC.getName(), d);
        }
        if (bl != null) {
            pausePathfindingTrait.setRightClick(bl);
            Messaging.sendTr(commandSender, bl != false ? "citizens.commands.npc.pausepathfinding.rightclick-set" : "citizens.commands.npc.pausepathfinding.rightclick-unset", nPC.getName());
        }
        if (n != null) {
            pausePathfindingTrait.setPauseTicks(n);
            Messaging.sendTr(commandSender, "citizens.commands.npc.pausepathfinding.pause-ticks-set", nPC.getName(), n);
        }
    }

    @Command(aliases={"npc"}, usage="pickupitems (--set [true|false])", desc="", modifiers={"pickupitems"}, min=1, max=1, permission="citizens.npc.pickupitems")
    public void pickupitems(CommandContext commandContext, CommandSender commandSender, NPC nPC, @Flag(value={"set"}) Boolean bl) {
        boolean bl2 = bl == null ? !nPC.data().get(NPC.Metadata.PICKUP_ITEMS, Boolean.valueOf(!nPC.isProtected())).booleanValue() : bl;
        nPC.data().setPersistent(NPC.Metadata.PICKUP_ITEMS, (Object)bl2);
        Messaging.sendTr(commandSender, bl2 ? "citizens.commands.npc.pickupitems.set" : "citizens.commands.npc.pickupitems.unset", nPC.getName());
    }

    @Command(aliases={"npc"}, usage="panimate [animation]", desc="", modifiers={"panimate"}, min=2, max=2, permission="citizens.npc.panimate")
    @Requirements(selected=true, ownership=true, types={EntityType.PLAYER})
    public void playerAnimate(CommandContext commandContext, CommandSender commandSender, NPC nPC, @Arg(value=1) PlayerAnimation playerAnimation) {
        if (playerAnimation == null) {
            Messaging.sendErrorTr(commandSender, "citizens.commands.npc.panimate.unknown-animation", Util.listValuesPretty(PlayerAnimation.values()));
            return;
        }
        playerAnimation.play((Player)nPC.getEntity(), 64);
    }

    @Command(aliases={"npc"}, usage="playerfilter -a(llowlist) -e(mpty) -d(enylist) --add [uuid] --remove [uuid] --addgroup [group] --removegroup [group] -c(lear) --applywithin [blocks range]", desc="", modifiers={"playerfilter"}, min=1, max=1, flags="adce", permission="citizens.npc.playerfilter")
    public void playerfilter(CommandContext commandContext, CommandSender commandSender, NPC nPC, @Flag(value={"add"}) UUID uUID, @Flag(value={"remove"}) UUID uUID2, @Flag(value={"removegroup"}) String string, @Flag(value={"addgroup"}) String string2, @Flag(value={"applywithin"}) Double d) {
        PlayerFilter playerFilter = nPC.getOrAddTrait(PlayerFilter.class);
        if (uUID != null) {
            playerFilter.addPlayer(uUID);
            Messaging.sendTr(commandSender, "citizens.commands.npc.playerfilter.added", uUID, nPC.getName());
        }
        if (uUID2 != null) {
            playerFilter.removePlayer(uUID2);
            Messaging.sendTr(commandSender, "citizens.commands.npc.playerfilter.removed", uUID2, nPC.getName());
        }
        if (string2 != null) {
            playerFilter.addGroup(string2);
            Messaging.sendTr(commandSender, "citizens.commands.npc.playerfilter.group-added", string2, nPC.getName());
        }
        if (string != null) {
            playerFilter.removeGroup(string);
            Messaging.sendTr(commandSender, "citizens.commands.npc.playerfilter.group-removed", string, nPC.getName());
        }
        if (d != null) {
            playerFilter.setApplyRange(d);
            Messaging.sendTr(commandSender, "citizens.commands.npc.playerfilter.applyrange-set", nPC.getName(), d);
        }
        if (commandContext.hasFlag('e')) {
            playerFilter.setPlayers(Collections.emptySet());
            Messaging.sendTr(commandSender, "citizens.commands.npc.playerfilter.emptied", nPC.getName());
        }
        if (commandContext.hasFlag('a')) {
            playerFilter.setAllowlist();
            Messaging.sendTr(commandSender, "citizens.commands.npc.playerfilter.allowlist-set", nPC.getName());
        }
        if (commandContext.hasFlag('d')) {
            playerFilter.setDenylist();
            Messaging.sendTr(commandSender, "citizens.commands.npc.playerfilter.denylist-set", nPC.getName());
        }
        if (commandContext.hasFlag('c')) {
            playerFilter.clear();
            Messaging.sendTr(commandSender, "citizens.commands.npc.playerfilter.cleared", nPC.getName());
        }
    }

    @Command(aliases={"npc"}, usage="playerlist (-a(dd),r(emove))", desc="", modifiers={"playerlist"}, min=1, max=1, flags="ar", permission="citizens.npc.playerlist")
    @Requirements(selected=true, ownership=true, types={EntityType.PLAYER})
    public void playerlist(CommandContext commandContext, CommandSender commandSender, NPC nPC) {
        boolean bl;
        boolean bl2 = bl = nPC.data().get(NPC.Metadata.REMOVE_FROM_PLAYERLIST, Boolean.valueOf(Settings.Setting.REMOVE_PLAYERS_FROM_PLAYER_LIST.asBoolean())) == false;
        if (commandContext.hasFlag('a')) {
            bl = false;
        } else if (commandContext.hasFlag('r')) {
            bl = true;
        }
        nPC.data().setPersistent(NPC.Metadata.REMOVE_FROM_PLAYERLIST, (Object)bl);
        if (nPC.isSpawned()) {
            NMS.addOrRemoveFromPlayerList(nPC.getEntity(), bl);
        }
        Messaging.sendTr(commandSender, bl ? "citizens.commands.npc.playerlist.removed" : "citizens.commands.npc.playerlist.added", nPC.getName());
    }

    @Command(aliases={"npc"}, usage="playsound [sound] (volume) (pitch) (--at x:y:z:world)", desc="", modifiers={"playsound"}, min=2, max=4, permission="citizens.npc.playsound")
    @Requirements(selected=true, ownership=true)
    public void playsound(CommandContext commandContext, CommandSender commandSender, NPC nPC, @Arg(value=1) String string, @Arg(value=2, defValue="1") Float f, @Arg(value=3, defValue="1") Float f2, @Flag(value={"at"}) Location location) {
        Location location2 = location == null ? nPC.getStoredLocation() : location;
        location2.getWorld().playSound(location2, string, f.floatValue(), f2.floatValue());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Command(aliases={"npc"}, usage="pose (--save [name] (-d) | --mirror [name] (-d) | --assume [name] | --remove [name] | --default [name]) (--yaw yaw) (--pitch pitch) (-a)", desc="", flags="ad", modifiers={"pose"}, min=1, max=2, permission="citizens.npc.pose")
    public void pose(CommandContext commandContext, CommandSender commandSender, NPC nPC, @Flag(value={"save"}) String string, @Flag(value={"mirror"}) String string2, @Flag(value={"assume"}) String string3, @Flag(value={"remove"}) String string4, @Flag(value={"default"}) String string5, @Flag(value={"yaw"}) Float f, @Flag(value={"pitch"}) Float f2) {
        Poses poses = nPC.getOrAddTrait(Poses.class);
        if (string != null) {
            if (string.isEmpty()) {
                throw new CommandException("citizens.commands.npc.pose.invalid-name");
            }
            Location location = nPC.getStoredLocation();
            if (f != null) {
                location.setYaw(f.floatValue());
            }
            if (f2 != null) {
                location.setPitch(f2.floatValue());
            }
            if (!poses.addPose(string, location, commandContext.hasFlag('d'))) throw new CommandException("citizens.commands.npc.pose.already-exists", string);
            Messaging.sendTr(commandSender, "citizens.commands.npc.pose.added", new Object[0]);
        } else if (string2 != null) {
            if (string2.isEmpty()) {
                throw new CommandException("citizens.commands.npc.pose.invalid-name");
            }
            if (commandContext.getSenderLocation() == null) {
                throw new ServerCommandException();
            }
            if (!poses.addPose(string2, commandContext.getSenderLocation(), commandContext.hasFlag('d'))) throw new CommandException("citizens.commands.npc.pose.already-exists", string2);
            Messaging.sendTr(commandSender, "citizens.commands.npc.pose.added", new Object[0]);
        } else if (string5 != null) {
            if (!poses.hasPose(string5)) {
                throw new CommandException("citizens.commands.npc.pose.missing", string5);
            }
            poses.setDefaultPose(string5);
            Messaging.sendTr(commandSender, "citizens.commands.npc.pose.default-pose-set", string5);
        } else if (string3 != null) {
            if (string3.isEmpty()) {
                throw new CommandException("citizens.commands.npc.pose.invalid-name");
            }
            if (!poses.hasPose(string3)) {
                throw new CommandException("citizens.commands.npc.pose.missing", string3);
            }
            poses.assumePose(string3);
        } else if (string4 != null) {
            if (string4.isEmpty()) {
                throw new CommandException("citizens.commands.npc.pose.invalid-name");
            }
            if (!poses.removePose(string4)) throw new CommandException("citizens.commands.npc.pose.missing", string4);
            Messaging.sendTr(commandSender, "citizens.commands.npc.pose.removed", new Object[0]);
        } else if (!commandContext.hasFlag('a')) {
            poses.describe(commandSender, commandContext.getInteger(1, 1));
        }
        if (!commandContext.hasFlag('a')) return;
        if (commandContext.getSenderLocation() == null) {
            throw new ServerCommandException();
        }
        poses.assumePose(commandContext.getSenderLocation());
    }

    @Command(aliases={"npc"}, usage="powered (--set true|false)", desc="", modifiers={"powered"}, min=1, max=1, permission="citizens.npc.powered")
    @Requirements(selected=true, ownership=true, types={EntityType.CREEPER})
    public void power(CommandContext commandContext, CommandSender commandSender, NPC nPC, @Flag(value={"set"}) Boolean bl) {
        boolean bl2 = bl != null ? bl : !nPC.getOrAddTrait(Powered.class).isPowered();
        nPC.getOrAddTrait(Powered.class).setPowered(bl2);
        Messaging.sendTr(commandSender, bl2 ? "citizens.commands.npc.powered.set" : "citizens.commands.npc.powered.stopped", new Object[0]);
    }

    @Command(aliases={"npc"}, usage="profession|prof [profession]", desc="", modifiers={"profession", "prof"}, min=2, max=2, permission="citizens.npc.profession")
    @Requirements(selected=true, ownership=true)
    public void profession(CommandContext commandContext, CommandSender commandSender, NPC nPC, @Arg(value=1) Villager.Profession profession) {
        EntityType entityType = nPC.getOrAddTrait(MobType.class).getType();
        if (entityType != EntityType.VILLAGER && !entityType.name().equals("ZOMBIE_VILLAGER")) {
            throw new CommandException("citizens.commands.requirements.disallowed-mobtype", Util.prettyEnum(entityType));
        }
        if (profession == null) {
            throw new CommandException("citizens.commands.npc.profession.invalid-profession", commandContext.getString(1), Util.listValuesPretty(Villager.Profession.values()));
        }
        nPC.getOrAddTrait(VillagerProfession.class).setProfession(profession);
        Messaging.sendTr(commandSender, "citizens.commands.npc.profession.set", nPC.getName(), Util.prettyEnum(profession));
    }

    @Command(aliases={"npc"}, usage="rabbittype [type]", desc="", modifiers={"rabbittype", "rbtype"}, min=2, permission="citizens.npc.rabbittype")
    @Requirements(selected=true, ownership=true, types={EntityType.RABBIT})
    public void rabbitType(CommandContext commandContext, CommandSender commandSender, NPC nPC, @Arg(value=1) Rabbit.Type type) {
        if (type == null) {
            throw new CommandException("citizens.commands.npc.rabbittype.invalid-type", Util.listValuesPretty(Rabbit.Type.values()));
        }
        nPC.getOrAddTrait(RabbitType.class).setType(type);
        Messaging.sendTr(commandSender, "citizens.commands.npc.rabbittype.type-set", nPC.getName(), type.name());
    }

    @Command(aliases={"npc"}, usage="remove|rem (all|id|name| --owner [owner] | --eid [entity uuid] | --world [world])", desc="", modifiers={"remove", "rem"}, min=1, max=2)
    @Requirements
    public void remove(CommandContext commandContext, CommandSender commandSender, NPC nPC2, @Flag(value={"owner"}) String string, @Flag(value={"eid"}) UUID uUID, @Flag(value={"world"}) String string2, @Arg(value=1, completions={"all"}) String string3) {
        if (string != null) {
            UUID uUID2 = null;
            try {
                uUID2 = UUID.fromString(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                try {
                    uUID2 = Bukkit.getOfflinePlayer((String)string).getUniqueId();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            for (NPC nPC3 : Lists.newArrayList((Iterable)CitizensAPI.getNPCRegistry())) {
                if (!nPC3.getOrAddTrait(Owner.class).isOwnedBy(commandSender) || (uUID2 == null || !nPC3.getOrAddTrait(Owner.class).isOwnedBy(uUID2)) && !nPC3.getOrAddTrait(Owner.class).isOwnedBy(string)) continue;
                this.history.add(commandSender, new RemoveNPCHistoryItem(nPC3));
                nPC3.destroy(commandSender);
            }
            Messaging.sendTr(commandSender, "citizens.commands.npc.remove.npcs-removed", new Object[0]);
            return;
        }
        if (string2 != null) {
            for (NPC nPC4 : Lists.newArrayList((Iterable)CitizensAPI.getNPCRegistry())) {
                Location location = nPC4.getStoredLocation();
                if (location == null || !nPC4.getOrAddTrait(Owner.class).isOwnedBy(commandSender) || location.getWorld() == null || !location.getWorld().getUID().toString().equals(string2) && !location.getWorld().getName().equalsIgnoreCase(string2)) continue;
                this.history.add(commandSender, new RemoveNPCHistoryItem(nPC4));
                nPC4.destroy(commandSender);
            }
            Messaging.sendTr(commandSender, "citizens.commands.npc.remove.npcs-removed", new Object[0]);
            return;
        }
        if (uUID != null) {
            Entity entity = Bukkit.getServer().getEntity(uUID);
            if (entity != null && (nPC2 = CitizensAPI.getNPCRegistry().getNPC(entity)) != null && nPC2.getOrAddTrait(Owner.class).isOwnedBy(commandSender)) {
                this.history.add(commandSender, new RemoveNPCHistoryItem(nPC2));
                nPC2.destroy(commandSender);
                Messaging.sendTr(commandSender, "citizens.commands.npc.remove.removed", nPC2.getName(), nPC2.getId());
            } else {
                Messaging.sendErrorTr(commandSender, "citizens.notifications.npc-not-found", new Object[0]);
            }
            return;
        }
        if (commandContext.argsLength() == 2) {
            if ("all".equalsIgnoreCase(string3)) {
                if (!commandSender.hasPermission("citizens.admin.remove.all") && !commandSender.hasPermission("citizens.admin")) {
                    throw new NoPermissionsException();
                }
                for (NPC nPC5 : CitizensAPI.getNPCRegistry()) {
                    this.history.add(commandSender, new RemoveNPCHistoryItem(nPC5));
                }
                CitizensAPI.getNPCRegistry().deregisterAll();
                Messaging.sendTr(commandSender, "citizens.commands.npc.remove.removed-all", new Object[0]);
            } else {
                NPCCommandSelector.Callback callback = nPC -> {
                    if (nPC == null) {
                        throw new CommandException("citizens.commands.requirements.must-have-selected");
                    }
                    if (!(commandSender instanceof ConsoleCommandSender) && !nPC.getOrAddTrait(Owner.class).isOwnedBy(commandSender)) {
                        throw new CommandException("citizens.commands.requirements.must-be-owner");
                    }
                    if (!commandSender.hasPermission("citizens.npc.remove") && !commandSender.hasPermission("citizens.admin")) {
                        throw new NoPermissionsException();
                    }
                    this.history.add(commandSender, new RemoveNPCHistoryItem(nPC));
                    nPC.destroy(commandSender);
                    Messaging.sendTr(commandSender, "citizens.commands.npc.remove.removed", nPC.getName(), nPC.getId());
                };
                NPCCommandSelector.startWithCallback(callback, CitizensAPI.getNPCRegistry(), commandSender, commandContext, commandContext.getString(1));
            }
            return;
        }
        if (nPC2 == null) {
            throw new CommandException("citizens.commands.requirements.must-have-selected");
        }
        if (!(commandSender instanceof ConsoleCommandSender) && !nPC2.getOrAddTrait(Owner.class).isOwnedBy(commandSender)) {
            throw new CommandException("citizens.commands.requirements.must-be-owner");
        }
        if (!commandSender.hasPermission("citizens.npc.remove") && !commandSender.hasPermission("citizens.admin")) {
            throw new NoPermissionsException();
        }
        this.history.add(commandSender, new RemoveNPCHistoryItem(nPC2));
        nPC2.destroy(commandSender);
        Messaging.sendTr(commandSender, "citizens.commands.npc.remove.removed", nPC2.getName(), nPC2.getId());
    }

    @Command(aliases={"npc"}, usage="rename [name]", desc="", modifiers={"rename"}, min=2, permission="citizens.npc.rename")
    public void rename(CommandContext commandContext, CommandSender commandSender, NPC nPC) {
        String string = nPC.getName();
        String string2 = commandContext.getJoinedStrings(1);
        int n = SpigotUtil.getMaxNameLength(nPC.getOrAddTrait(MobType.class).getType());
        if (Placeholders.replace(Messaging.stripColor(string2), commandSender, nPC).length() > n) {
            Messaging.sendErrorTr(commandSender, "citizens.commands.npc.create.npc-name-too-long", n);
            string2 = string2.substring(0, n);
        }
        nPC.setName(string2);
        Messaging.sendTr(commandSender, "citizens.commands.npc.rename.renamed", string, string2);
    }

    @Command(aliases={"npc"}, usage="respawn [delay]", desc="", modifiers={"respawn"}, min=1, max=2, permission="citizens.npc.respawn")
    public void respawn(CommandContext commandContext, CommandSender commandSender, NPC nPC, @Arg(value=1) Duration duration) {
        if (duration != null) {
            nPC.data().setPersistent(NPC.Metadata.RESPAWN_DELAY, (Object)Util.toTicks(duration));
            Messaging.sendTr(commandSender, "citizens.commands.npc.respawn.delay-set", Util.toTicks(duration));
        } else {
            Messaging.sendTr(commandSender, "citizens.commands.npc.respawn.describe", nPC.data().get(NPC.Metadata.RESPAWN_DELAY, Integer.valueOf(-1)));
        }
    }

    @Command(aliases={"npc"}, usage="rotate (--towards [x,y,z]) (--body [yaw]) (--head [yaw]) (--pitch [pitch]) (-s(mooth))", desc="", flags="s", modifiers={"rotate"}, min=1, max=1, permission="citizens.npc.rotate")
    public void rotate(CommandContext commandContext, CommandSender commandSender, NPC nPC, @Flag(value={"body"}) Float f, @Flag(value={"head"}) Float f2, @Flag(value={"pitch"}) Float f3, @Flag(value={"towards"}) Location location) {
        if (commandContext.hasFlag('s')) {
            if (f3 == null) {
                f3 = Float.valueOf(nPC.getStoredLocation().getPitch());
            }
            if (f == null) {
                f = f2 != null ? f2 : Float.valueOf(NMS.getHeadYaw(nPC.getEntity()));
            }
            nPC.getOrAddTrait(RotationTrait.class).getPhysicalSession().rotateToHave(f.floatValue(), f3.floatValue());
            return;
        }
        if (location != null) {
            nPC.getOrAddTrait(RotationTrait.class).getPhysicalSession().rotateToFace(location);
            return;
        }
        if (f != null) {
            NMS.setBodyYaw(nPC.getEntity(), f.floatValue());
            if (nPC.getEntity().getType() == EntityType.PLAYER) {
                NMS.sendPositionUpdateNearby(nPC.getEntity(), true, f, Float.valueOf(nPC.getEntity().getLocation().getPitch()), null);
                PlayerAnimation.ARM_SWING.play((Player)nPC.getEntity());
            }
        }
        if (f3 != null) {
            NMS.setPitch(nPC.getEntity(), f3.floatValue());
        }
        if (f2 != null) {
            NMS.setHeadYaw(nPC.getEntity(), f2.floatValue());
        }
    }

    @Command(aliases={"npc"}, usage="select|sel [id|name] (--range range) (--registry [name])", desc="", modifiers={"select", "sel"}, min=1, max=2, permission="citizens.npc.select")
    @Requirements
    public void select(CommandContext commandContext, CommandSender commandSender, NPC nPC3, @Flag(value={"range"}, defValue="10") double d, @Flag(value={"registry"}) String string) {
        NPCRegistry nPCRegistry;
        NPCCommandSelector.Callback callback = nPC2 -> {
            if (nPC2 == null) {
                throw new CommandException("citizens.notifications.npc-not-found");
            }
            if (nPC3 != null && nPC2.getId() == nPC3.getId()) {
                throw new CommandException("citizens.commands.npc.select.already-selected");
            }
            this.selector.select(commandSender, nPC2);
            Messaging.sendWithNPC(commandSender, Settings.Setting.SELECTION_MESSAGE.asString(), nPC2);
        };
        NPCRegistry nPCRegistry2 = nPCRegistry = string != null ? CitizensAPI.getNamedNPCRegistry(string) : CitizensAPI.getNPCRegistry();
        if (nPCRegistry == null) {
            throw new CommandException("citizens.commands.errors.unknown-registry", commandContext.getFlag("registry"));
        }
        if (commandContext.argsLength() <= 1) {
            if (commandContext.getSenderLocation() == null) {
                throw new ServerCommandException();
            }
            Location location = commandContext.getSenderLocation();
            List list = location.getWorld().getNearbyEntities(location, d, d, d).stream().map(entity -> nPCRegistry.getNPC((Entity)entity)).filter(nPC -> nPC != null).collect(Collectors.toList());
            Collections.sort(list, (nPC, nPC2) -> Double.compare(nPC.getEntity().getLocation().distanceSquared(location), nPC2.getEntity().getLocation().distanceSquared(location)));
            Iterator iterator = list.iterator();
            if (iterator.hasNext()) {
                NPC nPC4 = (NPC)iterator.next();
                if (nPC4.hasTrait(ClickRedirectTrait.class)) {
                    nPC4 = nPC4.getTraitNullable(ClickRedirectTrait.class).getRedirectNPC();
                }
                callback.run(nPC4);
            }
        } else {
            NPCCommandSelector.startWithCallback(callback, nPCRegistry, commandSender, commandContext, commandContext.getString(1));
        }
    }

    @Command(aliases={"npc"}, usage="setequipment [slot] [item]", desc="", modifiers={"setequipment"}, min=2, max=3, permission="citizens.npc.setequipment")
    public void setequipment(CommandContext commandContext, CommandSender commandSender, NPC nPC, @Arg(value=1) Equipment.EquipmentSlot equipmentSlot, @Arg(value=2) ItemStack itemStack) {
        if (equipmentSlot == null) {
            throw new CommandUsageException();
        }
        if (itemStack == null && commandContext.argsLength() == 3 && commandContext.getString(2).equalsIgnoreCase("hand")) {
            if (!(commandSender instanceof Player)) {
                throw new ServerCommandException();
            }
            itemStack = ((Player)commandSender).getItemInHand().clone();
        }
        nPC.getOrAddTrait(Equipment.class).set(equipmentSlot, itemStack);
        Messaging.sendTr(commandSender, "citizens.commands.npc.setequipment.set", new Object[]{equipmentSlot, itemStack});
    }

    @Command(aliases={"npc"}, usage="sheep (--color [color]) (--sheared [sheared])", desc="", modifiers={"sheep"}, min=1, max=1, permission="citizens.npc.sheep")
    @Requirements(selected=true, ownership=true, types={EntityType.SHEEP})
    public void sheep(CommandContext commandContext, CommandSender commandSender, NPC nPC, @Flag(value={"color"}) DyeColor dyeColor, @Flag(value={"sheared"}) Boolean bl) {
        SheepTrait sheepTrait = nPC.getOrAddTrait(SheepTrait.class);
        boolean bl2 = false;
        if (bl != null) {
            sheepTrait.setSheared(bl);
            bl2 = true;
        }
        if (commandContext.hasValueFlag("color")) {
            if (dyeColor != null) {
                sheepTrait.setColor(dyeColor);
                Messaging.sendTr(commandSender, "citizens.commands.npc.sheep.color-set", dyeColor.toString().toLowerCase());
            } else {
                Messaging.sendErrorTr(commandSender, "citizens.commands.npc.sheep.invalid-color", Util.listValuesPretty(DyeColor.values()));
            }
            bl2 = true;
        }
        if (!bl2) {
            throw new CommandException();
        }
    }

    @Command(aliases={"npc"}, usage="shop (edit|show|delete|copyfrom) (name)", desc="", modifiers={"shop"}, min=1, max=3, permission="citizens.npc.shop")
    @Requirements(selected=false, ownership=true)
    public void shop(CommandContext commandContext, Player player, NPC nPC, @Arg(value=1, completions={"edit", "show", "delete", "copyfrom"}) String string) {
        ShopTrait.NPCShop nPCShop;
        if (commandContext.argsLength() == 1) {
            if (nPC != null) {
                nPC.getOrAddTrait(ShopTrait.class).getDefaultShop().display(player);
            }
            return;
        }
        ShopTrait.NPCShop nPCShop2 = nPCShop = nPC != null ? nPC.getOrAddTrait(ShopTrait.class).getDefaultShop() : null;
        if (commandContext.argsLength() == 3) {
            nPCShop = this.shops.getShop(commandContext.getString(2).toLowerCase());
        }
        if (nPCShop == null) {
            throw new CommandUsageException();
        }
        if (string.equalsIgnoreCase("delete")) {
            if (!nPCShop.canEdit(nPC, player)) {
                throw new NoPermissionsException();
            }
            this.shops.deleteShop(nPCShop);
            Messaging.sendTr((CommandSender)player, "citizens.commands.npc.shop.deleted", nPCShop.getName());
        } else if (string.equalsIgnoreCase("edit")) {
            if (!nPCShop.canEdit(nPC, player)) {
                throw new NoPermissionsException();
            }
            nPCShop.displayEditor(nPC == null ? null : nPC.getOrAddTrait(ShopTrait.class), player);
        } else if (string.equalsIgnoreCase("copyfrom")) {
            if (!nPCShop.canEdit(nPC, player) || !nPC.getOrAddTrait(ShopTrait.class).getDefaultShop().canEdit(nPC, player)) {
                throw new NoPermissionsException();
            }
            MemoryDataKey memoryDataKey = new MemoryDataKey();
            PersistenceLoader.save(nPCShop, memoryDataKey);
            ShopTrait.NPCShop nPCShop3 = (ShopTrait.NPCShop)((Object)PersistenceLoader.load(ShopTrait.NPCShop.class, (DataKey)memoryDataKey));
            nPC.getOrAddTrait(ShopTrait.class).setDefaultShop(nPCShop3);
        } else if (string.equalsIgnoreCase("show")) {
            nPCShop.display(player);
        } else {
            throw new CommandUsageException();
        }
    }

    @Command(aliases={"npc"}, usage="sitting (--explicit [true|false]) (--at [at])", desc="", modifiers={"sitting"}, min=1, max=2, permission="citizens.npc.sitting")
    @Requirements(selected=true, ownership=true)
    public void sitting(CommandContext commandContext, CommandSender commandSender, NPC nPC, @Flag(value={"explicit"}) Boolean bl, @Flag(value={"at"}) Location location) {
        boolean bl2;
        SitTrait sitTrait = nPC.getOrAddTrait(SitTrait.class);
        boolean bl3 = bl != null ? bl : (bl2 = !sitTrait.isSitting());
        if (!bl2) {
            sitTrait.setSitting(null);
            Messaging.sendTr(commandSender, "citizens.commands.npc.sitting.unset", nPC.getName());
            return;
        }
        if (location == null) {
            location = nPC.getStoredLocation();
        }
        sitTrait.setSitting(location);
        Messaging.sendTr(commandSender, "citizens.commands.npc.sitting.set", nPC.getName(), Util.prettyPrintLocation(location));
    }

    @Command(aliases={"npc"}, usage="skin (-e(xport) -c(lear) -l(atest) -s(kull)) [name] (or --url [url] --file [file] (-s(lim)) or -t [uuid/name] [data] [signature])", desc="", modifiers={"skin"}, min=1, max=4, flags="ectls", permission="citizens.npc.skin")
    @Requirements(types={EntityType.PLAYER}, selected=true, ownership=true)
    public void skin(CommandContext commandContext, CommandSender commandSender, NPC nPC, @Flag(value={"url"}) String string, @Flag(value={"file"}) String string2) {
        String string3 = nPC.getName();
        SkinTrait skinTrait = nPC.getOrAddTrait(SkinTrait.class);
        if (commandContext.hasFlag('c')) {
            skinTrait.clearTexture();
            Messaging.sendTr(commandSender, "citizens.commands.npc.skin.cleared", new Object[0]);
            return;
        }
        if (commandContext.hasFlag('e')) {
            File file;
            if (skinTrait.getTexture() == null) {
                throw new CommandException("citizens.commands.npc.skin.missing-skin");
            }
            File file2 = new File(CitizensAPI.getDataFolder(), "skins");
            File file3 = file = string2 == null ? new File(file2, nPC.getUniqueId().toString() + ".png") : new File(file2, string2);
            if (!file.getParentFile().equals(file2) || !file.getName().endsWith(".png")) {
                throw new CommandException("citizens.commands.npc.skin.invalid-file", string2);
            }
            try {
                JSONObject jSONObject = (JSONObject)new JSONParser().parse(new String(BaseEncoding.base64().decode((CharSequence)skinTrait.getTexture())));
                JSONObject jSONObject2 = (JSONObject)jSONObject.get((Object)"textures");
                JSONObject jSONObject3 = (JSONObject)jSONObject2.get((Object)"SKIN");
                URL uRL = new URL(jSONObject3.get((Object)"url").toString().replace("\\", ""));
                if (!uRL.getHost().equals("textures.minecraft.net")) {
                    throw new CommandException("citizens.commands.npc.skin.error-setting-url", "Mojang");
                }
                try (ReadableByteChannel readableByteChannel = Channels.newChannel(uRL.openStream());
                     FileOutputStream fileOutputStream = new FileOutputStream(file);){
                    fileOutputStream.getChannel().transferFrom(readableByteChannel, 0L, 10000L);
                }
                Messaging.sendTr(commandSender, "citizens.commands.npc.skin.exported", file.getName());
            }
            catch (Exception exception) {
                throw new CommandException("Couldn't parse texture: " + exception.getMessage());
            }
            return;
        }
        if (string != null || string2 != null) {
            Messaging.sendTr(commandSender, "citizens.commands.npc.skin.fetching", string == null ? string2 : string);
            Bukkit.getScheduler().runTaskAsynchronously(CitizensAPI.getPlugin(), () -> {
                try {
                    File file;
                    Object object;
                    JSONObject jSONObject = null;
                    if (string2 != null) {
                        object = new File(CitizensAPI.getDataFolder(), "skins");
                        file = new File((File)object, Placeholders.replace(string2, commandSender, nPC));
                        if (!file.exists() || !file.isFile() || file.isHidden() || !file.getParentFile().equals(object)) {
                            Bukkit.getScheduler().runTask(CitizensAPI.getPlugin(), () -> Messaging.sendErrorTr(commandSender, "citizens.commands.npc.skin.invalid-file", string2));
                            return;
                        }
                        jSONObject = MojangSkinGenerator.generateFromPNG(Files.readAllBytes(file.toPath()), commandContext.hasFlag('s'));
                    } else {
                        jSONObject = MojangSkinGenerator.generateFromURL(Placeholders.replace(string, commandSender, nPC), commandContext.hasFlag('s'));
                    }
                    object = (String)jSONObject.get((Object)"uuid");
                    file = (JSONObject)jSONObject.get((Object)"texture");
                    String string3 = (String)file.get("value");
                    String string4 = (String)file.get("signature");
                    Bukkit.getScheduler().runTask(CitizensAPI.getPlugin(), () -> NPCCommands.lambda$skin$11(skinTrait, (String)object, string4, string3, commandSender, nPC, string, string2));
                }
                catch (Throwable throwable) {
                    if (Messaging.isDebugging()) {
                        throwable.printStackTrace();
                    }
                    Bukkit.getScheduler().runTask(CitizensAPI.getPlugin(), () -> Messaging.sendErrorTr(commandSender, "citizens.commands.npc.skin.error-setting-url", string == null ? string2 : string));
                }
            });
            return;
        }
        if (commandContext.hasFlag('t')) {
            if (commandContext.argsLength() != 4) {
                throw new CommandException("citizens.commands.npc.skin.missing-skin");
            }
            skinTrait.setSkinPersistent(commandContext.getString(1), commandContext.getString(3), commandContext.getString(2));
            Messaging.sendTr(commandSender, "citizens.commands.npc.skin.set", nPC.getName(), commandContext.getString(1));
            return;
        }
        if (commandContext.hasFlag('s') && nPC.getEntity() instanceof Player) {
            ItemStack itemStack = new ItemStack(Material.PLAYER_HEAD);
            SkullMeta skullMeta = (SkullMeta)itemStack.getItemMeta();
            NMS.setProfile(skullMeta, NMS.getProfile((Player)nPC.getEntity()));
            itemStack.setItemMeta((ItemMeta)skullMeta);
            if (!(commandSender instanceof Player) || !((Player)commandSender).getInventory().addItem(new ItemStack[]{itemStack}).isEmpty()) {
                if (commandContext.getSenderLocation() != null) {
                    commandContext.getSenderLocation().getWorld().dropItem(commandContext.getSenderLocation(), itemStack);
                } else {
                    throw new ServerCommandException();
                }
            }
            return;
        }
        if (commandContext.argsLength() != 2) {
            Messaging.send(commandSender, skinTrait.getSkinName());
            return;
        }
        if (commandContext.hasFlag('l')) {
            skinTrait.setShouldUpdateSkins(true);
        }
        string3 = commandContext.getString(1);
        Messaging.sendTr(commandSender, "citizens.commands.npc.skin.set", nPC.getName(), string3);
        skinTrait.setSkinName(string3, true);
    }

    @Command(aliases={"npc"}, usage="skinlayers (--cape [true|false]) (--hat [true|false]) (--jacket [true|false]) (--sleeves [true|false]) (--pants [true|false])", desc="", modifiers={"skinlayers"}, min=1, max=5, permission="citizens.npc.skinlayers")
    @Requirements(types={EntityType.PLAYER}, selected=true, ownership=true)
    public void skinLayers(CommandContext commandContext, CommandSender commandSender, NPC nPC, @Flag(value={"cape"}) Boolean bl, @Flag(value={"hat"}) Boolean bl2, @Flag(value={"jacket"}) Boolean bl3, @Flag(value={"sleeves"}) Boolean bl4, @Flag(value={"pants"}) Boolean bl5) {
        SkinLayers skinLayers = nPC.getOrAddTrait(SkinLayers.class);
        if (bl != null) {
            skinLayers.setVisible(SkinLayers.Layer.CAPE, bl);
        }
        if (bl2 != null) {
            skinLayers.setVisible(SkinLayers.Layer.HAT, bl2);
        }
        if (bl3 != null) {
            skinLayers.setVisible(SkinLayers.Layer.JACKET, bl3);
        }
        if (bl4 != null) {
            skinLayers.setVisible(SkinLayers.Layer.LEFT_SLEEVE, bl4);
            skinLayers.setVisible(SkinLayers.Layer.RIGHT_SLEEVE, bl4);
        }
        if (bl5 != null) {
            skinLayers.setVisible(SkinLayers.Layer.LEFT_PANTS, bl5);
            skinLayers.setVisible(SkinLayers.Layer.RIGHT_PANTS, bl5);
        }
        Messaging.sendTr(commandSender, "citizens.commands.npc.skin.layers-set", nPC.getName(), skinLayers.isVisible(SkinLayers.Layer.CAPE), skinLayers.isVisible(SkinLayers.Layer.HAT), skinLayers.isVisible(SkinLayers.Layer.JACKET), skinLayers.isVisible(SkinLayers.Layer.LEFT_SLEEVE) || skinLayers.isVisible(SkinLayers.Layer.RIGHT_SLEEVE), skinLayers.isVisible(SkinLayers.Layer.LEFT_PANTS) || skinLayers.isVisible(SkinLayers.Layer.RIGHT_PANTS));
    }

    @Command(aliases={"npc"}, usage="size [size]", desc="", modifiers={"size"}, min=1, max=2, permission="citizens.npc.size")
    @Requirements(selected=true, ownership=true, types={EntityType.MAGMA_CUBE, EntityType.SLIME})
    public void slimeSize(CommandContext commandContext, CommandSender commandSender, NPC nPC) {
        SlimeSize slimeSize = nPC.getOrAddTrait(SlimeSize.class);
        if (commandContext.argsLength() <= 1) {
            slimeSize.describe(commandSender);
            return;
        }
        int n = Math.max(-2, commandContext.getInteger(1));
        slimeSize.setSize(n);
        Messaging.sendTr(commandSender, "citizens.commands.npc.size.set", nPC.getName(), n);
    }

    @Command(aliases={"npc"}, usage="sound (--death [death sound|d]) (--ambient [ambient sound|d]) (--hurt [hurt sound|d]) (-n(one)/-s(ilent)) (-d(efault))", desc="", modifiers={"sound"}, flags="dns", min=1, max=1, permission="citizens.npc.sound")
    @Requirements(selected=true, ownership=true, livingEntity=true)
    public void sound(CommandContext commandContext, CommandSender commandSender, NPC nPC, @Flag(value={"death"}) Sound sound, @Flag(value={"ambient"}) Sound sound2, @Flag(value={"hurt"}) Sound sound3) {
        String string = (String)nPC.data().get(NPC.Metadata.AMBIENT_SOUND);
        String string2 = (String)nPC.data().get(NPC.Metadata.DEATH_SOUND);
        String string3 = (String)nPC.data().get(NPC.Metadata.HURT_SOUND);
        if (commandContext.getValueFlags().size() == 0 && commandContext.getFlags().size() == 0) {
            Messaging.sendTr(commandSender, "citizens.commands.npc.sound.info", nPC.getName(), string, string3, string2);
            return;
        }
        if (commandContext.hasFlag('n')) {
            string3 = "";
            string2 = "";
            string = "";
            nPC.data().setPersistent(NPC.Metadata.SILENT, (Object)true);
        }
        if (commandContext.hasFlag('s')) {
            nPC.data().setPersistent(NPC.Metadata.SILENT, (Object)(nPC.data().get(NPC.Metadata.SILENT, Boolean.valueOf(false)) == false ? 1 : 0));
        }
        if (commandContext.hasFlag('d')) {
            string3 = null;
            string2 = null;
            string = null;
            nPC.data().setPersistent(NPC.Metadata.SILENT, (Object)false);
        } else {
            if (sound != null) {
                string2 = NMS.getSoundPath(sound);
            } else if (commandContext.hasValueFlag("death")) {
                String string4 = string2 = commandContext.getFlag("death").equals("d") ? null : commandContext.getFlag("death");
            }
            if (sound2 != null) {
                string = NMS.getSoundPath(sound2);
            } else if (commandContext.hasValueFlag("ambient")) {
                String string5 = string = commandContext.getFlag("ambient").equals("d") ? null : commandContext.getFlag("ambient");
            }
            if (sound3 != null) {
                string3 = NMS.getSoundPath(sound3);
            } else if (commandContext.hasValueFlag("hurt")) {
                String string6 = string3 = commandContext.getFlag("hurt").equals("d") ? null : commandContext.getFlag("hurt");
            }
        }
        if (string2 == null) {
            nPC.data().remove(NPC.Metadata.DEATH_SOUND);
        } else {
            nPC.data().setPersistent(NPC.Metadata.DEATH_SOUND, (Object)string2);
        }
        if (string3 == null) {
            nPC.data().remove(NPC.Metadata.HURT_SOUND);
        } else {
            nPC.data().setPersistent(NPC.Metadata.HURT_SOUND, (Object)string3);
        }
        if (string == null) {
            nPC.data().remove(NPC.Metadata.AMBIENT_SOUND);
        } else {
            nPC.data().setPersistent(NPC.Metadata.AMBIENT_SOUND, (Object)string);
        }
        if (string != null && string.isEmpty()) {
            string = "none";
        }
        if (string3 != null && string3.isEmpty()) {
            string3 = "none";
        }
        if (string2 != null && string2.isEmpty()) {
            string2 = "none";
        }
        if (!Strings.isNullOrEmpty((String)string) && !string.equals("none") || !Strings.isNullOrEmpty((String)string2) && !string2.equals("none") || !Strings.isNullOrEmpty((String)string3) && !string3.equals("none")) {
            nPC.data().setPersistent(NPC.Metadata.SILENT, (Object)false);
        }
        Messaging.sendTr(commandSender, "citizens.commands.npc.sound.set", nPC.getName(), string, string3, string2);
    }

    @Command(aliases={"npc"}, usage="spawn (id|name) -l(oad chunks)", desc="", modifiers={"spawn"}, min=1, max=2, flags="l", permission="citizens.npc.spawn")
    @Requirements(ownership=true)
    public void spawn(CommandContext commandContext, CommandSender commandSender, NPC nPC2) {
        NPCCommandSelector.Callback callback = nPC -> {
            if (nPC == null) {
                if (commandContext.argsLength() > 1) {
                    throw new CommandException("citizens.commands.npc.spawn.missing-npc-id", commandContext.getString(1));
                }
                throw new CommandException("citizens.commands.requirements.must-have-selected");
            }
            if (nPC.isSpawned()) {
                throw new CommandException("citizens.commands.npc.spawn.already-spawned", nPC.getName());
            }
            Location location = nPC.getOrAddTrait(CurrentLocation.class).getLocation();
            if (location == null || commandContext.hasValueFlag("location")) {
                if (commandContext.getSenderLocation() == null) {
                    throw new CommandException("citizens.commands.npc.spawn.no-location");
                }
                location = commandContext.getSenderLocation();
            }
            if (commandContext.hasFlag('l') && !Util.isLoaded(location)) {
                location.getChunk().load();
            }
            if (nPC.spawn(location, SpawnReason.COMMAND)) {
                this.selector.select(commandSender, nPC);
                Messaging.sendTr(commandSender, "citizens.commands.npc.spawn.spawned", nPC.getName());
            }
        };
        if (commandContext.argsLength() > 1) {
            NPCCommandSelector.startWithCallback(callback, CitizensAPI.getNPCRegistry(), commandSender, commandContext, commandContext.getString(1));
        } else {
            callback.run(nPC2);
        }
    }

    @Command(aliases={"npc"}, usage="speak [message] --bubble [duration] --target [npcid|player name] --range (range to look for entities to speak to in blocks)", desc="", modifiers={"speak"}, min=2, permission="citizens.npc.speak")
    public void speak(CommandContext commandContext, CommandSender commandSender, NPC nPC, @Flag(value={"bubble"}) Duration duration, @Flag(value={"type"}) String string, @Flag(value={"target"}) String string2, @Flag(value={"range"}) Float f) {
        Object object;
        String string3 = commandContext.getJoinedStrings(1);
        SpeechContext speechContext = new SpeechContext(string3);
        Object object2 = null;
        if (string2 != null) {
            if (string2.matches("\\d+")) {
                object = CitizensAPI.getNPCRegistry().getById(Integer.parseInt(commandContext.getFlag("target")));
                if (object != null) {
                    speechContext.addRecipient(object.getEntity());
                }
            } else {
                object = Bukkit.getPlayerExact((String)string2);
                if (object != null) {
                    speechContext.addRecipient((Entity)object);
                    object2 = object;
                }
            }
        }
        if (duration != null) {
            object = nPC.getOrAddTrait(HologramTrait.class);
            ((HologramTrait)object).addTemporaryLine(Placeholders.replace(string3, object2, nPC), Util.toTicks(duration));
            return;
        }
        if (f != null) {
            nPC.getEntity().getNearbyEntities((double)f.floatValue(), (double)f.floatValue(), (double)f.floatValue()).forEach(entity -> {
                if (!CitizensAPI.getNPCRegistry().isNPC((Entity)entity)) {
                    speechContext.addRecipient((Entity)entity);
                }
            });
        }
        nPC.getDefaultSpeechController().speak(speechContext);
    }

    @Command(aliases={"npc"}, usage="speed [speed]", desc="", modifiers={"speed"}, min=2, max=2, permission="citizens.npc.speed")
    public void speed(CommandContext commandContext, CommandSender commandSender, NPC nPC) {
        float f = (float)Math.abs(commandContext.getDouble(1));
        nPC.getNavigator().getDefaultParameters().speedModifier(f);
        Messaging.sendTr(commandSender, "citizens.commands.npc.speed.set", Float.valueOf(f));
    }

    @Command(aliases={"npc"}, usage="swim (--set [true|false])", desc="", modifiers={"swim"}, min=1, max=1, permission="citizens.npc.swim")
    public void swim(CommandContext commandContext, CommandSender commandSender, NPC nPC, @Flag(value={"set"}) Boolean bl) {
        boolean bl2 = bl != null ? bl : nPC.data().get(NPC.Metadata.SWIM, Boolean.valueOf(true)) == false;
        nPC.data().setPersistent(NPC.Metadata.SWIM, (Object)bl2);
        Messaging.sendTr(commandSender, bl2 ? "citizens.commands.npc.swim.set" : "citizens.commands.npc.swim.unset", nPC.getName());
    }

    @Command(aliases={"npc"}, usage="target [name|UUID] (-a[ggressive]) (-c[ancel])", desc="", modifiers={"target"}, flags="ac", min=1, max=2, permission="citizens.npc.target")
    public void target(CommandContext commandContext, CommandSender commandSender, NPC nPC) {
        Player player;
        if (commandContext.hasFlag('c')) {
            nPC.getNavigator().cancelNavigation();
            return;
        }
        Player player2 = player = commandContext.argsLength() < 2 && commandSender instanceof Player ? (Player)commandSender : Bukkit.getPlayer((String)commandContext.getString(1));
        if (player == null && commandContext.argsLength() == 2) {
            player = Bukkit.getEntity((UUID)UUID.fromString(commandContext.getString(1)));
        }
        if (player == null) {
            throw new CommandUsageException();
        }
        nPC.getNavigator().setTarget((Entity)player, commandContext.hasFlag('a'));
    }

    @Command(aliases={"npc"}, usage="targetable (-t(emporary))", desc="", modifiers={"targetable"}, min=1, max=1, flags="t", permission="citizens.npc.targetable")
    public void targetable(CommandContext commandContext, CommandSender commandSender, NPC nPC) {
        boolean bl;
        boolean bl2 = bl = nPC.data().get(NPC.Metadata.TARGETABLE, Boolean.valueOf(nPC.isProtected())) == false;
        if (commandContext.hasFlag('t')) {
            nPC.data().set(NPC.Metadata.TARGETABLE, (Object)bl);
        } else {
            nPC.data().setPersistent(NPC.Metadata.TARGETABLE, (Object)bl);
        }
        if (bl && nPC.getOrAddTrait(MobType.class).getType() == EntityType.PLAYER && nPC.data().get(NPC.Metadata.REMOVE_FROM_PLAYERLIST, Boolean.valueOf(true)).booleanValue()) {
            Messaging.sendTr(commandSender, "citizens.commands.npc.targetable.playerlist-warning", new Object[0]);
            if (commandContext.hasFlag('t')) {
                nPC.data().set(NPC.Metadata.REMOVE_FROM_PLAYERLIST, (Object)false);
            } else {
                nPC.data().setPersistent(NPC.Metadata.REMOVE_FROM_PLAYERLIST, (Object)false);
            }
            if (nPC.isSpawned()) {
                NMS.addOrRemoveFromPlayerList(nPC.getEntity(), false);
            }
        }
        Messaging.sendTr(commandSender, bl ? "citizens.commands.npc.targetable.set" : "citizens.commands.npc.targetable.unset", nPC.getName());
    }

    @Command(aliases={"npc"}, usage="tp (-e(xact))", desc="", modifiers={"tp", "teleport"}, min=1, max=1, flags="e", permission="citizens.npc.tp")
    public void tp(CommandContext commandContext, Player player, NPC nPC) {
        Location location = nPC.getOrAddTrait(CurrentLocation.class).getLocation();
        if (location == null) {
            Messaging.sendError((CommandSender)player, "citizens.commands.npc.tp.location-not-found");
            return;
        }
        if (!commandContext.hasFlag('e')) {
            location = location.clone().add(location.getDirection().setY(0));
            location.setDirection(location.getDirection().multiply(-1)).setPitch(0.0f);
        }
        player.teleport(location, PlayerTeleportEvent.TeleportCause.COMMAND);
        Messaging.sendTr((CommandSender)player, "citizens.commands.npc.tp.teleported", nPC.getName());
    }

    @Command(aliases={"npc"}, usage="tphere (cursor) -c(enter) -f(ront)", desc="", flags="cf", modifiers={"tphere", "tph", "move"}, min=1, max=2, permission="citizens.npc.tphere")
    public void tphere(CommandContext commandContext, CommandSender commandSender, NPC nPC) {
        Object object;
        Location location = commandContext.getSenderLocation();
        if (location == null) {
            throw new ServerCommandException();
        }
        if (commandContext.argsLength() > 1 && commandContext.getString(1).equalsIgnoreCase("cursor")) {
            if (!(commandSender instanceof Player)) {
                throw new ServerCommandException();
            }
            object = ((Player)commandSender).getTargetBlock(null, 64);
            if (object == null) {
                throw new CommandException("citizens.commands.npc.tphere.missing-cursor-block");
            }
            location = object.getRelative(BlockFace.UP).getLocation();
        }
        if (!commandSender.hasPermission("citizens.npc.tphere.multiworld") && nPC.getStoredLocation().getWorld() != commandContext.getSenderLocation().getWorld()) {
            throw new CommandException("citizens.commands.npc.tphere.multiworld-not-allowed");
        }
        if (commandContext.hasFlag('c')) {
            location = location.getBlock().getLocation();
            location.setX(location.getX() + 0.5);
            location.setZ(location.getZ() + 0.5);
        }
        if (commandContext.hasFlag('f')) {
            location = location.clone().add(location.getDirection().setY(0));
            location.setDirection(location.getDirection().multiply(-1)).setPitch(0.0f);
        }
        if (!nPC.isSpawned()) {
            object = new NPCTeleportEvent(nPC, location);
            Bukkit.getPluginManager().callEvent((Event)object);
            if (((NPCTeleportEvent)((Object)object)).isCancelled()) {
                return;
            }
            nPC.spawn(location, SpawnReason.COMMAND);
        } else {
            nPC.teleport(location, PlayerTeleportEvent.TeleportCause.COMMAND);
        }
        Messaging.sendTr(commandSender, "citizens.commands.npc.tphere.teleported", nPC.getName(), Util.prettyPrintLocation(commandContext.getSenderLocation()));
    }

    @Command(aliases={"npc"}, usage="tpto [player name|npc id] [player name|npc id]", desc="", modifiers={"tpto"}, min=2, max=3, permission="citizens.npc.tpto", parsePlaceholders=true)
    @Requirements
    public void tpto(CommandContext commandContext, CommandSender commandSender, NPC nPC) {
        Player player;
        Entity entity;
        block14: {
            NPC nPC2;
            int n;
            entity = null;
            player = null;
            boolean bl = false;
            if (nPC != null) {
                entity = nPC.getEntity();
            }
            try {
                n = commandContext.getInteger(1);
                nPC2 = CitizensAPI.getNPCRegistry().getById(n);
                if (nPC2 != null) {
                    if (commandContext.argsLength() == 2) {
                        player = nPC2.getEntity();
                    } else {
                        entity = nPC2.getEntity();
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                if (commandContext.argsLength() == 2) {
                    player = Bukkit.getPlayerExact((String)commandContext.getString(1));
                } else {
                    entity = Bukkit.getPlayerExact((String)commandContext.getString(1));
                }
                bl = true;
            }
            if (commandContext.argsLength() == 3) {
                try {
                    n = commandContext.getInteger(2);
                    nPC2 = CitizensAPI.getNPCRegistry().getById(n);
                    if (nPC2 != null) {
                        player = nPC2.getEntity();
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    if (bl) break block14;
                    player = Bukkit.getPlayerExact((String)commandContext.getString(2));
                }
            }
        }
        if (entity == null) {
            throw new CommandException("citizens.commands.npc.tpto.from-not-found");
        }
        if (player == null) {
            throw new CommandException("citizens.commands.npc.tpto.to-not-found");
        }
        entity.teleport((Entity)player);
        Messaging.sendTr(commandSender, "citizens.commands.npc.tpto.success", new Object[0]);
    }

    @Command(aliases={"npc"}, usage="trackingrange [range]", desc="", modifiers={"trackingrange"}, min=1, max=2, permission="citizens.npc.trackingrange")
    public void trackingrange(CommandContext commandContext, CommandSender commandSender, NPC nPC, @Arg(value=1) Integer n) {
        if (n == null) {
            nPC.data().remove(NPC.Metadata.TRACKING_RANGE);
        } else {
            nPC.data().setPersistent(NPC.Metadata.TRACKING_RANGE, (Object)n);
        }
        Messaging.sendTr(commandSender, "citizens.commands.npc.trackingrange.set", n);
    }

    @Command(aliases={"npc"}, usage="type [type]", desc="", modifiers={"type"}, min=2, max=2, permission="citizens.npc.type")
    public void type(CommandContext commandContext, CommandSender commandSender, NPC nPC, @Arg(value=1) EntityType entityType) {
        if (entityType == null) {
            throw new CommandException("citizens.commands.npc.type.invalid", commandContext.getString(1));
        }
        nPC.setBukkitEntityType(entityType);
        Messaging.sendTr(commandSender, "citizens.commands.npc.type.set", nPC.getName(), commandContext.getString(1));
    }

    @Command(aliases={"npc"}, usage="undo (all)", desc="", modifiers={"undo"}, min=1, max=2, permission="citizens.npc.undo")
    @Requirements
    public void undo(CommandContext commandContext, CommandSender commandSender, NPC nPC, @Arg(value=1, completions={"all"}) String string) {
        if ("all".equalsIgnoreCase(string)) {
            while (this.history.undo(commandSender)) {
            }
        } else if (this.history.undo(commandSender)) {
            Messaging.sendTr(commandSender, "citizens.commands.npc.undo.successful", new Object[0]);
        } else {
            Messaging.sendTr(commandSender, "citizens.commands.npc.undo.unsuccessful", new Object[0]);
        }
    }

    @Command(aliases={"npc"}, usage="useitem (-o(ffhand))", desc="", modifiers={"useitem"}, min=1, max=1, flags="o", permission="citizens.npc.useitem")
    public void useitem(CommandContext commandContext, CommandSender commandSender, NPC nPC) {
        boolean bl = commandContext.hasFlag('o');
        if (bl) {
            nPC.data().setPersistent(NPC.Metadata.USING_OFFHAND_ITEM, (Object)(nPC.data().get(NPC.Metadata.USING_OFFHAND_ITEM, Boolean.valueOf(false)) == false ? 1 : 0));
            Messaging.sendTr(commandSender, "citizens.commands.npc.useitem.offhand-item-toggled", Boolean.toString((Boolean)nPC.data().get(NPC.Metadata.USING_OFFHAND_ITEM)));
        } else {
            nPC.data().setPersistent(NPC.Metadata.USING_HELD_ITEM, (Object)(nPC.data().get(NPC.Metadata.USING_HELD_ITEM, Boolean.valueOf(false)) == false ? 1 : 0));
            Messaging.sendTr(commandSender, "citizens.commands.npc.useitem.held-item-toggled", Boolean.toString((Boolean)nPC.data().get(NPC.Metadata.USING_HELD_ITEM)));
        }
    }

    @Command(aliases={"npc"}, usage="vulnerable (-t(emporary))", desc="", modifiers={"vulnerable"}, min=1, max=1, flags="t", permission="citizens.npc.vulnerable")
    public void vulnerable(CommandContext commandContext, CommandSender commandSender, NPC nPC) {
        boolean bl;
        boolean bl2 = bl = !nPC.isProtected();
        if (commandContext.hasFlag('t')) {
            nPC.data().set(NPC.Metadata.DEFAULT_PROTECTED, (Object)bl);
        } else {
            nPC.data().setPersistent(NPC.Metadata.DEFAULT_PROTECTED, (Object)bl);
        }
        String string = bl ? "citizens.commands.npc.vulnerable.stopped" : "citizens.commands.npc.vulnerable.set";
        Messaging.sendTr(commandSender, string, nPC.getName());
    }

    @Command(aliases={"npc"}, usage="wander", desc="", modifiers={"wander"}, min=1, max=1, permission="citizens.npc.wander")
    public void wander(CommandContext commandContext, CommandSender commandSender, NPC nPC) {
        Waypoints waypoints = nPC.getOrAddTrait(Waypoints.class);
        if (commandSender instanceof Player && Editor.hasEditor((Player)commandSender)) {
            Editor.leave((Player)commandSender);
        }
        waypoints.setWaypointProvider(waypoints.getCurrentProviderName().equals("wander") ? "linear" : "wander");
        Messaging.sendTr(commandSender, "citizens.waypoints.set-provider", waypoints.getCurrentProviderName());
    }

    @Command(aliases={"npc"}, usage="wither (--invulnerable [true|false]) (--invulnerable-ticks [ticks]) (--arrow-shield [true|false])", desc="", modifiers={"wither"}, min=1, requiresFlags=true, max=1, permission="citizens.npc.wither")
    @Requirements(selected=true, ownership=true, types={EntityType.WITHER})
    public void wither(CommandContext commandContext, CommandSender commandSender, NPC nPC, @Flag(value={"invulnerable"}) Boolean bl, @Flag(value={"arrow-shield"}) Boolean bl2, @Flag(value={"invulnerable-ticks"}) Integer n) {
        WitherTrait witherTrait = nPC.getOrAddTrait(WitherTrait.class);
        if (bl != null) {
            witherTrait.setInvulnerable(bl);
        }
        if (n != null) {
            witherTrait.setInvulnerableTicks(n);
        }
        if (bl2 != null) {
            witherTrait.setBlocksArrows(bl2);
        }
    }

    @Command(aliases={"npc"}, usage="wolf (-s(itting) a(ngry) t(amed) i(nterested)) --collar [hex rgb color|name] --variant [variant]", desc="", modifiers={"wolf"}, min=1, max=1, requiresFlags=true, flags="sati", permission="citizens.npc.wolf")
    @Requirements(selected=true, ownership=true, types={EntityType.WOLF})
    public void wolf(CommandContext commandContext, CommandSender commandSender, NPC nPC, @Flag(value={"collar"}) String string, @Flag(value={"variant"}, completions={"ASHEN", "BLACK", "CHESTNUT", "PALE", "RUSTY", "SNOWY", "STRIPED", "WOODS", "SPOTTED"}) String string2) {
        WolfModifiers wolfModifiers = nPC.getOrAddTrait(WolfModifiers.class);
        if (commandContext.hasFlag('a')) {
            wolfModifiers.setAngry(!wolfModifiers.isAngry());
        }
        if (commandContext.hasFlag('s')) {
            wolfModifiers.setSitting(!wolfModifiers.isSitting());
        }
        if (commandContext.hasFlag('t')) {
            wolfModifiers.setTamed(!wolfModifiers.isTamed());
        }
        if (commandContext.hasFlag('i')) {
            wolfModifiers.setInterested(!wolfModifiers.isInterested());
        }
        if (string2 != null) {
            string2 = string2.toUpperCase();
            try {
                Wolf.Variant.class.getField(string2);
            }
            catch (Throwable throwable) {
                throw new CommandUsageException();
            }
            wolfModifiers.setVariant(string2);
        }
        if (string != null) {
            String string3 = string;
            DyeColor dyeColor = null;
            try {
                dyeColor = DyeColor.valueOf((String)string3.toUpperCase().replace(' ', '_'));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                try {
                    int n = Integer.parseInt(string3.replace("#", ""), 16);
                    dyeColor = DyeColor.getByColor((Color)Color.fromRGB((int)n));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new CommandException("citizens.commands.npc.wolf.unknown-collar-color", string3);
                }
            }
            if (dyeColor == null) {
                throw new CommandException("citizens.commands.npc.wolf.collar-color-unsupported", string3);
            }
            wolfModifiers.setCollarColor(dyeColor);
        }
        Messaging.sendTr(commandSender, "citizens.commands.wolf.traits-updated", nPC.getName(), wolfModifiers.isAngry(), wolfModifiers.isSitting(), wolfModifiers.isTamed(), wolfModifiers.getCollarColor().name());
    }

    private static /* synthetic */ void lambda$skin$11(SkinTrait skinTrait, String string, String string2, String string3, CommandSender commandSender, NPC nPC, String string4, String string5) {
        try {
            skinTrait.setSkinPersistent(string, string2, string3);
            Messaging.sendTr(commandSender, "citizens.commands.npc.skin.skin-url-set", nPC.getName(), string4 == null ? string5 : string4);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Messaging.sendErrorTr(commandSender, "citizens.commands.npc.skin.error-setting-url", string4 == null ? string5 : string4);
        }
    }

    public static class OptionalBoatTypeCompletions
    extends Arg.CompletionsProvider.OptionalEnumCompletions {
        @Override
        public String getEnumClassName() {
            return "org.bukkit.entity.Boat.Type";
        }
    }

    public static class OptionalAttributeCompletions
    extends Arg.CompletionsProvider.OptionalEnumCompletions {
        @Override
        public String getEnumClassName() {
            return "org.bukkit.attribute.Attribute";
        }
    }
}

