/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.commands;

import com.google.common.base.Joiner;
import java.util.Collection;
import java.util.stream.Collectors;
import net.citizensnpcs.Citizens;
import net.citizensnpcs.api.command.Arg;
import net.citizensnpcs.api.command.Command;
import net.citizensnpcs.api.command.CommandContext;
import net.citizensnpcs.api.command.Requirements;
import net.citizensnpcs.api.command.exception.CommandException;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.npc.templates.Template;
import net.citizensnpcs.api.npc.templates.TemplateRegistry;
import net.citizensnpcs.api.util.Messaging;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;

@Requirements(selected=true, ownership=true)
public class TemplateCommands {
    private final TemplateRegistry registry;

    public TemplateCommands(Citizens citizens) {
        this.registry = citizens.getTemplateRegistry();
    }

    @Command(aliases={"template", "tpl"}, usage="apply (template namespace:)[template name]", desc="", modifiers={"apply"}, min=2, permission="citizens.templates.apply")
    public void apply(CommandContext commandContext, CommandSender commandSender, NPC nPC, @Arg(value=1, completionsProvider=TemplateCompletions.class) String string) {
        Template template2 = null;
        if (string.contains(":")) {
            int n = string.indexOf(58);
            template2 = this.registry.getTemplateByKey(new NamespacedKey(string.substring(0, n), string.substring(n + 1)));
        } else {
            Collection<Template> collection = this.registry.getTemplates(string);
            if (collection.isEmpty()) {
                throw new CommandException("citizens.commands.template.missing");
            }
            if (collection.size() > 1) {
                throw new CommandException("citizens.commands.template.qualified-template-required", string, Joiner.on((String)", ").join((Iterable)collection.stream().map(template -> template.getKey()).collect(Collectors.toList())));
            }
            template2 = collection.iterator().next();
        }
        if (template2 == null) {
            throw new CommandException("citizens.commands.template.missing");
        }
        template2.apply(nPC);
        Messaging.sendTr(commandSender, "citizens.commands.template.applied", template2.getKey().getKey(), nPC.getName());
    }

    @Command(aliases={"template", "tpl"}, usage="generate (template namespace:)[name]", desc="", modifiers={"generate"}, min=2, max=2, permission="citizens.templates.generate")
    public void generate(CommandContext commandContext, CommandSender commandSender, NPC nPC, @Arg(value=1, completionsProvider=TemplateCompletions.class) String string) {
        NamespacedKey namespacedKey;
        int n = string.indexOf(58);
        NamespacedKey namespacedKey2 = namespacedKey = n == -1 ? new NamespacedKey("generated", string) : new NamespacedKey(string.substring(0, n), string.substring(n + 1));
        if (this.registry.getTemplateByKey(namespacedKey) != null) {
            throw new CommandException("citizens.commands.template.conflict");
        }
        this.registry.generateTemplateFromNPC(namespacedKey, nPC);
        Messaging.sendTr(commandSender, "citizens.commands.template.generate.generated", nPC.getName());
    }

    @Command(aliases={"template", "tpl"}, usage="list", desc="", modifiers={"list"}, min=1, max=1, permission="citizens.templates.list")
    public void list(CommandContext commandContext, CommandSender commandSender, NPC nPC) {
        Messaging.sendTr(commandSender, "citizens.commands.template.list.header", new Object[0]);
        for (Template template : this.registry.getAllTemplates()) {
            Messaging.send(commandSender, "[[-]]    " + template.getKey());
        }
    }

    public static class TemplateCompletions
    implements Arg.CompletionsProvider {
        private final TemplateRegistry templateRegistry;

        public TemplateCompletions(Citizens citizens) {
            this.templateRegistry = citizens.getTemplateRegistry();
        }

        @Override
        public Collection<String> getCompletions(CommandContext commandContext, CommandSender commandSender, NPC nPC) {
            return this.templateRegistry.getAllTemplates().stream().map(template -> template.getKey().toString()).collect(Collectors.toList());
        }
    }
}

