/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.commands;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.command.Command;
import net.citizensnpcs.api.command.CommandContext;
import net.citizensnpcs.api.command.Requirements;
import net.citizensnpcs.api.event.NPCTraitCommandAttachEvent;
import net.citizensnpcs.api.event.NPCTraitCommandDetachEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.util.StringHelper;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Event;

@Requirements(selected=true, ownership=true)
public class TraitCommands {
    @Command(aliases={"trait"}, usage="add [trait name]...", desc="", modifiers={"add", "a"}, min=2, permission="citizens.npc.trait")
    public void add(CommandContext commandContext, CommandSender commandSender, NPC nPC) {
        ArrayList arrayList = Lists.newArrayList();
        ArrayList arrayList2 = Lists.newArrayList();
        for (String string : Splitter.on((char)',').split((CharSequence)commandContext.getJoinedStrings(1))) {
            if (!commandSender.hasPermission("citizens.npc.trait." + string) && !commandSender.hasPermission("citizens.npc.trait.*")) {
                arrayList2.add(String.format("%s: No permission", string));
                continue;
            }
            Class<? extends Trait> clazz = CitizensAPI.getTraitFactory().getTraitClass(string);
            if (clazz == null) {
                arrayList2.add(String.format("%s: Trait not found", string));
                continue;
            }
            if (nPC.hasTrait(clazz)) {
                arrayList2.add(String.format("%s: Already added", string));
                continue;
            }
            this.addTrait(nPC, clazz, commandSender);
            arrayList.add(StringHelper.wrap(string));
        }
        if (arrayList.size() > 0) {
            Messaging.sendTr(commandSender, "citizens.commands.trait.added", Joiner.on((String)", ").join((Iterable)arrayList));
        }
        if (arrayList2.size() > 0) {
            Messaging.sendTr(commandSender, "citizens.commands.trait.failed-to-add", Joiner.on((String)", ").join((Iterable)arrayList2));
        }
    }

    private void addTrait(NPC nPC, Class<? extends Trait> clazz, CommandSender commandSender) {
        nPC.addTrait(clazz);
        Bukkit.getPluginManager().callEvent((Event)new NPCTraitCommandAttachEvent(nPC, clazz, commandSender));
    }

    @Command(aliases={"trait"}, usage="remove [trait names]...", desc="", modifiers={"remove", "rem", "r"}, min=2, permission="citizens.npc.trait")
    public void remove(CommandContext commandContext, CommandSender commandSender, NPC nPC) {
        ArrayList arrayList = Lists.newArrayList();
        ArrayList arrayList2 = Lists.newArrayList();
        for (String string : Splitter.on((char)',').split((CharSequence)commandContext.getJoinedStrings(1))) {
            if (!commandSender.hasPermission("citizens.npc.trait." + string) && !commandSender.hasPermission("citizens.npc.trait.*")) {
                arrayList2.add(String.format("%s: No permission", string));
                continue;
            }
            Class<? extends Trait> clazz = CitizensAPI.getTraitFactory().getTraitClass(string);
            if (clazz == null) {
                arrayList2.add(String.format("%s: Trait not found", string));
                continue;
            }
            boolean bl = nPC.hasTrait(clazz);
            if (!bl) {
                arrayList2.add(String.format("%s: Trait not attached", string));
                continue;
            }
            this.removeTrait(nPC, clazz, commandSender);
            arrayList.add(StringHelper.wrap(string));
        }
        if (arrayList.size() > 0) {
            Messaging.sendTr(commandSender, "citizens.commands.trait.removed", Joiner.on((String)", ").join((Iterable)arrayList));
        }
        if (arrayList2.size() > 0) {
            Messaging.sendTr(commandSender, "citizens.commands.trait.failed-to-remove", Joiner.on((String)", ").join((Iterable)arrayList2));
        }
    }

    private void removeTrait(NPC nPC, Class<? extends Trait> clazz, CommandSender commandSender) {
        Bukkit.getPluginManager().callEvent((Event)new NPCTraitCommandDetachEvent(nPC, clazz, commandSender));
        nPC.removeTrait(clazz);
    }

    @Command(aliases={"trait"}, usage="[trait name], [trait name]...", desc="", modifiers={"*"}, min=1, permission="citizens.npc.trait")
    public void toggle(CommandContext commandContext, CommandSender commandSender, NPC nPC) {
        ArrayList arrayList = Lists.newArrayList();
        ArrayList arrayList2 = Lists.newArrayList();
        ArrayList arrayList3 = Lists.newArrayList();
        for (String string : Splitter.on((char)',').split((CharSequence)commandContext.getJoinedStrings(0))) {
            if (!commandSender.hasPermission("citizens.npc.trait." + string) && !commandSender.hasPermission("citizens.npc.trait.*")) {
                arrayList3.add(String.format("%s: No permission", string));
                continue;
            }
            Class<? extends Trait> clazz = CitizensAPI.getTraitFactory().getTraitClass(string);
            if (clazz == null) {
                arrayList3.add(String.format("%s: Trait not found", string));
                continue;
            }
            boolean bl = nPC.hasTrait(clazz);
            if (bl) {
                this.removeTrait(nPC, clazz, commandSender);
                arrayList2.add(StringHelper.wrap(string));
                continue;
            }
            this.addTrait(nPC, clazz, commandSender);
            arrayList.add(StringHelper.wrap(string));
        }
        if (arrayList.size() > 0) {
            Messaging.sendTr(commandSender, "citizens.commands.trait.added", Joiner.on((String)", ").join((Iterable)arrayList));
        }
        if (arrayList2.size() > 0) {
            Messaging.sendTr(commandSender, "citizens.commands.trait.removed", Joiner.on((String)", ").join((Iterable)arrayList2));
        }
        if (arrayList3.size() > 0) {
            Messaging.send(commandSender, "Failed to toggle traits", Joiner.on((String)", ").join((Iterable)arrayList3));
        }
    }
}

