/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.commands.gui;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.function.Consumer;
import net.citizensnpcs.api.gui.CitizensInventoryClickEvent;
import net.citizensnpcs.api.gui.InputMenus;
import net.citizensnpcs.api.gui.InventoryMenuPage;
import net.citizensnpcs.api.gui.InventoryMenuSlot;
import net.citizensnpcs.api.gui.Menu;
import net.citizensnpcs.api.gui.MenuContext;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.util.Util;
import org.bukkit.Material;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.ItemStack;

@Menu(title="Configure NPC", type=InventoryType.CHEST, dimensions={5, 9})
public class NPCConfigurator
extends InventoryMenuPage {
    private NPC npc;
    private static final Map<Integer, ConfiguratorInfo> SLOT_MAP = Maps.newHashMap();

    private NPCConfigurator() {
        throw new UnsupportedOperationException();
    }

    public NPCConfigurator(NPC nPC) {
        this.npc = nPC;
    }

    @Override
    public void initialise(MenuContext menuContext) {
        for (Map.Entry<Integer, ConfiguratorInfo> entry : SLOT_MAP.entrySet()) {
            ConfiguratorInfo configuratorInfo = entry.getValue();
            InventoryMenuSlot inventoryMenuSlot = menuContext.getSlot(entry.getKey());
            inventoryMenuSlot.setItemStack(new ItemStack(configuratorInfo.material, 1));
            inventoryMenuSlot.setClickHandler(citizensInventoryClickEvent -> configuratorInfo.clickHandler.accept(new ConfiguratorEvent(menuContext, this.npc, inventoryMenuSlot, (CitizensInventoryClickEvent)((Object)citizensInventoryClickEvent))));
            configuratorInfo.clickHandler.accept(new ConfiguratorEvent(menuContext, this.npc, inventoryMenuSlot, null));
        }
    }

    static {
        SLOT_MAP.put(0, new ConfiguratorInfo(Util.getFallbackMaterial("OAK_SIGN", "SIGN"), configuratorEvent -> {
            ((ConfiguratorEvent)configuratorEvent).slot.setDescription("Edit NPC name\n" + ((ConfiguratorEvent)configuratorEvent).npc.getName());
            if (((ConfiguratorEvent)configuratorEvent).event != null) {
                ((ConfiguratorEvent)configuratorEvent).ctx.getMenu().transition(InputMenus.stringSetter(() -> ((ConfiguratorEvent)configuratorEvent).npc.getName(), string -> ((ConfiguratorEvent)configuratorEvent).npc.setName((String)string)));
            }
        }));
    }

    private static class ConfiguratorInfo {
        private final Consumer<ConfiguratorEvent> clickHandler;
        private final Material material;

        public ConfiguratorInfo(Material material, Consumer<ConfiguratorEvent> consumer) {
            this.material = material;
            this.clickHandler = consumer;
        }
    }

    private static class ConfiguratorEvent {
        private final MenuContext ctx;
        private final CitizensInventoryClickEvent event;
        private final NPC npc;
        private final InventoryMenuSlot slot;

        public ConfiguratorEvent(MenuContext menuContext, NPC nPC, InventoryMenuSlot inventoryMenuSlot, CitizensInventoryClickEvent citizensInventoryClickEvent) {
            this.ctx = menuContext;
            this.npc = nPC;
            this.slot = inventoryMenuSlot;
            this.event = citizensInventoryClickEvent;
        }
    }
}

