/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.commands.history;

import java.util.UUID;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.npc.NPCSelector;
import net.citizensnpcs.api.trait.trait.MobType;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.api.util.MemoryDataKey;
import net.citizensnpcs.commands.history.CommandHistoryItem;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;

public class RemoveNPCHistoryItem
implements CommandHistoryItem {
    private final int id;
    private final DataKey key = new MemoryDataKey();
    private final EntityType type;
    private final UUID uuid;

    public RemoveNPCHistoryItem(NPC nPC) {
        nPC.save(this.key);
        this.type = nPC.getOrAddTrait(MobType.class).getType();
        this.uuid = nPC.getUniqueId();
        this.id = nPC.getId();
    }

    @Override
    public void undo(CommandSender commandSender, NPCSelector nPCSelector) {
        NPC nPC = CitizensAPI.getNPCRegistry().createNPC(this.type, this.uuid, this.id, this.key.getString("name"));
        nPC.load(this.key);
        nPCSelector.select(commandSender, nPC);
    }
}

