/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.editor;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.util.Messaging;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;

public abstract class Editor
implements Listener {
    private static final Map<UUID, Editor> EDITING = new HashMap<UUID, Editor>();

    public abstract void begin();

    public abstract void end();

    private static void enter(Player player, Editor editor) {
        editor.begin();
        player.getServer().getPluginManager().registerEvents((Listener)editor, CitizensAPI.getPlugin());
        EDITING.put(player.getUniqueId(), editor);
    }

    public static void enterOrLeave(Player player, Editor editor) {
        if (editor == null) {
            return;
        }
        Editor editor2 = EDITING.get(player.getUniqueId());
        if (editor2 == null) {
            Editor.enter(player, editor);
        } else if (editor2.getClass() == editor.getClass()) {
            Editor.leave(player);
        } else {
            Messaging.sendErrorTr((CommandSender)player, "citizens.editors.already-in-editor", new Object[0]);
        }
    }

    public static boolean hasEditor(Player player) {
        return EDITING.containsKey(player.getUniqueId());
    }

    public static void leave(Player player) {
        if (!Editor.hasEditor(player)) {
            return;
        }
        Editor editor = EDITING.remove(player.getUniqueId());
        HandlerList.unregisterAll((Listener)editor);
        editor.end();
    }

    public static void leaveAll() {
        for (Map.Entry<UUID, Editor> entry : EDITING.entrySet()) {
            entry.getValue().end();
            HandlerList.unregisterAll((Listener)entry.getValue());
        }
        EDITING.clear();
    }
}

