/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_16_R3.entity;

import com.mojang.authlib.GameProfile;
import java.util.UUID;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_16_R3.entity.EntityHumanNPC;
import net.citizensnpcs.npc.AbstractEntityController;
import net.citizensnpcs.npc.skin.Skin;
import net.citizensnpcs.trait.ScoreboardTrait;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.server.v1_16_R3.MinecraftServer;
import net.minecraft.server.v1_16_R3.PlayerInteractManager;
import net.minecraft.server.v1_16_R3.WorldServer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_16_R3.CraftWorld;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class HumanController
extends AbstractEntityController {
    @Override
    protected Entity createEntity(Location location, NPC nPC) {
        WorldServer worldServer = ((CraftWorld)location.getWorld()).getHandle();
        String string = nPC.getFullName();
        String string2 = string.length() > 16 ? string.substring(0, 16) : string;
        UUID uUID = nPC.getMinecraftUniqueId();
        String string3 = Util.getTeamName(uUID);
        if (nPC.requiresNameHologram()) {
            string2 = string3;
        }
        if (Settings.Setting.USE_SCOREBOARD_TEAMS.asBoolean()) {
            nPC.getOrAddTrait(ScoreboardTrait.class).createTeam(string2);
        }
        GameProfile gameProfile = new GameProfile(uUID, string2);
        EntityHumanNPC entityHumanNPC = new EntityHumanNPC((MinecraftServer)worldServer.getServer().getServer(), worldServer, gameProfile, new PlayerInteractManager(worldServer), nPC);
        Skin skin = entityHumanNPC.getSkinTracker().getSkin();
        if (skin != null) {
            skin.apply(entityHumanNPC);
        }
        Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), () -> {
            if (this.getBukkitEntity() == null || !this.getBukkitEntity().isValid() || this.getBukkitEntity() != entityHumanNPC.getBukkitEntity()) {
                return;
            }
            boolean bl = nPC.data().get("removefromplayerlist", Boolean.valueOf(Settings.Setting.REMOVE_PLAYERS_FROM_PLAYER_LIST.asBoolean()));
            NMS.addOrRemoveFromPlayerList((Entity)this.getBukkitEntity(), bl);
        }, 20L);
        entityHumanNPC.getBukkitEntity().setSleepingIgnored(true);
        return entityHumanNPC.getBukkitEntity();
    }

    public Player getBukkitEntity() {
        return (Player)super.getBukkitEntity();
    }
}

