/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_16_R3.entity.nonliving;

import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_16_R3.entity.MobEntityController;
import net.citizensnpcs.nms.v1_16_R3.util.ForwardingNPCHolder;
import net.citizensnpcs.nms.v1_16_R3.util.NMSBoundingBox;
import net.citizensnpcs.nms.v1_16_R3.util.NMSImpl;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.Util;
import net.minecraft.server.v1_16_R3.AxisAlignedBB;
import net.minecraft.server.v1_16_R3.BlockPosition;
import net.minecraft.server.v1_16_R3.EntityBoat;
import net.minecraft.server.v1_16_R3.EntityHuman;
import net.minecraft.server.v1_16_R3.EntityTypes;
import net.minecraft.server.v1_16_R3.EnumMoveType;
import net.minecraft.server.v1_16_R3.EnumPistonReaction;
import net.minecraft.server.v1_16_R3.Fluid;
import net.minecraft.server.v1_16_R3.FluidType;
import net.minecraft.server.v1_16_R3.IBlockAccess;
import net.minecraft.server.v1_16_R3.MathHelper;
import net.minecraft.server.v1_16_R3.NBTTagCompound;
import net.minecraft.server.v1_16_R3.Tag;
import net.minecraft.server.v1_16_R3.TagsFluid;
import net.minecraft.server.v1_16_R3.Vec3D;
import net.minecraft.server.v1_16_R3.World;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_16_R3.CraftServer;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftBoat;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftEntity;
import org.bukkit.entity.Boat;
import org.bukkit.entity.Entity;
import org.bukkit.util.Vector;

public class BoatController
extends MobEntityController {
    public BoatController() {
        super(EntityBoatNPC.class);
    }

    public Boat getBukkitEntity() {
        return (Boat)super.getBukkitEntity();
    }

    public static class EntityBoatNPC
    extends EntityBoat
    implements NPCHolder {
        private double aC;
        private float aD;
        private EntityBoat.EnumStatus aE;
        private EntityBoat.EnumStatus aF;
        private double ap;
        private double ar;
        private final CitizensNPC npc;

        public EntityBoatNPC(EntityTypes<? extends EntityBoat> entityTypes, World world) {
            this(entityTypes, world, null);
        }

        public EntityBoatNPC(EntityTypes<? extends EntityBoat> entityTypes, World world, NPC nPC) {
            super(entityTypes, world);
            this.npc = (CitizensNPC)nPC;
        }

        public void a(AxisAlignedBB axisAlignedBB) {
            super.a(NMSBoundingBox.makeBB(this.npc, axisAlignedBB));
        }

        public boolean a(Tag<FluidType> tag, double d) {
            if (this.npc == null) {
                return super.a(tag, d);
            }
            Vec3D vec3D = this.getMot().add(0.0, 0.0, 0.0);
            boolean bl = super.a(tag, d);
            if (!this.npc.isPushableByFluids()) {
                this.setMot(vec3D);
            }
            return bl;
        }

        public void collide(net.minecraft.server.v1_16_R3.Entity entity) {
            super.collide(entity);
            if (this.npc != null) {
                Util.callCollisionEvent(this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        public boolean d(NBTTagCompound nBTTagCompound) {
            return this.npc == null ? super.d(nBTTagCompound) : false;
        }

        public CraftEntity getBukkitEntity() {
            if (this.npc != null && !(super.getBukkitEntity() instanceof NPCHolder)) {
                NMSImpl.setBukkitEntity((net.minecraft.server.v1_16_R3.Entity)this, (CraftEntity)new BoatNPC(this));
            }
            return super.getBukkitEntity();
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        public EnumPistonReaction getPushReaction() {
            return Util.callPistonPushEvent(this.npc) ? EnumPistonReaction.IGNORE : super.getPushReaction();
        }

        private EntityBoat.EnumStatus getStatus() {
            EntityBoat.EnumStatus enumStatus = this.u();
            if (enumStatus != null) {
                this.aC = this.getBoundingBox().maxY;
                return enumStatus;
            }
            if (this.t()) {
                return EntityBoat.EnumStatus.IN_WATER;
            }
            float f = this.k();
            if (f > 0.0f) {
                this.aD = f;
                return EntityBoat.EnumStatus.ON_LAND;
            }
            return EntityBoat.EnumStatus.IN_AIR;
        }

        public void i(double d, double d2, double d3) {
            Vector vector = Util.callPushEvent(this.npc, d, d2, d3);
            if (vector != null) {
                super.i(vector.getX(), vector.getY(), vector.getZ());
            }
        }

        private boolean t() {
            boolean bl = false;
            AxisAlignedBB axisAlignedBB = this.getBoundingBox();
            int n = MathHelper.floor((double)axisAlignedBB.minX);
            int n2 = MathHelper.f((double)axisAlignedBB.maxX);
            int n3 = MathHelper.floor((double)axisAlignedBB.minY);
            int n4 = MathHelper.f((double)(axisAlignedBB.minY + 0.001));
            int n5 = MathHelper.floor((double)axisAlignedBB.minZ);
            int n6 = MathHelper.f((double)axisAlignedBB.maxZ);
            boolean bl2 = false;
            this.aC = Double.MIN_VALUE;
            BlockPosition.MutableBlockPosition mutableBlockPosition = new BlockPosition.MutableBlockPosition();
            for (int i = n; i < n2; ++i) {
                for (int j = n3; j < n4; ++j) {
                    for (int k = n5; k < n6; ++k) {
                        mutableBlockPosition.d(i, j, k);
                        Fluid fluid = this.world.getFluid((BlockPosition)mutableBlockPosition);
                        if (!fluid.a((Tag)TagsFluid.WATER)) continue;
                        float f = (float)j + fluid.getHeight((IBlockAccess)this.world, (BlockPosition)mutableBlockPosition);
                        this.aC = Math.max((double)f, this.aC);
                        bl = bl2 | axisAlignedBB.minY < (double)f;
                    }
                }
            }
            return bl;
        }

        public void tick() {
            if (this.npc != null) {
                this.npc.update();
                this.aF = this.aE;
                this.aE = this.getStatus();
                double d = this.isNoGravity() ? 0.0 : -0.04;
                double d2 = 0.0;
                this.ap = 0.05f;
                if (this.aF == EntityBoat.EnumStatus.IN_AIR && this.aE != EntityBoat.EnumStatus.IN_AIR && this.aE != EntityBoat.EnumStatus.ON_LAND) {
                    this.aC = this.e(1.0);
                    this.setPosition(this.locX(), (double)(this.i() - this.getHeight()) + 0.101, this.locZ());
                    this.setMot(this.getMot().d(1.0, 0.0, 1.0));
                    this.aE = EntityBoat.EnumStatus.IN_WATER;
                } else {
                    if (this.aE == EntityBoat.EnumStatus.IN_WATER) {
                        d2 = (this.aC - this.locY()) / (double)this.getHeight();
                        this.ap = 0.9f;
                    } else if (this.aE == EntityBoat.EnumStatus.UNDER_FLOWING_WATER) {
                        d = -7.0E-4;
                        this.ap = 0.9f;
                    } else if (this.aE == EntityBoat.EnumStatus.UNDER_WATER) {
                        d2 = 0.01;
                        this.ap = 0.45f;
                    } else if (this.aE == EntityBoat.EnumStatus.IN_AIR) {
                        this.ap = 0.9f;
                    } else if (this.aE == EntityBoat.EnumStatus.ON_LAND) {
                        this.ap = this.aD;
                        if (this.getRidingPassenger() instanceof EntityHuman) {
                            this.aD /= 2.0f;
                        }
                    }
                    Vec3D vec3D = this.getMot();
                    this.setMot(vec3D.x * this.ap, vec3D.y + d, vec3D.z * this.ap);
                    this.ar *= this.ap;
                    if (d2 > 0.0) {
                        Vec3D vec3D2 = this.getMot();
                        this.setMot(vec3D2.x, vec3D2.y + d2 * 0.0615, vec3D2.z);
                    }
                }
                this.move(EnumMoveType.SELF, this.getMot());
                if (this.isVehicle()) {
                    this.yaw = (float)((double)this.yaw + this.ar);
                }
            } else {
                super.tick();
            }
        }

        private EntityBoat.EnumStatus u() {
            AxisAlignedBB axisAlignedBB = this.getBoundingBox();
            double d = axisAlignedBB.maxY + 0.001;
            int n = MathHelper.floor((double)axisAlignedBB.minX);
            int n2 = MathHelper.f((double)axisAlignedBB.maxX);
            int n3 = MathHelper.floor((double)axisAlignedBB.maxY);
            int n4 = MathHelper.f((double)d);
            int n5 = MathHelper.floor((double)axisAlignedBB.minZ);
            int n6 = MathHelper.f((double)axisAlignedBB.maxZ);
            boolean bl = false;
            BlockPosition.MutableBlockPosition mutableBlockPosition = new BlockPosition.MutableBlockPosition();
            for (int i = n; i < n2; ++i) {
                for (int j = n3; j < n4; ++j) {
                    for (int k = n5; k < n6; ++k) {
                        mutableBlockPosition.d(i, j, k);
                        Fluid fluid = this.world.getFluid((BlockPosition)mutableBlockPosition);
                        if (!fluid.a((Tag)TagsFluid.WATER) || !(d < (double)((float)mutableBlockPosition.getY() + fluid.getHeight((IBlockAccess)this.world, (BlockPosition)mutableBlockPosition)))) continue;
                        if (!fluid.isSource()) {
                            return EntityBoat.EnumStatus.UNDER_FLOWING_WATER;
                        }
                        bl = true;
                    }
                }
            }
            return bl ? EntityBoat.EnumStatus.UNDER_WATER : null;
        }

        public void updateSize() {
            if (this.npc == null) {
                super.updateSize();
            } else {
                NMSImpl.setSize((net.minecraft.server.v1_16_R3.Entity)this, this.justCreated);
            }
        }
    }

    public static class BoatNPC
    extends CraftBoat
    implements ForwardingNPCHolder {
        public BoatNPC(EntityBoatNPC entityBoatNPC) {
            super((CraftServer)Bukkit.getServer(), (EntityBoat)entityBoatNPC);
        }
    }
}

