/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_16_R3.util;

import com.google.common.collect.Maps;
import java.util.EnumMap;
import net.citizensnpcs.nms.v1_16_R3.util.NMSImpl;
import net.citizensnpcs.util.PlayerAnimation;
import net.minecraft.server.v1_16_R3.Entity;
import net.minecraft.server.v1_16_R3.EntityPlayer;
import net.minecraft.server.v1_16_R3.EntityPose;
import net.minecraft.server.v1_16_R3.EnumHand;
import net.minecraft.server.v1_16_R3.Packet;
import net.minecraft.server.v1_16_R3.PacketPlayOutAnimation;
import net.minecraft.server.v1_16_R3.PacketPlayOutEntityMetadata;
import org.bukkit.entity.Player;

public class PlayerAnimationImpl {
    private static EnumMap<PlayerAnimation, Integer> DEFAULTS = Maps.newEnumMap(PlayerAnimation.class);

    public static void play(PlayerAnimation playerAnimation, Player player, Iterable<Player> iterable) {
        EntityPlayer entityPlayer = (EntityPlayer)NMSImpl.getHandle((org.bukkit.entity.Entity)player);
        if (DEFAULTS.containsKey((Object)playerAnimation)) {
            PlayerAnimationImpl.playDefaultAnimation(entityPlayer, iterable, DEFAULTS.get((Object)playerAnimation));
            return;
        }
        switch (playerAnimation) {
            case SNEAK: {
                entityPlayer.setPose(EntityPose.CROUCHING);
                PlayerAnimationImpl.sendPacketNearby(new PacketPlayOutEntityMetadata(entityPlayer.getId(), entityPlayer.getDataWatcher(), true), iterable);
                break;
            }
            case START_ELYTRA: {
                entityPlayer.startGliding();
                break;
            }
            case STOP_ELYTRA: {
                entityPlayer.stopGliding();
                break;
            }
            case START_USE_MAINHAND_ITEM: {
                entityPlayer.c(EnumHand.MAIN_HAND);
                PlayerAnimationImpl.sendPacketNearby(new PacketPlayOutEntityMetadata(entityPlayer.getId(), entityPlayer.getDataWatcher(), true), iterable);
                break;
            }
            case START_USE_OFFHAND_ITEM: {
                entityPlayer.c(EnumHand.OFF_HAND);
                PlayerAnimationImpl.sendPacketNearby(new PacketPlayOutEntityMetadata(entityPlayer.getId(), entityPlayer.getDataWatcher(), true), iterable);
                break;
            }
            case STOP_SNEAKING: {
                entityPlayer.setPose(EntityPose.STANDING);
                PlayerAnimationImpl.sendPacketNearby(new PacketPlayOutEntityMetadata(entityPlayer.getId(), entityPlayer.getDataWatcher(), true), iterable);
                break;
            }
            case STOP_USE_ITEM: {
                entityPlayer.clearActiveItem();
                PlayerAnimationImpl.sendPacketNearby(new PacketPlayOutEntityMetadata(entityPlayer.getId(), entityPlayer.getDataWatcher(), true), iterable);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    protected static void playDefaultAnimation(EntityPlayer entityPlayer, Iterable<Player> iterable, int n) {
        PacketPlayOutAnimation packetPlayOutAnimation = new PacketPlayOutAnimation((Entity)entityPlayer, n);
        PlayerAnimationImpl.sendPacketNearby(packetPlayOutAnimation, iterable);
    }

    protected static void sendPacketNearby(Packet<?> packet, Iterable<Player> iterable) {
        for (Player player : iterable) {
            NMSImpl.sendPacket(player, packet);
        }
    }

    static {
        DEFAULTS.put(PlayerAnimation.ARM_SWING, 0);
        DEFAULTS.put(PlayerAnimation.HURT, 1);
        DEFAULTS.put(PlayerAnimation.EAT_FOOD, 2);
        DEFAULTS.put(PlayerAnimation.ARM_SWING_OFFHAND, 3);
        DEFAULTS.put(PlayerAnimation.CRIT, 4);
        DEFAULTS.put(PlayerAnimation.MAGIC_CRIT, 5);
    }
}

