/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_19_R3.entity;

import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_19_R3.entity.MobEntityController;
import net.citizensnpcs.nms.v1_19_R3.util.ForwardingNPCHolder;
import net.citizensnpcs.nms.v1_19_R3.util.NMSBoundingBox;
import net.citizensnpcs.nms.v1_19_R3.util.NMSImpl;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Position;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.monster.EntityEndermite;
import net.minecraft.world.entity.vehicle.EntityBoat;
import net.minecraft.world.entity.vehicle.EntityMinecartAbstract;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_19_R3.CraftServer;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftEndermite;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftEntity;
import org.bukkit.entity.Endermite;
import org.bukkit.entity.Entity;
import org.bukkit.util.Vector;

public class EndermiteController
extends MobEntityController {
    public EndermiteController() {
        super(EntityEndermiteNPC.class);
    }

    public Endermite getBukkitEntity() {
        return (Endermite)super.getBukkitEntity();
    }

    public static class EntityEndermiteNPC
    extends EntityEndermite
    implements NPCHolder {
        private final CitizensNPC npc;

        public EntityEndermiteNPC(EntityTypes<? extends EntityEndermite> entityTypes, World world) {
            this(entityTypes, world, null);
        }

        public EntityEndermiteNPC(EntityTypes<? extends EntityEndermite> entityTypes, World world, NPC nPC) {
            super(entityTypes, world);
            this.npc = (CitizensNPC)nPC;
        }

        protected boolean l(net.minecraft.world.entity.Entity entity) {
            if (this.npc != null && (entity instanceof EntityBoat || entity instanceof EntityMinecartAbstract)) {
                return !this.npc.isProtected();
            }
            return super.l(entity);
        }

        public boolean a(float f, float f2, DamageSource damageSource) {
            if (this.npc == null || !this.npc.isFlyable()) {
                return super.a(f, f2, damageSource);
            }
            return false;
        }

        public void ds() {
            if (this.npc == null) {
                super.ds();
            }
        }

        protected void a(double d, boolean bl, IBlockData iBlockData, BlockPosition blockPosition) {
            if (this.npc == null || !this.npc.isFlyable()) {
                super.a(d, bl, iBlockData, blockPosition);
            }
        }

        public void U() {
            super.U();
            if (this.npc != null) {
                NMSImpl.updateMinecraftAIState(this.npc, (EntityInsentient)this);
                this.npc.update();
            }
        }

        protected SoundEffect s() {
            return NMSImpl.getSoundEffect(this.npc, super.s(), NPC.Metadata.AMBIENT_SOUND);
        }

        public CraftEntity getBukkitEntity() {
            if (this.npc != null && !(super.getBukkitEntity() instanceof NPCHolder)) {
                NMSImpl.setBukkitEntity((net.minecraft.world.entity.Entity)this, (CraftEntity)new EndermiteNPC(this));
            }
            return super.getBukkitEntity();
        }

        protected SoundEffect x_() {
            return NMSImpl.getSoundEffect(this.npc, super.x_(), NPC.Metadata.DEATH_SOUND);
        }

        protected SoundEffect d(DamageSource damageSource) {
            return NMSImpl.getSoundEffect(this.npc, super.d(damageSource), NPC.Metadata.HURT_SOUND);
        }

        public float eQ() {
            return NMS.getJumpPower(this.npc, super.eQ());
        }

        public int cp() {
            return NMS.getFallDistance(this.npc, super.cp());
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        public EnumPistonReaction C_() {
            return Util.callPistonPushEvent(this.npc) ? EnumPistonReaction.d : super.C_();
        }

        public boolean fI() {
            return NMSImpl.isLeashed(this.npc, () -> super.fI(), (EntityInsentient)this);
        }

        public boolean bn() {
            return this.npc == null ? super.bn() : this.npc.data().get(NPC.Metadata.COLLIDABLE, Boolean.valueOf(!this.npc.isProtected())).booleanValue();
        }

        public void q(double d, double d2, double d3) {
            NMS.callKnockbackEvent(this.npc, (float)d, d2, d3, nPCKnockbackEvent -> super.q((double)((float)nPCKnockbackEvent.getStrength()), nPCKnockbackEvent.getKnockbackVector().getX(), nPCKnockbackEvent.getKnockbackVector().getZ()));
        }

        protected AxisAlignedBB am() {
            return NMSBoundingBox.makeBB(this.npc, super.am());
        }

        public boolean z_() {
            if (this.npc == null || !this.npc.isFlyable()) {
                return super.z_();
            }
            return false;
        }

        public void j(double d, double d2, double d3) {
            Vector vector = Util.callPushEvent(this.npc, d, d2, d3);
            if (vector != null) {
                super.j(vector.getX(), vector.getY(), vector.getZ());
            }
        }

        public void g(net.minecraft.world.entity.Entity entity) {
            super.g(entity);
            if (this.npc != null) {
                Util.callCollisionEvent(this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        public void c_() {
            if (this.npc == null) {
                super.c_();
            } else {
                NMSImpl.setSize((net.minecraft.world.entity.Entity)this, this.al);
            }
        }

        public boolean e(NBTTagCompound nBTTagCompound) {
            return this.npc == null ? super.e(nBTTagCompound) : false;
        }

        public net.minecraft.world.entity.Entity teleportTo(WorldServer worldServer, Position position) {
            if (this.npc == null) {
                return super.teleportTo(worldServer, position);
            }
            return NMSImpl.teleportAcrossWorld((net.minecraft.world.entity.Entity)this, worldServer, position);
        }

        public void h(Vec3D vec3D) {
            if (this.npc == null || !this.npc.isFlyable()) {
                super.h(vec3D);
            } else {
                NMSImpl.flyingMoveLogic((EntityLiving)this, vec3D);
            }
        }

        public boolean a(TagKey<FluidType> tagKey, double d) {
            if (this.npc == null) {
                return super.a(tagKey, d);
            }
            Vec3D vec3D = this.dj().b(0.0, 0.0, 0.0);
            boolean bl = super.a(tagKey, d);
            if (!this.npc.isPushableByFluids()) {
                this.f(vec3D);
            }
            return bl;
        }
    }

    public static class EndermiteNPC
    extends CraftEndermite
    implements ForwardingNPCHolder {
        public EndermiteNPC(EntityEndermiteNPC entityEndermiteNPC) {
            super((CraftServer)Bukkit.getServer(), (EntityEndermite)entityEndermiteNPC);
        }
    }
}

