/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_19_R3.util;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.EnumSet;
import net.citizensnpcs.nms.v1_19_R3.util.EntityNodeEvaluatorBase;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.level.ChunkCache;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockCampfire;
import net.minecraft.world.level.block.BlockDoor;
import net.minecraft.world.level.block.BlockFenceGate;
import net.minecraft.world.level.block.BlockLeaves;
import net.minecraft.world.level.block.BlockMinecartTrackAbstract;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.pathfinder.PathDestination;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.level.pathfinder.PathPoint;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;

public class EntityNodeEvaluator
extends EntityNodeEvaluatorBase {
    private final Object2BooleanMap collisionCache = new Object2BooleanOpenHashMap();
    protected float oldWaterCost;
    private final Long2ObjectMap pathTypesByPosCache = new Long2ObjectOpenHashMap();
    private static final double DEFAULT_MOB_JUMP_HEIGHT = 1.125;
    public static final double SPACE_BETWEEN_WALL_POSTS = 0.5;

    private boolean canReachWithoutCollision(PathPoint pathPoint) {
        AxisAlignedBB axisAlignedBB = this.mob.cD();
        Vec3D vec3D = new Vec3D((double)pathPoint.a - this.mob.dl() + axisAlignedBB.b() / 2.0, (double)pathPoint.b - this.mob.dn() + axisAlignedBB.c() / 2.0, (double)pathPoint.c - this.mob.dr() + axisAlignedBB.d() / 2.0);
        int n = MathHelper.c((double)(vec3D.f() / axisAlignedBB.a()));
        vec3D = vec3D.a((double)(1.0f / (float)n));
        for (int i = 1; i <= n; ++i) {
            if (!this.hasCollisions(axisAlignedBB = axisAlignedBB.c(vec3D))) continue;
            return false;
        }
        return true;
    }

    protected boolean canStartAt(BlockPosition blockPosition) {
        PathType pathType = this.getBlockPathType(this.mob, blockPosition);
        return pathType != PathType.b && this.mvmt.getPathfindingMalus(pathType) >= 0.0f;
    }

    @Override
    public void b() {
        this.mvmt.setPathfindingMalus(PathType.j, this.oldWaterCost);
        this.pathTypesByPosCache.clear();
        this.collisionCache.clear();
        super.b();
    }

    protected PathType evaluateBlockPathType(IBlockAccess iBlockAccess, BlockPosition blockPosition, PathType pathType) {
        boolean bl = this.d();
        if (pathType == PathType.s && this.e() && bl) {
            pathType = PathType.d;
        }
        if (pathType == PathType.r && !bl) {
            pathType = PathType.a;
        }
        if (pathType == PathType.l && !(iBlockAccess.a_(blockPosition).b() instanceof BlockMinecartTrackAbstract) && !(iBlockAccess.a_(blockPosition.d()).b() instanceof BlockMinecartTrackAbstract)) {
            pathType = PathType.m;
        }
        return pathType;
    }

    protected PathPoint findAcceptedNode(int n, int n2, int n3, int n4, double d, EnumDirection enumDirection, PathType pathType) {
        PathPoint pathPoint = null;
        BlockPosition.MutableBlockPosition mutableBlockPosition = new BlockPosition.MutableBlockPosition();
        double d2 = this.getFloorLevel((BlockPosition)mutableBlockPosition.d(n, n2, n3));
        if (d2 - d > this.getMobJumpHeight()) {
            return null;
        }
        PathType pathType2 = this.getCachedBlockType(this.mob, n, n2, n3);
        float f = this.mvmt.getPathfindingMalus(pathType2);
        double d3 = (double)this.mob.dc() / 2.0;
        if (f >= 0.0f) {
            pathPoint = this.getNodeAndUpdateCostToMax(n, n2, n3, pathType2, f);
        }
        if (EntityNodeEvaluator.doesBlockHavePartialCollision(pathType) && pathPoint != null && pathPoint.k >= 0.0f && !this.canReachWithoutCollision(pathPoint)) {
            pathPoint = null;
        }
        if (pathType2 == PathType.c || this.isAmphibious() && pathType2 == PathType.j) {
            double d4;
            double d5;
            AxisAlignedBB axisAlignedBB;
            if ((pathPoint == null || pathPoint.k < 0.0f) && n4 > 0 && (pathType2 != PathType.h || this.g()) && pathType2 != PathType.m && pathType2 != PathType.e && pathType2 != PathType.f && (pathPoint = this.findAcceptedNode(n, n2 + 1, n3, n4 - 1, d, enumDirection, pathType)) != null && (pathPoint.l == PathType.b || pathPoint.l == PathType.c) && this.mob.dc() < 1.0f && this.hasCollisions(axisAlignedBB = new AxisAlignedBB((d5 = (double)(n - enumDirection.j()) + 0.5) - d3, this.getFloorLevel((BlockPosition)mutableBlockPosition.b(d5, (double)(n2 + 1), d4 = (double)(n3 - enumDirection.l()) + 0.5)) + 0.001, d4 - d3, d5 + d3, (double)this.mob.dd() + this.getFloorLevel((BlockPosition)mutableBlockPosition.b((double)pathPoint.a, (double)pathPoint.b, (double)pathPoint.c)) - 0.002, d4 + d3))) {
                pathPoint = null;
            }
            if (!this.isAmphibious() && pathType2 == PathType.j && !this.f()) {
                if (this.getCachedBlockType(this.mob, n, n2 - 1, n3) != PathType.j) {
                    return pathPoint;
                }
                while (n2 > this.mob.H.v_()) {
                    if ((pathType2 = this.getCachedBlockType(this.mob, n, --n2, n3)) != PathType.j) {
                        return pathPoint;
                    }
                    pathPoint = this.getNodeAndUpdateCostToMax(n, n2, n3, pathType2, this.mvmt.getPathfindingMalus(pathType2));
                }
            }
            if (pathType2 == PathType.b) {
                int n5 = 0;
                int n6 = n2;
                while (pathType2 == PathType.b) {
                    if (--n2 < this.mob.H.v_()) {
                        return this.getBlockedNode(n, n6, n3);
                    }
                    if (n5++ >= this.mob.cp()) {
                        return this.getBlockedNode(n, n2, n3);
                    }
                    pathType2 = this.getCachedBlockType(this.mob, n, n2, n3);
                    f = this.mvmt.getPathfindingMalus(pathType2);
                    if (pathType2 != PathType.b && f >= 0.0f) {
                        pathPoint = this.getNodeAndUpdateCostToMax(n, n2, n3, pathType2, f);
                        break;
                    }
                    if (!(f < 0.0f)) continue;
                    return this.getBlockedNode(n, n2, n3);
                }
            }
            if (EntityNodeEvaluator.doesBlockHavePartialCollision(pathType2) && pathPoint == null) {
                pathPoint = this.b(n, n2, n3);
                pathPoint.i = true;
                pathPoint.l = pathType2;
                pathPoint.k = pathType2.a();
            }
        }
        return pathPoint;
    }

    private PathPoint getBlockedNode(int n, int n2, int n3) {
        PathPoint pathPoint = this.b(n, n2, n3);
        pathPoint.l = PathType.a;
        pathPoint.k = -1.0f;
        return pathPoint;
    }

    public PathType a(IBlockAccess iBlockAccess, int n, int n2, int n3) {
        return EntityNodeEvaluator.getBlockPathTypeStatic(iBlockAccess, new BlockPosition.MutableBlockPosition(n, n2, n3));
    }

    public PathType getBlockPathType(IBlockAccess iBlockAccess, int n, int n2, int n3, EntityLiving entityLiving) {
        EnumSet<PathType> enumSet = EnumSet.noneOf(PathType.class);
        PathType pathType = PathType.a;
        pathType = this.getBlockPathTypes(iBlockAccess, n, n2, n3, enumSet, pathType, entityLiving.dg());
        if (enumSet.contains(PathType.h)) {
            return PathType.h;
        }
        if (enumSet.contains(PathType.m)) {
            return PathType.m;
        }
        PathType pathType2 = PathType.a;
        for (PathType pathType3 : enumSet) {
            if (this.mvmt.getPathfindingMalus(pathType3) < 0.0f) {
                return pathType3;
            }
            if (!(this.mvmt.getPathfindingMalus(pathType3) >= this.mvmt.getPathfindingMalus(pathType2))) continue;
            pathType2 = pathType3;
        }
        if (pathType == PathType.b && this.mvmt.getPathfindingMalus(pathType2) == 0.0f && this.d <= 1) {
            return PathType.b;
        }
        return pathType2;
    }

    public PathType a(IBlockAccess iBlockAccess, int n, int n2, int n3, EntityInsentient entityInsentient) {
        EnumSet<PathType> enumSet = EnumSet.noneOf(PathType.class);
        PathType pathType = PathType.a;
        pathType = this.getBlockPathTypes(iBlockAccess, n, n2, n3, enumSet, pathType, entityInsentient.dg());
        if (enumSet.contains(PathType.h)) {
            return PathType.h;
        }
        if (enumSet.contains(PathType.m)) {
            return PathType.m;
        }
        PathType pathType2 = PathType.a;
        for (PathType pathType3 : enumSet) {
            if (entityInsentient.a(pathType3) < 0.0f) {
                return pathType3;
            }
            if (!(entityInsentient.a(pathType3) >= entityInsentient.a(pathType2))) continue;
            pathType2 = pathType3;
        }
        if (pathType == PathType.b && entityInsentient.a(pathType2) == 0.0f && this.d <= 1) {
            return PathType.b;
        }
        return pathType2;
    }

    protected PathType getBlockPathType(EntityLiving entityLiving, BlockPosition blockPosition) {
        return this.getCachedBlockType(entityLiving, blockPosition.u(), blockPosition.v(), blockPosition.w());
    }

    public PathType getBlockPathTypes(IBlockAccess iBlockAccess, int n, int n2, int n3, EnumSet enumSet, PathType pathType, BlockPosition blockPosition) {
        for (int i = 0; i < this.d; ++i) {
            for (int j = 0; j < this.e; ++j) {
                for (int k = 0; k < this.f; ++k) {
                    int n4 = i + n;
                    int n5 = j + n2;
                    int n6 = k + n3;
                    PathType pathType2 = this.a(iBlockAccess, n4, n5, n6);
                    pathType2 = this.evaluateBlockPathType(iBlockAccess, blockPosition, pathType2);
                    if (i == 0 && j == 0 && k == 0) {
                        pathType = pathType2;
                    }
                    enumSet.add(pathType2);
                }
            }
        }
        return pathType;
    }

    protected PathType getCachedBlockType(EntityLiving entityLiving, int n, int n2, int n3) {
        return (PathType)this.pathTypesByPosCache.computeIfAbsent(BlockPosition.a((int)n, (int)n2, (int)n3), l -> this.getBlockPathType((IBlockAccess)this.a, n, n2, n3, entityLiving));
    }

    protected double getFloorLevel(BlockPosition blockPosition) {
        return (this.f() || this.isAmphibious()) && this.a.b_(blockPosition).a(TagsFluid.a) ? (double)blockPosition.v() + 0.5 : EntityNodeEvaluator.getFloorLevel((IBlockAccess)this.a, blockPosition);
    }

    public PathDestination a(double d, double d2, double d3) {
        return this.a(this.b(MathHelper.a((double)d), MathHelper.a((double)d2), MathHelper.a((double)d3)));
    }

    private double getMobJumpHeight() {
        return Math.max(1.125, (double)this.mob.dA());
    }

    public int a(PathPoint[] pathPointArray, PathPoint pathPoint) {
        PathPoint pathPoint2;
        PathPoint pathPoint3;
        PathPoint pathPoint4;
        PathPoint pathPoint5;
        PathPoint pathPoint6;
        PathPoint pathPoint7;
        PathPoint pathPoint8;
        double d;
        PathPoint pathPoint9;
        int n = 0;
        int n2 = 0;
        PathType pathType = this.getCachedBlockType(this.mob, pathPoint.a, pathPoint.b + 1, pathPoint.c);
        PathType pathType2 = this.getCachedBlockType(this.mob, pathPoint.a, pathPoint.b, pathPoint.c);
        if (this.mvmt.getPathfindingMalus(pathType) >= 0.0f && pathType2 != PathType.w) {
            n2 = MathHelper.d((float)Math.max(1.0f, this.mob.dA()));
        }
        if (this.isNeighborValid(pathPoint9 = this.findAcceptedNode(pathPoint.a, pathPoint.b, pathPoint.c + 1, n2, d = this.getFloorLevel(new BlockPosition(pathPoint.a, pathPoint.b, pathPoint.c)), EnumDirection.d, pathType2), pathPoint)) {
            pathPointArray[n++] = pathPoint9;
        }
        if (this.isNeighborValid(pathPoint8 = this.findAcceptedNode(pathPoint.a - 1, pathPoint.b, pathPoint.c, n2, d, EnumDirection.e, pathType2), pathPoint)) {
            pathPointArray[n++] = pathPoint8;
        }
        if (this.isNeighborValid(pathPoint7 = this.findAcceptedNode(pathPoint.a + 1, pathPoint.b, pathPoint.c, n2, d, EnumDirection.f, pathType2), pathPoint)) {
            pathPointArray[n++] = pathPoint7;
        }
        if (this.isNeighborValid(pathPoint6 = this.findAcceptedNode(pathPoint.a, pathPoint.b, pathPoint.c - 1, n2, d, EnumDirection.c, pathType2), pathPoint)) {
            pathPointArray[n++] = pathPoint6;
        }
        if (this.isDiagonalValid(pathPoint, pathPoint8, pathPoint6, pathPoint5 = this.findAcceptedNode(pathPoint.a - 1, pathPoint.b, pathPoint.c - 1, n2, d, EnumDirection.c, pathType2))) {
            pathPointArray[n++] = pathPoint5;
        }
        if (this.isDiagonalValid(pathPoint, pathPoint7, pathPoint6, pathPoint4 = this.findAcceptedNode(pathPoint.a + 1, pathPoint.b, pathPoint.c - 1, n2, d, EnumDirection.c, pathType2))) {
            pathPointArray[n++] = pathPoint4;
        }
        if (this.isDiagonalValid(pathPoint, pathPoint8, pathPoint9, pathPoint3 = this.findAcceptedNode(pathPoint.a - 1, pathPoint.b, pathPoint.c + 1, n2, d, EnumDirection.d, pathType2))) {
            pathPointArray[n++] = pathPoint3;
        }
        if (this.isDiagonalValid(pathPoint, pathPoint7, pathPoint9, pathPoint2 = this.findAcceptedNode(pathPoint.a + 1, pathPoint.b, pathPoint.c + 1, n2, d, EnumDirection.d, pathType2))) {
            pathPointArray[n++] = pathPoint2;
        }
        return n;
    }

    private PathPoint getNodeAndUpdateCostToMax(int n, int n2, int n3, PathType pathType, float f) {
        PathPoint pathPoint = this.b(n, n2, n3);
        pathPoint.l = pathType;
        pathPoint.k = Math.max(pathPoint.k, f);
        return pathPoint;
    }

    public PathPoint a() {
        BlockPosition blockPosition;
        int n;
        BlockPosition.MutableBlockPosition mutableBlockPosition;
        block12: {
            mutableBlockPosition = new BlockPosition.MutableBlockPosition();
            n = this.mob.dm();
            IBlockData iBlockData = this.a.a_((BlockPosition)mutableBlockPosition.b(this.mob.dl(), (double)n, this.mob.dr()));
            if (!this.mob.a(iBlockData.r())) {
                if (this.f() && this.mob.aT()) {
                    while (true) {
                        if (!iBlockData.a(Blocks.G) && iBlockData.r() != FluidTypes.c.a(false)) {
                            --n;
                            break block12;
                        }
                        iBlockData = this.a.a_((BlockPosition)mutableBlockPosition.b(this.mob.dl(), (double)(++n), this.mob.dr()));
                    }
                }
                if (this.mob.ax()) {
                    n = MathHelper.a((double)(this.mob.dn() + 0.5));
                } else {
                    blockPosition = this.mob.dg();
                    while ((this.a.a_(blockPosition).h() || this.a.a_(blockPosition).a((IBlockAccess)this.a, blockPosition, PathMode.a)) && blockPosition.v() > this.mob.H.v_()) {
                        blockPosition = blockPosition.d();
                    }
                    n = blockPosition.c().v();
                }
            } else {
                while (true) {
                    if (!this.mob.a(iBlockData.r())) {
                        --n;
                        break;
                    }
                    iBlockData = this.a.a_((BlockPosition)mutableBlockPosition.b(this.mob.dl(), (double)(++n), this.mob.dr()));
                }
            }
        }
        blockPosition = this.mob.dg();
        if (!this.canStartAt((BlockPosition)mutableBlockPosition.d(blockPosition.u(), n, blockPosition.w()))) {
            AxisAlignedBB axisAlignedBB = this.mob.cD();
            if (this.canStartAt((BlockPosition)mutableBlockPosition.b(axisAlignedBB.a, (double)n, axisAlignedBB.c)) || this.canStartAt((BlockPosition)mutableBlockPosition.b(axisAlignedBB.a, (double)n, axisAlignedBB.f)) || this.canStartAt((BlockPosition)mutableBlockPosition.b(axisAlignedBB.d, (double)n, axisAlignedBB.c)) || this.canStartAt((BlockPosition)mutableBlockPosition.b(axisAlignedBB.d, (double)n, axisAlignedBB.f))) {
                return this.getStartNode((BlockPosition)mutableBlockPosition);
            }
        }
        return this.getStartNode(new BlockPosition(blockPosition.u(), n, blockPosition.w()));
    }

    protected PathPoint getStartNode(BlockPosition blockPosition) {
        PathPoint pathPoint = this.b(blockPosition);
        pathPoint.l = this.getBlockPathType(this.mob, pathPoint.a());
        pathPoint.k = this.mvmt.getPathfindingMalus(pathPoint.l);
        return pathPoint;
    }

    private boolean hasCollisions(AxisAlignedBB axisAlignedBB) {
        return this.collisionCache.computeIfAbsent((Object)axisAlignedBB, object -> !this.a.a((Entity)this.mob, axisAlignedBB));
    }

    protected boolean isAmphibious() {
        return false;
    }

    protected boolean isDiagonalValid(PathPoint pathPoint, PathPoint pathPoint2, PathPoint pathPoint3, PathPoint pathPoint4) {
        if (pathPoint4 == null || pathPoint3 == null || pathPoint2 == null || pathPoint4.i) {
            return false;
        }
        if (pathPoint3.b <= pathPoint.b && pathPoint2.b <= pathPoint.b) {
            if (pathPoint2.l != PathType.d && pathPoint3.l != PathType.d && pathPoint4.l != PathType.d) {
                boolean bl = pathPoint3.l == PathType.h && pathPoint2.l == PathType.h && (double)this.mob.dc() < 0.5;
                return pathPoint4.k >= 0.0f && (pathPoint3.b < pathPoint.b || pathPoint3.k >= 0.0f || bl) && (pathPoint2.b < pathPoint.b || pathPoint2.k >= 0.0f || bl);
            }
            return false;
        }
        return false;
    }

    protected boolean isNeighborValid(PathPoint pathPoint, PathPoint pathPoint2) {
        return pathPoint != null && !pathPoint.i && (pathPoint.k >= 0.0f || pathPoint2.k < 0.0f);
    }

    @Override
    public void prepare(ChunkCache chunkCache, EntityLiving entityLiving) {
        super.prepare(chunkCache, entityLiving);
        this.oldWaterCost = this.mvmt.getPathfindingMalus(PathType.j);
    }

    @Override
    public void a(ChunkCache chunkCache, EntityInsentient entityInsentient) {
        super.a(chunkCache, entityInsentient);
        this.oldWaterCost = entityInsentient.a(PathType.j);
    }

    public static PathType checkNeighbourBlocks(IBlockAccess iBlockAccess, BlockPosition.MutableBlockPosition mutableBlockPosition, PathType pathType) {
        int n = mutableBlockPosition.u();
        int n2 = mutableBlockPosition.v();
        int n3 = mutableBlockPosition.w();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                for (int k = -1; k <= 1; ++k) {
                    if (i == 0 && k == 0) continue;
                    mutableBlockPosition.d(n + i, n2 + j, n3 + k);
                    IBlockData iBlockData = iBlockAccess.a_((BlockPosition)mutableBlockPosition);
                    if (iBlockData.a(Blocks.dP) || iBlockData.a(Blocks.oe)) {
                        return PathType.p;
                    }
                    if (EntityNodeEvaluator.isBurningBlock(iBlockData)) {
                        return PathType.n;
                    }
                    if (!iBlockAccess.b_((BlockPosition)mutableBlockPosition).a(TagsFluid.a)) continue;
                    return PathType.k;
                }
            }
        }
        return pathType;
    }

    private static boolean doesBlockHavePartialCollision(PathType pathType) {
        return pathType == PathType.h || pathType == PathType.s || pathType == PathType.t;
    }

    protected static PathType getBlockPathTypeRaw(IBlockAccess iBlockAccess, BlockPosition blockPosition) {
        IBlockData iBlockData = iBlockAccess.a_(blockPosition);
        Block block = iBlockData.b();
        Material material = iBlockData.d();
        if (iBlockData.h()) {
            return PathType.b;
        }
        if (!(iBlockData.a(TagsBlock.O) || iBlockData.a(Blocks.fl) || iBlockData.a(Blocks.rx))) {
            if (iBlockData.a(Blocks.qy)) {
                return PathType.f;
            }
            if (!iBlockData.a(Blocks.dP) && !iBlockData.a(Blocks.oe)) {
                if (iBlockData.a(Blocks.pc)) {
                    return PathType.w;
                }
                if (iBlockData.a(Blocks.fB)) {
                    return PathType.x;
                }
                Fluid fluid = iBlockAccess.b_(blockPosition);
                if (fluid.a(TagsFluid.b)) {
                    return PathType.i;
                }
                if (EntityNodeEvaluator.isBurningBlock(iBlockData)) {
                    return PathType.o;
                }
                if (BlockDoor.n((IBlockData)iBlockData) && !((Boolean)iBlockData.c((IBlockState)BlockDoor.b)).booleanValue()) {
                    return PathType.s;
                }
                if (block instanceof BlockDoor && material == Material.K && !((Boolean)iBlockData.c((IBlockState)BlockDoor.b)).booleanValue()) {
                    return PathType.t;
                }
                if (block instanceof BlockDoor && ((Boolean)iBlockData.c((IBlockState)BlockDoor.b)).booleanValue()) {
                    return PathType.r;
                }
                if (block instanceof BlockMinecartTrackAbstract) {
                    return PathType.l;
                }
                if (block instanceof BlockLeaves) {
                    return PathType.v;
                }
                if (iBlockData.a(TagsBlock.R) || iBlockData.a(TagsBlock.K) || block instanceof BlockFenceGate && !((Boolean)iBlockData.c((IBlockState)BlockFenceGate.a)).booleanValue()) {
                    return PathType.h;
                }
                if (!iBlockData.a(iBlockAccess, blockPosition, PathMode.a)) {
                    return PathType.a;
                }
                return fluid.a(TagsFluid.a) ? PathType.j : PathType.b;
            }
            return PathType.q;
        }
        return PathType.e;
    }

    public static PathType getBlockPathTypeStatic(IBlockAccess iBlockAccess, BlockPosition.MutableBlockPosition mutableBlockPosition) {
        int n = mutableBlockPosition.u();
        int n2 = mutableBlockPosition.v();
        int n3 = mutableBlockPosition.w();
        PathType pathType = EntityNodeEvaluator.getBlockPathTypeRaw(iBlockAccess, (BlockPosition)mutableBlockPosition);
        if (pathType == PathType.b && n2 >= iBlockAccess.v_() + 1) {
            PathType pathType2 = EntityNodeEvaluator.getBlockPathTypeRaw(iBlockAccess, (BlockPosition)mutableBlockPosition.d(n, n2 - 1, n3));
            PathType pathType3 = pathType = pathType2 != PathType.c && pathType2 != PathType.b && pathType2 != PathType.j && pathType2 != PathType.i ? PathType.c : PathType.b;
            if (pathType2 == PathType.o) {
                pathType = PathType.o;
            }
            if (pathType2 == PathType.q) {
                pathType = PathType.q;
            }
            if (pathType2 == PathType.w) {
                pathType = PathType.w;
            }
            if (pathType2 == PathType.f) {
                pathType = PathType.g;
            }
        }
        if (pathType == PathType.c) {
            pathType = EntityNodeEvaluator.checkNeighbourBlocks(iBlockAccess, mutableBlockPosition.d(n, n2, n3), pathType);
        }
        return pathType;
    }

    public static double getFloorLevel(IBlockAccess iBlockAccess, BlockPosition blockPosition) {
        BlockPosition blockPosition2 = blockPosition.d();
        VoxelShape voxelShape = iBlockAccess.a_(blockPosition2).k(iBlockAccess, blockPosition2);
        return (double)blockPosition2.v() + (voxelShape.b() ? 0.0 : voxelShape.c(EnumDirection.EnumAxis.b));
    }

    public static boolean isBurningBlock(IBlockData iBlockData) {
        return iBlockData.a(TagsBlock.aH) || iBlockData.a(Blocks.H) || iBlockData.a(Blocks.kG) || BlockCampfire.g((IBlockData)iBlockData) || iBlockData.a(Blocks.fu);
    }
}

