/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_20_R4.entity.nonliving;

import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_20_R4.entity.MobEntityController;
import net.citizensnpcs.nms.v1_20_R4.util.ForwardingNPCHolder;
import net.citizensnpcs.nms.v1_20_R4.util.NMSBoundingBox;
import net.citizensnpcs.nms.v1_20_R4.util.NMSImpl;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.Util;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.vehicle.EntityBoat;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_20_R4.CraftServer;
import org.bukkit.craftbukkit.v1_20_R4.entity.CraftBoat;
import org.bukkit.craftbukkit.v1_20_R4.entity.CraftEntity;
import org.bukkit.entity.Boat;
import org.bukkit.entity.Entity;

public class BoatController
extends MobEntityController {
    public BoatController() {
        super(EntityBoatNPC.class);
    }

    public Boat getBukkitEntity() {
        return (Boat)super.getBukkitEntity();
    }

    public static class EntityBoatNPC
    extends EntityBoat
    implements NPCHolder {
        private double aC;
        private float aD;
        private EntityBoat.EnumStatus aE;
        private EntityBoat.EnumStatus aF;
        private double ap;
        private double ar;
        private final CitizensNPC npc;

        public EntityBoatNPC(EntityTypes<? extends EntityBoat> entityTypes, World world) {
            this(entityTypes, world, null);
        }

        public EntityBoatNPC(EntityTypes<? extends EntityBoat> entityTypes, World world, NPC nPC) {
            super(entityTypes, world);
            this.npc = (CitizensNPC)nPC;
        }

        public CraftEntity getBukkitEntity() {
            if (this.npc != null && !(super.getBukkitEntity() instanceof NPCHolder)) {
                NMSImpl.setBukkitEntity((net.minecraft.world.entity.Entity)this, (CraftEntity)new BoatNPC(this));
            }
            return super.getBukkitEntity();
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        public EnumPistonReaction k_() {
            return Util.callPistonPushEvent(this.npc) ? EnumPistonReaction.d : super.k_();
        }

        private EntityBoat.EnumStatus getStatus() {
            EntityBoat.EnumStatus enumStatus = this.u();
            if (enumStatus != null) {
                this.aC = this.cK().e;
                return enumStatus;
            }
            if (this.t()) {
                return EntityBoat.EnumStatus.a;
            }
            float f = this.v();
            if (f > 0.0f) {
                this.aD = f;
                return EntityBoat.EnumStatus.d;
            }
            return EntityBoat.EnumStatus.e;
        }

        public boolean bA() {
            return this.npc == null ? super.bA() : this.npc.data().get(NPC.Metadata.COLLIDABLE, Boolean.valueOf(!this.npc.isProtected())).booleanValue();
        }

        protected AxisAlignedBB as() {
            return NMSBoundingBox.makeBB(this.npc, super.as());
        }

        public void h(net.minecraft.world.entity.Entity entity) {
            super.h(entity);
            if (this.npc != null) {
                Util.callCollisionEvent(this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        public void j_() {
            if (this.npc == null) {
                super.j_();
            } else {
                NMSImpl.setSize((net.minecraft.world.entity.Entity)this, this.an);
            }
        }

        public boolean e(NBTTagCompound nBTTagCompound) {
            return this.npc == null ? super.e(nBTTagCompound) : false;
        }

        private boolean t() {
            boolean bl = false;
            AxisAlignedBB axisAlignedBB = this.cK();
            int n = MathHelper.a((double)axisAlignedBB.a);
            int n2 = MathHelper.c((double)axisAlignedBB.d);
            int n3 = MathHelper.a((double)axisAlignedBB.b);
            int n4 = MathHelper.c((double)(axisAlignedBB.b + 0.001));
            int n5 = MathHelper.a((double)axisAlignedBB.c);
            int n6 = MathHelper.c((double)axisAlignedBB.f);
            boolean bl2 = false;
            this.aC = Double.MIN_VALUE;
            BlockPosition.MutableBlockPosition mutableBlockPosition = new BlockPosition.MutableBlockPosition();
            for (int i = n; i < n2; ++i) {
                for (int j = n3; j < n4; ++j) {
                    for (int k = n5; k < n6; ++k) {
                        mutableBlockPosition.d(i, j, k);
                        Fluid fluid = this.dP().b_((BlockPosition)mutableBlockPosition);
                        if (!fluid.a(TagsFluid.a)) continue;
                        float f = (float)j + fluid.a((IBlockAccess)this.dP(), (BlockPosition)mutableBlockPosition);
                        this.aC = Math.max((double)f, this.aC);
                        bl = bl2 | axisAlignedBB.b < (double)f;
                    }
                }
            }
            return bl;
        }

        public net.minecraft.world.entity.Entity teleportTo(WorldServer worldServer, Vec3D vec3D) {
            if (this.npc == null) {
                return super.teleportTo(worldServer, vec3D);
            }
            return NMSImpl.teleportAcrossWorld((net.minecraft.world.entity.Entity)this, worldServer, vec3D);
        }

        public void l() {
            if (this.npc != null) {
                this.npc.update();
                this.aF = this.aE;
                this.aE = this.getStatus();
                double d = this.aX() ? 0.0 : -0.04;
                double d2 = 0.0;
                this.ap = 0.05f;
                if (this.aF == EntityBoat.EnumStatus.e && this.aE != EntityBoat.EnumStatus.e && this.aE != EntityBoat.EnumStatus.d) {
                    this.aC = this.e(1.0);
                    this.a_(this.du(), (double)(this.u() - this.dk()) + 0.101, this.dA());
                    this.h(this.ds().d(1.0, 0.0, 1.0));
                    this.aE = EntityBoat.EnumStatus.a;
                } else {
                    if (this.aE == EntityBoat.EnumStatus.a) {
                        d2 = (this.aC - this.dw()) / (double)this.dk();
                        this.ap = 0.9f;
                    } else if (this.aE == EntityBoat.EnumStatus.c) {
                        d = -7.0E-4;
                        this.ap = 0.9f;
                    } else if (this.aE == EntityBoat.EnumStatus.b) {
                        d2 = 0.01;
                        this.ap = 0.45f;
                    } else if (this.aE == EntityBoat.EnumStatus.e) {
                        this.ap = 0.9f;
                    } else if (this.aE == EntityBoat.EnumStatus.d) {
                        this.ap = this.aD;
                        if (this.cQ() instanceof EntityPlayer) {
                            this.aD /= 2.0f;
                        }
                    }
                    Vec3D vec3D = this.ds();
                    this.o(vec3D.c * this.ap, vec3D.d + d, vec3D.e * this.ap);
                    this.ar *= this.ap;
                    if (d2 > 0.0) {
                        Vec3D vec3D2 = this.ds();
                        this.o(vec3D2.c, vec3D2.d + d2 * 0.0615, vec3D2.e);
                    }
                }
                this.a(EnumMoveType.a, this.ds());
                if (this.bS()) {
                    this.r((float)((double)this.dF() + this.ar));
                }
            } else {
                super.l();
            }
        }

        private EntityBoat.EnumStatus u() {
            AxisAlignedBB axisAlignedBB = this.cK();
            double d = axisAlignedBB.e + 0.001;
            int n = MathHelper.a((double)axisAlignedBB.a);
            int n2 = MathHelper.c((double)axisAlignedBB.d);
            int n3 = MathHelper.a((double)axisAlignedBB.e);
            int n4 = MathHelper.c((double)d);
            int n5 = MathHelper.a((double)axisAlignedBB.c);
            int n6 = MathHelper.c((double)axisAlignedBB.f);
            boolean bl = false;
            BlockPosition.MutableBlockPosition mutableBlockPosition = new BlockPosition.MutableBlockPosition();
            for (int i = n; i < n2; ++i) {
                for (int j = n3; j < n4; ++j) {
                    for (int k = n5; k < n6; ++k) {
                        mutableBlockPosition.d(i, j, k);
                        Fluid fluid = this.dP().b_((BlockPosition)mutableBlockPosition);
                        if (!fluid.a(TagsFluid.a) || !(d < (double)((float)mutableBlockPosition.v() + fluid.a((IBlockAccess)this.dP(), (BlockPosition)mutableBlockPosition)))) continue;
                        if (!fluid.b()) {
                            return EntityBoat.EnumStatus.c;
                        }
                        bl = true;
                    }
                }
            }
            return bl ? EntityBoat.EnumStatus.b : null;
        }

        public boolean a(TagKey<FluidType> tagKey, double d) {
            if (this.npc == null) {
                return super.a(tagKey, d);
            }
            Vec3D vec3D = this.ds().b(0.0, 0.0, 0.0);
            boolean bl = super.a(tagKey, d);
            if (!this.npc.isPushableByFluids()) {
                this.h(vec3D);
            }
            return bl;
        }
    }

    public static class BoatNPC
    extends CraftBoat
    implements ForwardingNPCHolder {
        public BoatNPC(EntityBoatNPC entityBoatNPC) {
            super((CraftServer)Bukkit.getServer(), (EntityBoat)entityBoatNPC);
        }
    }
}

