/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_20_R4.util;

import net.citizensnpcs.nms.v1_20_R4.entity.SlimeController;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsFluid;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.monster.EntitySlime;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.ICollisionAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockCampfire;
import net.minecraft.world.level.block.BlockDoor;
import net.minecraft.world.level.block.BlockFenceGate;
import net.minecraft.world.level.block.BlockLeaves;
import net.minecraft.world.level.block.BlockMinecartTrackAbstract;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.PathTypeCache;
import net.minecraft.world.level.pathfinder.PathfindingContext;

public class EntityPathfindingContext
extends PathfindingContext {
    private final PathTypeCache cache;
    private final ICollisionAccess level;
    private final BlockPosition mobPosition;
    private final BlockPosition.MutableBlockPosition mutablePos = new BlockPosition.MutableBlockPosition();

    public EntityPathfindingContext(ICollisionAccess iCollisionAccess, EntityLiving entityLiving) {
        super(iCollisionAccess, (EntityInsentient)new SlimeController.EntitySlimeNPC((EntityTypes<? extends EntitySlime>)EntityTypes.aP, entityLiving.dP()));
        this.level = iCollisionAccess;
        World world = entityLiving.dP();
        this.cache = world instanceof WorldServer ? ((WorldServer)world).H() : null;
        this.mobPosition = entityLiving.dp();
    }

    public IBlockData a(BlockPosition blockPosition) {
        return this.level.a_(blockPosition);
    }

    public PathType a(int n, int n2, int n3) {
        BlockPosition.MutableBlockPosition mutableBlockPosition = this.mutablePos.d(n, n2, n3);
        return this.cache == null ? EntityPathfindingContext.getPathTypeFromState((IBlockAccess)this.level, (BlockPosition)mutableBlockPosition) : this.cache.a((IBlockAccess)this.level, (BlockPosition)mutableBlockPosition);
    }

    public ICollisionAccess a() {
        return this.level;
    }

    public BlockPosition b() {
        return this.mobPosition;
    }

    static PathType getPathTypeFromState(IBlockAccess iBlockAccess, BlockPosition blockPosition) {
        IBlockData iBlockData = iBlockAccess.a_(blockPosition);
        Block block = iBlockData.b();
        if (iBlockData.i()) {
            return PathType.b;
        }
        if (!(iBlockData.a(TagsBlock.P) || iBlockData.a(Blocks.fm) || iBlockData.a(Blocks.sD))) {
            if (iBlockData.a(Blocks.qP)) {
                return PathType.f;
            }
            if (!iBlockData.a(Blocks.dQ) && !iBlockData.a(Blocks.oi)) {
                if (iBlockData.a(Blocks.pg)) {
                    return PathType.w;
                }
                if (iBlockData.a(Blocks.fC)) {
                    return PathType.x;
                }
                if (!iBlockData.a(Blocks.cd) && !iBlockData.a(Blocks.st)) {
                    Fluid fluid = iBlockData.u();
                    if (fluid.a(TagsFluid.b)) {
                        return PathType.i;
                    }
                    if (EntityPathfindingContext.isBurningBlock(iBlockData)) {
                        return PathType.o;
                    }
                    if (block instanceof BlockDoor) {
                        BlockDoor blockDoor = (BlockDoor)block;
                        if (((Boolean)iBlockData.c((IBlockState)BlockDoor.c)).booleanValue()) {
                            return PathType.r;
                        }
                        return blockDoor.b().c() ? PathType.s : PathType.t;
                    }
                    if (block instanceof BlockMinecartTrackAbstract) {
                        return PathType.l;
                    }
                    if (block instanceof BlockLeaves) {
                        return PathType.v;
                    }
                    if (iBlockData.a(TagsBlock.S) || iBlockData.a(TagsBlock.L) || block instanceof BlockFenceGate && !((Boolean)iBlockData.c((IBlockState)BlockFenceGate.b)).booleanValue()) {
                        return PathType.h;
                    }
                    if (!iBlockData.a(PathMode.a)) {
                        return PathType.a;
                    }
                    return fluid.a(TagsFluid.a) ? PathType.j : PathType.b;
                }
                return PathType.y;
            }
            return PathType.q;
        }
        return PathType.e;
    }

    static boolean isBurningBlock(IBlockData iBlockData) {
        return iBlockData.a(TagsBlock.aK) || iBlockData.a(Blocks.H) || iBlockData.a(Blocks.kJ) || BlockCampfire.g((IBlockData)iBlockData) || iBlockData.a(Blocks.fv);
    }
}

