/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_21_R1.entity.nonliving;

import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_21_R1.util.ForwardingNPCHolder;
import net.citizensnpcs.nms.v1_21_R1.util.NMSBoundingBox;
import net.citizensnpcs.nms.v1_21_R1.util.NMSImpl;
import net.citizensnpcs.npc.AbstractEntityController;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.Util;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.projectile.EntityEgg;
import net.minecraft.world.level.World;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R1.CraftServer;
import org.bukkit.craftbukkit.v1_21_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftEgg;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftEntity;
import org.bukkit.entity.Egg;
import org.bukkit.entity.Entity;

public class EggController
extends AbstractEntityController {
    public EggController() {
        super(EntityEggNPC.class);
    }

    @Override
    protected Entity createEntity(Location location, NPC nPC) {
        WorldServer worldServer = ((CraftWorld)location.getWorld()).getHandle();
        EntityEggNPC entityEggNPC = new EntityEggNPC((World)worldServer, nPC, location.getX(), location.getY(), location.getZ());
        return entityEggNPC.getBukkitEntity();
    }

    public Egg getBukkitEntity() {
        return (Egg)super.getBukkitEntity();
    }

    public static class EntityEggNPC
    extends EntityEgg
    implements NPCHolder {
        private final CitizensNPC npc;

        public EntityEggNPC(EntityTypes<? extends EntityEgg> entityTypes, World world) {
            this(entityTypes, world, null);
        }

        public EntityEggNPC(EntityTypes<? extends EntityEgg> entityTypes, World world, NPC nPC) {
            super(entityTypes, world);
            this.npc = (CitizensNPC)nPC;
        }

        public EntityEggNPC(World world, NPC nPC, double d, double d2, double d3) {
            super(world, d, d2, d3);
            this.npc = (CitizensNPC)nPC;
        }

        public CraftEntity getBukkitEntity() {
            if (this.npc != null && !(super.getBukkitEntity() instanceof NPCHolder)) {
                NMSImpl.setBukkitEntity((net.minecraft.world.entity.Entity)this, (CraftEntity)new EggNPC(this));
            }
            return super.getBukkitEntity();
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        public EnumPistonReaction j_() {
            return Util.callPistonPushEvent(this.npc) ? EnumPistonReaction.d : super.j_();
        }

        public boolean bB() {
            return this.npc == null ? super.bB() : this.npc.data().get(NPC.Metadata.COLLIDABLE, Boolean.valueOf(!this.npc.isProtected())).booleanValue();
        }

        protected AxisAlignedBB au() {
            return NMSBoundingBox.makeBB(this.npc, super.au());
        }

        public void h(net.minecraft.world.entity.Entity entity) {
            super.h(entity);
            if (this.npc != null) {
                Util.callCollisionEvent(this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        public boolean e(NBTTagCompound nBTTagCompound) {
            return this.npc == null ? super.e(nBTTagCompound) : false;
        }

        public net.minecraft.world.entity.Entity a(DimensionTransition dimensionTransition) {
            if (this.npc == null) {
                return super.a(dimensionTransition);
            }
            return NMSImpl.teleportAcrossWorld((net.minecraft.world.entity.Entity)this, dimensionTransition);
        }

        public void l() {
            if (this.npc != null) {
                this.npc.update();
                if (!this.npc.isProtected()) {
                    super.l();
                }
            } else {
                super.l();
            }
        }

        public boolean a(TagKey<FluidType> tagKey, double d) {
            if (this.npc == null) {
                return super.a(tagKey, d);
            }
            Vec3D vec3D = this.dr().b(0.0, 0.0, 0.0);
            boolean bl = super.a(tagKey, d);
            if (!this.npc.isPushableByFluids()) {
                this.i(vec3D);
            }
            return bl;
        }
    }

    public static class EggNPC
    extends CraftEgg
    implements ForwardingNPCHolder {
        public EggNPC(EntityEggNPC entityEggNPC) {
            super((CraftServer)Bukkit.getServer(), (EntityEgg)entityEggNPC);
        }
    }
}

