/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_8_R3.entity;

import java.lang.invoke.MethodHandle;
import java.util.List;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_8_R3.entity.MobEntityController;
import net.citizensnpcs.nms.v1_8_R3.util.NMSBoundingBox;
import net.citizensnpcs.nms.v1_8_R3.util.NMSImpl;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.trait.versioned.EnderDragonTrait;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.server.v1_8_R3.AxisAlignedBB;
import net.minecraft.server.v1_8_R3.DamageSource;
import net.minecraft.server.v1_8_R3.EntityEnderDragon;
import net.minecraft.server.v1_8_R3.EntityInsentient;
import net.minecraft.server.v1_8_R3.NBTTagCompound;
import net.minecraft.server.v1_8_R3.Vec3D;
import net.minecraft.server.v1_8_R3.World;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_8_R3.CraftServer;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftEnderDragon;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftEntity;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.Entity;
import org.bukkit.util.Vector;

public class EnderDragonController
extends MobEntityController {
    public EnderDragonController() {
        super(EntityEnderDragonNPC.class);
    }

    public EnderDragon getBukkitEntity() {
        return (EnderDragon)super.getBukkitEntity();
    }

    public static class EntityEnderDragonNPC
    extends EntityEnderDragon
    implements NPCHolder {
        private final CitizensNPC npc;
        private static final MethodHandle HURT = NMS.getMethodHandle(EntityEnderDragon.class, "b", true, List.class);
        private static final MethodHandle KNOCKBACK = NMS.getMethodHandle(EntityEnderDragon.class, "a", true, List.class);

        public EntityEnderDragonNPC(World world) {
            this(world, null);
        }

        public EntityEnderDragonNPC(World world, NPC nPC) {
            super(world);
            this.npc = (CitizensNPC)nPC;
        }

        public void a(AxisAlignedBB axisAlignedBB) {
            super.a(NMSBoundingBox.makeBB(this.npc, axisAlignedBB));
        }

        public void a(net.minecraft.server.v1_8_R3.Entity entity, float f, double d, double d2) {
            NMS.callKnockbackEvent(this.npc, f, d, d2, nPCKnockbackEvent -> super.a(entity, (float)nPCKnockbackEvent.getStrength(), nPCKnockbackEvent.getKnockbackVector().getX(), nPCKnockbackEvent.getKnockbackVector().getZ()));
        }

        public int aE() {
            return NMS.getFallDistance(this.npc, super.aE());
        }

        public float bE() {
            return NMS.getJumpPower(this.npc, super.bE());
        }

        protected String bo() {
            return NMSImpl.getSoundEffect(this.npc, super.bo(), NPC.Metadata.HURT_SOUND);
        }

        protected String bp() {
            return NMSImpl.getSoundEffect(this.npc, super.bp(), NPC.Metadata.DEATH_SOUND);
        }

        public boolean cc() {
            return NMSImpl.isLeashed(this.npc, () -> super.cc(), (EntityInsentient)this);
        }

        public void collide(net.minecraft.server.v1_8_R3.Entity entity) {
            super.collide(entity);
            if (this.npc != null) {
                Util.callCollisionEvent(this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        public boolean d(NBTTagCompound nBTTagCompound) {
            return this.npc == null ? super.d(nBTTagCompound) : false;
        }

        protected void D() {
            if (this.npc == null) {
                super.D();
            }
        }

        protected boolean dealDamage(DamageSource damageSource, float f) {
            if (this.npc == null) {
                return super.dealDamage(damageSource, f);
            }
            Vec3D vec3D = new Vec3D(this.motX, this.motY, this.motZ);
            boolean bl = super.dealDamage(damageSource, f);
            this.motX = vec3D.a;
            this.motY = vec3D.b;
            this.motZ = vec3D.c;
            return bl;
        }

        public void g(double d, double d2, double d3) {
            Vector vector = Util.callPushEvent(this.npc, d, d2, d3);
            if (vector != null) {
                super.g(vector.getX(), vector.getY(), vector.getZ());
            }
        }

        public CraftEntity getBukkitEntity() {
            if (this.npc != null && !(this.bukkitEntity instanceof NPCHolder)) {
                this.bukkitEntity = new EnderDragonNPC(this);
            }
            return super.getBukkitEntity();
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        public void m() {
            if (this.npc != null) {
                int n;
                this.npc.update();
                if (this.bl < 0) {
                    for (int i = 0; i < this.bk.length; ++i) {
                        this.bk[i][0] = this.yaw;
                        this.bk[i][1] = this.locY;
                    }
                }
                if (++this.bl == this.bk.length) {
                    this.bl = 0;
                }
                this.bk[this.bl][0] = this.yaw;
                this.bk[this.bl][1] = this.locY;
                float[][] fArray = NMS.calculateDragonPositions(this.yaw, new double[][]{this.b(0, 1.0f), this.b(5, 1.0f), this.b(10, 1.0f), this.b(12, 1.0f), this.b(14, 1.0f), this.b(16, 1.0f)});
                for (n = 0; n < this.children.length; ++n) {
                    Vec3D vec3D = new Vec3D(this.children[n].locX, this.children[n].locY, this.children[n].locZ);
                    this.children[n].setPosition(this.locX + (double)fArray[n][0], this.locY + (double)fArray[n][1], this.locZ + (double)fArray[n][2]);
                    this.children[n].lastX = vec3D.a;
                    this.children[n].lastY = vec3D.b;
                    this.children[n].lastZ = vec3D.c;
                }
                if (this.getBukkitEntity().getPassenger() != null) {
                    this.yaw = this.getBukkitEntity().getPassenger().getLocation().getYaw() - 180.0f;
                }
                if (this.motX != 0.0 || this.motY != 0.0 || this.motZ != 0.0) {
                    this.motX *= 0.98;
                    this.motY *= 0.98;
                    this.motZ *= 0.98;
                    if (this.getBukkitEntity().getPassenger() == null) {
                        this.yaw = Util.getDragonYaw((Entity)this.getBukkitEntity(), this.motX, this.motZ);
                    }
                    this.setPosition(this.locX + this.motX, this.locY + this.motY, this.locZ + this.motZ);
                }
                if (this.npc.hasTrait(EnderDragonTrait.class) && this.npc.getOrAddTrait(EnderDragonTrait.class).isDestroyWalls() && NMSImpl.ENDERDRAGON_CHECK_WALLS != null) {
                    for (n = 0; n < 3; ++n) {
                        try {
                            this.bx |= NMSImpl.ENDERDRAGON_CHECK_WALLS.invoke(this, this.children[n].getBoundingBox());
                            continue;
                        }
                        catch (Throwable throwable) {
                            throwable.printStackTrace();
                        }
                    }
                }
                if (this.npc.data().get(NPC.Metadata.COLLIDABLE, Boolean.valueOf(false)).booleanValue()) {
                    try {
                        KNOCKBACK.invoke(this, this.world.getEntities((net.minecraft.server.v1_8_R3.Entity)this, this.children[6].getBoundingBox().grow(4.0, 2.0, 4.0).c(0.0, -2.0, 0.0)));
                        KNOCKBACK.invoke(this, this.world.getEntities((net.minecraft.server.v1_8_R3.Entity)this, this.children[7].getBoundingBox().grow(4.0, 2.0, 4.0).c(0.0, -2.0, 0.0)));
                        HURT.invoke(this, this.world.getEntities((net.minecraft.server.v1_8_R3.Entity)this, this.children[0].getBoundingBox().grow(1.0, 1.0, 1.0)));
                        HURT.invoke(this, this.world.getEntities((net.minecraft.server.v1_8_R3.Entity)this, this.children[1].getBoundingBox().grow(1.0, 1.0, 1.0)));
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                }
            } else {
                super.m();
            }
        }

        protected String z() {
            return NMSImpl.getSoundEffect(this.npc, super.z(), NPC.Metadata.AMBIENT_SOUND);
        }
    }

    public static class EnderDragonNPC
    extends CraftEnderDragon
    implements NPCHolder {
        private final CitizensNPC npc;

        public EnderDragonNPC(EntityEnderDragonNPC entityEnderDragonNPC) {
            super((CraftServer)Bukkit.getServer(), (EntityEnderDragon)entityEnderDragonNPC);
            this.npc = entityEnderDragonNPC.npc;
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }
    }
}

