/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_8_R3.entity;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.WeakHashMap;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_8_R3.util.NMSImpl;
import net.citizensnpcs.npc.AbstractEntityController;
import net.citizensnpcs.trait.ScoreboardTrait;
import net.citizensnpcs.util.NMS;
import net.minecraft.server.v1_8_R3.EntityInsentient;
import net.minecraft.server.v1_8_R3.World;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.v1_8_R3.CraftWorld;
import org.bukkit.entity.Entity;

public abstract class MobEntityController
extends AbstractEntityController {
    private final Constructor<?> constructor;
    private static final Map<Class<?>, Constructor<?>> CONSTRUCTOR_CACHE = new WeakHashMap();
    private static final Field UUID_FIELD = NMS.getField(net.minecraft.server.v1_8_R3.Entity.class, "uniqueID");

    protected MobEntityController(Class<?> clazz) {
        super(clazz);
        this.constructor = MobEntityController.getConstructor(clazz);
    }

    @Override
    protected Entity createEntity(Location location, NPC nPC) {
        net.minecraft.server.v1_8_R3.Entity entity = this.createEntityFromClass(((CraftWorld)location.getWorld()).getHandle(), nPC);
        if (entity instanceof EntityInsentient) {
            NMSImpl.clearGoals(((EntityInsentient)entity).goalSelector, ((EntityInsentient)entity).targetSelector);
        }
        entity.setPositionRotation(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
        if (nPC != null) {
            Material material = location.getBlock().getRelative(BlockFace.DOWN).getType();
            if (material.isSolid()) {
                entity.onGround = true;
            }
            try {
                UUID_FIELD.set(entity, nPC.getUniqueId());
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            if (Settings.Setting.USE_SCOREBOARD_TEAMS.asBoolean()) {
                nPC.getOrAddTrait(ScoreboardTrait.class).createTeam(nPC.getUniqueId().toString());
            }
        }
        return entity.getBukkitEntity();
    }

    private net.minecraft.server.v1_8_R3.Entity createEntityFromClass(Object ... objectArray) {
        try {
            return (net.minecraft.server.v1_8_R3.Entity)this.constructor.newInstance(objectArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static Constructor<?> getConstructor(Class<?> clazz) {
        Constructor<?> constructor = CONSTRUCTOR_CACHE.get(clazz);
        if (constructor != null) {
            return constructor;
        }
        try {
            constructor = clazz.getConstructor(World.class, NPC.class);
            CONSTRUCTOR_CACHE.put(clazz, constructor);
            return constructor;
        }
        catch (Exception exception) {
            throw new IllegalStateException("unable to find an entity constructor");
        }
    }
}

