/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_8_R3.entity.nonliving;

import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_8_R3.util.NMSBoundingBox;
import net.citizensnpcs.npc.AbstractEntityController;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.Util;
import net.minecraft.server.v1_8_R3.AxisAlignedBB;
import net.minecraft.server.v1_8_R3.EntityEgg;
import net.minecraft.server.v1_8_R3.NBTTagCompound;
import net.minecraft.server.v1_8_R3.World;
import net.minecraft.server.v1_8_R3.WorldServer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_8_R3.CraftServer;
import org.bukkit.craftbukkit.v1_8_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftEgg;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftEntity;
import org.bukkit.entity.Egg;
import org.bukkit.entity.Entity;
import org.bukkit.util.Vector;

public class EggController
extends AbstractEntityController {
    public EggController() {
        super(EntityEggNPC.class);
    }

    @Override
    protected Entity createEntity(Location location, NPC nPC) {
        WorldServer worldServer = ((CraftWorld)location.getWorld()).getHandle();
        EntityEggNPC entityEggNPC = new EntityEggNPC((World)worldServer, nPC, location.getX(), location.getY(), location.getZ());
        return entityEggNPC.getBukkitEntity();
    }

    public Egg getBukkitEntity() {
        return (Egg)super.getBukkitEntity();
    }

    public static class EntityEggNPC
    extends EntityEgg
    implements NPCHolder {
        private final CitizensNPC npc;

        public EntityEggNPC(World world) {
            this(world, null);
        }

        public EntityEggNPC(World world, NPC nPC) {
            super(world);
            this.npc = (CitizensNPC)nPC;
        }

        public EntityEggNPC(World world, NPC nPC, double d, double d2, double d3) {
            super(world, d, d2, d3);
            this.npc = (CitizensNPC)nPC;
        }

        public void a(AxisAlignedBB axisAlignedBB) {
            super.a(NMSBoundingBox.makeBB(this.npc, axisAlignedBB));
        }

        public void collide(net.minecraft.server.v1_8_R3.Entity entity) {
            super.collide(entity);
            if (this.npc != null) {
                Util.callCollisionEvent(this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        public boolean d(NBTTagCompound nBTTagCompound) {
            return this.npc == null ? super.d(nBTTagCompound) : false;
        }

        public void g(double d, double d2, double d3) {
            Vector vector = Util.callPushEvent(this.npc, d, d2, d3);
            if (vector != null) {
                super.g(vector.getX(), vector.getY(), vector.getZ());
            }
        }

        public CraftEntity getBukkitEntity() {
            if (this.npc != null && !(this.bukkitEntity instanceof NPCHolder)) {
                this.bukkitEntity = new EggNPC(this);
            }
            return super.getBukkitEntity();
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        public void t_() {
            if (this.npc != null) {
                this.npc.update();
                if (!this.npc.isProtected()) {
                    super.t_();
                }
            } else {
                super.t_();
            }
        }
    }

    public static class EggNPC
    extends CraftEgg
    implements NPCHolder {
        private final CitizensNPC npc;

        public EggNPC(EntityEggNPC entityEggNPC) {
            super((CraftServer)Bukkit.getServer(), (EntityEgg)entityEggNPC);
            this.npc = entityEggNPC.npc;
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }
    }
}

