/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_8_R3.util;

import com.google.common.collect.ForwardingMap;
import com.google.common.collect.ForwardingSet;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.citizensnpcs.api.event.NPCLinkToPlayerEvent;
import net.citizensnpcs.api.event.NPCSeenByPlayerEvent;
import net.citizensnpcs.api.event.NPCUnlinkFromPlayerEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_8_R3.entity.EntityHumanNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.NMS;
import net.minecraft.server.v1_8_R3.Entity;
import net.minecraft.server.v1_8_R3.EntityPlayer;
import net.minecraft.server.v1_8_R3.EntityTrackerEntry;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class PlayerlistTrackerEntry
extends EntityTrackerEntry {
    private Map<EntityPlayer, Boolean> trackingMap;
    private static Field B = NMS.getField(EntityTrackerEntry.class, "b");
    private static Field C = NMS.getField(EntityTrackerEntry.class, "c");
    private static MethodHandle TRACKING_MAP_GETTER;
    private static MethodHandle TRACKING_MAP_SETTER;
    private static final MethodHandle TRACKING_SET_SETTER;
    private static Field U;

    public PlayerlistTrackerEntry(Entity entity, int n, int n2, boolean bl) {
        super(entity, n, n2, bl);
        if (TRACKING_MAP_SETTER != null) {
            try {
                Map map;
                this.trackingMap = map = TRACKING_MAP_GETTER.invoke(this);
                TRACKING_MAP_SETTER.invoke(this, new ForwardingMap<EntityPlayer, Boolean>(){

                    protected Map<EntityPlayer, Boolean> delegate() {
                        return map;
                    }

                    public Boolean put(EntityPlayer entityPlayer, Boolean bl) {
                        Boolean bl2 = (Boolean)super.put((Object)entityPlayer, (Object)bl);
                        if (bl2 == null) {
                            PlayerlistTrackerEntry.this.updateLastPlayer(entityPlayer);
                        }
                        return bl2;
                    }

                    public Boolean remove(Object object) {
                        Boolean bl = (Boolean)super.remove(object);
                        if (bl.booleanValue()) {
                            Bukkit.getPluginManager().callEvent((Event)new NPCUnlinkFromPlayerEvent(((NPCHolder)PlayerlistTrackerEntry.this.tracker).getNPC(), (Player)((EntityPlayer)object).getBukkitEntity()));
                        }
                        return bl;
                    }
                });
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        } else {
            try {
                final Set set = this.trackedPlayers;
                TRACKING_SET_SETTER.invoke(this, new ForwardingSet<EntityPlayer>(){

                    public boolean add(EntityPlayer entityPlayer) {
                        boolean bl = super.add((Object)entityPlayer);
                        if (bl) {
                            PlayerlistTrackerEntry.this.updateLastPlayer(entityPlayer);
                        }
                        return bl;
                    }

                    protected Set<EntityPlayer> delegate() {
                        return set;
                    }

                    public boolean remove(Object object) {
                        boolean bl = super.remove(object);
                        if (bl) {
                            Bukkit.getPluginManager().callEvent((Event)new NPCUnlinkFromPlayerEvent(((NPCHolder)PlayerlistTrackerEntry.this.tracker).getNPC(), (Player)((EntityPlayer)object).getBukkitEntity()));
                        }
                        return bl;
                    }
                });
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public PlayerlistTrackerEntry(EntityTrackerEntry entityTrackerEntry) {
        this(entityTrackerEntry.tracker, PlayerlistTrackerEntry.getB(entityTrackerEntry), PlayerlistTrackerEntry.getC(entityTrackerEntry), PlayerlistTrackerEntry.getU(entityTrackerEntry));
    }

    private boolean isTracked(EntityPlayer entityPlayer) {
        return this.trackingMap != null ? this.trackingMap.containsKey(entityPlayer) : this.trackedPlayers.contains(entityPlayer);
    }

    public void updateLastPlayer(EntityPlayer entityPlayer) {
        if (entityPlayer != null) {
            Bukkit.getPluginManager().callEvent((Event)new NPCLinkToPlayerEvent(((NPCHolder)this.tracker).getNPC(), (Player)entityPlayer.getBukkitEntity()));
            entityPlayer = null;
        }
    }

    public void updatePlayer(EntityPlayer entityPlayer) {
        if (entityPlayer instanceof EntityHumanNPC) {
            return;
        }
        if (!this.isTracked(entityPlayer) && this.tracker instanceof NPCHolder) {
            NPC nPC = ((NPCHolder)this.tracker).getNPC();
            NPCSeenByPlayerEvent nPCSeenByPlayerEvent = new NPCSeenByPlayerEvent(nPC, (Player)entityPlayer.getBukkitEntity());
            Bukkit.getPluginManager().callEvent((Event)nPCSeenByPlayerEvent);
            if (nPCSeenByPlayerEvent.isCancelled()) {
                return;
            }
        }
        super.updatePlayer(entityPlayer);
    }

    private static int getB(EntityTrackerEntry entityTrackerEntry) {
        try {
            Entity entity = entityTrackerEntry.tracker;
            if (entity instanceof NPCHolder) {
                return ((NPCHolder)entity).getNPC().data().get(NPC.Metadata.TRACKING_RANGE, (Integer)B.get(entityTrackerEntry));
            }
            return (Integer)B.get(entityTrackerEntry);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        return 0;
    }

    private static int getC(EntityTrackerEntry entityTrackerEntry) {
        try {
            return (Integer)C.get(entityTrackerEntry);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        return 0;
    }

    public static Set<Player> getSeenBy(EntityTrackerEntry entityTrackerEntry) {
        if (TRACKING_MAP_GETTER != null) {
            Map map;
            try {
                map = TRACKING_MAP_GETTER.invoke(entityTrackerEntry);
            }
            catch (Throwable throwable) {
                return null;
            }
            return map.keySet().stream().map(entityPlayer -> entityPlayer.getBukkitEntity()).collect(Collectors.toSet());
        }
        return entityTrackerEntry.trackedPlayers.stream().map(entityPlayer -> entityPlayer.getBukkitEntity()).collect(Collectors.toSet());
    }

    private static boolean getU(EntityTrackerEntry entityTrackerEntry) {
        try {
            return (Boolean)U.get(entityTrackerEntry);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        return false;
    }

    static {
        TRACKING_SET_SETTER = NMS.getFirstFinalSetter(EntityTrackerEntry.class, Set.class);
        U = NMS.getField(EntityTrackerEntry.class, "u");
        try {
            if (EntityTrackerEntry.class.getField("trackedPlayerMap") != null) {
                TRACKING_MAP_SETTER = NMS.getFirstSetter(EntityTrackerEntry.class, Map.class);
                TRACKING_MAP_GETTER = NMS.getFirstGetter(EntityTrackerEntry.class, Map.class);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

