/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc;

import com.google.common.base.Throwables;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.SetMultimap;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import net.citizensnpcs.NPCNeedsRespawnEvent;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.ai.Navigator;
import net.citizensnpcs.api.astar.pathfinder.MinecraftBlockExaminer;
import net.citizensnpcs.api.astar.pathfinder.SwimmingExaminer;
import net.citizensnpcs.api.event.DespawnReason;
import net.citizensnpcs.api.event.NPCDespawnEvent;
import net.citizensnpcs.api.event.NPCSpawnEvent;
import net.citizensnpcs.api.event.NPCTeleportEvent;
import net.citizensnpcs.api.event.SpawnReason;
import net.citizensnpcs.api.npc.AbstractNPC;
import net.citizensnpcs.api.npc.BlockBreaker;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.npc.NPCRegistry;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.trait.MobType;
import net.citizensnpcs.api.trait.trait.Spawned;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.npc.EntityController;
import net.citizensnpcs.npc.EntityControllers;
import net.citizensnpcs.npc.ai.CitizensNavigator;
import net.citizensnpcs.npc.skin.SkinnableEntity;
import net.citizensnpcs.trait.CurrentLocation;
import net.citizensnpcs.trait.Gravity;
import net.citizensnpcs.trait.HologramTrait;
import net.citizensnpcs.trait.PacketNPC;
import net.citizensnpcs.trait.ScoreboardTrait;
import net.citizensnpcs.trait.SitTrait;
import net.citizensnpcs.trait.SkinLayers;
import net.citizensnpcs.trait.SneakTrait;
import net.citizensnpcs.util.ChunkCoord;
import net.citizensnpcs.util.EntityPacketTracker;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.PlayerAnimation;
import net.citizensnpcs.util.PlayerUpdateTask;
import net.citizensnpcs.util.Util;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.scheduler.BukkitRunnable;

public class CitizensNPC
extends AbstractNPC {
    private ChunkCoord cachedCoord;
    private EntityController entityController;
    private final CitizensNavigator navigator = new CitizensNavigator(this);
    private int updateCounter = 0;
    private static SetMultimap<ChunkCoord, NPC> CHUNK_LOADERS = HashMultimap.create();
    private static boolean SUPPORT_GLOWING = true;
    private static boolean SUPPORT_NODAMAGE_TICKS = true;
    private static boolean SUPPORT_PICKUP_ITEMS = true;
    private static boolean SUPPORT_SILENT = true;
    private static boolean SUPPORT_USE_ITEM = true;

    public CitizensNPC(UUID uUID, int n, String string, EntityController entityController, NPCRegistry nPCRegistry) {
        super(uUID, n, string, nPCRegistry);
        this.setEntityController(entityController);
    }

    @Override
    public boolean despawn(DespawnReason despawnReason) {
        if (this.getEntity() == null && despawnReason != DespawnReason.DEATH) {
            Messaging.debug("Tried to despawn", this, "while already despawned, DespawnReason." + (Object)((Object)despawnReason));
            if (despawnReason == DespawnReason.RELOAD) {
                this.unloadEvents();
            }
            return true;
        }
        NPCDespawnEvent nPCDespawnEvent = new NPCDespawnEvent(this, despawnReason);
        if (despawnReason == DespawnReason.CHUNK_UNLOAD) {
            nPCDespawnEvent.setCancelled(this.data().get(NPC.Metadata.KEEP_CHUNK_LOADED, Boolean.valueOf(Settings.Setting.KEEP_CHUNKS_LOADED.asBoolean())));
        }
        Bukkit.getPluginManager().callEvent((Event)nPCDespawnEvent);
        if (nPCDespawnEvent.isCancelled() && despawnReason != DespawnReason.DEATH) {
            Messaging.debug("Couldn't despawn", this, "due to despawn event cancellation. Will load chunk.", this.getEntity().isValid(), ", DespawnReason." + (Object)((Object)despawnReason));
            return false;
        }
        boolean bl = this.getOrAddTrait(Spawned.class).shouldSpawn();
        if (!bl) {
            this.data().remove("selectors");
        }
        if (this.getEntity() instanceof Player) {
            PlayerUpdateTask.deregisterPlayer(this.getEntity());
        }
        this.navigator.onDespawn();
        if (despawnReason == DespawnReason.RELOAD) {
            this.unloadEvents();
        }
        for (Trait trait : new ArrayList(this.traits.values())) {
            trait.onDespawn(despawnReason);
        }
        Messaging.debug("Despawned", this, "DespawnReason." + (Object)((Object)despawnReason));
        if (this.getEntity() instanceof SkinnableEntity) {
            ((SkinnableEntity)this.getEntity()).getSkinTracker().onRemoveNPC();
        }
        if (despawnReason == DespawnReason.DEATH) {
            this.entityController.die();
        } else {
            this.entityController.remove();
        }
        return true;
    }

    @Override
    public void destroy() {
        super.destroy();
        this.resetCachedCoord();
    }

    @Override
    public void faceLocation(Location location) {
        if (!this.isSpawned()) {
            return;
        }
        Util.faceLocation(this.getEntity(), location);
    }

    @Override
    public BlockBreaker getBlockBreaker(Block block, BlockBreaker.BlockBreakerConfiguration blockBreakerConfiguration) {
        return NMS.getBlockBreaker(this.getEntity(), block, blockBreakerConfiguration);
    }

    @Override
    public Entity getEntity() {
        return this.entityController == null ? null : this.entityController.getBukkitEntity();
    }

    public EntityController getEntityController() {
        return this.entityController;
    }

    @Override
    public Navigator getNavigator() {
        return this.navigator;
    }

    @Override
    public Location getStoredLocation() {
        return this.isSpawned() ? this.getEntity().getLocation() : this.getOrAddTrait(CurrentLocation.class).getLocation();
    }

    @Override
    public boolean isFlyable() {
        this.updateFlyableState();
        return super.isFlyable();
    }

    @Override
    public boolean isSpawned() {
        return this.getEntity() != null && (this.hasTrait(PacketNPC.class) || NMS.isValid(this.getEntity()));
    }

    @Override
    public boolean isUpdating(NPC.NPCUpdate nPCUpdate) {
        return nPCUpdate == NPC.NPCUpdate.PACKET ? this.updateCounter > this.data().get(NPC.Metadata.PACKET_UPDATE_DELAY, Integer.valueOf(Settings.Setting.PACKET_UPDATE_DELAY.asTicks())) : false;
    }

    @Override
    public void load(DataKey dataKey) {
        super.load(dataKey);
        CurrentLocation currentLocation = this.getOrAddTrait(CurrentLocation.class);
        if (this.getOrAddTrait(Spawned.class).shouldSpawn() && currentLocation.getLocation() != null) {
            if (currentLocation.getLocation() != null) {
                this.spawn(currentLocation.getLocation(), SpawnReason.RESPAWN);
            } else {
                Messaging.debug("Tried to spawn", this, "on load but world was null");
            }
        }
        this.navigator.load(dataKey.getRelative("navigator"));
    }

    @Override
    public boolean requiresNameHologram() {
        return !this.data().has(NPC.Metadata.HOLOGRAM_RENDERER) && (super.requiresNameHologram() || Settings.Setting.ALWAYS_USE_NAME_HOLOGRAM.asBoolean());
    }

    private void resetCachedCoord() {
        if (this.cachedCoord == null) {
            return;
        }
        Set set = CHUNK_LOADERS.get((Object)this.cachedCoord);
        set.remove(this);
        if (set.size() == 0) {
            this.cachedCoord.setForceLoaded(false);
        }
        this.cachedCoord = null;
    }

    @Override
    public void save(DataKey dataKey) {
        super.save(dataKey);
        if (!this.data().get(NPC.Metadata.SHOULD_SAVE, Boolean.valueOf(true)).booleanValue()) {
            return;
        }
        this.navigator.save(dataKey.getRelative("navigator"));
    }

    @Override
    public void scheduleUpdate(NPC.NPCUpdate nPCUpdate) {
        if (nPCUpdate == NPC.NPCUpdate.PACKET) {
            this.updateCounter = this.data().get(NPC.Metadata.PACKET_UPDATE_DELAY, Integer.valueOf(Settings.Setting.PACKET_UPDATE_DELAY.asTicks())) + 1;
        }
    }

    @Override
    public void setBukkitEntityType(EntityType entityType) {
        EntityController entityController = EntityControllers.createForType(entityType);
        if (entityController == null) {
            throw new IllegalArgumentException("Unsupported entity type " + entityType);
        }
        this.setEntityController(entityController);
    }

    public void setEntityController(EntityController entityController) {
        PacketNPC packetNPC;
        Objects.requireNonNull(entityController);
        boolean bl = this.entityController == null ? false : this.isSpawned();
        Location location = null;
        if (bl) {
            location = this.getEntity().getLocation();
            this.despawn(DespawnReason.PENDING_RESPAWN);
        }
        if ((packetNPC = this.getTraitNullable(PacketNPC.class)) != null) {
            entityController = packetNPC.wrap(entityController);
        }
        this.entityController = entityController;
        if (bl) {
            this.spawn(location, SpawnReason.RESPAWN);
        }
    }

    @Override
    public void setFlyable(boolean bl) {
        super.setFlyable(bl);
        this.updateFlyableState();
    }

    @Override
    public void setMoveDestination(Location location) {
        if (!this.isSpawned()) {
            return;
        }
        if (location == null) {
            NMS.cancelMoveDestination(this.getEntity());
        } else {
            NMS.setDestination(this.getEntity(), location.getX(), location.getY(), location.getZ(), 1.0f);
        }
    }

    @Override
    protected void setNameInternal(String string) {
        super.setNameInternal(string);
        if (this.requiresNameHologram() && !this.hasTrait(HologramTrait.class)) {
            this.addTrait(HologramTrait.class);
        }
        this.updateCustomName();
    }

    @Override
    public void setSneaking(boolean bl) {
        this.getOrAddTrait(SneakTrait.class).setSneaking(bl);
    }

    @Override
    public boolean shouldRemoveFromTabList() {
        return this.data().get(NPC.Metadata.REMOVE_FROM_TABLIST, Boolean.valueOf(Settings.Setting.DISABLE_TABLIST.asBoolean()));
    }

    @Override
    public boolean spawn(Location location) {
        return this.spawn(location, SpawnReason.PLUGIN);
    }

    @Override
    public boolean spawn(Location location, final SpawnReason spawnReason) {
        Objects.requireNonNull(location, "location cannot be null");
        Objects.requireNonNull(spawnReason, "reason cannot be null");
        if (this.getEntity() != null) {
            Messaging.debug("Tried to spawn", this, "while already spawned. SpawnReason." + (Object)((Object)spawnReason));
            return false;
        }
        if (location.getWorld() == null) {
            Messaging.debug("Tried to spawn", this, "but the world was null. SpawnReason." + (Object)((Object)spawnReason));
            return false;
        }
        location = location.clone();
        if (spawnReason == SpawnReason.CHUNK_LOAD || spawnReason == SpawnReason.COMMAND) {
            location.getChunk().load();
        }
        this.getOrAddTrait(CurrentLocation.class).setLocation(location);
        this.entityController.create(location.clone(), this);
        this.getEntity().setMetadata("NPC", (MetadataValue)new FixedMetadataValue(CitizensAPI.getPlugin(), (Object)true));
        this.getEntity().setMetadata("NPC-ID", (MetadataValue)new FixedMetadataValue(CitizensAPI.getPlugin(), (Object)this.getId()));
        EntityPacketTracker entityPacketTracker = NMS.getPacketTracker(this.getEntity());
        if (entityPacketTracker != null) {
            for (Player player : Bukkit.getServer().getOnlinePlayers()) {
                entityPacketTracker.unlink(player);
            }
        }
        if (this.getEntity() instanceof SkinnableEntity && !this.hasTrait(SkinLayers.class)) {
            ((SkinnableEntity)this.getEntity()).setSkinFlags(EnumSet.allOf(SkinLayers.Layer.class));
        }
        for (Trait object2 : this.traits.values().toArray(new Trait[this.traits.values().size()])) {
            try {
                object2.onPreSpawn();
            }
            catch (Throwable throwable) {
                Messaging.severeTr("citizens.notifications.trait-onspawn-failed", object2.getName(), this.getId());
                throwable.printStackTrace();
            }
        }
        boolean bl = Messaging.isDebugging() ? Util.isLoaded(location) : false;
        int n = this.entityController.spawn(location) ? 1 : 0;
        if (n == 0) {
            if (Messaging.isDebugging()) {
                Messaging.debug("Retrying spawn of", this, "later, SpawnReason." + (Object)((Object)spawnReason) + ". Was loaded", bl, "is loaded", Util.isLoaded(location));
            }
            this.entityController.remove();
            Bukkit.getPluginManager().callEvent((Event)new NPCNeedsRespawnEvent(this, location));
            return false;
        }
        NMS.setLocationDirectly(this.getEntity(), location);
        NMS.setHeadYaw(this.getEntity(), location.getYaw());
        NMS.setBodyYaw(this.getEntity(), location.getYaw());
        final Location location2 = location;
        final Consumer<Runnable> consumer = new Consumer<Runnable>(){
            private int timer;

            @Override
            public void accept(Runnable runnable) {
                if (CitizensNPC.this.getEntity() == null || !CitizensNPC.this.hasTrait(PacketNPC.class) && !CitizensNPC.this.getEntity().isValid()) {
                    if (this.timer++ > Settings.Setting.ENTITY_SPAWN_WAIT_DURATION.asTicks()) {
                        Messaging.debug("Couldn't spawn ", CitizensNPC.this, "waited", this.timer, "ticks but entity not added to world");
                        CitizensNPC.this.entityController.remove();
                        runnable.run();
                        Bukkit.getPluginManager().callEvent((Event)new NPCNeedsRespawnEvent(CitizensNPC.this, location2));
                    }
                    return;
                }
                CitizensNPC.this.getOrAddTrait(CurrentLocation.class).setLocation(location2);
                CitizensNPC.this.getOrAddTrait(Spawned.class).setSpawned(true);
                NPCSpawnEvent nPCSpawnEvent = new NPCSpawnEvent(CitizensNPC.this, location2, spawnReason);
                Bukkit.getPluginManager().callEvent((Event)nPCSpawnEvent);
                if (nPCSpawnEvent.isCancelled()) {
                    Messaging.debug("Couldn't spawn", CitizensNPC.this, "SpawnReason." + (Object)((Object)spawnReason), "due to event cancellation.");
                    CitizensNPC.this.entityController.remove();
                    runnable.run();
                    return;
                }
                CitizensNPC.this.navigator.onSpawn();
                for (Trait trait : (EntityType)Iterables.toArray(CitizensNPC.this.traits.values(), Trait.class)) {
                    try {
                        trait.onSpawn();
                    }
                    catch (Throwable throwable) {
                        Messaging.severeTr("citizens.notifications.trait-onspawn-failed", trait.getName(), CitizensNPC.this.getId());
                        throwable.printStackTrace();
                    }
                }
                NMS.replaceTracker(CitizensNPC.this.getEntity());
                EntityType entityType = CitizensNPC.this.getEntity().getType();
                if (entityType.isAlive()) {
                    LivingEntity livingEntity = (LivingEntity)CitizensNPC.this.getEntity();
                    livingEntity.setRemoveWhenFarAway(false);
                    if (NMS.getStepHeight((Entity)livingEntity) < 1.0f) {
                        NMS.setStepHeight((Entity)livingEntity, 1.0f);
                    }
                    if (entityType == EntityType.PLAYER) {
                        PlayerUpdateTask.registerPlayer(CitizensNPC.this.getEntity());
                    } else if (CitizensNPC.this.data().has(NPC.Metadata.AGGRESSIVE)) {
                        NMS.setAggressive((Entity)livingEntity, (Boolean)CitizensNPC.this.data().get(NPC.Metadata.AGGRESSIVE));
                    }
                    if (SUPPORT_NODAMAGE_TICKS && (Settings.Setting.DEFAULT_SPAWN_NODAMAGE_DURATION.asTicks() != 20 || CitizensNPC.this.data().has(NPC.Metadata.SPAWN_NODAMAGE_TICKS))) {
                        try {
                            livingEntity.setNoDamageTicks(CitizensNPC.this.data().get(NPC.Metadata.SPAWN_NODAMAGE_TICKS, Integer.valueOf(Settings.Setting.DEFAULT_SPAWN_NODAMAGE_DURATION.asTicks())).intValue());
                        }
                        catch (NoSuchMethodError noSuchMethodError) {
                            SUPPORT_NODAMAGE_TICKS = false;
                        }
                    }
                }
                if (CitizensNPC.this.requiresNameHologram() && !CitizensNPC.this.hasTrait(HologramTrait.class)) {
                    CitizensNPC.this.addTrait(HologramTrait.class);
                }
                CitizensNPC.this.updateFlyableState();
                CitizensNPC.this.updateCustomNameVisibility();
                CitizensNPC.this.updateScoreboard();
                Messaging.debug("Spawned", CitizensNPC.this, "SpawnReason." + (Object)((Object)spawnReason));
                runnable.run();
            }
        };
        if (this.getEntity() != null && this.getEntity().isValid()) {
            consumer.accept(() -> {});
        } else {
            new BukkitRunnable(){

                public void run() {
                    consumer.accept(() -> (this).cancel());
                }
            }.runTaskTimer(CitizensAPI.getPlugin(), 0L, 1L);
        }
        return true;
    }

    @Override
    public void teleport(Location location, PlayerTeleportEvent.TeleportCause teleportCause) {
        if (!this.isSpawned()) {
            return;
        }
        if (this.hasTrait(SitTrait.class) && this.getOrAddTrait(SitTrait.class).isSitting()) {
            this.getOrAddTrait(SitTrait.class).setSitting(location);
        }
        Location location2 = this.getEntity().getLocation();
        if (this.isSpawned() && location2.getWorld() == location.getWorld()) {
            if (location2.distance(location) < 1.0) {
                NMS.setHeadAndBodyYaw(this.getEntity(), location.getYaw());
            }
            if (this.getEntity().getType() == EntityType.PLAYER && !this.getEntity().isInsideVehicle() && NMS.getPassengers(this.getEntity()).size() == 0) {
                NPCTeleportEvent nPCTeleportEvent = new NPCTeleportEvent(this, location);
                Bukkit.getPluginManager().callEvent((Event)nPCTeleportEvent);
                if (nPCTeleportEvent.isCancelled()) {
                    return;
                }
                NMS.setLocationDirectly(this.getEntity(), location);
                return;
            }
        }
        super.teleport(location, teleportCause);
    }

    public String toString() {
        EntityType entityType = this.hasTrait(MobType.class) ? this.getTraitNullable(MobType.class).getType() : null;
        return this.getId() + "{" + this.getRawName() + ", " + entityType + "}";
    }

    @Override
    public void update() {
        try {
            Gravity gravity;
            int n;
            super.update();
            if (!this.isSpawned()) {
                this.resetCachedCoord();
                return;
            }
            if (this.data().has(NPC.Metadata.ACTIVATION_RANGE) && ((n = ((Integer)this.data().get(NPC.Metadata.ACTIVATION_RANGE)).intValue()) == -1 || CitizensAPI.getLocationLookup().getNearbyPlayers(this.getStoredLocation(), n).iterator().hasNext())) {
                NMS.activate(this.getEntity());
            }
            int n2 = n = this.data().get(NPC.Metadata.SWIM, Boolean.valueOf(SwimmingExaminer.isWaterMob(this.getEntity()))) != false && MinecraftBlockExaminer.isLiquid(this.getEntity().getLocation().getBlock().getType()) ? 1 : 0;
            if (this.navigator.isNavigating()) {
                if (n != 0) {
                    this.getEntity().setVelocity(this.getEntity().getVelocity().multiply(this.data().get(NPC.Metadata.WATER_SPEED_MODIFIER, Float.valueOf(Settings.Setting.NPC_WATER_SPEED_MODIFIER.asFloat())).floatValue()));
                    gravity = this.navigator.getPathStrategy().getCurrentDestination();
                    if (gravity == null || gravity.getY() > this.getStoredLocation().getY()) {
                        NMS.trySwim(this.getEntity());
                    }
                }
            } else if (n != 0 && ((gravity = this.getTraitNullable(Gravity.class)) == null || gravity.hasGravity())) {
                NMS.trySwim(this.getEntity());
            }
            if (SUPPORT_GLOWING && this.data().has(NPC.Metadata.GLOWING)) {
                try {
                    this.getEntity().setGlowing(this.data().get(NPC.Metadata.GLOWING, Boolean.valueOf(false)).booleanValue());
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    SUPPORT_GLOWING = false;
                }
            }
            if (SUPPORT_SILENT && this.data().has(NPC.Metadata.SILENT)) {
                try {
                    this.getEntity().setSilent(Boolean.parseBoolean(this.data().get(NPC.Metadata.SILENT).toString()));
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    SUPPORT_SILENT = false;
                }
            }
            boolean bl = this.getEntity() instanceof LivingEntity;
            if (this.isUpdating(NPC.NPCUpdate.PACKET)) {
                ChunkCoord chunkCoord;
                if (this.data().get(NPC.Metadata.KEEP_CHUNK_LOADED, Boolean.valueOf(Settings.Setting.KEEP_CHUNKS_LOADED.asBoolean())).booleanValue() && !(chunkCoord = new ChunkCoord(this.getStoredLocation())).equals(this.cachedCoord)) {
                    this.resetCachedCoord();
                    chunkCoord.setForceLoaded(true);
                    CHUNK_LOADERS.put((Object)chunkCoord, (Object)this);
                    this.cachedCoord = chunkCoord;
                }
                if (bl) {
                    this.updateScoreboard();
                }
                this.updateCounter = 0;
            }
            this.updateCustomNameVisibility();
            if (bl) {
                NMS.setKnockbackResistance((LivingEntity)this.getEntity(), this.isProtected() ? 1.0 : 0.0);
                if (SUPPORT_PICKUP_ITEMS) {
                    try {
                        ((LivingEntity)this.getEntity()).setCanPickupItems(this.data().get(NPC.Metadata.PICKUP_ITEMS, Boolean.valueOf(false)).booleanValue());
                    }
                    catch (Throwable throwable) {
                        SUPPORT_PICKUP_ITEMS = false;
                    }
                }
                if (this.getEntity() instanceof Player) {
                    this.updateUsingItemState((Player)this.getEntity());
                }
            }
            this.navigator.run();
            ++this.updateCounter;
        }
        catch (Exception exception) {
            Throwable throwable = Throwables.getRootCause((Throwable)exception);
            Messaging.logTr("citizens.notifications.exception-updating-npc", this.getId(), throwable.getMessage());
            throwable.printStackTrace();
        }
    }

    private void updateCustomName() {
        if (this.getEntity() == null) {
            return;
        }
        if (this.coloredNameComponentCache != null) {
            NMS.setCustomName(this.getEntity(), this.coloredNameComponentCache, this.coloredNameStringCache);
        } else {
            this.getEntity().setCustomName(this.getFullName());
        }
    }

    private void updateCustomNameVisibility() {
        String string = ((Object)this.data().get(NPC.Metadata.NAMEPLATE_VISIBLE, Boolean.valueOf(true))).toString();
        if (this.requiresNameHologram()) {
            string = "false";
        }
        if (string.equals("true") || string.equals("hover")) {
            this.updateCustomName();
        }
        this.getEntity().setCustomNameVisible(Boolean.parseBoolean(string));
    }

    private void updateFlyableState() {
        EntityType entityType;
        if (!CitizensAPI.hasImplementation()) {
            return;
        }
        EntityType entityType2 = entityType = this.isSpawned() ? this.getEntity().getType() : this.getOrAddTrait(MobType.class).getType();
        if (entityType == null || !Util.isAlwaysFlyable(entityType)) {
            return;
        }
        if (!this.data().has(NPC.Metadata.FLYABLE)) {
            this.data().setPersistent(NPC.Metadata.FLYABLE, (Object)true);
        }
        if (!this.hasTrait(Gravity.class)) {
            this.getOrAddTrait(Gravity.class).setEnabled(true);
        }
    }

    private void updateScoreboard() {
        if (this.data().has(NPC.Metadata.SCOREBOARD_FAKE_TEAM_NAME)) {
            this.getOrAddTrait(ScoreboardTrait.class).update();
        }
    }

    private void updateUsingItemState(Player player) {
        boolean bl = this.data().get(NPC.Metadata.USING_HELD_ITEM, Boolean.valueOf(false));
        boolean bl2 = this.data().get(NPC.Metadata.USING_OFFHAND_ITEM, Boolean.valueOf(false));
        if (!SUPPORT_USE_ITEM) {
            return;
        }
        try {
            if (bl) {
                PlayerAnimation.STOP_USE_ITEM.play(player, 64);
                PlayerAnimation.START_USE_MAINHAND_ITEM.play(player, 64);
            } else if (bl2) {
                PlayerAnimation.STOP_USE_ITEM.play(player, 64);
                PlayerAnimation.START_USE_OFFHAND_ITEM.play(player, 64);
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            SUPPORT_USE_ITEM = false;
        }
    }
}

