/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.ai;

import net.citizensnpcs.api.astar.pathfinder.BlockExaminer;
import net.citizensnpcs.api.astar.pathfinder.BlockSource;
import net.citizensnpcs.api.astar.pathfinder.MinecraftBlockExaminer;
import net.citizensnpcs.api.astar.pathfinder.PathPoint;
import net.citizensnpcs.api.util.BoundingBox;
import net.citizensnpcs.util.NMS;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.util.Vector;

public class BoundingBoxExaminer
implements BlockExaminer {
    private double height;
    private double width;

    public BoundingBoxExaminer(Entity entity) {
        if (entity != null) {
            this.height = NMS.getBoundingBoxHeight(entity);
            this.width = NMS.getWidth(entity);
        }
    }

    @Override
    public float getCost(BlockSource blockSource, PathPoint pathPoint) {
        return 0.0f;
    }

    @Override
    public BlockExaminer.PassableState isPassable(BlockSource blockSource, PathPoint pathPoint) {
        Vector vector = pathPoint.getVector();
        Block block = blockSource.getBlockAt(vector.getBlockX(), vector.getBlockY() + 2, vector.getBlockZ());
        Material material = blockSource.getMaterialAt(vector.getBlockX(), vector.getBlockY() - 1, vector.getBlockZ());
        if (!MinecraftBlockExaminer.canStandIn(block) && MinecraftBlockExaminer.canStandOn(material)) {
            BoundingBox boundingBox = blockSource.getCollisionBox(vector.getBlockX(), vector.getBlockY() + 2, vector.getBlockZ());
            BoundingBox boundingBox2 = blockSource.getCollisionBox(vector.getBlockX(), vector.getBlockY() - 1, vector.getBlockZ());
            if (boundingBox == null || boundingBox2 == null) {
                return BlockExaminer.PassableState.IGNORE;
            }
            float f = (float)(boundingBox.minY - boundingBox2.maxY);
            if ((double)f < this.height) {
                return BlockExaminer.PassableState.UNPASSABLE;
            }
        }
        return BlockExaminer.PassableState.IGNORE;
    }
}

