/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.ai;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.function.Function;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.ai.EntityTarget;
import net.citizensnpcs.api.ai.Navigator;
import net.citizensnpcs.api.ai.NavigatorParameters;
import net.citizensnpcs.api.ai.PathStrategy;
import net.citizensnpcs.api.ai.StuckAction;
import net.citizensnpcs.api.ai.TargetType;
import net.citizensnpcs.api.ai.TeleportStuckAction;
import net.citizensnpcs.api.ai.event.CancelReason;
import net.citizensnpcs.api.ai.event.NavigationBeginEvent;
import net.citizensnpcs.api.ai.event.NavigationCancelEvent;
import net.citizensnpcs.api.ai.event.NavigationCompleteEvent;
import net.citizensnpcs.api.ai.event.NavigationReplaceEvent;
import net.citizensnpcs.api.ai.event.NavigationStuckEvent;
import net.citizensnpcs.api.ai.event.NavigatorCallback;
import net.citizensnpcs.api.astar.pathfinder.DoorExaminer;
import net.citizensnpcs.api.astar.pathfinder.FlyingBlockExaminer;
import net.citizensnpcs.api.astar.pathfinder.MinecraftBlockExaminer;
import net.citizensnpcs.api.astar.pathfinder.SwimmingExaminer;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.api.util.SpigotUtil;
import net.citizensnpcs.npc.ai.AStarNavigationStrategy;
import net.citizensnpcs.npc.ai.BoundingBoxExaminer;
import net.citizensnpcs.npc.ai.FallingExaminer;
import net.citizensnpcs.npc.ai.FlyingAStarNavigationStrategy;
import net.citizensnpcs.npc.ai.MCNavigationStrategy;
import net.citizensnpcs.npc.ai.MCTargetStrategy;
import net.citizensnpcs.npc.ai.StraightLineNavigationStrategy;
import net.citizensnpcs.trait.RotationTrait;
import net.citizensnpcs.util.ChunkCoord;
import net.citizensnpcs.util.NMS;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.util.Vector;

public class CitizensNavigator
implements Navigator,
Runnable {
    private Location activeTicket;
    private final NavigatorParameters defaultParams;
    private PathStrategy executing;
    private int lastX;
    private int lastY;
    private int lastZ;
    private NavigatorParameters localParams;
    private final NPC npc;
    private boolean paused;
    private RotationTrait.PacketRotationSession session;
    private int stationaryTicks;
    private static boolean SUPPORT_CHUNK_TICKETS = true;
    private static int UNINITIALISED_SPEED = Integer.MIN_VALUE;

    public CitizensNavigator(NPC nPC) {
        this.localParams = this.defaultParams = new NavigatorParameters().baseSpeed(UNINITIALISED_SPEED).range(Settings.Setting.DEFAULT_PATHFINDING_RANGE.asFloat()).debug(Settings.Setting.DEBUG_PATHFINDING.asBoolean()).defaultAttackStrategy((livingEntity, livingEntity2) -> {
            NMS.attack(livingEntity, livingEntity2);
            return false;
        }).attackRange(Settings.Setting.NPC_ATTACK_DISTANCE.asDouble()).updatePathRate(Settings.Setting.DEFAULT_PATHFINDER_UPDATE_PATH_RATE.asTicks()).distanceMargin(Settings.Setting.DEFAULT_DISTANCE_MARGIN.asDouble()).pathDistanceMargin(Settings.Setting.DEFAULT_PATH_DISTANCE_MARGIN.asDouble()).stationaryTicks(Settings.Setting.DEFAULT_STATIONARY_DURATION.asTicks()).stuckAction(TeleportStuckAction.INSTANCE).examiner(new MinecraftBlockExaminer()).useNewPathfinder(Settings.Setting.USE_NEW_PATHFINDER.asBoolean()).straightLineTargetingDistance(Settings.Setting.DEFAULT_STRAIGHT_LINE_TARGETING_DISTANCE.asFloat()).destinationTeleportMargin(Settings.Setting.DEFAULT_DESTINATION_TELEPORT_MARGIN.asDouble());
        this.npc = nPC;
        if (nPC.data().get(NPC.Metadata.DISABLE_DEFAULT_STUCK_ACTION, Boolean.valueOf(!Settings.Setting.DEFAULT_STUCK_ACTION.asString().contains("teleport"))).booleanValue()) {
            this.defaultParams.stuckAction(null);
        }
        this.defaultParams.examiner(new SwimmingExaminer(nPC));
    }

    @Override
    public void cancelNavigation() {
        this.stopNavigating(CancelReason.PLUGIN);
    }

    @Override
    public void cancelNavigation(CancelReason cancelReason) {
        this.stopNavigating(cancelReason);
    }

    @Override
    public boolean canNavigateTo(Location location) {
        return this.canNavigateTo(location, this.defaultParams.clone());
    }

    @Override
    public boolean canNavigateTo(Location location, NavigatorParameters navigatorParameters) {
        if (this.defaultParams.useNewPathfinder() || !(this.npc.getEntity() instanceof LivingEntity)) {
            if (this.npc.isFlyable()) {
                navigatorParameters.examiner(new FlyingBlockExaminer());
            }
            AStarNavigationStrategy.AStarPlanner aStarPlanner = new AStarNavigationStrategy.AStarPlanner(navigatorParameters, this.npc.getStoredLocation(), location);
            aStarPlanner.tick(Settings.Setting.MAXIMUM_ASTAR_ITERATIONS.asInt(), Settings.Setting.MAXIMUM_ASTAR_ITERATIONS.asInt());
            return aStarPlanner.plan != null;
        }
        MCNavigationStrategy.MCNavigator mCNavigator = NMS.getTargetNavigator(this.npc.getEntity(), location, navigatorParameters);
        return mCNavigator.getCancelReason() == null;
    }

    @Override
    public NavigatorParameters getDefaultParameters() {
        return this.defaultParams;
    }

    @Override
    public EntityTarget getEntityTarget() {
        return this.executing instanceof EntityTarget ? (EntityTarget)((Object)this.executing) : null;
    }

    @Override
    public NavigatorParameters getLocalParameters() {
        if (!this.isNavigating()) {
            return this.defaultParams;
        }
        return this.localParams;
    }

    @Override
    public NPC getNPC() {
        return this.npc;
    }

    @Override
    public PathStrategy getPathStrategy() {
        return this.executing;
    }

    @Override
    public Location getTargetAsLocation() {
        return this.isNavigating() ? this.executing.getTargetAsLocation() : null;
    }

    @Override
    public TargetType getTargetType() {
        return this.isNavigating() ? this.executing.getTargetType() : null;
    }

    @Override
    public boolean isNavigating() {
        return this.executing != null && !this.isPaused();
    }

    @Override
    public boolean isPaused() {
        return this.paused;
    }

    public void load(DataKey dataKey) {
        if (dataKey.keyExists("pathfindingrange")) {
            this.defaultParams.range((float)dataKey.getDouble("pathfindingrange"));
        }
        if (dataKey.keyExists("usenewpathfinder")) {
            this.defaultParams.useNewPathfinder(dataKey.getBoolean("usenewpathfinder"));
        }
        if (dataKey.keyExists("stationaryticks")) {
            this.defaultParams.stationaryTicks(dataKey.getInt("stationaryticks"));
        }
        if (dataKey.keyExists("distancemargin")) {
            this.defaultParams.distanceMargin(dataKey.getDouble("distancemargin"));
        }
        if (dataKey.keyExists("destinationteleportmargin")) {
            this.defaultParams.destinationTeleportMargin(dataKey.getDouble("destinationteleportmargin"));
        }
        if (dataKey.keyExists("updatepathrate")) {
            this.defaultParams.updatePathRate(dataKey.getInt("updatepathrate"));
        }
        this.defaultParams.speedModifier((float)dataKey.getDouble("speedmodifier", 1.0));
        this.defaultParams.avoidWater(dataKey.getBoolean("avoidwater"));
        if (!dataKey.getBoolean("usedefaultstuckaction") && this.defaultParams.stuckAction() == TeleportStuckAction.INSTANCE) {
            this.defaultParams.stuckAction(null);
        }
    }

    public void onDespawn() {
        this.stopNavigating(CancelReason.NPC_DESPAWNED);
    }

    public void onSpawn() {
        if (this.defaultParams.baseSpeed() == (float)UNINITIALISED_SPEED) {
            this.defaultParams.baseSpeed(NMS.getSpeedFor(this.npc));
        }
        this.updatePathfindingRange();
    }

    @Override
    public void run() {
        Object object;
        this.updateMountedStatus();
        if (!this.isNavigating() || !this.npc.isSpawned() || this.isPaused()) {
            return;
        }
        Location location = this.npc.getStoredLocation();
        Location location2 = this.getTargetAsLocation();
        if (!location.getWorld().equals((Object)location2.getWorld()) || (double)this.localParams.range() < location.distance(location2)) {
            this.stopNavigating(CancelReason.STUCK);
            return;
        }
        if (this.updateStationaryStatus()) {
            return;
        }
        this.updatePathfindingRange();
        boolean bl = this.executing.update();
        if (!bl) {
            this.localParams.run();
        }
        if (this.localParams.lookAtFunction() != null) {
            if (this.session == null) {
                object = this.npc.getOrAddTrait(RotationTrait.class);
                this.session = object.createPacketSession(object.getGlobalParameters().clone().filter(player -> true).persist(true));
            }
            this.session.getSession().rotateToFace(this.localParams.lookAtFunction().apply(this));
        }
        if (this.localParams.destinationTeleportMargin() > 0.0 && location.distance(location2) <= this.localParams.destinationTeleportMargin()) {
            this.npc.teleport(location2, PlayerTeleportEvent.TeleportCause.PLUGIN);
            bl = true;
        }
        if (!bl) {
            return;
        }
        if (this.executing.getCancelReason() != null) {
            this.stopNavigating(this.executing.getCancelReason());
        } else {
            object = new NavigationCompleteEvent(this);
            PathStrategy pathStrategy = this.executing;
            Bukkit.getPluginManager().callEvent((Event)object);
            if (pathStrategy == this.executing) {
                this.stopNavigating(null);
            }
        }
    }

    public void save(DataKey dataKey) {
        if (this.defaultParams.range() != Settings.Setting.DEFAULT_PATHFINDING_RANGE.asFloat()) {
            dataKey.setDouble("pathfindingrange", this.defaultParams.range());
        } else {
            dataKey.removeKey("pathfindingrange");
        }
        if (this.defaultParams.stationaryTicks() != Settings.Setting.DEFAULT_STATIONARY_DURATION.asTicks()) {
            dataKey.setInt("stationaryticks", this.defaultParams.stationaryTicks());
        } else {
            dataKey.removeKey("stationaryticks");
        }
        if (this.defaultParams.destinationTeleportMargin() != Settings.Setting.DEFAULT_DESTINATION_TELEPORT_MARGIN.asDouble()) {
            dataKey.setDouble("destinationteleportmargin", this.defaultParams.destinationTeleportMargin());
        } else {
            dataKey.removeKey("destinationteleportmargin");
        }
        if (this.defaultParams.distanceMargin() != Settings.Setting.DEFAULT_DISTANCE_MARGIN.asDouble()) {
            dataKey.setDouble("distancemargin", this.defaultParams.distanceMargin());
        } else {
            dataKey.removeKey("distancemargin");
        }
        if (this.defaultParams.updatePathRate() != Settings.Setting.DEFAULT_PATHFINDER_UPDATE_PATH_RATE.asTicks()) {
            dataKey.setInt("updatepathrate", this.defaultParams.updatePathRate());
        } else {
            dataKey.removeKey("updatepathrate");
        }
        if (this.defaultParams.useNewPathfinder() != Settings.Setting.USE_NEW_PATHFINDER.asBoolean()) {
            dataKey.setBoolean("usenewpathfinder", this.defaultParams.useNewPathfinder());
        } else {
            dataKey.removeKey("usenewpathfinder");
        }
        dataKey.setDouble("speedmodifier", this.defaultParams.speedModifier());
        dataKey.setBoolean("avoidwater", this.defaultParams.avoidWater());
        dataKey.setBoolean("usedefaultstuckaction", this.defaultParams.stuckAction() == TeleportStuckAction.INSTANCE);
    }

    @Override
    public void setPaused(boolean bl) {
        if (bl && this.isNavigating()) {
            NMS.cancelMoveDestination(this.npc.getEntity());
        }
        this.paused = bl;
    }

    @Override
    public void setStraightLineTarget(Entity entity, boolean bl) {
        if (!this.npc.isSpawned()) {
            throw new IllegalStateException("npc is not spawned");
        }
        if (entity == null) {
            this.cancelNavigation();
            return;
        }
        this.setTarget((NavigatorParameters navigatorParameters) -> {
            navigatorParameters.straightLineTargetingDistance(100000.0f);
            return new MCTargetStrategy(this.npc, entity, bl, (NavigatorParameters)navigatorParameters);
        });
    }

    @Override
    public void setStraightLineTarget(Location location) {
        if (!this.npc.isSpawned()) {
            throw new IllegalStateException("npc is not spawned");
        }
        if (location == null) {
            this.cancelNavigation();
            return;
        }
        this.setTarget((NavigatorParameters navigatorParameters) -> new StraightLineNavigationStrategy(this.npc, location.clone(), (NavigatorParameters)navigatorParameters));
    }

    @Override
    public void setTarget(Entity entity, boolean bl) {
        if (!this.npc.isSpawned()) {
            throw new IllegalStateException("npc is not spawned");
        }
        if (entity == null) {
            this.cancelNavigation();
            return;
        }
        this.setTarget((NavigatorParameters navigatorParameters) -> new MCTargetStrategy(this.npc, entity, bl, (NavigatorParameters)navigatorParameters));
    }

    @Override
    public void setTarget(Function<NavigatorParameters, PathStrategy> function) {
        if (!this.npc.isSpawned()) {
            throw new IllegalStateException("npc is not spawned");
        }
        this.switchParams();
        this.switchStrategyTo(function.apply(this.localParams));
    }

    @Override
    public void setTarget(Iterable<Vector> iterable) {
        if (!this.npc.isSpawned()) {
            throw new IllegalStateException("npc is not spawned");
        }
        if (iterable == null || Iterables.size(iterable) == 0) {
            this.cancelNavigation();
            return;
        }
        this.setTarget((NavigatorParameters navigatorParameters) -> {
            if (this.npc.isFlyable()) {
                return new FlyingAStarNavigationStrategy(this.npc, iterable, (NavigatorParameters)navigatorParameters);
            }
            if (navigatorParameters.useNewPathfinder() || !(this.npc.getEntity() instanceof LivingEntity)) {
                return new AStarNavigationStrategy(this.npc, iterable, (NavigatorParameters)navigatorParameters);
            }
            return new MCNavigationStrategy(this.npc, iterable, (NavigatorParameters)navigatorParameters);
        });
    }

    @Override
    public void setTarget(Location location) {
        if (!this.npc.isSpawned()) {
            throw new IllegalStateException("npc is not spawned");
        }
        if (location == null) {
            this.cancelNavigation();
            return;
        }
        Location location2 = location.clone();
        this.setTarget((NavigatorParameters navigatorParameters) -> {
            if (this.npc.isFlyable()) {
                return new FlyingAStarNavigationStrategy(this.npc, location2, (NavigatorParameters)navigatorParameters);
            }
            if (navigatorParameters.useNewPathfinder() || !(this.npc.getEntity() instanceof LivingEntity)) {
                return new AStarNavigationStrategy(this.npc, location2, (NavigatorParameters)navigatorParameters);
            }
            return new MCNavigationStrategy(this.npc, location2, (NavigatorParameters)navigatorParameters);
        });
    }

    private void stopNavigating() {
        if (this.executing != null) {
            this.executing.stop();
        }
        this.executing = null;
        this.localParams = this.defaultParams;
        this.stationaryTicks = 0;
        if (this.npc.isSpawned()) {
            Vector vector = this.npc.getEntity().getVelocity();
            vector.setX(0).setY(0).setZ(0);
            this.npc.getEntity().setVelocity(vector);
            NMS.cancelMoveDestination(this.npc.getEntity());
        }
        if (!(SUPPORT_CHUNK_TICKETS && CitizensAPI.hasImplementation() && CitizensAPI.getPlugin().isEnabled())) {
            return;
        }
        Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), () -> this.updateTicket(this.isNavigating() ? this.executing.getTargetAsLocation() : null), 10L);
    }

    private void stopNavigating(CancelReason cancelReason) {
        Object object;
        if (!this.isNavigating()) {
            return;
        }
        if (cancelReason == CancelReason.STUCK && Messaging.isDebugging()) {
            Messaging.debug(this.npc, "navigation ended, stuck", this.executing);
        }
        if (this.session != null) {
            this.session.end();
            this.session = null;
        }
        Iterator<NavigatorCallback> iterator = this.localParams.callbacks().iterator();
        ArrayList<NavigatorCallback> arrayList = new ArrayList<NavigatorCallback>();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
            iterator.remove();
        }
        for (NavigatorCallback object22 : arrayList) {
            object22.onCompletion(cancelReason);
        }
        if (cancelReason == null) {
            this.stopNavigating();
            return;
        }
        if (cancelReason == CancelReason.STUCK) {
            boolean bl;
            object = this.localParams.stuckAction();
            NavigationStuckEvent navigationStuckEvent = new NavigationStuckEvent(this, (StuckAction)object);
            Bukkit.getPluginManager().callEvent((Event)navigationStuckEvent);
            object = navigationStuckEvent.getAction();
            boolean bl2 = bl = object != null ? object.run(this.npc, this) : false;
            if (bl) {
                this.stationaryTicks = 0;
                this.executing.clearCancelReason();
                return;
            }
        }
        object = new NavigationCancelEvent(this, cancelReason);
        PathStrategy pathStrategy = this.executing;
        Bukkit.getPluginManager().callEvent((Event)object);
        if (pathStrategy == this.executing) {
            this.stopNavigating();
        }
    }

    private void switchParams() {
        this.localParams = this.defaultParams.clone();
        int n = this.npc.data().get(NPC.Metadata.PATHFINDER_FALL_DISTANCE, Integer.valueOf(Settings.Setting.PATHFINDER_FALL_DISTANCE.asInt()));
        if (n != -1) {
            this.localParams.examiner(new FallingExaminer(n));
        }
        if (this.npc.data().get(NPC.Metadata.PATHFINDER_OPEN_DOORS, Boolean.valueOf(Settings.Setting.NEW_PATHFINDER_OPENS_DOORS.asBoolean())).booleanValue()) {
            this.localParams.examiner(new DoorExaminer());
        }
        if (Settings.Setting.NEW_PATHFINDER_CHECK_BOUNDING_BOXES.asBoolean()) {
            this.localParams.examiner(new BoundingBoxExaminer(this.npc.getEntity()));
        }
    }

    private void switchStrategyTo(PathStrategy pathStrategy) {
        this.updatePathfindingRange();
        if (this.executing != null) {
            Bukkit.getPluginManager().callEvent((Event)new NavigationReplaceEvent(this));
        }
        this.executing = pathStrategy;
        this.stationaryTicks = 0;
        if (this.npc.isSpawned()) {
            NMS.updateNavigationWorld(this.npc.getEntity(), this.npc.getEntity().getWorld());
            this.updateTicket(this.executing.getTargetAsLocation());
        }
        Bukkit.getPluginManager().callEvent((Event)new NavigationBeginEvent(this));
    }

    private void updateMountedStatus() {
        if (this.isNavigating()) {
            // empty if block
        }
    }

    private void updatePathfindingRange() {
        NMS.updatePathfindingRange(this.npc, this.localParams.range());
    }

    private boolean updateStationaryStatus() {
        if (this.localParams.stationaryTicks() < 0) {
            return false;
        }
        Location location = this.npc.getEntity().getLocation();
        if (!SpigotUtil.checkYSafe(location.getY(), location.getWorld())) {
            this.stopNavigating(CancelReason.STUCK);
            return true;
        }
        if (this.lastX == location.getBlockX() && this.lastY == location.getBlockY() && this.lastZ == location.getBlockZ()) {
            if (++this.stationaryTicks >= this.localParams.stationaryTicks()) {
                this.stopNavigating(CancelReason.STUCK);
                return true;
            }
        } else {
            this.stationaryTicks = 0;
        }
        this.lastX = location.getBlockX();
        this.lastY = location.getBlockY();
        this.lastZ = location.getBlockZ();
        return false;
    }

    private void updateTicket(Location location) {
        if (!(SUPPORT_CHUNK_TICKETS && CitizensAPI.hasImplementation() && CitizensAPI.getPlugin().isEnabled())) {
            return;
        }
        if (location != null && this.activeTicket != null && new ChunkCoord(location.getChunk()).equals(new ChunkCoord(this.activeTicket.getChunk()))) {
            this.activeTicket = location.clone();
            return;
        }
        if (this.activeTicket != null) {
            try {
                this.activeTicket.getChunk().removePluginChunkTicket(CitizensAPI.getPlugin());
            }
            catch (NoSuchMethodError noSuchMethodError) {
                SUPPORT_CHUNK_TICKETS = false;
                this.activeTicket = null;
            }
        }
        if (location == null) {
            this.activeTicket = null;
            return;
        }
        this.activeTicket = location.clone();
        try {
            this.activeTicket.getChunk().addPluginChunkTicket(CitizensAPI.getPlugin());
        }
        catch (NoSuchMethodError noSuchMethodError) {
            SUPPORT_CHUNK_TICKETS = false;
            this.activeTicket = null;
        }
    }
}

