/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.skin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.npc.skin.SkinnableEntity;
import net.citizensnpcs.util.NMS;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class TabListRemover {
    private final Map<UUID, PlayerEntry> pending = new HashMap<UUID, PlayerEntry>(Math.max(128, Math.min(1024, Bukkit.getMaxPlayers() / 2)));

    TabListRemover() {
        Bukkit.getScheduler().runTaskTimer(CitizensAPI.getPlugin(), (Runnable)new Sender(), 2L, 2L);
    }

    public void cancelPackets(Player player) {
        Objects.requireNonNull(player);
        PlayerEntry playerEntry = this.pending.remove(player.getUniqueId());
        if (playerEntry == null) {
            return;
        }
        for (SkinnableEntity skinnableEntity : playerEntry.toRemove) {
            skinnableEntity.getSkinTracker().notifyRemovePacketCancelled(player.getUniqueId());
        }
    }

    public void cancelPackets(Player player, SkinnableEntity skinnableEntity) {
        Objects.requireNonNull(player);
        Objects.requireNonNull(skinnableEntity);
        PlayerEntry playerEntry = this.pending.get(player.getUniqueId());
        if (playerEntry == null) {
            return;
        }
        if (playerEntry.toRemove.remove(skinnableEntity)) {
            skinnableEntity.getSkinTracker().notifyRemovePacketCancelled(player.getUniqueId());
        }
        if (playerEntry.toRemove.isEmpty()) {
            this.pending.remove(player.getUniqueId());
        }
    }

    private PlayerEntry getEntry(Player player) {
        PlayerEntry playerEntry = this.pending.get(player.getUniqueId());
        if (playerEntry == null) {
            playerEntry = new PlayerEntry(player);
            this.pending.put(player.getUniqueId(), playerEntry);
        }
        return playerEntry;
    }

    public void sendPacket(Player player, SkinnableEntity skinnableEntity) {
        Objects.requireNonNull(player);
        Objects.requireNonNull(skinnableEntity);
        PlayerEntry playerEntry = this.getEntry(player);
        playerEntry.toRemove.add(skinnableEntity);
    }

    private class Sender
    implements Runnable {
        private Sender() {
        }

        @Override
        public void run() {
            int n = 15;
            Iterator iterator = TabListRemover.this.pending.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                PlayerEntry playerEntry = (PlayerEntry)entry.getValue();
                if (!playerEntry.player.isOnline()) {
                    iterator.remove();
                    continue;
                }
                int n2 = Math.min(n, playerEntry.toRemove.size());
                ArrayList<Player> arrayList = new ArrayList<Player>(n2);
                Iterator<SkinnableEntity> iterator2 = playerEntry.toRemove.iterator();
                for (int i = 0; iterator2.hasNext() && i < n; ++i) {
                    SkinnableEntity skinnableEntity = iterator2.next();
                    arrayList.add(skinnableEntity.getBukkitEntity());
                    skinnableEntity.getSkinTracker().notifyRemovePacketSent(playerEntry.player.getUniqueId());
                    iterator2.remove();
                }
                NMS.sendTabListRemove(playerEntry.player, arrayList);
                if (!playerEntry.toRemove.isEmpty()) continue;
                iterator.remove();
            }
        }
    }

    private static class PlayerEntry {
        Player player;
        Set<SkinnableEntity> toRemove = new HashSet<SkinnableEntity>(20);

        PlayerEntry(Player player) {
            this.player = player;
        }
    }
}

