/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait;

import com.google.common.collect.Maps;
import java.util.Map;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.entity.LivingEntity;

@TraitName(value="attributetrait")
public class AttributeTrait
extends Trait {
    @Persist(keyType=Attribute.class)
    private final Map<Attribute, Double> attributes = Maps.newEnumMap(Attribute.class);

    public AttributeTrait() {
        super("attributetrait");
    }

    @Override
    public void onSpawn() {
        if (!(this.npc.getEntity() instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)this.npc.getEntity();
        for (Map.Entry<Attribute, Double> entry : this.attributes.entrySet()) {
            livingEntity.getAttribute(entry.getKey()).setBaseValue(entry.getValue().doubleValue());
        }
    }

    public void setAttributeValue(Attribute attribute, double d) {
        this.attributes.put(attribute, d);
        this.onSpawn();
    }

    public void setDefaultAttribute(Attribute attribute) {
        this.attributes.remove(attribute);
        if (!(this.npc.getEntity() instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)this.npc.getEntity();
        AttributeInstance attributeInstance = livingEntity.getAttribute(attribute);
        attributeInstance.setBaseValue(attributeInstance.getDefaultValue());
    }
}

