/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait;

import java.util.function.Function;
import java.util.function.Supplier;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.util.BoundingBox;
import net.citizensnpcs.api.util.EntityDim;
import net.citizensnpcs.util.NMS;
import org.bukkit.Location;

@TraitName(value="boundingbox")
public class BoundingBoxTrait
extends Trait
implements Supplier<BoundingBox> {
    private EntityDim base;
    private Function<EntityDim, BoundingBox> function;
    @Persist
    private float height = -1.0f;
    @Persist
    private float scale = -1.0f;
    @Persist
    private float width = -1.0f;

    public BoundingBoxTrait() {
        super("boundingbox");
    }

    @Override
    public BoundingBox get() {
        Location location = this.npc.getEntity().getLocation();
        if (this.function != null) {
            BoundingBox boundingBox = this.function.apply(this.getAdjustedBoundingBox());
            NMS.setDimensions(this.npc.getEntity(), boundingBox.toDimensions());
            return boundingBox.add(location);
        }
        EntityDim entityDim = this.getAdjustedBoundingBox();
        NMS.setDimensions(this.npc.getEntity(), entityDim);
        return new BoundingBox(location.getX() - (double)(entityDim.width / 2.0f), location.getY(), location.getZ() - (double)(entityDim.width / 2.0f), location.getX() + (double)(entityDim.width / 2.0f), location.getY() + (double)entityDim.height, location.getZ() + (double)(entityDim.width / 2.0f));
    }

    public EntityDim getAdjustedBoundingBox() {
        EntityDim entityDim = this.base;
        if (this.scale != -1.0f) {
            entityDim = entityDim.mul(this.scale);
        }
        return new EntityDim(this.width == -1.0f ? entityDim.width : this.width, this.height == -1.0f ? entityDim.height : this.height);
    }

    @Override
    public void onDespawn() {
        this.npc.data().remove(NPC.Metadata.BOUNDING_BOX_FUNCTION);
    }

    @Override
    public void onRemove() {
        this.onDespawn();
    }

    @Override
    public void onSpawn() {
        this.base = EntityDim.from(this.npc.getEntity());
        this.npc.data().set(NPC.Metadata.BOUNDING_BOX_FUNCTION, (Object)this);
    }

    public void setBoundingBoxFunction(Function<EntityDim, BoundingBox> function) {
        this.function = function;
    }

    public void setHeight(float f) {
        this.height = f;
    }

    public void setScale(float f) {
        this.scale = f;
    }

    public void setWidth(float f) {
        this.width = f;
    }
}

