/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.BaseEncoding;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.event.NPCCommandDispatchEvent;
import net.citizensnpcs.api.gui.InventoryMenuPage;
import net.citizensnpcs.api.gui.InventoryMenuSlot;
import net.citizensnpcs.api.gui.Menu;
import net.citizensnpcs.api.gui.MenuContext;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.persistence.DelegatePersistence;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.persistence.Persister;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.api.util.ItemStorage;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.api.util.Placeholders;
import net.citizensnpcs.api.util.Translator;
import net.citizensnpcs.trait.shop.ExperienceAction;
import net.citizensnpcs.trait.shop.ItemAction;
import net.citizensnpcs.trait.shop.MoneyAction;
import net.citizensnpcs.trait.shop.NPCShopAction;
import net.citizensnpcs.util.StringHelper;
import net.citizensnpcs.util.Util;
import org.apache.logging.log4j.core.lookup.StrSubstitutor;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.permissions.PermissionAttachment;

@TraitName(value="commandtrait")
public class CommandTrait
extends Trait {
    @Persist(keyType=Integer.class)
    @DelegatePersistence(value=NPCCommandPersister.class)
    private final Map<Integer, NPCCommand> commands = Maps.newHashMap();
    @Persist
    private double cost = -1.0;
    @Persist(keyType=CommandTraitError.class)
    private final Map<CommandTraitError, String> customErrorMessages = Maps.newEnumMap(CommandTraitError.class);
    private final Map<String, Set<CommandTraitError>> executionErrors = Maps.newHashMap();
    @Persist
    private ExecutionMode executionMode = ExecutionMode.LINEAR;
    @Persist
    private int experienceCost = -1;
    @Persist(valueType=Long.class)
    private final Map<String, Long> globalCooldowns = Maps.newHashMap();
    @Persist
    private boolean hideErrorMessages;
    @Persist
    private final List<ItemStack> itemRequirements = Lists.newArrayList();
    private int lastUsedId = -1;
    @Persist
    private boolean persistSequence = false;
    @Persist(keyType=UUID.class, reify=true, value="cooldowns")
    private final Map<UUID, PlayerNPCCommand> playerTracking = Maps.newHashMap();
    @Persist
    private final List<String> temporaryPermissions = Lists.newArrayList();

    public CommandTrait() {
        super("commandtrait");
    }

    public int addCommand(NPCCommandBuilder nPCCommandBuilder) {
        int n = this.getNewId();
        this.commands.put(n, nPCCommandBuilder.build(n));
        return n;
    }

    private NPCShopAction.Transaction chargeCommandCosts(Player player, Hand hand, NPCCommand nPCCommand) {
        NPCShopAction.Transaction transaction;
        if (player.hasPermission("citizens.npc.command.ignoreerrors.*")) {
            return NPCShopAction.Transaction.success();
        }
        ArrayList arrayList = Lists.newArrayList();
        if (this.nonZeroOrNegativeOne(nPCCommand.cost) && !player.hasPermission("citizens.npc.command.ignoreerrors.cost")) {
            transaction = new MoneyAction(nPCCommand.cost).take(player, 1);
            if (!transaction.isPossible()) {
                this.sendErrorMessage(player, CommandTraitError.MISSING_MONEY, null, nPCCommand.cost);
            }
            arrayList.add(transaction);
        }
        if (nPCCommand.experienceCost != -1 && !player.hasPermission("citizens.npc.command.ignoreerrors.expcost")) {
            transaction = new ExperienceAction(nPCCommand.experienceCost).take(player, 1);
            if (!transaction.isPossible()) {
                this.sendErrorMessage(player, CommandTraitError.MISSING_EXPERIENCE, null, nPCCommand.experienceCost);
            }
            arrayList.add(transaction);
        }
        if (nPCCommand.itemCost != null && nPCCommand.itemCost.size() > 0 && !player.hasPermission("citizens.npc.command.ignoreerrors.itemcost")) {
            transaction = new ItemAction(nPCCommand.itemCost).take(player, 1);
            if (!transaction.isPossible()) {
                ItemStack itemStack = nPCCommand.itemCost.get(0);
                this.sendErrorMessage(player, CommandTraitError.MISSING_ITEM, null, itemStack.hasItemMeta() && itemStack.getItemMeta().hasDisplayName() ? itemStack.getItemMeta().getDisplayName() : Util.prettyEnum(itemStack.getType()), itemStack.getAmount());
            }
            arrayList.add(transaction);
        }
        return NPCShopAction.Transaction.compose(arrayList);
    }

    private NPCShopAction.Transaction chargeGlobalCommandCosts(Player player, Hand hand) {
        NPCShopAction.Transaction transaction;
        if (player.hasPermission("citizens.npc.command.ignoreerrors.*")) {
            return NPCShopAction.Transaction.success();
        }
        ArrayList arrayList = Lists.newArrayList();
        if (this.nonZeroOrNegativeOne(this.cost) && !player.hasPermission("citizens.npc.command.ignoreerrors.cost")) {
            transaction = new MoneyAction(this.cost).take(player, 1);
            if (!transaction.isPossible()) {
                this.sendErrorMessage(player, CommandTraitError.MISSING_MONEY, null, this.cost);
            }
            arrayList.add(transaction);
        }
        if (this.experienceCost > 0 && !player.hasPermission("citizens.npc.command.ignoreerrors.expcost")) {
            transaction = new ExperienceAction(this.experienceCost).take(player, 1);
            if (!transaction.isPossible()) {
                this.sendErrorMessage(player, CommandTraitError.MISSING_EXPERIENCE, null, this.experienceCost);
            }
            arrayList.add(transaction);
        }
        if (this.itemRequirements.size() > 0 && !player.hasPermission("citizens.npc.command.ignoreerrors.itemcost")) {
            transaction = new ItemAction(this.itemRequirements).take(player, 1);
            if (!transaction.isPossible()) {
                ItemStack itemStack = this.itemRequirements.get(0);
                this.sendErrorMessage(player, CommandTraitError.MISSING_ITEM, null, itemStack.hasItemMeta() && itemStack.getItemMeta().hasDisplayName() ? itemStack.getItemMeta().getDisplayName() : Util.prettyEnum(itemStack.getType()), itemStack.getAmount());
            }
            arrayList.add(transaction);
        }
        return NPCShopAction.Transaction.compose(arrayList);
    }

    public void clear() {
        this.commands.clear();
    }

    public void clearHistory(CommandTraitError commandTraitError, UUID uUID) {
        ArrayList arrayList = Lists.newArrayList();
        if (uUID != null) {
            arrayList.add(this.playerTracking.get(uUID));
        } else {
            arrayList.addAll(this.playerTracking.values());
        }
        switch (commandTraitError.ordinal()) {
            case 0: {
                for (PlayerNPCCommand playerNPCCommand : arrayList) {
                    playerNPCCommand.nUsed.clear();
                }
                break;
            }
            case 5: {
                for (PlayerNPCCommand playerNPCCommand : arrayList) {
                    playerNPCCommand.lastUsed.clear();
                }
                break;
            }
            case 6: {
                this.globalCooldowns.clear();
                break;
            }
            default: {
                return;
            }
        }
    }

    public void clearPlayerHistory(UUID uUID) {
        if (uUID == null) {
            this.playerTracking.clear();
        } else {
            this.playerTracking.remove(uUID);
        }
    }

    public void describe(CommandSender commandSender) {
        Object object2;
        ArrayList arrayList = Lists.newArrayList();
        ArrayList arrayList2 = Lists.newArrayList();
        for (NPCCommand object22 : this.commands.values()) {
            if (object22.hand == Hand.LEFT || object22.hand == Hand.SHIFT_LEFT || object22.hand == Hand.BOTH) {
                arrayList.add(object22);
            }
            if (object22.hand != Hand.RIGHT && object22.hand != Hand.SHIFT_RIGHT && object22.hand != Hand.BOTH) continue;
            arrayList2.add(object22);
        }
        ArrayList arrayList3 = Lists.newArrayList();
        if (this.cost > 0.0) {
            arrayList3.add("Cost: " + StringHelper.wrap(this.cost));
        }
        if (this.experienceCost > 0) {
            arrayList3.add("XP cost: " + StringHelper.wrap(this.experienceCost));
        }
        if (arrayList.size() > 0) {
            arrayList3.add(Messaging.tr("citizens.commands.npc.command.left-hand-header", new Object[0]));
            for (Object object2 : arrayList) {
                arrayList3.add(this.describe((NPCCommand)object2));
            }
        }
        if (arrayList2.size() > 0) {
            arrayList3.add(Messaging.tr("citizens.commands.npc.command.right-hand-header", new Object[0]));
            for (Object object2 : arrayList2) {
                arrayList3.add(this.describe((NPCCommand)object2));
            }
        }
        if (arrayList3.isEmpty()) {
            arrayList3.add(Messaging.tr("citizens.commands.npc.command.none-added", new Object[0]));
        } else {
            arrayList3.add(0, this.executionMode.toString());
        }
        StringBuilder stringBuilder = new StringBuilder();
        object2 = arrayList3.iterator();
        while (object2.hasNext()) {
            String string = (String)object2.next();
            stringBuilder.append(string);
            stringBuilder.append(" ");
        }
        Messaging.send(commandSender, stringBuilder.toString().trim());
    }

    private String describe(NPCCommand nPCCommand) {
        String string = Messaging.tr("citizens.commands.npc.command.describe-format", nPCCommand.command, StringHelper.wrap(nPCCommand.cooldown != 0 ? nPCCommand.cooldown : Settings.Setting.NPC_COMMAND_GLOBAL_COMMAND_COOLDOWN.asSeconds()), StringHelper.wrap(nPCCommand.cost > 0.0 ? Double.valueOf(nPCCommand.cost) : "default"), StringHelper.wrap(nPCCommand.experienceCost > 0 ? Integer.valueOf(nPCCommand.experienceCost) : "default"), nPCCommand.id);
        if (nPCCommand.globalCooldown > 0) {
            string = string + "[global " + StringHelper.wrap(nPCCommand.globalCooldown) + "s]";
        }
        if (nPCCommand.delay > 0) {
            string = string + "[delay " + StringHelper.wrap(nPCCommand.delay) + "t]";
        }
        if (nPCCommand.n > 0) {
            string = string + "[" + StringHelper.wrap(nPCCommand.n) + " uses]";
        }
        if (nPCCommand.op) {
            string = string + " -o";
        }
        if (nPCCommand.player) {
            string = string + " -p";
        }
        return string;
    }

    public void dispatch(final Player player, Hand hand) {
        final Hand hand2 = player.isSneaking() ? (hand == Hand.LEFT ? Hand.SHIFT_LEFT : Hand.SHIFT_RIGHT) : hand;
        NPCCommandDispatchEvent nPCCommandDispatchEvent = new NPCCommandDispatchEvent(this.npc, player);
        Bukkit.getServer().getPluginManager().callEvent((Event)nPCCommandDispatchEvent);
        if (nPCCommandDispatchEvent.isCancelled()) {
            return;
        }
        NPCShopAction.Transaction transaction = this.chargeGlobalCommandCosts(player, hand2);
        if (!transaction.isPossible()) {
            return;
        }
        transaction.run();
        Runnable runnable = new Runnable(){
            boolean failedCharge;

            @Override
            public void run() {
                ArrayList arrayList = Lists.newArrayList((Iterable)Iterables.filter(CommandTrait.this.commands.values(), nPCCommand -> nPCCommand.hand == hand2 || nPCCommand.hand == Hand.BOTH));
                if (CommandTrait.this.executionMode == ExecutionMode.RANDOM) {
                    if (arrayList.size() > 0) {
                        this.runCommand(player, hand2, (NPCCommand)arrayList.get(Util.getFastRandom().nextInt(arrayList.size())));
                    }
                    return;
                }
                int n = -1;
                if (CommandTrait.this.executionMode == ExecutionMode.SEQUENTIAL || CommandTrait.this.executionMode == ExecutionMode.CYCLE) {
                    Collections.sort(arrayList, Comparator.comparing(nPCCommand -> nPCCommand.id));
                    int n2 = n = arrayList.size() > 0 ? ((NPCCommand)arrayList.get((int)(arrayList.size() - 1))).id : -1;
                }
                if (CommandTrait.this.executionMode == ExecutionMode.LINEAR) {
                    CommandTrait.this.executionErrors.put(player.getUniqueId().toString(), EnumSet.noneOf(CommandTraitError.class));
                }
                for (NPCCommand nPCCommand2 : arrayList) {
                    PlayerNPCCommand playerNPCCommand = null;
                    if (CommandTrait.this.executionMode == ExecutionMode.CYCLE && nPCCommand2.id <= CommandTrait.this.lastUsedId) {
                        if (CommandTrait.this.lastUsedId != n) continue;
                        CommandTrait.this.lastUsedId = -1;
                    }
                    if (CommandTrait.this.executionMode == ExecutionMode.SEQUENTIAL && (playerNPCCommand = (PlayerNPCCommand)CommandTrait.this.playerTracking.get(player.getUniqueId())) != null) {
                        if (playerNPCCommand.lastUsedHand != hand2) {
                            playerNPCCommand.lastUsedHand = hand2;
                            playerNPCCommand.lastUsedId = -1;
                        }
                        if (nPCCommand2.id <= playerNPCCommand.lastUsedId) {
                            if (playerNPCCommand.lastUsedId != n) continue;
                            playerNPCCommand.lastUsedId = -1;
                        }
                    }
                    this.runCommand(player, hand2, nPCCommand2);
                    if (CommandTrait.this.executionMode != ExecutionMode.SEQUENTIAL && CommandTrait.this.executionMode != ExecutionMode.CYCLE && !this.failedCharge) continue;
                    break;
                }
            }

            private void runCommand(Player player2, Hand hand, NPCCommand nPCCommand) {
                Runnable runnable = () -> {
                    PermissionAttachment permissionAttachment;
                    PlayerNPCCommand playerNPCCommand = (PlayerNPCCommand)CommandTrait.this.playerTracking.get(player2.getUniqueId());
                    if (playerNPCCommand == null && (CommandTrait.this.executionMode == ExecutionMode.SEQUENTIAL || PlayerNPCCommand.requiresTracking(nPCCommand))) {
                        playerNPCCommand = new PlayerNPCCommand();
                        CommandTrait.this.playerTracking.put(player2.getUniqueId(), playerNPCCommand);
                    }
                    NPCShopAction.Transaction transaction = null;
                    if (!this.failedCharge && !(transaction = CommandTrait.this.chargeCommandCosts(player2, hand, nPCCommand)).isPossible()) {
                        this.failedCharge = true;
                        return;
                    }
                    if (playerNPCCommand != null && !playerNPCCommand.canUse(CommandTrait.this, player2, hand, nPCCommand)) {
                        return;
                    }
                    if (!this.failedCharge) {
                        transaction.run();
                    }
                    if (CommandTrait.this.temporaryPermissions.size() > 0 && (permissionAttachment = player2.addAttachment(CitizensAPI.getPlugin())) != null) {
                        for (String string : CommandTrait.this.temporaryPermissions) {
                            permissionAttachment.setPermission(string, true);
                        }
                        nPCCommand.run(CommandTrait.this.npc, player2);
                        permissionAttachment.remove();
                        return;
                    }
                    nPCCommand.run(CommandTrait.this.npc, player2);
                };
                if (nPCCommand.delay <= 0) {
                    runnable.run();
                } else {
                    Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), runnable, (long)nPCCommand.delay);
                }
            }
        };
        if (Bukkit.isPrimaryThread()) {
            runnable.run();
        } else {
            Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), runnable);
        }
    }

    public double getCost() {
        return this.cost;
    }

    public ExecutionMode getExecutionMode() {
        return this.executionMode;
    }

    public int getExperienceCost() {
        return this.experienceCost;
    }

    private int getNewId() {
        int n = 0;
        while (this.commands.containsKey(n)) {
            ++n;
        }
        return n;
    }

    public boolean hasCommandId(int n) {
        return this.commands.containsKey(n);
    }

    public boolean isHideErrorMessages() {
        return this.hideErrorMessages;
    }

    private boolean nonZeroOrNegativeOne(double d) {
        return Math.abs(d) > 1.0E-4 && Math.abs(-1.0 - d) > 1.0E-4;
    }

    public boolean persistSequence() {
        return this.persistSequence;
    }

    public void removeCommandById(int n) {
        this.commands.remove(n);
    }

    @Override
    public void save(DataKey dataKey) {
        Collection<NPCCommand> collection = this.commands.values();
        Iterator<PlayerNPCCommand> iterator = this.playerTracking.values().iterator();
        while (iterator.hasNext()) {
            PlayerNPCCommand playerNPCCommand = iterator.next();
            playerNPCCommand.prune(this.globalCooldowns, collection);
            if (!playerNPCCommand.lastUsed.isEmpty() || !playerNPCCommand.nUsed.isEmpty() || this.persistSequence && playerNPCCommand.lastUsedId != -1) continue;
            iterator.remove();
        }
    }

    private void sendErrorMessage(Player player, CommandTraitError commandTraitError, Function<String, String> function, Object ... objectArray) {
        if (this.hideErrorMessages) {
            return;
        }
        Set<CommandTraitError> set = this.executionErrors.get(player.getUniqueId().toString());
        if (set != null) {
            if (set.contains((Object)commandTraitError)) {
                return;
            }
            set.add(commandTraitError);
        }
        String string = Placeholders.replace(this.customErrorMessages.getOrDefault((Object)commandTraitError, commandTraitError.setting.asString()), (CommandSender)player, this.npc);
        if (function != null) {
            string = function.apply(string);
        }
        if (string != null && string.trim().length() > 0) {
            Messaging.send((CommandSender)player, Translator.format(string, objectArray));
        }
    }

    public void setCost(double d) {
        this.cost = d;
    }

    public void setCustomErrorMessage(CommandTraitError commandTraitError, String string) {
        this.customErrorMessages.put(commandTraitError, string);
    }

    public void setExecutionMode(ExecutionMode executionMode) {
        this.executionMode = executionMode;
    }

    public void setExperienceCost(int n) {
        this.experienceCost = n;
    }

    public void setHideErrorMessages(boolean bl) {
        this.hideErrorMessages = bl;
    }

    public void setPersistSequence(boolean bl) {
        this.persistSequence = bl;
    }

    public void setTemporaryPermissions(List<String> list) {
        this.temporaryPermissions.clear();
        this.temporaryPermissions.addAll(list);
    }

    public static enum CommandTraitError {
        MAXIMUM_TIMES_USED(Settings.Setting.NPC_COMMAND_MAXIMUM_TIMES_USED_MESSAGE),
        MISSING_EXPERIENCE(Settings.Setting.NPC_COMMAND_NOT_ENOUGH_EXPERIENCE_MESSAGE),
        MISSING_ITEM(Settings.Setting.NPC_COMMAND_MISSING_ITEM_MESSAGE),
        MISSING_MONEY(Settings.Setting.NPC_COMMAND_NOT_ENOUGH_MONEY_MESSAGE),
        NO_PERMISSION(Settings.Setting.NPC_COMMAND_NO_PERMISSION_MESSAGE),
        ON_COOLDOWN(Settings.Setting.NPC_COMMAND_ON_COOLDOWN_MESSAGE),
        ON_GLOBAL_COOLDOWN(Settings.Setting.NPC_COMMAND_ON_GLOBAL_COOLDOWN_MESSAGE);

        private final Settings.Setting setting;

        private CommandTraitError(Settings.Setting setting) {
            this.setting = setting;
        }
    }

    public static enum Hand {
        BOTH,
        LEFT,
        RIGHT,
        SHIFT_LEFT,
        SHIFT_RIGHT;

    }

    private static class NPCCommand {
        String command;
        int cooldown;
        double cost = -1.0;
        int delay;
        int experienceCost = -1;
        int globalCooldown;
        Hand hand;
        int id;
        List<ItemStack> itemCost;
        String key;
        int n;
        boolean op;
        List<String> perms;
        boolean player;

        public NPCCommand(int n, String string, Hand hand, boolean bl, boolean bl2, int n2, List<String> list, int n3, int n4, int n5, double d, int n6, List<ItemStack> list2) {
            this.id = n;
            this.command = string;
            this.hand = hand;
            this.player = bl;
            this.op = bl2;
            this.cooldown = n2;
            this.perms = list;
            this.n = n3;
            this.delay = n4;
            this.globalCooldown = n5;
            this.cost = d;
            this.experienceCost = n6;
            this.itemCost = list2;
        }

        public String getEncodedKey() {
            if (this.key != null) {
                return this.key;
            }
            this.key = BaseEncoding.base64().encode(this.command.getBytes());
            return this.key;
        }

        public void run(NPC nPC, Player player) {
            Util.runCommand(nPC, player, this.command, this.op, this.player);
        }
    }

    public static enum ExecutionMode {
        CYCLE,
        LINEAR,
        RANDOM,
        SEQUENTIAL;


        public String toString() {
            return this.name().charAt(0) + this.name().substring(1).toLowerCase();
        }
    }

    public static class NPCCommandBuilder {
        String command;
        int cooldown;
        double cost = -1.0;
        int delay;
        int experienceCost = -1;
        int globalCooldown;
        Hand hand;
        List<ItemStack> itemCost = Lists.newArrayList();
        int n = -1;
        boolean op;
        List<String> perms = Lists.newArrayList();
        boolean player;

        public NPCCommandBuilder(String string, Hand hand) {
            this.command = string;
            this.hand = hand;
        }

        public NPCCommandBuilder addPerm(String string) {
            this.perms.add(string);
            return this;
        }

        public NPCCommandBuilder addPerms(List<String> list) {
            this.perms.addAll(list);
            return this;
        }

        private NPCCommand build(int n) {
            return new NPCCommand(n, this.command, this.hand, this.player, this.op, this.cooldown, this.perms, this.n, this.delay, this.globalCooldown, this.cost, this.experienceCost, this.itemCost);
        }

        public NPCCommandBuilder command(String string) {
            this.command = string;
            return this;
        }

        public NPCCommandBuilder cooldown(Duration duration) {
            return this.cooldown(Util.convert(TimeUnit.SECONDS, duration));
        }

        public NPCCommandBuilder cooldown(int n) {
            this.cooldown = n;
            return this;
        }

        public NPCCommandBuilder cost(double d) {
            this.cost = d;
            return this;
        }

        public NPCCommandBuilder delay(Duration duration) {
            this.delay = Util.toTicks(duration);
            return this;
        }

        public NPCCommandBuilder experienceCost(int n) {
            this.experienceCost = n;
            return this;
        }

        public NPCCommandBuilder globalCooldown(Duration duration) {
            return this.globalCooldown(Util.convert(TimeUnit.SECONDS, duration));
        }

        public NPCCommandBuilder globalCooldown(int n) {
            this.globalCooldown = n;
            return this;
        }

        public NPCCommandBuilder itemCost(List<ItemStack> list) {
            this.itemCost = list;
            return this;
        }

        public NPCCommandBuilder n(int n) {
            this.n = n;
            return this;
        }

        public NPCCommandBuilder op(boolean bl) {
            this.op = bl;
            return this;
        }

        public NPCCommandBuilder player(boolean bl) {
            this.player = bl;
            return this;
        }
    }

    private static class PlayerNPCCommand {
        @Persist(valueType=Long.class)
        Map<String, Long> lastUsed = Maps.newHashMap();
        @Persist
        Hand lastUsedHand;
        @Persist
        int lastUsedId = -1;
        @Persist
        Map<String, Integer> nUsed = Maps.newHashMap();

        public boolean canUse(CommandTrait commandTrait, Player player, Hand hand, NPCCommand nPCCommand) {
            long l;
            for (String string : nPCCommand.perms) {
                if (player.hasPermission(string)) continue;
                commandTrait.sendErrorMessage(player, CommandTraitError.NO_PERMISSION, null, new Object[0]);
                return false;
            }
            long l2 = Settings.Setting.NPC_COMMAND_GLOBAL_COMMAND_COOLDOWN.asSeconds();
            long l3 = System.currentTimeMillis() / 1000L;
            String string = nPCCommand.getEncodedKey();
            if (!player.hasPermission("citizens.npc.command.ignoreerrors.cooldown") && this.lastUsed.containsKey(string)) {
                l = ((Number)this.lastUsed.get(string)).longValue() + (nPCCommand.cooldown != 0 ? (long)nPCCommand.cooldown : l2);
                if (l3 < l) {
                    long l4 = l - l3;
                    commandTrait.sendErrorMessage(player, CommandTraitError.ON_COOLDOWN, new TimeVariableFormatter(l4, TimeUnit.SECONDS), new Object[]{l4});
                    return false;
                }
                this.lastUsed.remove(string);
            }
            if (!player.hasPermission("citizens.npc.command.ignoreerrors.globalcooldown") && nPCCommand.globalCooldown > 0 && commandTrait.globalCooldowns.containsKey(string)) {
                l = ((Number)commandTrait.globalCooldowns.get(string)).longValue() + (long)nPCCommand.globalCooldown;
                if (l3 < l) {
                    long l5 = l - l3;
                    commandTrait.sendErrorMessage(player, CommandTraitError.ON_GLOBAL_COOLDOWN, new TimeVariableFormatter(l5, TimeUnit.SECONDS), new Object[]{l5});
                    return false;
                }
                commandTrait.globalCooldowns.remove(string);
            }
            int n = this.nUsed.getOrDefault(string, 0);
            if (!player.hasPermission("citizens.npc.command.ignoreerrors.nused") && nPCCommand.n > 0 && nPCCommand.n <= n) {
                commandTrait.sendErrorMessage(player, CommandTraitError.MAXIMUM_TIMES_USED, null, new Object[]{nPCCommand.n});
                return false;
            }
            if (nPCCommand.cooldown > 0 || l2 > 0L) {
                this.lastUsed.put(string, l3);
            }
            if (nPCCommand.globalCooldown > 0) {
                commandTrait.globalCooldowns.put(string, l3);
            }
            if (nPCCommand.n > 0) {
                this.nUsed.put(string, n + 1);
            }
            this.lastUsedId = nPCCommand.id;
            this.lastUsedHand = hand;
            return true;
        }

        public void prune(Map<String, Long> map, Collection<NPCCommand> collection) {
            String string;
            long l = System.currentTimeMillis() / 1000L;
            HashSet hashSet = Sets.newHashSet();
            for (NPCCommand iterator2 : collection) {
                string = iterator2.getEncodedKey();
                hashSet.add(string);
                Number number = this.lastUsed.get(string);
                if (number != null && number.longValue() + (long)(iterator2.cooldown != 0 ? iterator2.cooldown : Settings.Setting.NPC_COMMAND_GLOBAL_COMMAND_COOLDOWN.asSeconds()) < l) {
                    this.lastUsed.remove(string);
                }
                if (map == null || (number = (Number)map.get(string)) == null || number.longValue() + (long)iterator2.globalCooldown >= l) continue;
                map.remove(string);
            }
            Object object = Sets.newHashSet(this.lastUsed.keySet());
            object.removeAll(hashSet);
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                this.lastUsed.remove(string);
                this.nUsed.remove(string);
            }
            if (map != null) {
                object = Sets.newHashSet(map.keySet());
                object.removeAll(hashSet);
                Iterator iterator2 = object.iterator();
                while (iterator2.hasNext()) {
                    string = (String)iterator2.next();
                    map.remove(string);
                }
            }
        }

        public static boolean requiresTracking(NPCCommand nPCCommand) {
            return nPCCommand.globalCooldown > 0 || nPCCommand.cooldown > 0 || nPCCommand.n > 0 || nPCCommand.perms != null && nPCCommand.perms.size() > 0 || Settings.Setting.NPC_COMMAND_GLOBAL_COMMAND_COOLDOWN.asSeconds() > 0;
        }
    }

    private static class TimeVariableFormatter
    implements Function<String, String> {
        private final Map<String, String> map = Maps.newHashMapWithExpectedSize((int)5);

        public TimeVariableFormatter(long l, TimeUnit timeUnit) {
            long l2 = TimeUnit.SECONDS.convert(l, timeUnit);
            long l3 = TimeUnit.MINUTES.convert(l, timeUnit);
            long l4 = TimeUnit.HOURS.convert(l, timeUnit);
            long l5 = TimeUnit.DAYS.convert(l, timeUnit);
            this.map.put("seconds", "" + l2);
            this.map.put("seconds_over", "" + (l2 - TimeUnit.SECONDS.convert(l3, TimeUnit.MINUTES)));
            this.map.put("minutes", "" + l3);
            this.map.put("minutes_over", "" + (l3 - TimeUnit.MINUTES.convert(l4, TimeUnit.HOURS)));
            this.map.put("hours", "" + l4);
            this.map.put("hours_over", "" + (l4 - TimeUnit.HOURS.convert(l5, TimeUnit.DAYS)));
            this.map.put("days", "" + l5);
        }

        @Override
        public String apply(String string) {
            return StrSubstitutor.replace((Object)string, this.map, (String)"{", (String)"}");
        }
    }

    private static class NPCCommandPersister
    implements Persister<NPCCommand> {
        @Override
        public NPCCommand create(DataKey dataKey) {
            ArrayList arrayList = Lists.newArrayList();
            for (DataKey object : dataKey.getRelative("permissions").getIntegerSubKeys()) {
                arrayList.add(object.getString(""));
            }
            ArrayList arrayList2 = Lists.newArrayList();
            for (DataKey dataKey2 : dataKey.getRelative("itemCost").getIntegerSubKeys()) {
                arrayList2.add(ItemStorage.loadItemStack(dataKey2));
            }
            double d = dataKey.getDouble("cost", -1.0);
            int n = dataKey.getInt("experienceCost", -1);
            return new NPCCommand(Integer.parseInt(dataKey.name()), dataKey.getString("command"), Hand.valueOf(dataKey.getString("hand")), Boolean.parseBoolean(dataKey.getString("player")), Boolean.parseBoolean(dataKey.getString("op")), dataKey.getInt("cooldown"), arrayList, dataKey.getInt("n"), dataKey.getInt("delay"), dataKey.getInt("globalcooldown"), d, n, arrayList2);
        }

        @Override
        public void save(NPCCommand nPCCommand, DataKey dataKey) {
            int n;
            dataKey.setString("command", nPCCommand.command);
            dataKey.setString("hand", nPCCommand.hand.name());
            dataKey.setBoolean("player", nPCCommand.player);
            dataKey.setBoolean("op", nPCCommand.op);
            dataKey.setInt("cooldown", nPCCommand.cooldown);
            dataKey.setInt("globalcooldown", nPCCommand.globalCooldown);
            dataKey.setInt("n", nPCCommand.n);
            dataKey.setInt("delay", nPCCommand.delay);
            for (n = 0; n < nPCCommand.perms.size(); ++n) {
                dataKey.setString("permissions." + n, nPCCommand.perms.get(n));
            }
            dataKey.setDouble("cost", nPCCommand.cost);
            dataKey.setInt("experienceCost", nPCCommand.experienceCost);
            for (n = 0; n < nPCCommand.itemCost.size(); ++n) {
                ItemStorage.saveItem(dataKey.getRelative("itemCost." + n), nPCCommand.itemCost.get(n));
            }
        }
    }

    @Menu(title="Drag items for requirements", type=InventoryType.CHEST, dimensions={5, 9})
    public static class ItemRequirementGUI
    extends InventoryMenuPage {
        private int id = -1;
        private Inventory inventory;
        private CommandTrait trait;

        private ItemRequirementGUI() {
            throw new UnsupportedOperationException();
        }

        public ItemRequirementGUI(CommandTrait commandTrait) {
            this.trait = commandTrait;
        }

        public ItemRequirementGUI(CommandTrait commandTrait, int n) {
            this.trait = commandTrait;
            this.id = n;
        }

        @Override
        public void initialise(MenuContext menuContext) {
            this.inventory = menuContext.getInventory();
            if (this.id == -1) {
                for (ItemStack itemStack : this.trait.itemRequirements) {
                    this.inventory.addItem(new ItemStack[]{itemStack.clone()});
                }
            } else {
                for (ItemStack itemStack : ((NPCCommand)((CommandTrait)this.trait).commands.get((Object)Integer.valueOf((int)this.id))).itemCost) {
                    this.inventory.addItem(new ItemStack[]{itemStack.clone()});
                }
            }
        }

        @Override
        public void onClick(InventoryMenuSlot inventoryMenuSlot, InventoryClickEvent inventoryClickEvent) {
            inventoryClickEvent.setCancelled(false);
        }

        @Override
        public void onClose(HumanEntity humanEntity) {
            ArrayList arrayList = Lists.newArrayList();
            for (ItemStack itemStack : this.inventory.getContents()) {
                if (itemStack == null || itemStack.getType() == Material.AIR) continue;
                arrayList.add(itemStack);
            }
            if (this.id == -1) {
                this.trait.itemRequirements.clear();
                this.trait.itemRequirements.addAll(arrayList);
            } else {
                ((NPCCommand)((CommandTrait)this.trait).commands.get((Object)Integer.valueOf((int)this.id))).itemCost.clear();
                ((NPCCommand)((CommandTrait)this.trait).commands.get((Object)Integer.valueOf((int)this.id))).itemCost.addAll(arrayList);
            }
        }
    }
}

