/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait;

import java.util.List;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.event.NPCRightClickEvent;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.trait.trait.Owner;
import net.citizensnpcs.trait.Toggleable;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.util.Vector;

@TraitName(value="controllable")
public class Controllable
extends Trait
implements Toggleable {
    private MovementController controller = new GroundController();
    @Persist
    private BuiltInControls controls;
    @Persist
    private boolean enabled = true;
    @Persist(value="owner_required")
    private boolean ownerRequired;

    public Controllable() {
        super("controllable");
    }

    private void enterOrLeaveVehicle(Player player) {
        List<Entity> list = NMS.getPassengers((Entity)player);
        if (list.size() > 0) {
            if (list.contains(player)) {
                player.leaveVehicle();
            }
            return;
        }
        if (!player.hasPermission("citizens.npc.controllable." + this.npc.getEntity().getType().name().toLowerCase().replace("_", "")) || !player.hasPermission("citizens.npc.controllable") || this.ownerRequired && !this.npc.getOrAddTrait(Owner.class).isOwnedBy((CommandSender)player)) {
            return;
        }
        NMS.mount(this.npc.getEntity(), (Entity)player);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    private void loadController() {
        if (this.controls != null) {
            this.controller = this.controls.create(this);
            return;
        }
        if (!(this.npc.getEntity() instanceof LivingEntity) && !(this.npc.getEntity() instanceof Vehicle)) {
            this.controller = new LookAirController();
            return;
        }
        this.controller = Util.isAlwaysFlyable(this.npc.getEntity().getType()) ? new PlayerInputAirController() : new GroundController();
    }

    public boolean mount(Player player) {
        List<Entity> list = NMS.getPassengers(this.npc.getEntity());
        if (list.size() != 0) {
            return false;
        }
        boolean bl = false;
        for (Entity entity : list) {
            if (entity == null || entity != player) continue;
            bl = true;
            break;
        }
        if (bl) {
            return false;
        }
        this.enterOrLeaveVehicle(player);
        return true;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    private void onPlayerInteract(PlayerInteractEvent playerInteractEvent) {
        if (!this.npc.isSpawned() || !this.enabled) {
            return;
        }
        Action action = playerInteractEvent.getAction();
        if (!NMS.getPassengers(this.npc.getEntity()).contains(playerInteractEvent.getPlayer())) {
            return;
        }
        switch (action) {
            case RIGHT_CLICK_BLOCK: {
                if (playerInteractEvent.isCancelled()) {
                    return;
                }
            }
            case RIGHT_CLICK_AIR: {
                this.controller.rightClick(playerInteractEvent);
                break;
            }
            case LEFT_CLICK_BLOCK: {
                if (playerInteractEvent.isCancelled()) {
                    return;
                }
            }
            case LEFT_CLICK_AIR: {
                this.controller.leftClick(playerInteractEvent);
                break;
            }
        }
    }

    @EventHandler
    private void onRightClick(NPCRightClickEvent nPCRightClickEvent) {
        if (!(this.enabled && this.npc.isSpawned() && nPCRightClickEvent.getNPC().equals(this.npc))) {
            return;
        }
        this.controller.rightClickEntity(nPCRightClickEvent);
        nPCRightClickEvent.setDelayedCancellation(true);
    }

    @Override
    public void onSpawn() {
        this.loadController();
    }

    @Override
    public void run() {
        if (!this.enabled || !this.npc.isSpawned()) {
            return;
        }
        List<Entity> list = NMS.getPassengers(this.npc.getEntity());
        if (list.size() == 0 || !(list.get(0) instanceof Player) || this.npc.getNavigator().isNavigating()) {
            return;
        }
        this.controller.run((Player)list.get(0));
    }

    public void setControls(BuiltInControls builtInControls) {
        this.controls = builtInControls;
    }

    public boolean setEnabled(boolean bl) {
        this.enabled = bl;
        return bl;
    }

    private void setMountedYaw(Entity entity) {
        if (entity instanceof EnderDragon || !Settings.Setting.USE_BOAT_CONTROLS.asBoolean()) {
            return;
        }
        Location location = entity.getLocation();
        Vector vector = entity.getVelocity();
        if (vector.lengthSquared() == 0.0) {
            return;
        }
        double d = location.getX() + vector.getX();
        double d2 = location.getZ() + vector.getZ();
        if (location.getZ() > d2) {
            location.setYaw((float)(-Math.toDegrees(Math.atan((location.getX() - d) / (location.getZ() - d2)))) + 180.0f);
        } else if (location.getZ() < d2) {
            location.setYaw((float)(-Math.toDegrees(Math.atan((location.getX() - d) / (location.getZ() - d2)))));
        }
        NMS.look(entity, location.getYaw(), location.getPitch());
    }

    public void setOwnerRequired(boolean bl) {
        this.ownerRequired = bl;
    }

    @Override
    public boolean toggle() {
        boolean bl = this.enabled = !this.enabled;
        if (!this.enabled && NMS.getPassengers(this.npc.getEntity()).size() > 0) {
            NMS.getPassengers(this.npc.getEntity()).get(0).leaveVehicle();
        }
        return this.enabled;
    }

    private double updateHorizontalSpeed(Entity entity, Entity entity2, double d, float f, double d2) {
        double d3;
        Vector vector = entity.getVelocity();
        double d4 = Math.sqrt(vector.getX() * vector.getX() + vector.getZ() * vector.getZ());
        double d5 = NMS.getHorizontalMovement(entity2);
        if (Math.abs(Math.abs(d5) - 0.98) > 0.02) {
            return d;
        }
        double d6 = entity2.getLocation().getYaw();
        if (d5 > 0.0) {
            d3 = -Math.sin(d6 * Math.PI / 180.0);
            double d7 = Math.cos(d6 * Math.PI / 180.0);
            vector = vector.setX(d3 * d * (double)f).setZ(d7 * d * (double)f);
        }
        if ((d3 = Math.sqrt((vector = vector.add(new Vector(entity2.getVelocity().getX() * (double)f * Settings.Setting.CONTROLLABLE_GROUND_DIRECTION_MODIFIER.asDouble(), 0.0, entity2.getVelocity().getZ() * (double)f * Settings.Setting.CONTROLLABLE_GROUND_DIRECTION_MODIFIER.asDouble())).multiply(0.98)).getX() * vector.getX() + vector.getZ() * vector.getZ())) > d2) {
            vector = vector.multiply(new Vector(d2 / d3, 1.0, d2 / d3));
            d3 = d2;
        }
        entity.setVelocity(vector);
        if (d3 > d4 && d < d2) {
            return (float)Math.min(d2, d + (d2 - d) / 50.0);
        }
        return (float)Math.max(0.0, d - d / 50.0);
    }

    public class GroundController
    implements MovementController {
        private int jumpTicks = 0;
        private double speed = 0.07;
        private static final float AIR_SPEED = 0.5f;
        private static final float GROUND_SPEED = 0.5f;
        private static final float JUMP_VELOCITY = 0.5f;

        @Override
        public void leftClick(PlayerInteractEvent playerInteractEvent) {
        }

        @Override
        public void rightClick(PlayerInteractEvent playerInteractEvent) {
        }

        @Override
        public void rightClickEntity(NPCRightClickEvent nPCRightClickEvent) {
            Controllable.this.enterOrLeaveVehicle(nPCRightClickEvent.getClicker());
        }

        @Override
        public void run(Player player) {
            boolean bl = NMS.isOnGround(Controllable.this.npc.getEntity());
            float f = Controllable.this.npc.getNavigator().getDefaultParameters().modifiedSpeed(bl ? 0.5f : 0.5f);
            if (!Util.isHorse(Controllable.this.npc.getEntity().getType())) {
                this.speed = Controllable.this.updateHorizontalSpeed(Controllable.this.npc.getEntity(), (Entity)player, this.speed, f, Settings.Setting.MAX_CONTROLLABLE_GROUND_SPEED.asDouble());
            }
            if (bl && this.jumpTicks <= 0 && NMS.shouldJump((Entity)player)) {
                Controllable.this.npc.getEntity().setVelocity(Controllable.this.npc.getEntity().getVelocity().setY(0.5f));
                this.jumpTicks = 10;
            }
            --this.jumpTicks;
            Controllable.this.setMountedYaw(Controllable.this.npc.getEntity());
        }
    }

    public static interface MovementController {
        public void leftClick(PlayerInteractEvent var1);

        public void rightClick(PlayerInteractEvent var1);

        public void rightClickEntity(NPCRightClickEvent var1);

        public void run(Player var1);
    }

    public static enum BuiltInControls {
        AIR{

            @Override
            MovementController create(Controllable controllable) {
                return controllable.new PlayerInputAirController();
            }
        }
        ,
        GROUND{

            @Override
            MovementController create(Controllable controllable) {
                return controllable.new GroundController();
            }
        }
        ,
        GROUND_JUMPLESS{

            @Override
            MovementController create(Controllable controllable) {
                return controllable.new JumplessGroundController();
            }
        }
        ,
        LOOK_AIR{

            @Override
            MovementController create(Controllable controllable) {
                return controllable.new LookAirController();
            }
        };


        abstract MovementController create(Controllable var1);
    }

    public class LookAirController
    implements MovementController {
        private boolean paused = false;

        @Override
        public void leftClick(PlayerInteractEvent playerInteractEvent) {
            this.paused = !this.paused;
        }

        @Override
        public void rightClick(PlayerInteractEvent playerInteractEvent) {
            this.paused = !this.paused;
        }

        @Override
        public void rightClickEntity(NPCRightClickEvent nPCRightClickEvent) {
            Controllable.this.enterOrLeaveVehicle(nPCRightClickEvent.getClicker());
        }

        @Override
        public void run(Player player) {
            if (this.paused) {
                Controllable.this.npc.getEntity().setVelocity(Controllable.this.npc.getEntity().getVelocity().setY(0.001));
                return;
            }
            Vector vector = player.getEyeLocation().getDirection();
            vector.multiply(Controllable.this.npc.getNavigator().getDefaultParameters().speedModifier());
            Controllable.this.npc.getEntity().setVelocity(vector);
            Controllable.this.setMountedYaw(Controllable.this.npc.getEntity());
        }
    }

    public class PlayerInputAirController
    implements MovementController {
        private boolean paused = false;
        private double speed;

        @Override
        public void leftClick(PlayerInteractEvent playerInteractEvent) {
            this.paused = !this.paused;
        }

        @Override
        public void rightClick(PlayerInteractEvent playerInteractEvent) {
            Controllable.this.npc.getEntity().setVelocity(Controllable.this.npc.getEntity().getVelocity().setY(-0.25f));
        }

        @Override
        public void rightClickEntity(NPCRightClickEvent nPCRightClickEvent) {
            Controllable.this.enterOrLeaveVehicle(nPCRightClickEvent.getClicker());
        }

        @Override
        public void run(Player player) {
            if (this.paused) {
                Controllable.this.npc.getEntity().setVelocity(Controllable.this.npc.getEntity().getVelocity().setY(0.001f));
                return;
            }
            this.speed = Controllable.this.updateHorizontalSpeed(Controllable.this.npc.getEntity(), (Entity)player, this.speed, 1.0f, Settings.Setting.MAX_CONTROLLABLE_FLIGHT_SPEED.asDouble());
            boolean bl = NMS.shouldJump((Entity)player);
            if (bl) {
                Controllable.this.npc.getEntity().setVelocity(Controllable.this.npc.getEntity().getVelocity().setY(0.25f));
            }
            Controllable.this.npc.getEntity().setVelocity(Controllable.this.npc.getEntity().getVelocity().multiply(new Vector(1.0, 0.98, 1.0)));
            Controllable.this.setMountedYaw(Controllable.this.npc.getEntity());
        }
    }

    public class JumplessGroundController
    implements MovementController {
        private double speed = 0.07;
        private static final float AIR_SPEED = 0.5f;
        private static final float GROUND_SPEED = 0.5f;

        @Override
        public void leftClick(PlayerInteractEvent playerInteractEvent) {
        }

        @Override
        public void rightClick(PlayerInteractEvent playerInteractEvent) {
        }

        @Override
        public void rightClickEntity(NPCRightClickEvent nPCRightClickEvent) {
            Controllable.this.enterOrLeaveVehicle(nPCRightClickEvent.getClicker());
        }

        @Override
        public void run(Player player) {
            boolean bl = NMS.isOnGround(Controllable.this.npc.getEntity());
            float f = Controllable.this.npc.getNavigator().getDefaultParameters().modifiedSpeed(bl ? 0.5f : 0.5f);
            if (!Util.isHorse(Controllable.this.npc.getEntity().getType())) {
                this.speed = Controllable.this.updateHorizontalSpeed(Controllable.this.npc.getEntity(), (Entity)player, this.speed, f, Settings.Setting.MAX_CONTROLLABLE_GROUND_SPEED.asDouble());
            }
            Controllable.this.setMountedYaw(Controllable.this.npc.getEntity());
        }
    }
}

