/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait;

import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.trait.EntityPoseTrait;
import net.citizensnpcs.util.NMS;
import org.bukkit.Location;
import org.bukkit.block.Bed;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.entity.Villager;

@TraitName(value="sleeptrait")
public class SleepTrait
extends Trait {
    @Persist
    private Location at;
    private boolean sleeping;
    private static Boolean SUPPORT_BLOCKDATA = null;

    public SleepTrait() {
        super("sleeptrait");
    }

    @Override
    public void onDespawn() {
        this.sleeping = false;
    }

    @Override
    public void run() {
        if (!this.npc.isSpawned()) {
            return;
        }
        if (this.at == null) {
            if (this.sleeping) {
                this.wakeup();
            }
            return;
        }
        if (this.npc.getEntity() instanceof Player) {
            block11: {
                Player player = (Player)this.npc.getEntity();
                this.npc.getOrAddTrait(EntityPoseTrait.class).setPose(EntityPoseTrait.EntityPose.SLEEPING);
                if (SUPPORT_BLOCKDATA.booleanValue()) {
                    try {
                        if (this.at.getBlock().getBlockData() instanceof Bed || this.at.getBlock().getState() instanceof Bed) {
                            player.sleep(this.at, true);
                            break block11;
                        }
                        NMS.sleep(player, true);
                    }
                    catch (Throwable throwable) {
                        SUPPORT_BLOCKDATA = false;
                        NMS.sleep(player, true);
                    }
                } else {
                    NMS.sleep(player, true);
                }
            }
            this.sleeping = true;
        } else if (this.npc.getEntity() instanceof Villager) {
            this.sleeping = ((Villager)this.npc.getEntity()).sleep(this.at);
        }
    }

    public void setSleeping(Location location) {
        this.at = location != null ? location.clone() : null;
        this.wakeup();
    }

    private void wakeup() {
        this.npc.getOrAddTrait(EntityPoseTrait.class).setPose(null);
        if (this.npc.getEntity() instanceof Player) {
            NMS.sleep((Player)this.npc.getEntity(), false);
        } else if (this.npc.getEntity() instanceof Villager) {
            ((Villager)this.npc.getEntity()).wakeup();
        }
        this.sleeping = false;
    }

    static {
        try {
            Block.class.getMethod("getBlockData", new Class[0]);
            SUPPORT_BLOCKDATA = true;
        }
        catch (NoSuchMethodException | SecurityException exception) {
            SUPPORT_BLOCKDATA = false;
        }
    }
}

