/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait;

import net.citizensnpcs.api.exception.NPCLoadException;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.util.DataKey;
import org.bukkit.entity.Villager;
import org.bukkit.entity.ZombieVillager;

@TraitName(value="profession")
public class VillagerProfession
extends Trait {
    private Villager.Profession profession = Villager.Profession.FARMER;
    private static boolean SUPPORT_ZOMBIE_VILLAGER = true;

    public VillagerProfession() {
        super("profession");
    }

    public Villager.Profession getProfession() {
        return this.profession;
    }

    @Override
    public void load(DataKey dataKey) {
        try {
            this.profession = Villager.Profession.valueOf((String)dataKey.getString(""));
            if ("NORMAL".equals(this.profession.name())) {
                this.profession = Villager.Profession.FARMER;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new NPCLoadException("Invalid profession.");
        }
    }

    @Override
    public void onSpawn() {
        if (!this.npc.isSpawned()) {
            return;
        }
        if (this.npc.getEntity() instanceof Villager) {
            ((Villager)this.npc.getEntity()).setProfession(this.profession);
            return;
        }
        if (SUPPORT_ZOMBIE_VILLAGER) {
            try {
                if (this.npc.getEntity() instanceof ZombieVillager) {
                    ((ZombieVillager)this.npc.getEntity()).setVillagerProfession(this.profession);
                }
            }
            catch (Throwable throwable) {
                SUPPORT_ZOMBIE_VILLAGER = false;
            }
        }
    }

    @Override
    public void save(DataKey dataKey) {
        dataKey.setString("", this.profession.name());
    }

    public void setProfession(Villager.Profession profession) {
        if ("NORMAL".equals(profession.name())) {
            profession = Villager.Profession.FARMER;
        }
        this.profession = profession;
        this.onSpawn();
    }

    public String toString() {
        return "Profession{" + this.profession + "}";
    }
}

