/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.versioned;

import net.citizensnpcs.api.command.Command;
import net.citizensnpcs.api.command.CommandContext;
import net.citizensnpcs.api.command.Requirements;
import net.citizensnpcs.api.command.exception.CommandUsageException;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.util.NMS;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Allay;
import org.bukkit.entity.EntityType;

@TraitName(value="allaytrait")
public class AllayTrait
extends Trait {
    @Persist
    private boolean dancing = false;

    public AllayTrait() {
        super("allaytrait");
    }

    public boolean isDancing() {
        return this.dancing;
    }

    @Override
    public void run() {
        if (!this.npc.isSpawned() || !(this.npc.getEntity() instanceof Allay)) {
            return;
        }
        NMS.setAllayDancing(this.npc.getEntity(), this.dancing);
    }

    public void setDancing(boolean bl) {
        this.dancing = bl;
    }

    @Command(aliases={"npc"}, usage="allay (-d(ancing))", desc="", modifiers={"allay"}, min=1, max=1, flags="d", permission="citizens.npc.allay")
    @Requirements(selected=true, ownership=true, types={EntityType.ALLAY})
    public static void allay(CommandContext commandContext, CommandSender commandSender, NPC nPC) {
        AllayTrait allayTrait = nPC.getOrAddTrait(AllayTrait.class);
        String string = "";
        if (commandContext.hasFlag('d')) {
            allayTrait.setDancing(!allayTrait.isDancing());
            string = string + ' ' + (allayTrait.isDancing() ? Messaging.tr("citizens.commands.npc.allay.dancing-set", nPC.getName()) : Messaging.tr("citizens.commands.npc.allay.dancing-unset", nPC.getName()));
        }
        if (string.isEmpty()) {
            throw new CommandUsageException();
        }
        Messaging.send(commandSender, string.trim());
    }
}

