/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.versioned;

import net.citizensnpcs.api.command.Command;
import net.citizensnpcs.api.command.CommandContext;
import net.citizensnpcs.api.command.Flag;
import net.citizensnpcs.api.command.Requirements;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.util.NMS;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Camel;
import org.bukkit.entity.EntityType;

@TraitName(value="cameltrait")
public class CamelTrait
extends Trait {
    @Persist
    private CamelPose pose;

    public CamelTrait() {
        super("cameltrait");
    }

    public CamelPose getPose() {
        return this.pose;
    }

    @Override
    public void run() {
        if (this.pose != null && this.npc.isSpawned() && this.npc.getEntity() instanceof Camel) {
            NMS.setCamelPose(this.npc.getEntity(), this.pose);
        }
    }

    public void setPose(CamelPose camelPose) {
        this.pose = camelPose;
    }

    @Command(aliases={"npc"}, usage="camel (--pose pose)", desc="", modifiers={"camel"}, min=1, max=1, permission="citizens.npc.camel")
    @Requirements(selected=true, ownership=true, types={EntityType.CAMEL})
    public static void camel(CommandContext commandContext, CommandSender commandSender, NPC nPC, @Flag(value={"pose"}) CamelPose camelPose) {
        CamelTrait camelTrait = nPC.getOrAddTrait(CamelTrait.class);
        String string = "";
        if (camelPose != null) {
            camelTrait.setPose(camelPose);
            string = string + Messaging.tr("citizens.commands.npc.camel.pose-set", new Object[]{camelPose});
        }
        if (!string.isEmpty()) {
            Messaging.send(commandSender, string);
        }
    }

    public static enum CamelPose {
        PANIC,
        SITTING,
        STANDING;

    }
}

