/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.versioned;

import net.citizensnpcs.api.command.Command;
import net.citizensnpcs.api.command.CommandContext;
import net.citizensnpcs.api.command.Flag;
import net.citizensnpcs.api.command.Requirements;
import net.citizensnpcs.api.command.exception.CommandException;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.util.Util;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Frog;

@TraitName(value="frogtrait")
public class FrogTrait
extends Trait {
    @Persist
    private Frog.Variant variant;

    public FrogTrait() {
        super("frogtrait");
    }

    public Frog.Variant getVariant() {
        return this.variant;
    }

    @Override
    public void run() {
        if (this.npc.isSpawned() && this.npc.getEntity() instanceof Frog && this.variant != null) {
            Frog frog = (Frog)this.npc.getEntity();
            frog.setVariant(this.variant);
        }
    }

    public void setVariant(Frog.Variant variant) {
        this.variant = variant;
    }

    @Command(aliases={"npc"}, usage="frog (--variant variant)", desc="", modifiers={"frog"}, min=1, max=1, permission="citizens.npc.frog")
    @Requirements(selected=true, ownership=true, types={EntityType.FROG})
    public static void frog(CommandContext commandContext, CommandSender commandSender, NPC nPC, @Flag(value={"variant"}) Frog.Variant variant) {
        FrogTrait frogTrait = nPC.getOrAddTrait(FrogTrait.class);
        String string = "";
        if (commandContext.hasValueFlag("variant")) {
            if (variant == null) {
                throw new CommandException("citizens.commands.npc.frog.invalid-variant", Util.listValuesPretty(Frog.Variant.values()));
            }
            frogTrait.setVariant(variant);
            string = string + Messaging.tr("citizens.commands.npc.frog.variant-set", Util.prettyEnum(variant));
        }
        if (!string.isEmpty()) {
            Messaging.send(commandSender, string);
        }
    }
}

