/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.versioned;

import net.citizensnpcs.api.command.Command;
import net.citizensnpcs.api.command.CommandContext;
import net.citizensnpcs.api.command.Requirements;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.util.Messaging;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Goat;

@TraitName(value="goattrait")
public class GoatTrait
extends Trait {
    @Persist
    private boolean leftHorn = true;
    @Persist
    private boolean rightHorn = true;
    private static boolean SUPPORTS_HORNS = true;

    public GoatTrait() {
        super("goattrait");
    }

    public boolean isLeftHorn() {
        return this.leftHorn;
    }

    public boolean isRightHorn() {
        return this.rightHorn;
    }

    @Override
    public void run() {
        if (this.npc.isSpawned() && this.npc.getEntity() instanceof Goat) {
            Goat goat = (Goat)this.npc.getEntity();
            if (SUPPORTS_HORNS) {
                try {
                    goat.setRightHorn(this.rightHorn);
                    goat.setLeftHorn(this.leftHorn);
                }
                catch (Throwable throwable) {
                    SUPPORTS_HORNS = false;
                }
            }
        }
    }

    public void setLeftHorn(boolean bl) {
        this.leftHorn = bl;
    }

    public void setRightHorn(boolean bl) {
        this.rightHorn = bl;
    }

    @Command(aliases={"npc"}, usage="goat -l(eft) -r(ight) -n(either) -b(oth) horn", desc="", modifiers={"goat"}, flags="lrnb", min=1, max=1, permission="citizens.npc.goat")
    @Requirements(selected=true, ownership=true, types={EntityType.GOAT})
    public static void goat(CommandContext commandContext, CommandSender commandSender, NPC nPC) {
        GoatTrait goatTrait = nPC.getOrAddTrait(GoatTrait.class);
        boolean bl = goatTrait.isLeftHorn();
        boolean bl2 = goatTrait.isRightHorn();
        if (commandContext.hasFlag('l')) {
            boolean bl3 = bl = !bl;
        }
        if (commandContext.hasFlag('r')) {
            boolean bl4 = bl2 = !bl2;
        }
        if (commandContext.hasFlag('b')) {
            bl2 = true;
            bl = true;
        }
        if (commandContext.hasFlag('n')) {
            bl2 = false;
            bl = false;
        }
        goatTrait.setLeftHorn(bl);
        goatTrait.setRightHorn(bl2);
        String string = Messaging.tr("citizens.commands.npc.goat.horns-set", nPC.getName(), bl, bl2);
        if (!string.isEmpty()) {
            Messaging.send(commandSender, string);
        }
    }
}

