/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.versioned;

import net.citizensnpcs.api.command.Command;
import net.citizensnpcs.api.command.CommandContext;
import net.citizensnpcs.api.command.Flag;
import net.citizensnpcs.api.command.Requirements;
import net.citizensnpcs.api.command.exception.CommandUsageException;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import org.bukkit.DyeColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Shulker;

@TraitName(value="shulkertrait")
public class ShulkerTrait
extends Trait {
    @Persist(value="color")
    private DyeColor color = DyeColor.PURPLE;
    private int lastPeekSet = 0;
    @Persist(value="peek")
    private int peek = 0;

    public ShulkerTrait() {
        super("shulkertrait");
    }

    public DyeColor getColor() {
        return this.color;
    }

    public int getPeek() {
        return this.peek;
    }

    @Override
    public void onSpawn() {
        this.setPeek(this.peek);
    }

    @Override
    public void run() {
        if (this.color == null) {
            this.color = DyeColor.PURPLE;
        }
        if (this.npc.getEntity() instanceof Shulker) {
            if (this.peek != this.lastPeekSet) {
                NMS.setPeekShulker(this.npc.getEntity(), this.peek);
                this.lastPeekSet = this.peek;
            }
            ((Shulker)this.npc.getEntity()).setColor(this.color);
        }
    }

    public void setColor(DyeColor dyeColor) {
        this.color = dyeColor;
    }

    public void setPeek(int n) {
        this.peek = n;
        this.lastPeekSet = -1;
    }

    @Command(aliases={"npc"}, usage="shulker (--peek [peek] --color [color])", desc="", modifiers={"shulker"}, min=1, max=1, permission="citizens.npc.shulker")
    @Requirements(selected=true, ownership=true, types={EntityType.SHULKER})
    public static void shulker(CommandContext commandContext, CommandSender commandSender, NPC nPC, @Flag(value={"peek"}) Integer n, @Flag(value={"color"}) DyeColor dyeColor) {
        ShulkerTrait shulkerTrait = nPC.getOrAddTrait(ShulkerTrait.class);
        boolean bl = false;
        if (n != null) {
            shulkerTrait.setPeek((byte)n.intValue());
            Messaging.sendTr(commandSender, "citizens.commands.npc.shulker.peek-set", nPC.getName(), n);
            bl = true;
        }
        if (commandContext.hasValueFlag("color")) {
            if (dyeColor == null) {
                Messaging.sendErrorTr(commandSender, "citizens.commands.npc.shulker.invalid-color", Util.listValuesPretty(DyeColor.values()));
                return;
            }
            shulkerTrait.setColor(dyeColor);
            Messaging.sendTr(commandSender, "citizens.commands.npc.shulker.color-set", nPC.getName(), Util.prettyEnum(dyeColor));
            bl = true;
        }
        if (!bl) {
            throw new CommandUsageException();
        }
    }
}

