/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.waypoint;

import ch.ethz.globis.phtree.PhTreeSolid;
import com.google.common.collect.ForwardingList;
import com.google.common.collect.Lists;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.ai.goals.WanderGoal;
import net.citizensnpcs.api.command.CommandContext;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.trait.waypoint.EntityMarkers;
import net.citizensnpcs.trait.waypoint.WaypointEditor;
import net.citizensnpcs.trait.waypoint.WaypointProvider;
import net.citizensnpcs.util.Util;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;

public class WanderWaypointProvider
implements WaypointProvider {
    private WanderGoal currentGoal;
    @Persist
    private int delay = -1;
    private NPC npc;
    @Persist
    private boolean pathfind = true;
    private boolean paused;
    @Persist
    private final List<Location> regionCentres = Lists.newArrayList();
    private PhTreeSolid<Boolean> tree = PhTreeSolid.create((int)3);
    @Persist
    private String worldguardRegion;
    private Object worldguardRegionCache;
    @Persist
    private int xrange = DEFAULT_XRANGE;
    @Persist
    private int yrange = DEFAULT_YRANGE;
    private static int DEFAULT_XRANGE = 25;
    private static int DEFAULT_YRANGE = 3;

    public void addRegionCentre(Location location) {
        this.regionCentres.add(location);
        this.recalculateTree();
    }

    public void addRegionCentres(Collection<Location> collection) {
        this.regionCentres.addAll(collection);
        this.recalculateTree();
    }

    @Override
    public WaypointEditor createEditor(final CommandSender commandSender, CommandContext commandContext) {
        return new WaypointEditor(){
            boolean editingRegions = false;
            EntityMarkers<Location> markers = new EntityMarkers();

            @Override
            public void begin() {
                Messaging.sendTr(commandSender, "citizens.editors.waypoints.wander.begin", WanderWaypointProvider.this.pathfind ? "<green>" : "<red>");
                WanderWaypointProvider.this.setPaused(true);
            }

            @Override
            public void end() {
                Messaging.sendTr(commandSender, "citizens.editors.waypoints.wander.end", new Object[0]);
                this.editingRegions = false;
                WanderWaypointProvider.this.setPaused(false);
                this.markers.destroyMarkers();
            }

            private String formatLoc(Location location) {
                return String.format("[[%d]], [[%d]], [[%d]]", location.getBlockX(), location.getBlockY(), location.getBlockZ());
            }

            @EventHandler(ignoreCancelled=true)
            public void onPlayerChat(AsyncPlayerChatEvent asyncPlayerChatEvent) {
                if (!asyncPlayerChatEvent.getPlayer().equals((Object)commandSender)) {
                    return;
                }
                String string = asyncPlayerChatEvent.getMessage().toLowerCase();
                if (string.startsWith("xrange") || string.startsWith("yrange")) {
                    asyncPlayerChatEvent.setCancelled(true);
                    int n = 0;
                    try {
                        n = Integer.parseInt(string.split(" ", 2)[1]);
                        if (n <= 0) {
                            n = 0;
                        }
                        if (string.startsWith("xrange")) {
                            WanderWaypointProvider.this.setXYRange(n, WanderWaypointProvider.this.yrange);
                        } else {
                            WanderWaypointProvider.this.setXYRange(WanderWaypointProvider.this.xrange, n);
                        }
                        WanderWaypointProvider.this.recalculateTree();
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), () -> Messaging.sendTr(commandSender, "citizens.editors.waypoints.wander.range-set", WanderWaypointProvider.this.xrange, WanderWaypointProvider.this.yrange));
                } else if (string.startsWith("regions")) {
                    asyncPlayerChatEvent.setCancelled(true);
                    this.editingRegions = !this.editingRegions;
                    Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), () -> {
                        if (this.editingRegions) {
                            for (Location location : WanderWaypointProvider.this.regionCentres) {
                                Entity entity = this.markers.createMarker(location, location);
                                entity.setMetadata("wandermarker", (MetadataValue)new FixedMetadataValue(CitizensAPI.getPlugin(), (Object)location));
                            }
                            Messaging.sendTr(commandSender, "citizens.editors.waypoints.wander.editing-regions", new Object[0]);
                        } else {
                            this.markers.destroyMarkers();
                            Messaging.sendTr(commandSender, "citizens.editors.waypoints.wander.editing-regions-stop", new Object[0]);
                        }
                    });
                } else if (string.startsWith("delay")) {
                    asyncPlayerChatEvent.setCancelled(true);
                    WanderWaypointProvider.this.setDelay(Util.parseTicks(string.split(" ")[1]));
                    Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), () -> Messaging.sendTr(commandSender, "citizens.editors.waypoints.wander.delay-set", WanderWaypointProvider.this.delay));
                } else if (string.startsWith("worldguardregion")) {
                    asyncPlayerChatEvent.setCancelled(true);
                    Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), () -> {
                        ProtectedRegion protectedRegion = null;
                        String string2 = string.replace("worldguardregion", "").trim();
                        try {
                            RegionManager regionManager = WorldGuard.getInstance().getPlatform().getRegionContainer().get(BukkitAdapter.adapt((World)WanderWaypointProvider.this.npc.getStoredLocation().getWorld()));
                            protectedRegion = regionManager.getRegion(string2);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        if (protectedRegion == null) {
                            Messaging.sendErrorTr(commandSender, "citizens.editors.waypoints.wander.worldguard-region-not-found", new Object[0]);
                            return;
                        }
                        WanderWaypointProvider.this.setWorldGuardRegion(string2);
                        Messaging.sendErrorTr(commandSender, "citizens.editors.waypoints.wander.worldguard-region-set", string2);
                    });
                } else if (string.startsWith("pathfind")) {
                    asyncPlayerChatEvent.setCancelled(true);
                    Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), () -> {
                        WanderWaypointProvider.this.pathfind = !WanderWaypointProvider.this.pathfind;
                        if (WanderWaypointProvider.this.currentGoal != null) {
                            WanderWaypointProvider.this.currentGoal.setPathfind(WanderWaypointProvider.this.pathfind);
                        }
                        this.begin();
                    });
                }
            }

            @EventHandler(ignoreCancelled=true)
            public void onPlayerInteract(PlayerInteractEvent playerInteractEvent) {
                if (!playerInteractEvent.getPlayer().equals((Object)commandSender) || playerInteractEvent.getAction() == Action.PHYSICAL || !WanderWaypointProvider.this.npc.isSpawned() || !this.editingRegions || playerInteractEvent.getPlayer().getWorld() != WanderWaypointProvider.this.npc.getEntity().getWorld() || Util.isOffHand(playerInteractEvent)) {
                    return;
                }
                if (playerInteractEvent.getAction() == Action.LEFT_CLICK_BLOCK || playerInteractEvent.getAction() == Action.LEFT_CLICK_AIR) {
                    if (playerInteractEvent.getClickedBlock() == null) {
                        return;
                    }
                    playerInteractEvent.setCancelled(true);
                    Location location = playerInteractEvent.getClickedBlock().getLocation().add(0.0, 1.0, 0.0);
                    if (!WanderWaypointProvider.this.regionCentres.contains(location)) {
                        WanderWaypointProvider.this.regionCentres.add(location);
                        Entity entity = this.markers.createMarker(location, location);
                        entity.setMetadata("wandermarker", (MetadataValue)new FixedMetadataValue(CitizensAPI.getPlugin(), (Object)location));
                        Messaging.sendTr(commandSender, "citizens.editors.waypoints.wander.added-region", this.formatLoc(location), WanderWaypointProvider.this.regionCentres.size());
                        WanderWaypointProvider.this.recalculateTree();
                    }
                }
            }

            @EventHandler(ignoreCancelled=true)
            public void onPlayerInteractEntity(PlayerInteractEntityEvent playerInteractEntityEvent) {
                if (!commandSender.equals((Object)playerInteractEntityEvent.getPlayer()) || !this.editingRegions || Util.isOffHand(playerInteractEntityEvent) || !playerInteractEntityEvent.getRightClicked().hasMetadata("wandermarker")) {
                    return;
                }
                WanderWaypointProvider.this.regionCentres.remove(((MetadataValue)playerInteractEntityEvent.getRightClicked().getMetadata("wandermarker").get(0)).value());
                this.markers.removeMarker((Location)((MetadataValue)playerInteractEntityEvent.getRightClicked().getMetadata("wandermarker").get(0)).value());
                Messaging.sendTr(commandSender, "citizens.editors.waypoints.wander.removed-region", this.formatLoc((Location)((MetadataValue)playerInteractEntityEvent.getRightClicked().getMetadata("wandermarker").get(0)).value()), WanderWaypointProvider.this.regionCentres.size());
                WanderWaypointProvider.this.recalculateTree();
            }
        };
    }

    public int getDelay() {
        return this.delay;
    }

    public List<Location> getRegionCentres() {
        return new RecalculateList();
    }

    public Object getWorldGuardRegion() {
        if (this.worldguardRegion == null) {
            return null;
        }
        if (this.worldguardRegionCache != null) {
            return this.worldguardRegionCache;
        }
        try {
            RegionManager regionManager = WorldGuard.getInstance().getPlatform().getRegionContainer().get(BukkitAdapter.adapt((World)this.npc.getStoredLocation().getWorld()));
            this.worldguardRegionCache = regionManager.getRegion(this.worldguardRegion);
            return this.worldguardRegionCache;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public int getXRange() {
        return this.xrange;
    }

    public int getYRange() {
        return this.yrange;
    }

    public boolean isPathfind() {
        return this.pathfind;
    }

    @Override
    public boolean isPaused() {
        return this.paused;
    }

    @Override
    public void load(DataKey dataKey) {
        this.recalculateTree();
    }

    @Override
    public void onRemove() {
        this.worldguardRegionCache = null;
        if (this.currentGoal == null) {
            return;
        }
        this.currentGoal.pause();
        this.npc.getDefaultGoalController().removeGoal(this.currentGoal);
        this.currentGoal = null;
    }

    @Override
    public void onSpawn(NPC nPC) {
        this.npc = nPC;
        if (this.currentGoal == null) {
            this.currentGoal = WanderGoal.builder(nPC).xrange(this.xrange).yrange(this.yrange).pathfind(this.pathfind).tree(() -> this.regionCentres.isEmpty() ? null : this.tree).delay(this.delay).worldguardRegion(this::getWorldGuardRegion).build();
            if (this.paused) {
                this.currentGoal.pause();
            }
        }
        Iterator iterator = nPC.getDefaultGoalController().iterator();
        while (iterator.hasNext()) {
            if (!(iterator.next() instanceof WanderGoal)) continue;
            iterator.remove();
        }
        nPC.getDefaultGoalController().addGoal(this.currentGoal, 1);
    }

    private void recalculateTree() {
        this.tree = PhTreeSolid.create((int)3);
        for (Location location : this.regionCentres) {
            long[] lArray = new long[]{location.getBlockX() - this.xrange, location.getBlockY() - this.yrange, location.getBlockZ() - this.xrange};
            long[] lArray2 = new long[]{location.getBlockX() + this.xrange, location.getBlockY() + this.yrange, location.getBlockZ() + this.xrange};
            this.tree.put(lArray, lArray2, (Object)true);
        }
    }

    public void removeRegionCentre(Location location) {
        this.regionCentres.remove(location);
        this.recalculateTree();
    }

    public void removeRegionCentres(Collection<Location> collection) {
        this.regionCentres.removeAll(collection);
        this.recalculateTree();
    }

    @Override
    public void save(DataKey dataKey) {
    }

    public void setDelay(int n) {
        this.delay = n;
        if (this.currentGoal != null) {
            this.currentGoal.setDelay(n);
        }
    }

    public void setPathfind(boolean bl) {
        this.pathfind = bl;
        if (this.currentGoal != null) {
            this.currentGoal.setPathfind(bl);
        }
    }

    @Override
    public void setPaused(boolean bl) {
        this.paused = bl;
        if (this.currentGoal != null) {
            if (bl) {
                this.currentGoal.pause();
            } else {
                this.currentGoal.unpause();
            }
        }
    }

    public void setWorldGuardRegion(String string) {
        this.worldguardRegion = string;
        this.worldguardRegionCache = null;
    }

    public void setXYRange(int n, int n2) {
        this.xrange = n;
        this.yrange = n2;
        if (this.currentGoal != null) {
            this.currentGoal.setXYRange(n, n2);
        }
    }

    private class RecalculateList
    extends ForwardingList<Location> {
        private RecalculateList() {
        }

        public void add(int n, Location location) {
            super.add(n, (Object)location);
            WanderWaypointProvider.this.recalculateTree();
        }

        public boolean add(Location location) {
            boolean bl = super.add((Object)location);
            WanderWaypointProvider.this.recalculateTree();
            return bl;
        }

        protected List<Location> delegate() {
            return WanderWaypointProvider.this.regionCentres;
        }

        public Location remove(int n) {
            Location location = (Location)super.remove(n);
            WanderWaypointProvider.this.recalculateTree();
            return location;
        }

        public Location set(int n, Location location) {
            Location location2 = (Location)super.set(n, (Object)location);
            WanderWaypointProvider.this.recalculateTree();
            return location2;
        }
    }
}

