/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.util;

import java.util.Objects;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;

public class ChunkCoord {
    public final UUID worldUUID;
    public final int x;
    public final int z;
    private static boolean SUPPORTS_FORCE_LOADED = true;

    public ChunkCoord(Chunk chunk) {
        this(chunk.getWorld().getUID(), chunk.getX(), chunk.getZ());
    }

    public ChunkCoord(Location location) {
        this(location.getWorld().getUID(), location.getBlockX() >> 4, location.getBlockZ() >> 4);
    }

    public ChunkCoord(UUID uUID, int n, int n2) {
        this.x = n;
        this.z = n2;
        this.worldUUID = uUID;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ChunkCoord chunkCoord = (ChunkCoord)object;
        if (!Objects.equals(this.worldUUID, chunkCoord.worldUUID)) {
            return false;
        }
        return this.x == chunkCoord.x && this.z == chunkCoord.z;
    }

    public Chunk getChunk() {
        World world = Bukkit.getWorld((UUID)this.worldUUID);
        return world != null ? world.getChunkAt(this.x, this.z) : null;
    }

    public int hashCode() {
        int n = 31;
        return 31 * (31 * (31 + (this.worldUUID == null ? 0 : this.worldUUID.hashCode())) + this.x) + this.z;
    }

    public void setForceLoaded(boolean bl) {
        Chunk chunk = this.getChunk();
        if (chunk != null && SUPPORTS_FORCE_LOADED) {
            try {
                chunk.setForceLoaded(bl);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                SUPPORTS_FORCE_LOADED = false;
            }
        }
    }

    public String toString() {
        return "[" + this.x + "," + this.z + "]";
    }
}

