/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.citizensnpcs.api.npc.AbstractNPC;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.trait.PacketNPC;
import net.citizensnpcs.util.NMS;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitRunnable;

public class PlayerUpdateTask
extends BukkitRunnable {
    private final List<PlayerTick> players = Lists.newArrayList();
    private final Set<UUID> uuids = Sets.newHashSet();
    private static List<Entity> PLAYERS_PENDING_ADD = new ArrayList<Entity>();
    private static List<Entity> PLAYERS_PENDING_REMOVE = new ArrayList<Entity>();

    public void cancel() {
        super.cancel();
        this.uuids.clear();
        this.players.clear();
    }

    public void run() {
        if (PLAYERS_PENDING_REMOVE.size() > 0) {
            this.players.removeIf(playerTick -> PLAYERS_PENDING_REMOVE.contains(((PlayerTick)playerTick).entity));
            for (Entity object : PLAYERS_PENDING_REMOVE) {
                this.uuids.remove(object.getUniqueId());
            }
            PLAYERS_PENDING_REMOVE.clear();
        }
        for (Entity entity : PLAYERS_PENDING_ADD) {
            NPC nPC = ((NPCHolder)entity).getNPC();
            if (this.uuids.contains(entity.getUniqueId())) {
                PlayerTick playerTick2 = null;
                Object object = this.players.iterator();
                while (object.hasNext()) {
                    PlayerTick playerTick3 = object.next();
                    if (!playerTick3.entity.getUniqueId().equals(entity.getUniqueId())) continue;
                    playerTick2 = playerTick3;
                    object.remove();
                    this.uuids.remove(playerTick3.entity.getUniqueId());
                    break;
                }
                object = ((NPCHolder)playerTick2.entity).getNPC();
                Messaging.severe(object == nPC ? "Player registered twice" : "Player registered twice with different NPC instances", playerTick2.entity.getUniqueId());
                playerTick2.entity.remove();
            }
            if (nPC.hasTrait(PacketNPC.class)) {
                this.players.add(new PlayerTick(entity, () -> ((AbstractNPC)nPC).update()));
            } else {
                this.players.add(new PlayerTick(entity, NMS.playerTicker((Player)entity)));
            }
            this.uuids.add(entity.getUniqueId());
        }
        PLAYERS_PENDING_ADD.clear();
        for (PlayerTick playerTick4 : this.players) {
            playerTick4.run();
        }
    }

    public static void deregisterPlayer(Entity entity) {
        PLAYERS_PENDING_ADD.remove(entity);
        PLAYERS_PENDING_REMOVE.add(entity);
    }

    public static void registerPlayer(Entity entity) {
        PLAYERS_PENDING_REMOVE.remove(entity);
        PLAYERS_PENDING_ADD.add(entity);
    }

    private static class PlayerTick
    implements Runnable {
        private final Entity entity;
        private final Runnable tick;

        public PlayerTick(Entity entity, Runnable runnable) {
            this.entity = entity;
            this.tick = runnable;
        }

        @Override
        public void run() {
            this.tick.run();
        }
    }
}

