/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.util;

import java.util.Random;
import java.util.concurrent.locks.ReentrantLock;

public class XORShiftRNG
extends Random {
    private final ReentrantLock lock = new ReentrantLock();
    private final byte[] seed = new byte[20];
    private int state1;
    private int state2;
    private int state3;
    private int state4;
    private int state5;
    private static final int BITWISE_BYTE_TO_INT = 255;
    private static Random SEED_GENERATOR = new Random();
    private static final int SEED_SIZE_BYTES = 20;
    private static final long serialVersionUID = -1843001897066722618L;

    public XORShiftRNG() {
        SEED_GENERATOR.nextBytes(this.seed);
        int[] nArray = XORShiftRNG.convertBytesToInts(this.seed);
        this.state1 = nArray[0];
        this.state2 = nArray[1];
        this.state3 = nArray[2];
        this.state4 = nArray[3];
        this.state5 = nArray[4];
    }

    public byte[] getSeed() {
        return (byte[])this.seed.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int next(int n) {
        try {
            this.lock.lock();
            int n2 = this.state1 ^ this.state1 >> 7;
            this.state1 = this.state2;
            this.state2 = this.state3;
            this.state3 = this.state4;
            this.state4 = this.state5;
            this.state5 = this.state5 ^ this.state5 << 6 ^ n2 ^ n2 << 13;
            int n3 = (this.state2 + this.state2 + 1) * this.state5;
            int n4 = n3 >>> 32 - n;
            return n4;
        }
        finally {
            this.lock.unlock();
        }
    }

    public static int convertBytesToInt(byte[] byArray, int n) {
        return 0xFF & byArray[n + 3] | (0xFF & byArray[n + 2]) << 8 | (0xFF & byArray[n + 1]) << 16 | (0xFF & byArray[n]) << 24;
    }

    public static int[] convertBytesToInts(byte[] byArray) {
        if (byArray.length % 4 != 0) {
            throw new IllegalArgumentException("Number of input bytes must be a multiple of 4.");
        }
        int[] nArray = new int[byArray.length / 4];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = XORShiftRNG.convertBytesToInt(byArray, i * 4);
        }
        return nArray;
    }
}

