/*
 * Decompiled with CFR 0.152.
 */
package ct.ajneb97.configs;

import ct.ajneb97.ComplexTurrets;
import ct.ajneb97.configs.TurretConfig;
import ct.ajneb97.model.estructura.CriticalHit;
import ct.ajneb97.model.estructura.ParticleEffect;
import ct.ajneb97.model.estructura.ShootType;
import ct.ajneb97.model.estructura.TargetType;
import ct.ajneb97.model.estructura.Turret;
import ct.ajneb97.model.estructura.TurretAttackPriority;
import ct.ajneb97.model.estructura.TurretCraft;
import ct.ajneb97.model.estructura.TurretEffect;
import ct.ajneb97.model.estructura.TurretItem;
import ct.ajneb97.model.estructura.TurretItemType;
import ct.ajneb97.model.estructura.TurretUpgrade;
import ct.ajneb97.model.estructura.UpgradeAction;
import ct.ajneb97.model.estructura.UpgradeItemCost;
import ct.ajneb97.utils.UtilsOthers;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.configuration.file.FileConfiguration;

public class TurretsConfigsManager {
    private ArrayList<TurretConfig> configTurrets;
    private ComplexTurrets plugin;
    private boolean firstTime;

    public TurretsConfigsManager(ComplexTurrets complexTurrets) {
        this.plugin = complexTurrets;
        this.firstTime = false;
        this.configTurrets = new ArrayList();
    }

    public void configurar() {
        this.createTurretsFolder();
        this.registerTurrets();
        this.checkAndFixTurrets();
        this.cargarTurrets();
    }

    public void createTurretsFolder() {
        try {
            File file = new File(this.plugin.getDataFolder() + File.separator + "turrets");
            if (!file.exists()) {
                this.firstTime = true;
                file.mkdirs();
                String string = "Burst.yml";
                TurretConfig turretConfig = new TurretConfig(string, this.plugin);
                turretConfig.registerTurretConfig(false);
                string = "Siege.yml";
                turretConfig = new TurretConfig(string, this.plugin);
                turretConfig.registerTurretConfig(false);
                string = "Healing.yml";
                turretConfig = new TurretConfig(string, this.plugin);
                turretConfig.registerTurretConfig(false);
                string = "Slowness.yml";
                turretConfig = new TurretConfig(string, this.plugin);
                turretConfig.registerTurretConfig(false);
            }
        }
        catch (SecurityException securityException) {
            Object var1_2 = null;
        }
    }

    public void checkAndFixTurrets() {
        if (this.firstTime && UtilsOthers.isLegacy()) {
            for (TurretConfig turretConfig : this.configTurrets) {
                List list;
                FileConfiguration fileConfiguration = turretConfig.getConfig();
                String string = turretConfig.getPath();
                if (string.equals("Burst.yml")) {
                    list = fileConfiguration.getStringList("turret.structure");
                    list.set(1, "STAINED_CLAY:9");
                    fileConfiguration.set("turret.structure", (Object)list);
                    fileConfiguration.set("turret.effects.shoot_effect.sound", (Object)"FIREWORK_BLAST;1;1.7");
                } else if (string.equals("Siege.yml")) {
                    list = fileConfiguration.getStringList("turret.structure");
                    list.set(1, "HARD_CLAY");
                    fileConfiguration.set("turret.structure", (Object)list);
                    fileConfiguration.set("turret.effects.shoot_effect.sound", (Object)"CREEPER_DEATH;1;0.3");
                    fileConfiguration.set("turret.effects.impact_effect.sound", (Object)"EXPLODE;1;0.4");
                    fileConfiguration.set("items.ammunition.id", (Object)"SULPHUR");
                } else if (string.equals("Healing.yml")) {
                    list = fileConfiguration.getStringList("turret.structure");
                    list.set(1, "STAINED_CLAY:11");
                    fileConfiguration.set("turret.structure", (Object)list);
                    fileConfiguration.set("turret.effects.shoot_effect.sound", (Object)"BLAZE_DEATH;1;2");
                } else if (string.equals("Slowness.yml")) {
                    list = fileConfiguration.getStringList("turret.structure");
                    list.set(1, "STAINED_GLASS_PANE:10");
                    list.set(2, "STAINED_CLAY:10");
                    fileConfiguration.set("turret.structure", (Object)list);
                    fileConfiguration.set("turret.effects.shoot_effect.sound", (Object)"NOTE_PLING;1;2");
                    fileConfiguration.set("turret.effects.impact_effect.list_of_effects.effect1.particle", (Object)"FIREWORKS_SPARK");
                    fileConfiguration.set("items.ammunition.id", (Object)"INK_SACK:5");
                    fileConfiguration.set("items.block.id", (Object)"STAINED_CLAY:10");
                }
                turretConfig.saveTurretConfig();
            }
            this.firstTime = false;
        }
    }

    public void registerTurrets() {
        String string = this.plugin.getDataFolder() + File.separator + "turrets";
        File file = new File(string);
        File[] fileArray = file.listFiles();
        int n = 0;
        while (n < fileArray.length) {
            if (fileArray[n].isFile()) {
                String string2 = fileArray[n].getName();
                TurretConfig turretConfig = new TurretConfig(string2, this.plugin);
                if (string2.equals("Burst.yml") || string2.equals("Siege.yml") || string2.equals("Healing.yml") || string2.equals("Slowness.yml")) {
                    turretConfig.registerTurretConfig(false);
                } else {
                    turretConfig.registerTurretConfig(true);
                }
                this.configTurrets.add(turretConfig);
            }
            ++n;
        }
    }

    public boolean archivoYaRegistrado(String string) {
        int n = 0;
        while (n < this.configTurrets.size()) {
            if (this.configTurrets.get(n).getPath().equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public TurretConfig getConfigTurrets(String string) {
        int n = 0;
        while (n < this.configTurrets.size()) {
            if (this.configTurrets.get(n).getPath().equals(string)) {
                return this.configTurrets.get(n);
            }
            ++n;
        }
        return null;
    }

    public void reloadTurrets() {
        this.configTurrets = new ArrayList();
        this.configurar();
    }

    public ArrayList<TurretConfig> getConfigTurrets() {
        return this.configTurrets;
    }

    public void cargarTurrets() {
        ArrayList<Turret> arrayList = new ArrayList<Turret>();
        for (TurretConfig turretConfig : this.configTurrets) {
            FileConfiguration fileConfiguration = turretConfig.getConfig();
            String string = turretConfig.getPath().replace(".yml", "");
            String string2 = fileConfiguration.getString("turret.alias");
            List list = fileConfiguration.getStringList("turret.structure");
            ShootType shootType = ShootType.valueOf(fileConfiguration.getString("turret.shoot_type"));
            TargetType targetType = TargetType.valueOf(fileConfiguration.getString("turret.target"));
            double d = 0.0;
            if (fileConfiguration.contains("turret.hologram_vertical_offset")) {
                d = fileConfiguration.getDouble("turret.hologram_vertical_offset");
            }
            int n = 0;
            if (fileConfiguration.contains("turret.activation_delay")) {
                n = fileConfiguration.getInt("turret.activation_delay");
            }
            boolean bl = false;
            if (fileConfiguration.contains("turret.shoot_through_liquids")) {
                bl = fileConfiguration.getBoolean("turret.shoot_through_liquids");
            }
            String string3 = "turret.effects.shoot_effect";
            double d2 = 0.0;
            if (fileConfiguration.contains(String.valueOf(string3) + ".separation")) {
                d2 = fileConfiguration.getDouble(String.valueOf(string3) + ".separation");
            }
            int n2 = 0;
            if (fileConfiguration.contains(String.valueOf(string3) + ".amount")) {
                n2 = fileConfiguration.getInt(String.valueOf(string3) + ".amount");
            }
            String string4 = null;
            if (fileConfiguration.contains(String.valueOf(string3) + ".sound")) {
                string4 = fileConfiguration.getString(String.valueOf(string3) + ".sound");
            }
            double d3 = 20.0;
            if (fileConfiguration.contains(String.valueOf(string3) + ".parabolic_separation")) {
                d3 = fileConfiguration.getDouble(String.valueOf(string3) + ".parabolic_separation");
            }
            double d4 = 0.1;
            if (fileConfiguration.contains(String.valueOf(string3) + ".parabolic_speed")) {
                d4 = fileConfiguration.getDouble(String.valueOf(string3) + ".parabolic_speed");
            }
            ArrayList<ParticleEffect> arrayList2 = this.getParticleEffects(fileConfiguration, string3);
            TurretEffect turretEffect = new TurretEffect(d2, n2, arrayList2, string4, d4, d3);
            TurretEffect turretEffect2 = null;
            string3 = "turret.effects.impact_effect";
            if (fileConfiguration.contains(string3)) {
                string4 = null;
                if (fileConfiguration.contains(String.valueOf(string3) + ".sound")) {
                    string4 = fileConfiguration.getString(String.valueOf(string3) + ".sound");
                }
                ArrayList<ParticleEffect> arrayList3 = this.getParticleEffects(fileConfiguration, string3);
                turretEffect2 = new TurretEffect(0.0, 0, arrayList3, string4, 0.0, 0.0);
            }
            int n3 = fileConfiguration.getInt("turret.health_recovery");
            double d5 = 2.0;
            if (fileConfiguration.contains("turret.min_attack_distance")) {
                d5 = fileConfiguration.getDouble("turret.min_attack_distance");
            }
            boolean bl2 = fileConfiguration.getBoolean("turret.require_ammunition");
            ArrayList<TurretUpgrade> arrayList4 = new ArrayList<TurretUpgrade>();
            ArrayList<TurretItem> arrayList5 = new ArrayList<TurretItem>();
            TurretCraft turretCraft = null;
            TurretCraft turretCraft2 = null;
            List list2 = fileConfiguration.getStringList("hologram");
            List list3 = fileConfiguration.getStringList("hit_hologram");
            List list4 = null;
            if (fileConfiguration.contains("hit_hologram_critical_hit")) {
                list4 = fileConfiguration.getStringList("hit_hologram_critical_hit");
            }
            for (String string5 : fileConfiguration.getConfigurationSection("turret.upgrades").getKeys(false)) {
                Object object;
                double d6;
                String string6;
                String string7;
                Object object22;
                double d7 = fileConfiguration.getDouble("turret.upgrades." + string5 + ".speed");
                double d8 = fileConfiguration.getDouble("turret.upgrades." + string5 + ".range");
                int n4 = 0;
                double d9 = 0.0;
                double d10 = 0.0;
                double d11 = 0.0;
                double d12 = 0.0;
                int n5 = 0;
                int n6 = 0;
                int n7 = 1;
                double d13 = 0.0;
                int n8 = 0;
                String string8 = null;
                double d14 = 0.0;
                ArrayList<UpgradeAction> arrayList6 = new ArrayList<UpgradeAction>();
                ArrayList<UpgradeItemCost> arrayList7 = new ArrayList<UpgradeItemCost>();
                TurretItem turretItem = null;
                TurretItem turretItem2 = null;
                CriticalHit criticalHit = null;
                if (fileConfiguration.contains("turret.upgrades." + string5 + ".accuracy")) {
                    n4 = fileConfiguration.getInt("turret.upgrades." + string5 + ".accuracy");
                }
                if (fileConfiguration.contains("turret.upgrades." + string5 + ".min_damage")) {
                    d9 = fileConfiguration.getDouble("turret.upgrades." + string5 + ".min_damage");
                }
                if (fileConfiguration.contains("turret.upgrades." + string5 + ".max_damage")) {
                    d10 = fileConfiguration.getDouble("turret.upgrades." + string5 + ".max_damage");
                }
                if (fileConfiguration.contains("turret.upgrades." + string5 + ".min_heal")) {
                    d11 = fileConfiguration.getDouble("turret.upgrades." + string5 + ".min_heal");
                }
                if (fileConfiguration.contains("turret.upgrades." + string5 + ".max_heal")) {
                    d12 = fileConfiguration.getDouble("turret.upgrades." + string5 + ".max_heal");
                }
                if (fileConfiguration.contains("turret.upgrades." + string5 + ".health")) {
                    n5 = fileConfiguration.getInt("turret.upgrades." + string5 + ".health");
                }
                if (fileConfiguration.contains("turret.upgrades." + string5 + ".money_cost")) {
                    n6 = fileConfiguration.getInt("turret.upgrades." + string5 + ".money_cost");
                }
                if (fileConfiguration.contains("turret.upgrades." + string5 + ".max_targets")) {
                    n7 = fileConfiguration.getInt("turret.upgrades." + string5 + ".max_targets");
                }
                if (fileConfiguration.contains("turret.upgrades." + string5 + ".splash_radius")) {
                    d13 = fileConfiguration.getDouble("turret.upgrades." + string5 + ".splash_radius");
                }
                if (fileConfiguration.contains("turret.upgrades." + string5 + ".entity_damage_reduction")) {
                    string8 = fileConfiguration.getString("turret.upgrades." + string5 + ".entity_damage_reduction");
                }
                if (fileConfiguration.contains("turret.upgrades." + string5 + ".shield_reduction")) {
                    d14 = fileConfiguration.getDouble("turret.upgrades." + string5 + ".shield_reduction");
                }
                if (fileConfiguration.contains("turret.upgrades." + string5 + ".max_ammo")) {
                    n8 = fileConfiguration.getInt("turret.upgrades." + string5 + ".max_ammo");
                }
                if (fileConfiguration.contains("turret.upgrades." + string5 + ".actions")) {
                    for (Object object22 : fileConfiguration.getConfigurationSection("turret.upgrades." + string5 + ".actions").getKeys(false)) {
                        string7 = "turret.upgrades." + string5 + ".actions." + (String)object22;
                        string6 = fileConfiguration.getString(String.valueOf(string7) + ".type");
                        int n9 = fileConfiguration.getInt(String.valueOf(string7) + ".duration");
                        d6 = fileConfiguration.getDouble(String.valueOf(string7) + ".probability");
                        object = new UpgradeAction((String)object22, string6, n9, d6);
                        arrayList6.add((UpgradeAction)object);
                    }
                }
                if (fileConfiguration.contains("turret.upgrades." + string5 + ".item_cost")) {
                    for (Object object22 : fileConfiguration.getConfigurationSection("turret.upgrades." + string5 + ".item_cost").getKeys(false)) {
                        string7 = "turret.upgrades." + string5 + ".item_cost." + (String)object22;
                        string6 = fileConfiguration.getString(String.valueOf(string7) + ".id");
                        String string9 = fileConfiguration.getString(String.valueOf(string7) + ".message_displayname");
                        int n10 = fileConfiguration.getInt(String.valueOf(string7) + ".amount");
                        String string10 = null;
                        object = null;
                        if (fileConfiguration.contains(String.valueOf(string7) + ".name")) {
                            string10 = fileConfiguration.getString(String.valueOf(string7) + ".name");
                        }
                        if (fileConfiguration.contains(String.valueOf(string7) + ".lore")) {
                            object = fileConfiguration.getStringList(String.valueOf(string7) + ".lore");
                        }
                        UpgradeItemCost upgradeItemCost = new UpgradeItemCost((String)object22, string6, string9, n10, string10, (List<String>)object);
                        arrayList7.add(upgradeItemCost);
                    }
                }
                if (fileConfiguration.contains("turret.upgrades." + string5 + ".critical_hit")) {
                    object22 = "turret.upgrades." + string5 + ".critical_hit";
                    double d15 = fileConfiguration.getDouble(String.valueOf(object22) + ".chance");
                    double d16 = 0.0;
                    d6 = 0.0;
                    double d17 = 0.0;
                    double d18 = 0.0;
                    if (fileConfiguration.contains(String.valueOf(object22) + ".min_damage")) {
                        d16 = fileConfiguration.getDouble(String.valueOf(object22) + ".min_damage");
                    }
                    if (fileConfiguration.contains(String.valueOf(object22) + ".max_damage")) {
                        d6 = fileConfiguration.getDouble(String.valueOf(object22) + ".max_damage");
                    }
                    if (fileConfiguration.contains(String.valueOf(object22) + ".min_heal")) {
                        d17 = fileConfiguration.getDouble(String.valueOf(object22) + ".min_heal");
                    }
                    if (fileConfiguration.contains(String.valueOf(object22) + ".max_heal")) {
                        d18 = fileConfiguration.getDouble(String.valueOf(object22) + ".max_heal");
                    }
                    criticalHit = new CriticalHit(d15, d16, d6, d17, d18);
                }
                turretItem = this.setTurretUpgradeItem(fileConfiguration, "turret.upgrades." + string5 + ".custom_upgrade_item", TurretItemType.UPGRADE);
                turretItem2 = this.setTurretUpgradeItem(fileConfiguration, "turret.upgrades." + string5 + ".custom_block_item", TurretItemType.BLOCK);
                object22 = new TurretUpgrade(Integer.valueOf(string5), d7, d8, d9, d10, n4, n5, n6, n7, d13, d11, d12, string8, d14, arrayList6, arrayList7, turretItem, turretItem2, criticalHit, n8);
                arrayList4.add((TurretUpgrade)object22);
            }
            this.addTurretItem(fileConfiguration, "items", arrayList5);
            this.addTurretItem(fileConfiguration, "inventory", arrayList5);
            boolean bl3 = fileConfiguration.getBoolean("turret.default_options.attack_players");
            boolean bl4 = fileConfiguration.getBoolean("turret.default_options.attack_monsters");
            boolean bl5 = fileConfiguration.getBoolean("turret.default_options.attack_animals");
            boolean bl6 = fileConfiguration.getBoolean("turret.default_options.attack_others");
            boolean bl7 = false;
            if (fileConfiguration.contains("turret.default_options.enabled")) {
                bl7 = fileConfiguration.getBoolean("turret.default_options.enabled");
            }
            TurretAttackPriority turretAttackPriority = TurretAttackPriority.CLOSEST;
            if (fileConfiguration.contains("turret.default_options.priority")) {
                turretAttackPriority = TurretAttackPriority.valueOf(fileConfiguration.getString("turret.default_options.priority"));
            }
            Turret turret = new Turret(string, string2, list, shootType, targetType, turretEffect, turretEffect2, arrayList4, arrayList5, turretCraft, turretCraft2, bl2, list2, list3, n3, bl3, bl4, bl5, bl6, turretAttackPriority, d, list4, bl7, d5, n, bl);
            arrayList.add(turret);
        }
        this.plugin.getTurretsManager().setTurrets(arrayList);
    }

    private void addTurretItem(FileConfiguration fileConfiguration, String string, ArrayList<TurretItem> arrayList) {
        for (String string2 : fileConfiguration.getConfigurationSection(string).getKeys(false)) {
            String string3 = fileConfiguration.getString(String.valueOf(string) + "." + string2 + ".id");
            String string4 = fileConfiguration.getString(String.valueOf(string) + "." + string2 + ".name");
            List list = fileConfiguration.getStringList(String.valueOf(string) + "." + string2 + ".lore");
            int n = 0;
            if (fileConfiguration.contains(String.valueOf(string) + "." + string2 + ".custom_model_data")) {
                n = fileConfiguration.getInt(String.valueOf(string) + "." + string2 + ".custom_model_data");
            }
            TurretItem turretItem = new TurretItem(string3, string4, list, TurretItemType.valueOf(string2.toUpperCase()), n);
            arrayList.add(turretItem);
        }
    }

    private TurretItem setTurretUpgradeItem(FileConfiguration fileConfiguration, String string, TurretItemType turretItemType) {
        if (fileConfiguration.contains(string)) {
            String string2 = fileConfiguration.getString(String.valueOf(string) + ".id");
            String string3 = fileConfiguration.getString(String.valueOf(string) + ".name");
            List list = fileConfiguration.getStringList(String.valueOf(string) + ".lore");
            int n = 0;
            if (fileConfiguration.contains(String.valueOf(string) + ".custom_model_data")) {
                n = fileConfiguration.getInt(String.valueOf(string) + ".custom_model_data");
            }
            return new TurretItem(string2, string3, list, turretItemType, n);
        }
        return null;
    }

    private ArrayList<ParticleEffect> getParticleEffects(FileConfiguration fileConfiguration, String string) {
        ArrayList<ParticleEffect> arrayList = new ArrayList<ParticleEffect>();
        if (fileConfiguration.contains(String.valueOf(string) + ".list_of_effects")) {
            for (String string2 : fileConfiguration.getConfigurationSection(String.valueOf(string) + ".list_of_effects").getKeys(false)) {
                String string3 = fileConfiguration.getString(String.valueOf(string) + ".list_of_effects." + string2 + ".particle");
                double d = 0.0;
                double d2 = 0.0;
                if (fileConfiguration.contains(String.valueOf(string) + ".list_of_effects." + string2 + ".offset_horizontal")) {
                    d = fileConfiguration.getDouble(String.valueOf(string) + ".list_of_effects." + string2 + ".offset_horizontal");
                }
                if (fileConfiguration.contains(String.valueOf(string) + ".list_of_effects." + string2 + ".offset_vertical")) {
                    d2 = fileConfiguration.getDouble(String.valueOf(string) + ".list_of_effects." + string2 + ".offset_vertical");
                }
                double d3 = fileConfiguration.getDouble(String.valueOf(string) + ".list_of_effects." + string2 + ".speed");
                ParticleEffect particleEffect = new ParticleEffect(string3, d, d2, d3);
                arrayList.add(particleEffect);
            }
        }
        return arrayList;
    }
}

