/*
 * Decompiled with CFR 0.152.
 */
package ct.ajneb97.listeners;

import ct.ajneb97.ComplexTurrets;
import ct.ajneb97.api.TurretPlaceEvent;
import ct.ajneb97.api.TurretRightClickEvent;
import ct.ajneb97.configs.MainConfigManager;
import ct.ajneb97.managers.InventoryManager;
import ct.ajneb97.managers.ItemManager;
import ct.ajneb97.managers.JugadorManager;
import ct.ajneb97.managers.MensajesManager;
import ct.ajneb97.managers.TurretsManager;
import ct.ajneb97.model.PlayerHologram;
import ct.ajneb97.model.PlayerTurret;
import ct.ajneb97.model.estructura.Turret;
import ct.ajneb97.model.others.SavedTurretProperties;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class JugadorListener
implements Listener {
    private ComplexTurrets plugin;

    public JugadorListener(ComplexTurrets complexTurrets) {
        this.plugin = complexTurrets;
    }

    @EventHandler
    public void placeTurret(BlockPlaceEvent blockPlaceEvent) {
        ItemStack itemStack = blockPlaceEvent.getItemInHand();
        final Location location = blockPlaceEvent.getBlock().getLocation();
        final Player player = blockPlaceEvent.getPlayer();
        if (blockPlaceEvent.isCancelled()) {
            return;
        }
        if (itemStack != null && !itemStack.getType().equals((Object)Material.AIR) && itemStack.hasItemMeta()) {
            MensajesManager mensajesManager = this.plugin.getMensajesManager();
            FileConfiguration fileConfiguration = this.plugin.getMessages();
            final TurretsManager turretsManager = this.plugin.getTurretsManager();
            String string = ItemManager.getTagStringItem(itemStack, "complex_turrets_turret_id");
            if (string == null) {
                return;
            }
            final Turret turret = turretsManager.getTurret(string);
            if (turret == null) {
                return;
            }
            blockPlaceEvent.setCancelled(true);
            if (!Bukkit.getVersion().contains("1.8") && !blockPlaceEvent.getHand().equals((Object)EquipmentSlot.HAND)) {
                mensajesManager.enviarMensaje((CommandSender)player, fileConfiguration.getString("placeTurretMainHand"), true);
                return;
            }
            if (!this.plugin.getVerifyManager().verifyPlaceTurret(turret, player, location, mensajesManager, fileConfiguration)) {
                return;
            }
            if (this.plugin.isPluginDisabled() && (player.isOp() || player.hasPermission("complexturrets.admin"))) {
                mensajesManager.enviarMensaje((CommandSender)player, fileConfiguration.getString("pluginDisabledError"), true);
                return;
            }
            TurretPlaceEvent turretPlaceEvent = new TurretPlaceEvent(player, turret, location);
            this.plugin.getServer().getPluginManager().callEvent((Event)turretPlaceEvent);
            if (turretPlaceEvent.isCancelled()) {
                return;
            }
            final int n = ItemManager.getTagIntItem(itemStack, "complex_turrets_turret_level");
            String string2 = ItemManager.getTagStringItem(itemStack, "complex_turrets_turret_attack_animals");
            String string3 = ItemManager.getTagStringItem(itemStack, "complex_turrets_turret_attack_monsters");
            String string4 = ItemManager.getTagStringItem(itemStack, "complex_turrets_turret_attack_others");
            String string5 = ItemManager.getTagStringItem(itemStack, "complex_turrets_turret_attack_players");
            String string6 = ItemManager.getTagStringItem(itemStack, "complex_turrets_turret_priority");
            String string7 = ItemManager.getTagStringItem(itemStack, "complex_turrets_turret_whitelist");
            final SavedTurretProperties savedTurretProperties = SavedTurretProperties.createPropertiesFromStrings(string2, string3, string4, string5, string6, string7);
            ItemStack itemStack2 = itemStack.clone();
            itemStack2.setAmount(1);
            player.getInventory().removeItem(new ItemStack[]{itemStack2});
            new BukkitRunnable(){

                public void run() {
                    turretsManager.createTurret(player, turret, n, location, savedTurretProperties);
                }
            }.runTaskLater((Plugin)this.plugin, 2L);
            mensajesManager.enviarMensaje((CommandSender)player, fileConfiguration.getString("turretCreated"), true);
        }
    }

    @EventHandler
    public void clickTurret(PlayerInteractEvent playerInteractEvent) {
        Player player = playerInteractEvent.getPlayer();
        Block block = playerInteractEvent.getClickedBlock();
        if (block != null && !block.getType().equals((Object)Material.AIR) && playerInteractEvent.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK)) {
            Location location = block.getLocation();
            PlayerTurret playerTurret = this.plugin.getJugadorManager().getTurretFromLocation(location);
            if (playerTurret != null) {
                playerInteractEvent.setCancelled(true);
                if (!Bukkit.getVersion().contains("1.8") && !playerInteractEvent.getHand().equals((Object)EquipmentSlot.HAND)) {
                    return;
                }
                MensajesManager mensajesManager = this.plugin.getMensajesManager();
                FileConfiguration fileConfiguration = this.plugin.getMessages();
                if (!this.plugin.getVerifyManager().canOpenTurret(player, playerTurret)) {
                    mensajesManager.enviarMensaje((CommandSender)player, fileConfiguration.getString("notYourTurret"), true);
                    return;
                }
                InventoryManager inventoryManager = this.plugin.getInventoryManager();
                if (inventoryManager.getPlayerInventory(playerTurret) != null) {
                    mensajesManager.enviarMensaje((CommandSender)player, fileConfiguration.getString("turretInventoryAlreadyInUse"), true);
                    return;
                }
                if (this.plugin.isPluginDisabled() && (player.isOp() || player.hasPermission("complexturrets.admin"))) {
                    mensajesManager.enviarMensaje((CommandSender)player, fileConfiguration.getString("pluginDisabledError"), true);
                    return;
                }
                TurretRightClickEvent turretRightClickEvent = new TurretRightClickEvent(player, playerTurret);
                this.plugin.getServer().getPluginManager().callEvent((Event)turretRightClickEvent);
                if (turretRightClickEvent.isCancelled()) {
                    return;
                }
                inventoryManager.openInventory(player, playerTurret, inventoryManager.getInventoryByName("main"), null);
                mensajesManager.enviarMensaje((CommandSender)player, fileConfiguration.getString("openingTurretInventory"), true);
            }
        }
    }

    @EventHandler
    public void breakTurret(BlockBreakEvent blockBreakEvent) {
        PlayerTurret playerTurret;
        if (blockBreakEvent.isCancelled()) {
            return;
        }
        Location location = blockBreakEvent.getBlock().getLocation();
        Player player = blockBreakEvent.getPlayer();
        if (!blockBreakEvent.getBlock().getType().equals((Object)Material.AIR) && (playerTurret = this.plugin.getJugadorManager().getTurretFromLocation(location)) != null) {
            blockBreakEvent.setCancelled(true);
            MensajesManager mensajesManager = this.plugin.getMensajesManager();
            FileConfiguration fileConfiguration = this.plugin.getMessages();
            mensajesManager.enviarMensaje((CommandSender)player, fileConfiguration.getString("cantBreakTurret"), true);
        }
    }

    @EventHandler
    public void seeTurret(PlayerMoveEvent playerMoveEvent) {
        final Player player = playerMoveEvent.getPlayer();
        try {
            Block block = player.getTargetBlock(null, 5);
            final JugadorManager jugadorManager = this.plugin.getJugadorManager();
            if (block != null && !block.getType().equals((Object)Material.AIR)) {
                if (this.plugin.isPluginDisabled()) {
                    return;
                }
                MainConfigManager mainConfigManager = this.plugin.getConfigsManager().getMainConfigManager();
                if (!mainConfigManager.isInformationHolograms() || mainConfigManager.isInformationHologramsAlwaysVisible()) {
                    return;
                }
                final Location location = block.getLocation();
                new BukkitRunnable(){

                    public void run() {
                        final PlayerTurret playerTurret = jugadorManager.getTurretFromLocation(location);
                        if (playerTurret != null) {
                            new BukkitRunnable(){

                                public void run() {
                                    PlayerHologram playerHologram = jugadorManager.getPlayerHologram(player);
                                    if (playerHologram == null) {
                                        JugadorListener.this.plugin.getDependencyManager().getHologramsManager().createInformationHologram(player, playerTurret);
                                    }
                                }
                            }.runTask((Plugin)JugadorListener.this.plugin);
                            return;
                        }
                        new BukkitRunnable(){

                            public void run() {
                                JugadorListener.this.plugin.getDependencyManager().getHologramsManager().removeInformationHologram(player, null);
                            }
                        }.runTask((Plugin)JugadorListener.this.plugin);
                    }
                }.runTaskAsynchronously((Plugin)this.plugin);
                return;
            }
            this.plugin.getDependencyManager().getHologramsManager().removeInformationHologram(player, null);
        }
        catch (Exception exception) {
            return;
        }
    }

    @EventHandler
    public void quitServer(PlayerQuitEvent playerQuitEvent) {
        Player player = playerQuitEvent.getPlayer();
        this.plugin.getDependencyManager().getHologramsManager().removeInformationHologram(player, null);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void playerDeathByTurret(PlayerDeathEvent playerDeathEvent) {
        Player player = playerDeathEvent.getEntity();
        if (player.hasMetadata("complexturrets_damaged")) {
            PlayerTurret playerTurret = (PlayerTurret)((MetadataValue)player.getMetadata("complexturrets_damaged").get(0)).value();
            FileConfiguration fileConfiguration = this.plugin.getMessages();
            String string = this.plugin.getTurretsManager().getTurret(playerTurret.getTurretName()).getAlias();
            String string2 = fileConfiguration.getString("playerDeathByTurret").replace("%player%", player.getName()).replace("%killer%", playerTurret.getOwnerName()).replace("%turret_alias%", string);
            playerDeathEvent.setDeathMessage(MensajesManager.getMensajeColor(string2));
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void placeBlock(BlockPlaceEvent blockPlaceEvent) {
        if (blockPlaceEvent.isCancelled()) {
            return;
        }
        Block block = blockPlaceEvent.getBlock();
        Player player = blockPlaceEvent.getPlayer();
        if (this.plugin.getVerifyManager().isBlockNearbyTurret(block)) {
            blockPlaceEvent.setCancelled(true);
            MensajesManager mensajesManager = this.plugin.getMensajesManager();
            FileConfiguration fileConfiguration = this.plugin.getMessages();
            int n = this.plugin.getConfigsManager().getMainConfigManager().getTurretBlocksNearbyMinDistance();
            mensajesManager.enviarMensaje((CommandSender)player, fileConfiguration.getString("placeBlockTurretNearby").replace("%distance%", String.valueOf(n)), true);
        }
    }
}

