/*
 * Decompiled with CFR 0.152.
 */
package ct.ajneb97.listeners;

import ct.ajneb97.ComplexTurrets;
import ct.ajneb97.api.TurretHitByArrowEvent;
import ct.ajneb97.managers.ItemManager;
import ct.ajneb97.model.PlayerTurret;
import ct.ajneb97.utils.UtilsMath;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.BlockIterator;

public class OtherTurretsListener
implements Listener {
    private ComplexTurrets plugin;

    public OtherTurretsListener(ComplexTurrets complexTurrets) {
        this.plugin = complexTurrets;
    }

    @EventHandler
    public void blockPistonExtend(BlockPistonExtendEvent blockPistonExtendEvent) {
        List list = blockPistonExtendEvent.getBlocks();
        for (Block block : list) {
            PlayerTurret playerTurret;
            if (block == null || (playerTurret = this.plugin.getJugadorManager().getTurretFromLocation(block.getLocation())) == null) continue;
            blockPistonExtendEvent.setCancelled(true);
            return;
        }
    }

    @EventHandler
    public void blockPistonRetract(BlockPistonRetractEvent blockPistonRetractEvent) {
        List list = blockPistonRetractEvent.getBlocks();
        for (Block block : list) {
            PlayerTurret playerTurret;
            if (block == null || (playerTurret = this.plugin.getJugadorManager().getTurretFromLocation(block.getLocation())) == null) continue;
            blockPistonRetractEvent.setCancelled(true);
            return;
        }
    }

    @EventHandler
    public void preventHeadDestroy(BlockFromToEvent blockFromToEvent) {
        PlayerTurret playerTurret;
        Block block = blockFromToEvent.getToBlock();
        String string = block.getType().name();
        if ((string.contains("PLAYER_HEAD") || string.contains("SKULL_ITEM") || string.contains("SKULL")) && (playerTurret = this.plugin.getJugadorManager().getTurretFromLocation(block.getLocation())) != null) {
            blockFromToEvent.setCancelled(true);
        }
    }

    @EventHandler
    public void preventHeadDestroy(PlayerInteractEvent playerInteractEvent) {
        PlayerTurret playerTurret;
        String string;
        Block block = playerInteractEvent.getClickedBlock();
        ItemStack itemStack = playerInteractEvent.getItem();
        if (!Bukkit.getVersion().contains("1.8") && !Bukkit.getVersion().contains("1.9") && playerInteractEvent.getAction().equals((Object)Action.PHYSICAL)) {
            return;
        }
        if (block == null || itemStack == null) {
            return;
        }
        BlockFace blockFace = playerInteractEvent.getBlockFace();
        Location location = new Location(block.getWorld(), (double)(block.getX() + blockFace.getModX()), (double)(block.getY() + blockFace.getModY()), (double)(block.getZ() + blockFace.getModZ()));
        Block block2 = block.getWorld().getBlockAt(location);
        if (block2 != null && ((string = block2.getType().name()).contains("PLAYER_HEAD") || string.contains("SKULL_ITEM") || string.contains("SKULL")) && (playerTurret = this.plugin.getJugadorManager().getTurretFromLocation(location)) != null) {
            playerInteractEvent.setCancelled(true);
        }
    }

    @EventHandler
    public void turretExplode(EntityExplodeEvent entityExplodeEvent) {
        List list = entityExplodeEvent.blockList();
        boolean bl = this.plugin.getConfig().getBoolean("protect_turrets_from_explosions");
        int n = 0;
        while (n < list.size()) {
            PlayerTurret playerTurret;
            if (list.get(n) != null && (playerTurret = this.plugin.getJugadorManager().getTurretFromLocation(((Block)list.get(n)).getLocation())) != null) {
                list.remove(n);
                --n;
                if (!bl) {
                    String string = this.plugin.getConfigsManager().getMainConfigManager().getTurretDamageExplosions();
                    String[] stringArray = string.split("-");
                    int n2 = Integer.valueOf(stringArray[0]);
                    int n3 = Integer.valueOf(stringArray[1]);
                    int n4 = (int)UtilsMath.getRandomNumber(n2, n3);
                    this.plugin.getJugadorManager().damageTurret(playerTurret, n4, null);
                }
            }
            ++n;
        }
    }

    @EventHandler
    public void projectileShoot(EntityShootBowEvent entityShootBowEvent) {
        if (entityShootBowEvent.getEntity() instanceof Player) {
            float f = entityShootBowEvent.getForce();
            Entity entity = entityShootBowEvent.getProjectile();
            ItemStack itemStack = entityShootBowEvent.getBow();
            if (itemStack.getType().name().equals("CROSSBOW")) {
                entity.setMetadata("complexturrets_is_crossbow", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)true));
            } else {
                entity.setMetadata("complexturrets_is_crossbow", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)false));
            }
            int n = ItemManager.getTagIntItem(itemStack, "complexturrets_turret_min_damage");
            int n2 = ItemManager.getTagIntItem(itemStack, "complexturrets_turret_max_damage");
            if (n != -1 && n2 != -1) {
                entity.setMetadata("complexturrets_min_damage", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)n));
                entity.setMetadata("complexturrets_max_damage", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)n2));
            }
            entity.setMetadata("complexturrets_force", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)Float.valueOf(f)));
        }
    }

    @EventHandler
    public void projectileHit(ProjectileHitEvent projectileHitEvent) {
        final Projectile projectile = projectileHitEvent.getEntity();
        if (projectile instanceof Arrow) {
            ProjectileSource projectileSource = projectile.getShooter();
            if (!(projectileSource instanceof Player)) {
                return;
            }
            final Player player = (Player)projectileSource;
            final Location location = projectile.getLocation();
            new BukkitRunnable(){

                public void run() {
                    boolean bl;
                    BlockIterator blockIterator = new BlockIterator(location.getWorld(), location.toVector(), projectile.getVelocity().normalize(), 0.0, 2);
                    Block block = null;
                    Block block2 = null;
                    PlayerTurret playerTurret = null;
                    while (blockIterator.hasNext()) {
                        block2 = block;
                        block = blockIterator.next();
                        if (block.getType().equals((Object)Material.AIR) || (playerTurret = OtherTurretsListener.this.plugin.getJugadorManager().getTurretFromLocation(block.getLocation())) == null) continue;
                        if (block2 == null || block2.isPassable()) break;
                        return;
                    }
                    if (playerTurret == null) {
                        return;
                    }
                    float f = 1.0f;
                    if (projectile.hasMetadata("complexturrets_force")) {
                        f = ((MetadataValue)projectile.getMetadata("complexturrets_force").get(0)).asFloat();
                    }
                    String string = OtherTurretsListener.this.plugin.getConfigsManager().getMainConfigManager().getTurretDamageBow();
                    if (projectile.hasMetadata("complexturrets_is_crossbow") && (bl = ((MetadataValue)projectile.getMetadata("complexturrets_is_crossbow").get(0)).asBoolean())) {
                        string = OtherTurretsListener.this.plugin.getConfigsManager().getMainConfigManager().getTurretDamageCrossbow();
                    }
                    String[] stringArray = string.split("-");
                    int n = Integer.valueOf(stringArray[0]);
                    int n2 = Integer.valueOf(stringArray[1]);
                    if (projectile.hasMetadata("complexturrets_min_damage")) {
                        n = ((MetadataValue)projectile.getMetadata("complexturrets_min_damage").get(0)).asInt();
                        n2 = ((MetadataValue)projectile.getMetadata("complexturrets_max_damage").get(0)).asInt();
                    }
                    final float f2 = f;
                    final PlayerTurret playerTurret2 = playerTurret;
                    final int n3 = n;
                    final int n4 = n2;
                    new BukkitRunnable(){

                        public void run() {
                            TurretHitByArrowEvent turretHitByArrowEvent = new TurretHitByArrowEvent(player, playerTurret2, f2, n3, n4, (Arrow)projectile);
                            OtherTurretsListener.this.plugin.getServer().getPluginManager().callEvent((Event)turretHitByArrowEvent);
                        }
                    }.runTask((Plugin)OtherTurretsListener.this.plugin);
                }
            }.runTaskAsynchronously((Plugin)this.plugin);
        }
    }

    @EventHandler
    public void turretHit(TurretHitByArrowEvent turretHitByArrowEvent) {
        int n;
        Player player = turretHitByArrowEvent.getDamager();
        PlayerTurret playerTurret = turretHitByArrowEvent.getPlayerTurret();
        float f = turretHitByArrowEvent.getForce();
        int n2 = turretHitByArrowEvent.getMinDamage();
        int n3 = turretHitByArrowEvent.getMaxDamage();
        if (this.plugin.getConfigsManager().getMainConfigManager().isRemoveArrowsOnTurretDamage()) {
            turretHitByArrowEvent.getArrow().remove();
        }
        if ((n = playerTurret.getCurrentHealth()) == 0) {
            return;
        }
        int n4 = (int)UtilsMath.getRandomNumber(n2, n3);
        if (n4 == 0) {
            return;
        }
        n4 = (int)((float)n4 * f);
        this.plugin.getJugadorManager().damageTurret(playerTurret, n4, player);
    }

    @EventHandler
    public void entityDeathByTurret(EntityDeathEvent entityDeathEvent) {
        boolean bl;
        LivingEntity livingEntity = entityDeathEvent.getEntity();
        if (livingEntity.hasMetadata("complexturrets_damaged") && !(livingEntity instanceof Player) && (bl = this.plugin.getConfigsManager().getMainConfigManager().isBlockMobDropOnTurretKill())) {
            entityDeathEvent.getDrops().clear();
        }
    }
}

